/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.bumanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataOperationInterface;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.QueryMarineNewLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.TELineExternalInf;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEQueryLineData;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEBUPortPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import gnu.trove.TIntArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEBUQueryResourceLineBean
extends TENEExplorerBean {
    private static final int QUERYALL_BYNEID = 0;
    private static final int QUERY_BINDEDLIINE_ONLY_BYBUNAME = 1;
    private static final int QUERY_REFRESHBINDSTATE_BY_NEID_BUNAME = 2;
    private static final int LINESTATUS_BINDED = 1;
    private static final int LINESTATUS_NON_BINDED = 0;
    private static final int OADM_BU_TYPE = 1;
    private static final int PS_BU_TYPE = 2;
    private static final String UNKNOWN = "UNKNOWN";
    protected static final int NO_NEID = 0;
    protected Map<String, TEQueryLineData> marineLineStrMap = new HashMap<String, TEQueryLineData>();
    protected Map<Integer, TEMarineLineStruct> oneNELineStrMap = new HashMap<Integer, TEMarineLineStruct>();
    protected Map<Integer, List<TEMarineLineStruct>> neLineStrMap = new HashMap<Integer, List<TEMarineLineStruct>>();
    protected List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private String ip = null;
    protected String userID;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.ip = ipAddress;
        this.userID = user;
        ArrayList<RowParams> errorDetialList = new ArrayList<RowParams>();
        boolean allSucc = true;
        try {
            boolean needFilterBU;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            BussinessParams bussinessParams = new BussinessParams();
            this.outputData.setBussinessParams(bussinessParams);
            TELogFactory.getNormalLogger().info("Start to get BU bond line resourde!");
            TIntArrayList neids = new TIntArrayList();
            BussinessParams bus = inputData.getBussinessParams();
            RowParams row = bus.getRowParams(0);
            Param queryallParam = row.getParam("queryaction");
            Param bunameparam = row.getParam("buname");
            int queryAction = Integer.parseInt(queryallParam.getValue());
            boolean rresult = this.refreshInputData(row, neids);
            if (!rresult) {
                return this.outputData;
            }
            allSucc = this.getLineInfo(memeryData, user, ipAddress, errorDetialList, neids);
            Iterator<Map.Entry<String, TEQueryLineData>> itMap = this.marineLineStrMap.entrySet().iterator();
            TEQueryLineData lineStr = null;
            String buName = null;
            if (null != bunameparam) {
                buName = bunameparam.getValue();
            }
            boolean bl = needFilterBU = null != buName && !buName.isEmpty();
            if (needFilterBU) {
                while (itMap.hasNext()) {
                    Map.Entry<String, TEQueryLineData> entry = itMap.next();
                    lineStr = entry.getValue();
                    TEMarineLineStruct lineStrSrc = lineStr.getLineStrSrc();
                    TEMarineLineStruct lineStrSin = lineStr.getLineStrSnk();
                    List<TEMarineLineStruct.EqptStruct> eqptStrList = lineStrSrc.getEqptStrList();
                    eqptStrList = null == eqptStrList || eqptStrList.isEmpty() ? lineStrSin.getEqptStrList() : eqptStrList;
                    boolean found = false;
                    if (null != eqptStrList) {
                        for (TEMarineLineStruct.EqptStruct ep : eqptStrList) {
                            int epType = ep.getEqptType();
                            if (1 != epType && 2 != epType || !buName.equals(ep.getEqptName())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    itMap.remove();
                }
            }
            Collection<TEQueryLineData> lines = this.marineLineStrMap.values();
            this.convertLineToData(lines);
            ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
            boolean rbresult = this.refreshLineBindStatus(row, queryAction, rowList);
            if (!rbresult) {
                return this.outputData;
            }
            TELogFactory.getNormalLogger().info("Get BU bond line resourde operation end!");
            this.outputData.getBussinessParams().getRowParamList().addAll(errorDetialList);
            if (allSucc) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void convertLineToData(Collection<TEQueryLineData> lines) {
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        for (TEQueryLineData line : lines) {
            rowList.add(this.convertLineToOneRow(line));
        }
    }

    private RowParams convertLineToOneRow(TEQueryLineData line) {
        RowParams oneRow = new RowParams();
        TEMarineLineStruct lineStrSrc = line.getLineStrSrc();
        TEMarineLineStruct lineStrSnk = line.getLineStrSnk();
        Param p = null;
        p = new Param();
        p.setName("lineID");
        int lineID = lineStrSrc.getLineID();
        lineID = 0 == lineID ? lineStrSnk.getLineID() : lineID;
        p.setValue(String.valueOf(lineID));
        oneRow.addParam(p);
        this.getSrcLmuInfo(oneRow, lineStrSrc);
        this.getSrcLasInfo(oneRow, lineStrSrc);
        this.getSrcLmiInfo(oneRow, lineStrSrc, lineStrSnk);
        this.getSinkLmuInfo(oneRow, lineStrSnk);
        this.getSinLasInfo(oneRow, lineStrSnk);
        this.getSinkLmiInfo(oneRow, lineStrSnk, lineStrSrc);
        p = new Param();
        p.setName("lineDirection");
        p.setValue(String.valueOf(line.getLineStrSrc().getLineID()));
        oneRow.addParam(p);
        p = new Param();
        p.setName("remark");
        p.setValue(line.getLineStrSrc().getRemark());
        oneRow.addParam(p);
        Param bindstatusparam = new Param("bindstatus", String.valueOf(0));
        Param controlpointparam = new Param("bucontrolpoint", "");
        Param buportaparam = new Param("buporta", "");
        Param buportbparam = new Param("buportb", "");
        Param buportcparam = new Param("buportc", "");
        oneRow.addParam(bindstatusparam);
        oneRow.addParam(controlpointparam);
        oneRow.addParam(buportaparam);
        oneRow.addParam(buportbparam);
        oneRow.addParam(buportcparam);
        return oneRow;
    }

    private void getSinkLmiInfo(RowParams oneRow, TEMarineLineStruct lineStrSnk, TEMarineLineStruct lineStrSrc) {
        int neID = (int)lineStrSnk.getNeID();
        int slotID = (int)lineStrSnk.getLmiSlot();
        int portID = (int)lineStrSnk.getLmiPort();
        int bdType = -1;
        String neName = UNKNOWN;
        String bdName = UNKNOWN;
        String portName = UNKNOWN;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard bd = null;
        if (null != ne) {
            neName = ne.getNEName();
            bd = ne.getBoard(slotID);
            if (null != bd) {
                bdName = bd.getBoardName();
                bdType = bd.getBoardType();
                portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, bdType, portID);
            }
        }
        Param p = new Param();
        p.setName("sinkLmiSlotId");
        p.setValue(String.valueOf(slotID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmineid");
        p.setValue(String.valueOf(neID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmiNeName");
        p.setValue(neName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmiBoardName");
        p.setValue(bdName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmiBoardType");
        p.setValue(String.valueOf(bdType));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmiPortId");
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmiPortName");
        p.setValue(portName);
        oneRow.addParam(p);
        int opNeID = (int)lineStrSnk.getOpNeID();
        TENE opNe = TENEListMgr.getInstance().getNE(opNeID);
        int srcNeID = (int)lineStrSrc.getNeID();
        if (opNeID == srcNeID || 0 != opNeID && null == opNe) {
            p = new Param();
            p.setName("sinkSaveSrcLmineid");
            p.setValue(String.valueOf(opNeID));
            oneRow.addParam(p);
        }
    }

    private void getSinLasInfo(RowParams oneRow, TEMarineLineStruct lineStrSnk) {
        int neID = (int)lineStrSnk.getNeID();
        int slotID = (int)lineStrSnk.getLasSlot();
        int portID = (int)lineStrSnk.getLasPort();
        int bdType = -1;
        String neName = UNKNOWN;
        String bdName = UNKNOWN;
        String portName = UNKNOWN;
        TENE tene = TENEListMgr.getInstance().getNE(neID);
        TEBoard bd = null;
        if (null != tene) {
            neName = tene.getNEName();
            bd = tene.getBoard(slotID);
            if (null != bd) {
                bdName = bd.getBoardName();
                bdType = bd.getBoardType();
                portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, bdType, portID);
            }
        }
        Param p = new Param();
        p.setName("sinkLasSlotId");
        p.setValue(String.valueOf(slotID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasneid");
        p.setValue(String.valueOf(neID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasNeName");
        p.setValue(neName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasBoardName");
        p.setValue(bdName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasBoardType");
        p.setValue(String.valueOf(bdType));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasPortId");
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLasPortName");
        p.setValue(portName);
        oneRow.addParam(p);
    }

    private void getSinkLmuInfo(RowParams oneRow, TEMarineLineStruct lineStrSnk) {
        int neID = (int)lineStrSnk.getNeID();
        int slotID = (int)lineStrSnk.getLmuSlot();
        int portID = (int)lineStrSnk.getLmuPort();
        int bdType = -1;
        String neName = UNKNOWN;
        String bdName = UNKNOWN;
        String portName = UNKNOWN;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard bd = null;
        if (null != ne) {
            bd = ne.getBoard(slotID);
            neName = ne.getNEName();
            if (null != bd) {
                bdName = bd.getBoardName();
                bdType = bd.getBoardType();
                portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, bdType, portID);
            }
        }
        Param p = new Param();
        p.setName("sinkLmuSlotId");
        p.setValue(String.valueOf(slotID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuneid");
        p.setValue(String.valueOf(neID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuNeName");
        p.setValue(neName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuBoardName");
        p.setValue(bdName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuBoardType");
        p.setValue(String.valueOf(bdType));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuPortId");
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("sinkLmuPortName");
        p.setValue(portName);
        oneRow.addParam(p);
    }

    private void getSrcLmiInfo(RowParams oneRow, TEMarineLineStruct lineStrSrc, TEMarineLineStruct lineStrSnk) {
        int neID = (int)lineStrSrc.getNeID();
        int slotID = (int)lineStrSrc.getLmiSlot();
        int portID = (int)lineStrSrc.getLmiPort();
        int bdType = -1;
        String neName = UNKNOWN;
        String bdName = UNKNOWN;
        String portName = UNKNOWN;
        Param p = new Param();
        p.setName("srcLmiSlotId");
        p.setValue(String.valueOf(slotID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmineid");
        p.setValue(String.valueOf(neID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmiPortId");
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard bd = null;
        if (null != ne) {
            bd = ne.getBoard(slotID);
            if (null != bd) {
                bdName = bd.getBoardName();
                bdType = bd.getBoardType();
                portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, bdType, portID);
            }
            neName = ne.getNEName();
        }
        p = new Param();
        p.setName("srcLmiNeName");
        p.setValue(neName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmiBoardName");
        p.setValue(bdName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmiBoardType");
        p.setValue(String.valueOf(bdType));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmiPortName");
        p.setValue(portName);
        oneRow.addParam(p);
        int opNeID = (int)lineStrSrc.getOpNeID();
        TENE opNe = TENEListMgr.getInstance().getNE(opNeID);
        int snkNeID = (int)lineStrSnk.getNeID();
        if (opNeID == snkNeID || 0 != opNeID && null == opNe) {
            p = new Param();
            p.setName("srcSaveSinkLmineid");
            p.setValue(String.valueOf(lineStrSrc.getOpNeID()));
            oneRow.addParam(p);
        }
    }

    private void getSrcLasInfo(RowParams oneRow, TEMarineLineStruct lineStrSrc) {
        int slotID = (int)lineStrSrc.getLasSlot();
        Param p = new Param();
        p.setName("srcLasSlotId");
        p.setValue(String.valueOf(slotID));
        oneRow.addParam(p);
        int neID = (int)lineStrSrc.getNeID();
        p = new Param();
        p.setName("srcLasneid");
        p.setValue(String.valueOf(neID));
        oneRow.addParam(p);
        int portID = (int)lineStrSrc.getLasPort();
        p = new Param();
        p.setName("srcLasPortId");
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        String bdname = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        p = new Param();
        p.setName("srcLasNeName");
        p.setValue(neName);
        oneRow.addParam(p);
        TEBoard bd = null;
        if (null != ne) {
            bd = ne.getBoard(slotID);
        }
        if (null != bd) {
            bdname = bd.getBoardName();
        }
        p = new Param();
        p.setName("srcLasBoardName");
        p.setValue(bdname);
        oneRow.addParam(p);
        String bdType = "";
        if (null != bd) {
            bdType = String.valueOf(bd.getBoardType());
        }
        p = new Param();
        p.setName("srcLasBoardType");
        p.setValue(bdType);
        oneRow.addParam(p);
        String portName = UNKNOWN;
        if (null != ne && null != bd) {
            portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, bd.getBoardType(), portID);
        }
        p = new Param();
        p.setName("srcLasPortName");
        p.setValue(portName);
        oneRow.addParam(p);
    }

    private void getSrcLmuInfo(RowParams oneRow, TEMarineLineStruct lineStrSrc) {
        Param p = new Param();
        p.setName("srcLmuSlotId");
        p.setValue(String.valueOf(lineStrSrc.getLmuSlot()));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuneid");
        p.setValue(String.valueOf(lineStrSrc.getNeID()));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuNeName");
        int srcNEID = (int)lineStrSrc.getNeID();
        TENE tNE = TENEListMgr.getInstance().getNE(srcNEID);
        String srcNEName = UNKNOWN;
        if (null != tNE) {
            srcNEName = tNE.getNEName();
        }
        p.setValue(srcNEName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuBoardName");
        int srcLmuSlot = (int)lineStrSrc.getLmuSlot();
        String bdName = UNKNOWN;
        TEBoard bd = null;
        if (null != tNE && null != (bd = tNE.getBoard(srcLmuSlot))) {
            bdName = bd.getBoardName();
        }
        p.setValue(bdName);
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuBoardType");
        int bdType = -1;
        if (null != bd) {
            bdType = bd.getBoardType();
        }
        p.setValue(null != bd ? String.valueOf(bdType) : UNKNOWN);
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuPortId");
        int portID = (int)lineStrSrc.getLmuPort();
        p.setValue(String.valueOf(portID));
        oneRow.addParam(p);
        p = new Param();
        p.setName("srcLmuPortName");
        String portName = UNKNOWN;
        if (null != tNE) {
            portName = TEConfigurationDataMgr.getInstance().getPortName(srcNEID, srcLmuSlot, bdType, portID);
        }
        p.setValue(portName);
        oneRow.addParam(p);
    }

    private boolean refreshLineBindStatus(RowParams row, int queryAction, List<RowParams> rowList) {
        if (0 != queryAction) {
            TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
            TEMarineBUPO buPO = null;
            Param bunameparam = row.getParam("buname");
            String buName = bunameparam.getValue();
            ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
            buDataOperService.queryBUInfoByName(buName, buSet);
            if (null == buSet || buSet.isEmpty()) {
                TELogFactory.getNormalLogger().info("can't find bu --- name->" + buName);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615228));
                return false;
            }
            boolean needDel = 1 == queryAction;
            buPO = (TEMarineBUPO)buSet.get(0);
            ArrayList blinelist = new ArrayList();
            blinelist.addAll(buPO.getBondLineList());
            Iterator lineiter = blinelist.iterator();
            block0: while (lineiter.hasNext()) {
                TEBUBondLinePO tmpBuPO = (TEBUBondLinePO)lineiter.next();
                int blineid = tmpBuPO.getLineId();
                int srcneid = tmpBuPO.getSrcNeID();
                TENE ne = TENEListMgr.getInstance().getPhyNE(srcneid);
                srcneid = null == ne ? srcneid : ne.getNEID();
                int snkneid = tmpBuPO.getSnkNeID();
                ne = TENEListMgr.getInstance().getPhyNE(snkneid);
                snkneid = null == ne ? snkneid : ne.getNEID();
                for (RowParams onerow : rowList) {
                    int lineID = Integer.parseInt(onerow.getParam("lineID").getValue());
                    Param tmpParam = null == onerow.getParam("srcLmuNeId") || onerow.getParam("srcLmuNeId").getValue().equals("4294967295") ? onerow.getParam("sinkSaveSrcLmineid") : onerow.getParam("srcLmuNeId");
                    int srcLmuNdId = null == tmpParam || onerow.getParam("srcLmuNeId").getValue().equals("4294967295") ? 0 : Integer.parseInt(tmpParam.getValue());
                    tmpParam = null == onerow.getParam("sinkLmuNeId") || onerow.getParam("sinkLmuNeId").getValue().equals("4294967295") ? onerow.getParam("srcSaveSinkLmineid") : onerow.getParam("sinkLmuNeId");
                    int sinLmuNdId = null == tmpParam || tmpParam.getValue().equals("4294967295") ? 0 : Integer.parseInt(tmpParam.getValue());
                    Param bindstatusparam = onerow.getParam("bindstatus");
                    Param controlpointparam = onerow.getParam("bucontrolpoint");
                    Param buportaparam = onerow.getParam("buporta");
                    Param buportbparam = onerow.getParam("buportb");
                    Param buportcparam = onerow.getParam("buportc");
                    if (lineID != blineid || srcneid != srcLmuNdId && snkneid != sinLmuNdId) continue;
                    bindstatusparam.setValue(String.valueOf(1));
                    controlpointparam.setValue(String.valueOf(tmpBuPO.getControlPart()));
                    TENE srcNE = TENEListMgr.getInstance().getNE(srcLmuNdId);
                    TENE sinkNE = TENEListMgr.getInstance().getNE(sinLmuNdId);
                    onerow.addParam(new Param("srcLmuNeName", null == srcNE ? "" : srcNE.getNEName()));
                    onerow.addParam(new Param("sinLmuNeName", null == sinkNE ? "" : sinkNE.getNEName()));
                    lineiter.remove();
                    for (TEBUPortPO buPortPO : buPO.getPortList()) {
                        String bondSLM = buPortPO.getBondSLM();
                        String[] bondSLMs = bondSLM.split(",");
                        StringBuffer neIDs = new StringBuffer("");
                        for (int k = 0; k < bondSLMs.length; ++k) {
                            if (bondSLMs[k].equals("") || bondSLMs[k].equals("0")) {
                                neIDs.append("0");
                                continue;
                            }
                            TENE neTmp = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(bondSLMs[k]));
                            if (null == neTmp) {
                                neIDs.append("0");
                            } else {
                                neIDs.append(String.valueOf(neTmp.getNEID()));
                            }
                            if (k == bondSLMs.length - 1) continue;
                            neIDs.append(",");
                        }
                        if (buPortPO.getPortName().equals("A")) {
                            buportaparam.setValue(neIDs.toString());
                            continue;
                        }
                        if (buPortPO.getPortName().equals("B")) {
                            buportbparam.setValue(neIDs.toString());
                            continue;
                        }
                        if (!buPortPO.getPortName().equals("C")) continue;
                        buportcparam.setValue(neIDs.toString());
                    }
                    continue block0;
                }
            }
            if (needDel) {
                this.removeRowParams(rowList);
            }
        }
        return true;
    }

    private boolean getLineInfo(Datainterface memeryData, String user, String ipAddress, List<RowParams> errorDetialList, TIntArrayList neids) {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TELineExternalInf.getLineInfoByNeIdList(neids, this.marineLineStrMap);
        } else {
            this.queryMarineLine(neids);
        }
        return true;
    }

    private boolean refreshInputData(RowParams row, TIntArrayList neids) throws Exception {
        Param queryallParam = row.getParam("queryaction");
        int queryAction = Integer.parseInt(queryallParam.getValue());
        if (0 == queryAction || 2 == queryAction) {
            this.addNEIDs(row, neids);
        }
        if (1 == queryAction || 2 == queryAction) {
            Param bunameparam = row.getParam("buname");
            if (null == bunameparam) {
                throw new Exception("buname param is needed here....");
            }
            String buName = bunameparam.getValue();
            return this.addBondNEIDsByBUName(buName, neids);
        }
        return true;
    }

    private void addNEIDs(RowParams row, TIntArrayList neids) {
        String neidstr;
        Param neidparam = row.getParam("neids");
        if (null != neidparam && !"".equals((neidstr = neidparam.getValue()).trim())) {
            String[] tidstr;
            for (String t : tidstr = neidstr.split(",")) {
                int tid = Integer.parseInt(t);
                if (neids.contains(tid)) continue;
                neids.add(tid);
            }
        }
    }

    private boolean addBondNEIDsByBUName(String buName, TIntArrayList neids) {
        TEBUDataOperationInterface buDataOperService = TEMarineBUUtil.getBUDataOperationHandler();
        TEMarineBUPO buPO = null;
        ArrayList<TEMarineBUPO> buSet = new ArrayList<TEMarineBUPO>();
        buDataOperService.queryBUInfoByName(buName, buSet);
        if (null == buSet || buSet.isEmpty()) {
            TELogFactory.getNormalLogger().info("can't find bu --- name->" + buName);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615228));
            return false;
        }
        int invalidNEID = -1;
        String zeroNEID = BigInteger.ZERO.toString();
        String oneNEID = BigInteger.valueOf(invalidNEID).toString();
        buPO = (TEMarineBUPO)buSet.get(0);
        Set slit = buPO.getPortList();
        for (TEBUPortPO ppo : slit) {
            String tidStr = ppo.getBondSLM();
            if (zeroNEID.equals(tidStr) || oneNEID.equals(tidStr)) continue;
            String[] tids = tidStr.split(",");
            for (int i = 0; i < tids.length; ++i) {
                int tid;
                TENE ne = TENEListMgr.getInstance().getPhyNE(Integer.parseInt(tids[i]));
                if (null == ne || neids.contains(tid = ne.getNEID())) continue;
                neids.add(tid);
            }
        }
        return true;
    }

    private void removeRowParams(List<RowParams> rowList) {
        Iterator<RowParams> iter = rowList.iterator();
        while (iter.hasNext()) {
            RowParams onerow = iter.next();
            Param bindstatusparam = onerow.getParam("bindstatus");
            if (!String.valueOf(0).equals(bindstatusparam.getValue())) continue;
            iter.remove();
        }
    }

    private void queryMarineLine(TIntArrayList neList) {
        if (null == neList) {
            return;
        }
        int errCode = 0;
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            RowParams[] rows;
            this.oneNELineStrMap.clear();
            int neID = neList.get(i);
            Datainterface din = new Datainterface();
            BussinessParams bus = new BussinessParams();
            din.setBussinessParams(bus);
            RowParams rp = new RowParams();
            bus.addRowParams(rp);
            Param p = null;
            p = new Param("neid", String.valueOf(neID));
            rp.addParam(p);
            p = new Param("lineID", String.valueOf(0));
            rp.addParam(p);
            Datainterface allData = null;
            int sfid = 2179382;
            SubFunc subFunc = null;
            try {
                subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            }
            catch (Exception e1) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e1);
            }
            QueryMarineNewLineBean bean = new QueryMarineNewLineBean();
            allData = bean.performBussinessProcess(neID, subFunc, din, null, this.userID, this.ip);
            int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err && 0 != (errCode = this.getErrorDetial(neID, allData, err))) {
                this.setErrorDetail(neID, errCode);
                continue;
            }
            bus = allData.getBussinessParams();
            for (RowParams row : rows = bus.getRowParams()) {
                this.getRowData(row, neID);
            }
        }
        this.changeMarineData();
    }

    protected void changeMarineData() {
        Iterator<Map.Entry<String, TEQueryLineData>> itMap = this.marineLineStrMap.entrySet().iterator();
        TEQueryLineData marineLine = null;
        if (this.marineLineStrMap.isEmpty()) {
            return;
        }
        int len = this.marineLineStrMap.size();
        for (int i = 0; i < len; ++i) {
            Map.Entry<String, TEQueryLineData> entry = itMap.next();
            marineLine = entry.getValue();
            if (null != marineLine.getLineStrSrc()) {
                this.addneLineStrList(marineLine.getLineStrSrc());
            }
            if (null == marineLine.getLineStrSnk()) continue;
            this.addneLineStrList(marineLine.getLineStrSnk());
        }
    }

    private void addneLineStrList(TEMarineLineStruct lineStr) {
        List<TEMarineLineStruct> neLineStrList = null;
        int neID = (int)lineStr.getNeID();
        neLineStrList = this.neLineStrMap.get(neID);
        if (null == neLineStrList) {
            neLineStrList = new ArrayList<TEMarineLineStruct>();
        }
        neLineStrList.add(lineStr);
        this.neLineStrMap.put(neID, neLineStrList);
    }

    private void getRowData(RowParams row, int neid) {
        Param param = null;
        param = row.getParam("cmdCode");
        if (null == param) {
            return;
        }
        int cmdCode = Integer.parseInt(row.getParam("cmdCode").getValue());
        switch (cmdCode) {
            case 30440: {
                this.setMarineLineInfo(row, neid);
                break;
            }
            case 30405: {
                this.setLineMemo(row, neid);
                break;
            }
            case 30409: {
                this.setLineSpanNum(row, neid);
                break;
            }
            case 30443: {
                this.setLineEqptNum(row, neid);
                break;
            }
            case 30411: {
                this.setLineFiberPara(row, neid);
                break;
            }
            case 30445: {
                this.setLineEqptPos(row, neid);
                break;
            }
        }
    }

    protected void setMarineLineInfo(RowParams row, int neid) {
        TEMarineLineStruct lineStruct = new TEMarineLineStruct();
        lineStruct.setLineID(Integer.parseInt(row.getParam("lineID").getValue()));
        int lineID = lineStruct.getLineID();
        lineStruct.setNeID(neid);
        lineStruct.setLmuSlot(Integer.parseInt(row.getParam("lmuSlot").getValue()));
        lineStruct.setLmuPort(1L);
        lineStruct.setLasSlot(Integer.parseInt(row.getParam("lasSlot").getValue()));
        lineStruct.setLasPort(Integer.parseInt(row.getParam("lasPort").getValue()));
        lineStruct.setLmiSlot(Integer.parseInt(row.getParam("lmiSlot").getValue()));
        lineStruct.setLmiPort(2L);
        int phyNeID = Integer.parseInt(row.getParam("opNeID").getValue());
        int logicNeID = 0 == phyNeID ? 0 : TENECommMgr.getInstance().getLogicNEID(phyNeID);
        lineStruct.setOpNeID(logicNeID);
        lineStruct.setOpLmiSlot(Integer.parseInt(row.getParam("opLmiSlot").getValue()));
        lineStruct.setDirection(Integer.parseInt(row.getParam("lineDirection").getValue()));
        int direction = lineStruct.getDirection();
        this.oneNELineStrMap.put(lineID, lineStruct);
        String lineKey = 1 == direction ? String.valueOf(neid) + logicNeID + lineID : String.valueOf(logicNeID) + neid + lineID;
        TEQueryLineData marineLine = this.marineLineStrMap.get(lineKey);
        if (null == marineLine) {
            marineLine = new TEQueryLineData();
        }
        if (1 == direction) {
            marineLine.setLineStrSrc(lineStruct);
        } else {
            marineLine.setLineStrSnk(lineStruct);
        }
        this.marineLineStrMap.put(lineKey, marineLine);
    }

    protected TEMarineLineStruct getMarineLineStruct(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return null;
        }
        int direction = neLine.getDirection();
        int opNEID = (int)neLine.getOpNeID();
        String lineKey = 1 == direction ? String.valueOf(neid) + opNEID + lineID : String.valueOf(opNEID) + neid + lineID;
        TEQueryLineData marineLine = this.marineLineStrMap.get(lineKey);
        TEMarineLineStruct lineStr = null;
        if (null != marineLine) {
            lineStr = 1 == direction ? marineLine.getLineStrSrc() : marineLine.getLineStrSnk();
        }
        return lineStr;
    }

    protected void setLineMemo(RowParams row, int neid) {
        TEMarineLineStruct lineStr = this.getMarineLineStruct(row, neid);
        if (null != lineStr) {
            lineStr.setRemark(row.getParam("lineRemark").getValue().trim());
        }
    }

    protected void setLineSpanNum(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        TEMarineLineStruct lineStr = this.getMarineLineStruct(row, neid);
        if (null != lineStr) {
            lineStr.setSpanNum(Integer.parseInt(row.getParam("spanNum").getValue()));
            neLine.setEqptNum(lineStr.getEqptNum());
        }
    }

    protected void setLineFiberPara(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return;
        }
        int direction = neLine.getDirection();
        int opNEID = (int)neLine.getOpNeID();
        int spanNum = neLine.getSpanNum();
        String lineKey = 1 == direction ? String.valueOf(neid) + opNEID + lineID : String.valueOf(opNEID) + neid + lineID;
        List<TEMarineLineStruct.SpanStruct> spanList = null;
        TEMarineLineStruct.SpanStruct spanStr = new TEMarineLineStruct.SpanStruct();
        int spanID = Integer.parseInt(row.getParam("spanNo").getValue());
        if (1 == direction) {
            spanStr.setSpanID(spanID);
        } else {
            spanStr.setSpanID(spanNum - spanID + 1);
        }
        spanStr.setFiberType(row.getParam("fiberType").getValue().trim());
        spanStr.setrefractiveIndex(Integer.parseInt(row.getParam("refraction").getValue()));
        int fiberLenth = Integer.parseInt(row.getParam("fiberLenth").getValue());
        spanStr.setFiberLenth(fiberLenth);
        neLine.setFiberLenth(fiberLenth);
        spanStr.setAtteCoefficient(Integer.parseInt(row.getParam("attenuation").getValue()));
        TEQueryLineData marineLine = this.marineLineStrMap.get(lineKey);
        if (null != marineLine) {
            TEMarineLineStruct lineStr = null;
            lineStr = 1 == direction ? marineLine.getLineStrSrc() : marineLine.getLineStrSnk();
            spanList = lineStr.getSpanStrList();
            if (null == spanList) {
                spanList = new ArrayList<TEMarineLineStruct.SpanStruct>();
                lineStr.setSpanStrList(spanList);
            }
            spanList.add(spanStr);
        }
    }

    protected void setLineEqptNum(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        TEMarineLineStruct lineStr = this.getMarineLineStruct(row, neid);
        if (null != lineStr) {
            lineStr.setEqptNum(Integer.parseInt(row.getParam("eqptNum").getValue()));
            neLine.setEqptNum(lineStr.getEqptNum());
        }
    }

    protected void setLineEqptPos(RowParams row, int neid) {
        List<TEMarineLineStruct.EqptStruct> eqptStrList = null;
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return;
        }
        int direction = neLine.getDirection();
        int opNEID = (int)neLine.getOpNeID();
        int eqptNum = neLine.getEqptNum();
        int fiberLenth = neLine.getFiberLenth();
        int spanNum = neLine.getSpanNum();
        String lineKey = 1 == direction ? String.valueOf(neid) + opNEID + lineID : String.valueOf(opNEID) + neid + lineID;
        TEQueryLineData marineLine = this.marineLineStrMap.get(lineKey);
        if (null != marineLine) {
            TEMarineLineStruct lineStr = null;
            lineStr = 1 == direction ? marineLine.getLineStrSrc() : marineLine.getLineStrSnk();
            eqptStrList = lineStr.getEqptStrList();
            if (null == eqptStrList) {
                eqptStrList = new ArrayList<TEMarineLineStruct.EqptStruct>();
            }
            TEMarineLineStruct.EqptStruct eqptStr = new TEMarineLineStruct.EqptStruct();
            int eqptID = TEMarineLinePubFun.getNERelID(Integer.parseInt(row.getParam("eqptId").getValue()), eqptNum, direction);
            int spanID = TEMarineLinePubFun.getNERelID(Integer.parseInt(row.getParam("spanId").getValue()), spanNum, direction);
            int eqptPos = TEMarineLinePubFun.getEqptRelPos(Integer.parseInt(row.getParam("eqptPos").getValue()), fiberLenth, direction);
            eqptStr.setEqptID(eqptID);
            eqptStr.setEqptSpan(spanID);
            eqptStr.setEqptPos(eqptPos);
            eqptStr.setEqptType(Integer.parseInt(row.getParam("eqptType").getValue()));
            eqptStr.setEqptName(row.getParam("eqptName").getValue().trim());
            eqptStrList.add(eqptStr);
            lineStr.setEqptStrList(eqptStrList);
        }
    }

    protected int getErrorDetial(int neid, Datainterface allData, int err) {
        if (2 != err && 1 != err && 1090650126 != err) {
            return err;
        }
        List<TEMarineLineError> errorDetailList = TEMarineLinePubFun.setOPErrorCode(neid, allData, err, false);
        this.errorDetialList.addAll(errorDetailList);
        return 0;
    }

    protected void setErrorDetail(int neid, int err) {
        TEMarineLineError errInfo = new TEMarineLineError();
        errInfo.setCmdID(0);
        errInfo.setErrObject(String.valueOf(neid));
        errInfo.setErrValue(err);
        this.errorDetialList.add(errInfo);
    }
}

