/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TEBoardNameConvertUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TENEImplInterface_TL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPortRunnable;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.login.TELoginNEManager;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class TETL1NE_PFE
extends TETL1NE {
    private static String TL1_DESCRIBE_FILE_PATH = "nemgr" + File.separator + "device" + File.separator + "marine" + File.separator + "conf" + File.separator + "tl1describ.xml";
    TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();

    public void queryBoard() {
        this.querySubrack();
        this.queryLPBoard();
        this.queryLogicPort_PFE();
    }

    public void querySubrack() {
    }

    public void queryLPBoard() {
        TL1Operation oper1 = null;
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.marine_dev", (String)TL1_DESCRIBE_FILE_PATH);
            oper1 = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper1.getInMsg();
            StringBuffer sb = new StringBuffer();
            sb.append("SLOT-ALL");
            input.getPart("AID").setValue(sb.toString());
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 60);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            this.setLoginCode(result.retCode);
            return;
        }
        this.setBoardToMemory(operationList);
    }

    public void setBoardToMemory(ArrayList operationList) {
        boolean querySucc = false;
        HashMap<String, TEBoard> queryboardMap = new HashMap<String, TEBoard>();
        Vector<TEBoard> newPhyBoardList = new Vector<TEBoard>();
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        int slotID = -1;
        String boardName = "";
        int boardType = -1;
        TEBoard board = null;
        String sst = "";
        int size = outMsgs.length;
        for (int i = 0; i < size; ++i) {
            if (0 != outMsgs[i].getFault().getCompletionCode()) {
                this.setLoginCode(outMsgs[i].getFault().getCompletionCode());
                this.setErrorCode(outMsgs[i].getFault().getErrCode());
                this.setErrorDes(outMsgs[i].getFault().getErrDesc());
                return;
            }
            querySucc = true;
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
            String[] tempSlots = ((Part)dataBlock.get("slotID")).getValue().split("SLOT-");
            int len = tempSlots.length;
            if (2 != len) continue;
            String tmpSlotStr = tempSlots[1];
            slotID = TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM((String)tmpSlotStr);
            boardName = ((Part)dataBlock.get("PROVTYPE")).getValue();
            if (boardName == null) {
                boardName = ((Part)dataBlock.get("ACTTYPE")).getValue();
            }
            int state = 0;
            TEBoardNameConvertUtil boardNameConvertUtil = TEBoardNameConvertUtil.getInstance();
            boardNameConvertUtil.setNeType(this.getNeImplInterface().getNeType());
            boardNameConvertUtil.setHostVersion(this.getNeImplInterface().getHostVersion());
            if (null != boardName && !"".equals(boardName)) {
                boardType = this.getBoardTypeValue(72, boardName);
                board = new TEBoard(this.neID, slotID, boardType, boardName);
                board.setState(state);
                if (sst != null && sst.indexOf("STBYH") != -1) {
                    board.setBoardPG(1);
                }
                queryboardMap.put(String.valueOf(slotID), board);
            }
            if (null == (boardName = ((Part)dataBlock.get("ACTTYPE")).getValue()) || "".equals(boardName)) continue;
            String convertBoardName = boardNameConvertUtil.nameToNM(boardName);
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.getNeImplInterface().getNeType(), boardName, convertBoardName);
            board = new TEBoard(this.neID, slotID, boardType, boardName);
            if (sst != null && sst.indexOf("STBYH") != -1) {
                board.setBoardPG(1);
            }
            board.setState(state);
            newPhyBoardList.add(board);
        }
        this.reNewMemoryPhyBoard_PFE(newPhyBoardList);
        if (querySucc) {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            Vector boardList = neImpl.getBoardList();
            if (queryboardMap.size() != boardList.size()) {
                this.setBoardUpdateFlag(true);
            } else {
                int i = 0;
                int len = boardList.size();
                for (i = 0; i < len; ++i) {
                    TEBoard board1 = (TEBoard)boardList.get(i);
                    if (queryboardMap.containsValue(board1)) continue;
                    this.setBoardUpdateFlag(true);
                    break;
                }
                if (i >= len) {
                    this.setBoardUpdateFlag(false);
                }
            }
            Vector<TEBoard> tmpBoardVec = new Vector<TEBoard>();
            Iterator iter = queryboardMap.values().iterator();
            while (iter.hasNext()) {
                tmpBoardVec.add((TEBoard)iter.next());
            }
            this.reNewMemoryLogBoard_PFE(tmpBoardVec);
            Collections.sort(boardList);
        }
        queryboardMap.clear();
    }

    private int getBoardTypeValue(int neType, String boardName) {
        if (72 != neType || null == boardName || "".equals(boardName)) {
            return -1;
        }
        if (boardName.equals("CTU")) {
            return 1429;
        }
        if (boardName.equals("CV1")) {
            return 1425;
        }
        if (boardName.equals("CV2")) {
            return 1426;
        }
        if (boardName.equals("LCU")) {
            return 1427;
        }
        if (boardName.equals("OP")) {
            return 1428;
        }
        if (boardName.equals("TL")) {
            return 1424;
        }
        return -1;
    }

    private void reNewMemoryPhyBoard_PFE(Vector newPhyBoardList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector phyBoardList = neImpl.getPhyBoardList();
        if (newPhyBoardList.size() > 1) {
            this.setPhyBoardList(newPhyBoardList);
        } else {
            int m = newPhyBoardList.size();
            for (int j = 0; j < m; ++j) {
                TEBoard newBoard = (TEBoard)newPhyBoardList.get(j);
                TEBoard oldBoard = this.getPhyBoard(newBoard.getSlotID());
                if (oldBoard != null) {
                    phyBoardList.remove(oldBoard);
                }
                if (oldBoard == null || newBoard.getBoardType() != oldBoard.getBoardType()) {
                    phyBoardList.add(newBoard);
                    continue;
                }
                if (oldBoard.getState() == newBoard.getState()) continue;
                oldBoard.setState(newBoard.getState());
            }
        }
    }

    private void reNewMemoryLogBoard_PFE(Vector tmpBoardVec) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        if (tmpBoardVec.size() > 1) {
            this.setBoardList(tmpBoardVec);
        } else {
            int m = tmpBoardVec.size();
            for (int j = 0; j < m; ++j) {
                TEBoard newBoard = (TEBoard)tmpBoardVec.get(j);
                TEBoard oldBoard = this.getBoard(newBoard.getSlotID());
                if (oldBoard != null) {
                    boardList.remove(oldBoard);
                }
                if (oldBoard == null || newBoard.getBoardType() != oldBoard.getBoardType()) {
                    boardList.add(newBoard);
                    if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, newBoard.getBoardType())) continue;
                    TETL1QueryLogicPort.queryExistLogicPort((int)this.neID, (int)newBoard.getSlotID(), (int)newBoard.getBoardType());
                    continue;
                }
                if (oldBoard.getState() == newBoard.getState()) continue;
                oldBoard.setState(newBoard.getState());
            }
        }
    }

    private void queryLogicPort_PFE() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector boardList = neImpl.getBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board1 = (TEBoard)boardList.get(i);
            int boardType = board1.getBoardType();
            if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, boardType)) continue;
            int slotID = board1.getSlotID();
            TELoginNEManager.getInstance().getChanel().putRequest((Runnable)new TETL1QueryLogicPortRunnable(this.neID, slotID, boardType));
        }
    }

    public void queryNEInfo() {
        this.queryBoard();
    }

    public void queryNESysInfo() {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        this.neImpl.setTL1_DES_PATH(TEGetFilePath.getFilePath((int)this.getNEType(), (String)this.getHostVersion(), (String)("conf" + File.separator + "tl1describ.xml")));
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.marine_dev", (String)this.neImpl.getTL1_DES_PATH());
            TL1Operation oper = null;
            oper = definitions.getTL1Operation("RTRV-SYS");
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 30);
            if (result.retCode != 0) {
                return;
            }
            oper = (TL1Operation)operationList.get(0);
            OutMsg outMsg = oper.getOutMsg(0);
            if (0 != outMsg.getFault().getCompletionCode()) {
                return;
            }
            HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            neImpl.setNeState("runstate");
            this.setShelfType(136);
            if (hm.get("NODEID") != null) {
                String nodeid = ((Part)hm.get("NODEID")).getValue();
                this.setNodeID(nodeid);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse parse fail", (Throwable)e);
        }
    }

    public ArrayList queryTL1Alarm() {
        this.setTimeZome("UTC");
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        if (alarmList != null && alarmList.size() > 0) {
            alarmList.clear();
        }
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        ArrayList<TL1Operation> operLogList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.marine_dev", (String)TL1_DESCRIBE_FILE_PATH);
            TL1Operation oper = definitions.getTL1Operation("RTRV-COND-ALL");
            operationList.add(oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_PFE.queryTL1Alarm() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operationList, 40);
        if (result.retCode != 0) {
            neImpl.setQueryAlarmSucc(false);
            return operationList;
        }
        neImpl.setQueryAlarmSucc(true);
        TL1Operation tl1oper = (TL1Operation)operationList.get(0);
        OutMsg[] output = tl1oper.getOutMsg();
        String slotAid = "";
        String slotAidType = "";
        String alarmLevel = "";
        String alarmName = "";
        String alarmSRVEFF = "";
        String alarmDate = "";
        String alarmTime = "";
        String location = "";
        String direction = "";
        String alarmCause = "";
        String alarmSN = "";
        String alarmReason = "";
        int alarmType = 0;
        TEAlarmData almData = null;
        int fbType = 0;
        boolean flag = false;
        Part part = null;
        int len = output.length;
        for (int j = 0; j < len; ++j) {
            int almdirection;
            HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output[j]);
            part = (Part)partMap.get("aid");
            slotAid = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("aidtype");
            slotAidType = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ntfcncde");
            alarmLevel = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("condtype");
            alarmName = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("srveff");
            alarmSRVEFF = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ocrdat");
            alarmDate = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ocrtm");
            alarmTime = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("locn");
            location = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("dirn");
            direction = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("conddesc");
            alarmCause = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("SN");
            alarmSN = TETL1CommonUtil.isNull((String)part.getValue());
            int almlocation = TETL1FaultUtil.getTL1AlarmLocation((String)location);
            almData = TETL1FaultUtil.getAlarmDataFromStatic((String)slotAidType, (int)almlocation, (int)(almdirection = 0), (String)alarmName);
            if (null == almData) continue;
            alarmReason = almData.getAeReasion();
            alarmType = almData.getAeType();
            fbType = almData.getAIDType();
            TETL1Alarm alarm = new TETL1Alarm(slotAid, slotAidType, alarmName, alarmLevel, alarmSRVEFF, alarmDate, alarmTime, location, direction, alarmSN, alarmCause, alarmReason, alarmType, fbType, this.neID);
            TEConfigurationDataMgr.getInstance().setNEType(1);
            TETL1Alarm.parseAlarmParam((TETL1Alarm)alarm, (int)this.neID);
            if (alarm.getAlarmSN().equals("-1")) continue;
            TETL1Alarm tmpAlm = null;
            int size2 = alarmList.size();
            for (int n = 0; n < size2; ++n) {
                tmpAlm = (TETL1Alarm)alarmList.get(n);
                if (!tmpAlm.getAlarmSN().equals(alarm.getAlarmSN())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            alarmList.add(alarm);
        }
        operLogList.add((TL1Operation)tl1oper.clone());
        return operLogList;
    }

    private void parseEnvAlarmData_PFE(TL1Operation operation, ArrayList operLogList) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        OutMsg[] output = operation.getOutMsg();
        String slotAid = "";
        String slotAidType = "";
        String alarmLevel = "";
        String alarmName = "";
        String alarmSRVEFF = "";
        String alarmDate = "";
        String alarmTime = "";
        String almmsg = "";
        String alarmSN = "";
        String alarmReason = "";
        int alarmType = 0;
        TEAlarmData almData = null;
        int fbType = 0;
        boolean flag = false;
        Part part = null;
        int len = output.length;
        for (int j = 0; j < len; ++j) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output[j]);
            if (partMap.size() <= 0) continue;
            part = (Part)partMap.get("aid");
            slotAid = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ntfcncde");
            alarmLevel = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("condtype");
            alarmName = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ocrdat");
            alarmDate = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("ocrtm");
            alarmTime = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("conddesc");
            almmsg = TETL1CommonUtil.isNull((String)part.getValue());
            part = (Part)partMap.get("SN");
            alarmSN = TETL1CommonUtil.isNull((String)part.getValue());
            almData = TETL1FaultUtil.getAlarmDataFromStatic((String)"ENV", (int)1, (int)0, (String)alarmName);
            if (null == almData) continue;
            alarmReason = almData.getAeReasion();
            alarmType = almData.getAeType();
            fbType = almData.getAIDType();
            TETL1Alarm alarm = new TETL1Alarm(slotAid, slotAidType, alarmName, alarmLevel, alarmSRVEFF, alarmDate, alarmTime, "NEND", "", alarmSN, almmsg, alarmReason, alarmType, fbType, this.neID);
            TEConfigurationDataMgr.getInstance().setNEType(1);
            TETL1Alarm.parseENVAlarmParam((TETL1Alarm)alarm, (int)this.neID);
            if (alarm.getAlarmSN().equals("-1")) continue;
            TETL1Alarm tmpAlm = null;
            int size2 = alarmList.size();
            for (int n = 0; n < size2; ++n) {
                tmpAlm = (TETL1Alarm)alarmList.get(n);
                if (!tmpAlm.getAlarmSN().equals(alarm.getAlarmSN())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            alarmList.add(alarm);
        }
        operLogList.add((TL1Operation)operation.clone());
    }

    public TENEAlarmAnalyse alarmAnalyse(int slotID) {
        TENEAlarmAnalyse almAnalyse = null;
        if (slotID == -1) {
            almAnalyse = this.almAnalyse(this.getAlarmList());
        } else {
            Vector<TETL1Alarm> slotAlmList = new Vector<TETL1Alarm>();
            int size = this.getAlarmList().size();
            for (int i = 0; i < size; ++i) {
                TETL1Alarm alarm = (TETL1Alarm)this.getAlarmList().get(i);
                if (alarm.getSlotID() != slotID) continue;
                slotAlmList.add(alarm);
            }
            almAnalyse = this.almAnalyse(slotAlmList);
        }
        return almAnalyse;
    }

    public void setTimeTask() {
        if (!this.getNeImplInterface().isSchedule()) {
            TELoginNEManager.getInstance().registerNe((TENE)this, 10000, 10000);
            TELogFactory.getNormalLogger().info("NEname: " + this.getNEName() + " start boardTimerTask ");
            this.getNeImplInterface().setSchedule(true);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TENE)) {
            return false;
        }
        TENE ne = (TENE)obj;
        return ne.getNEID() == this.neID;
    }

    public int hashCode() {
        return this.neID;
    }
}

