/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.ChannelPathNode;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.channel.TEChannelModeDataMgr;
import com.huawei.nglct.nemgr.necommon.fault.TEAlmFBKey;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEAlarmAdapterCache {
    public static final int OTN_Board_InSDHMode = 2;
    public static final int OTN_Board_InOTNMode = 1;
    public static final int PAYLOADTYPE_NONE = 0;
    public static final int PAYLOADTYPE_OTU1 = 513;
    public static final int PAYLOADTYPE_OTU2 = 514;
    public static final int PAYLOADTYPE_OTU3 = 515;
    public static final int PAYLOADTYPE_OTU3E = 517;
    public static final int PAYLOADTYPE_OTU5G = 516;
    public static final int PAYLOADTYPE_ODU1 = 529;
    public static final int PAYLOADTYPE_ODU2 = 530;
    public static final int PAYLOADTYPE_ODU3 = 531;
    public static final int PAYLOADTYPE_ODU5G = 532;
    public static final String WDM_OTNMode = "WDM_OTN";
    public static final String WDM_SDHMode = "WDM_SDH";
    public static final String WDM_NONEMode = "WDM_NONE";
    private static final String filename = "alarm_adapter_board.xml";
    private static String PAKAGE_PATH = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "alarm" + File.separator + "alarm_adapter_board.xml";
    private Map supPortBoard = null;
    private Map neBoardServerMode = new HashMap();
    private Map boardModeMap = new HashMap();
    private Map payloadModeMap = new HashMap();
    private Map portFixModeMap = new HashMap();
    private Map portDynModeMap = new HashMap();
    private static TEAlarmAdapterCache instance = new TEAlarmAdapterCache();

    public static TEAlarmAdapterCache getInstatce() {
        return instance;
    }

    private void parseFile(int neid) {
        NodeList dynfbmodel;
        String fileName = TEResourceManager.getPath() + File.separator + PAKAGE_PATH;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(fileName);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return;
        }
        NodeList nodelist = null;
        Element root = doc.getDocumentElement();
        NodeList almfbmodelList = root.getElementsByTagName("almfbmodel");
        nodelist = null != almfbmodelList && almfbmodelList.getLength() == 1 ? almfbmodelList.item(0).getChildNodes() : root.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = nodelist.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            String boardid = childElement.getAttributes().getNamedItem("value").getNodeValue();
            String portstr = childElement.getAttributes().getNamedItem("portid").getNodeValue();
            ArrayList portlist = this.getNoList(portstr);
            this.supPortBoard.put(boardid, portlist);
        }
        NodeList fixfbmodellList = root.getElementsByTagName("fixfbmodel");
        if (null != fixfbmodellList && fixfbmodellList.getLength() > 0) {
            int size = fixfbmodellList.getLength();
            for (int i = 0; i < size; ++i) {
                Element boardElement = (Element)fixfbmodellList.item(i);
                int boardType = SDXMLInterpreterMgr.getInstance().parseInt(boardElement.getAttribute("cp_type"));
                NodeList nodeListTemp = boardElement.getChildNodes();
                int sizetemp = nodeListTemp.getLength();
                for (int j = 0; j < sizetemp; ++j) {
                    Node child = nodeListTemp.item(j);
                    if (!(child instanceof Element)) continue;
                    Element portElement = (Element)child;
                    String portIDStr = portElement.getAttribute("portid");
                    ArrayList portNoList = new ArrayList();
                    TENEListUtils.getPortArr((String)portIDStr, portNoList);
                    String pathIDStr = portElement.getAttribute("pathid");
                    ArrayList pathNoList = new ArrayList();
                    TENEListUtils.getPortArr((String)pathIDStr, pathNoList);
                    String fbtypeStr = portElement.getAttribute("fbtype");
                    ArrayList fbtypeList = new ArrayList();
                    this.stringToNumber(neid, fbtypeStr, fbtypeList);
                    this.expendFixFbObjs(boardType, portNoList, pathNoList, fbtypeList);
                }
            }
        }
        if (null != (dynfbmodel = root.getElementsByTagName("dynfbmodel")) && dynfbmodel.getLength() > 0) {
            int size = dynfbmodel.getLength();
            for (int i = 0; i < size; ++i) {
                Element boardElement = (Element)dynfbmodel.item(i);
                int boardType = SDXMLInterpreterMgr.getInstance().parseInt(boardElement.getAttribute("cp_type"));
                NodeList nodeListTemp = boardElement.getChildNodes();
                int sizetemp = nodeListTemp.getLength();
                for (int j = 0; j < sizetemp; ++j) {
                    Node child = nodeListTemp.item(j);
                    if (!(child instanceof Element)) continue;
                    Element portElement = (Element)child;
                    String portIDStr = portElement.getAttribute("portid");
                    ArrayList portNoList = new ArrayList();
                    TENEListUtils.getPortArr((String)portIDStr, portNoList);
                    String pathIDStr = portElement.getAttribute("pathid");
                    ArrayList pathNoList = new ArrayList();
                    TENEListUtils.getPortArr((String)pathIDStr, pathNoList);
                    String fbtypeStr = portElement.getAttribute("fbtype");
                    ArrayList fbtypeList = new ArrayList();
                    this.stringToNumber(neid, fbtypeStr, fbtypeList);
                    String workmode = portElement.getAttribute("workmode");
                    this.expendDynFbObjs(boardType, portNoList, pathNoList, fbtypeList, workmode);
                }
            }
        }
    }

    private void stringToNumber(int neid, String strValue, ArrayList fbList) {
        StringBuffer levelStr = new StringBuffer();
        int levelID = -1;
        int len2 = strValue.length();
        for (int j = 0; j < len2; ++j) {
            char ch = strValue.charAt(j);
            if (ch != ',' && ch != '[' && ch != ']') {
                levelStr.append(ch);
                continue;
            }
            if (levelStr.length() == 0) continue;
            String levelIdMacro = levelStr.toString().trim();
            Integer tmpLevelID = SDXMLInterpreterMgr.getInstance().parseInt(levelIdMacro);
            if (tmpLevelID != null) {
                levelID = tmpLevelID;
                if (TEConfigurationDataMgr.getInstance().isBIFBType(levelID)) {
                    levelID = TEConfigurationDataMgr.getInstance().getBidirFBType(levelID);
                }
            }
            fbList.add(new Integer(levelID));
            levelStr.delete(0, levelStr.length());
        }
    }

    private void expendFixFbObjs(int boardType, ArrayList portList, ArrayList pathIDList, ArrayList fbtypeList) {
        TEAlmFBKey almfb = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                almfb = new TEAlmFBKey(boardType, ((Integer)portList.get(i)).intValue(), ((Integer)pathIDList.get(j)).intValue());
                if (this.portFixModeMap.containsKey(almfb)) {
                    ArrayList fbList = (ArrayList)this.portFixModeMap.get(almfb);
                    if (fbList.containsAll(fbtypeList)) continue;
                    fbList.addAll(fbList);
                    continue;
                }
                this.portFixModeMap.put(almfb, fbtypeList);
            }
        }
    }

    private void expendDynFbObjs(int boardType, ArrayList portList, ArrayList pathIDList, ArrayList fbtypeList, String workmode) {
        if (workmode == null) {
            workmode = "";
        }
        TEAlmFBKey almfb = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            almfb = new TEAlmFBKey(boardType, ((Integer)portList.get(i)).intValue(), 0);
            if (!this.portDynModeMap.containsKey(almfb)) {
                this.portDynModeMap.put(almfb, new ArrayList());
            }
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                almfb = new TEAlmFBKey(boardType, ((Integer)portList.get(i)).intValue(), ((Integer)pathIDList.get(j)).intValue(), workmode);
                if (this.portDynModeMap.containsKey(almfb)) {
                    ArrayList fbList = (ArrayList)this.portDynModeMap.get(almfb);
                    if (fbList.containsAll(fbtypeList)) continue;
                    fbList.addAll(fbList);
                    continue;
                }
                this.portDynModeMap.put(almfb, fbtypeList);
            }
        }
    }

    public boolean getDynPort(int boardtype, int portid) {
        TEAlmFBKey almfb = new TEAlmFBKey(boardtype, portid, 0);
        boolean blDyn = false;
        if (this.portDynModeMap.containsKey(almfb)) {
            blDyn = true;
        }
        return blDyn;
    }

    public ArrayList getDynPortFbList(int boardtype, int portid, int pathid, String workmode) {
        TEAlmFBKey almfb = new TEAlmFBKey(boardtype, portid, pathid, workmode);
        ArrayList fblist = null;
        if (null != this.portDynModeMap.get(almfb)) {
            fblist = (ArrayList)this.portDynModeMap.get(almfb);
        }
        return fblist;
    }

    public ArrayList getPortFixMode(int boardtype, int portid, int pathid) {
        TEAlmFBKey almfb = new TEAlmFBKey(boardtype, portid, pathid);
        ArrayList fbList = null;
        if (null != this.portFixModeMap.get(almfb)) {
            fbList = (ArrayList)this.portFixModeMap.get(almfb);
        }
        return fbList;
    }

    public void initData(int neid) {
        if (this.supPortBoard == null) {
            this.supPortBoard = new HashMap();
            this.parseFile(neid);
        }
    }

    private TEAlarmAdapterCache() {
    }

    public boolean isChangePort(int neid, int slotid, int portid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int boardtype = ne.getBoard(slotid).getBoardType();
        if (this.supPortBoard.get(boardtype + "") != null) {
            ArrayList portPropertyList = (ArrayList)this.supPortBoard.get(boardtype + "");
            int length = portPropertyList.size();
            for (int j = 0; j < length; ++j) {
                int id = (Integer)portPropertyList.get(j);
                if (portid != id) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getBoardMode(int neid, int slotid) {
        Map neMapdata = null;
        if (this.boardModeMap.get(neid + "") != null) {
            neMapdata = (Map)this.boardModeMap.get(neid + "");
        } else {
            neMapdata = new HashMap();
            this.boardModeMap.put(neid + "", neMapdata);
        }
        String boardMode = null;
        boardMode = neMapdata.get(slotid + "") != null ? (String)neMapdata.get(slotid + "") : this.queryBoardMode(neid, slotid);
        return boardMode;
    }

    public String getPortMode(int neid, int slotid, int portid) {
        Map neMapdata = null;
        if (this.neBoardServerMode.get(neid + "") != null) {
            neMapdata = (Map)this.neBoardServerMode.get(neid + "");
        } else {
            neMapdata = new HashMap();
            this.neBoardServerMode.put(neid + "", neMapdata);
        }
        Map boardData = null;
        if (neMapdata.get(slotid + "") != null) {
            boardData = (Map)neMapdata.get(slotid + "");
        } else {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            this.queryNeBoardMode(neid, slotid, ne.getBoard(slotid).getBoardType());
            Map tem = (Map)this.neBoardServerMode.get(neid + "");
            if (null == tem.get(slotid + "")) {
                return WDM_SDHMode;
            }
            boardData = (Map)tem.get(slotid + "");
        }
        String mode = (String)boardData.get(portid + "");
        if (null == mode || "".equals(mode)) {
            return WDM_SDHMode;
        }
        return mode;
    }

    public void setPortMode(int neid, int slotid, int portid, String mode) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int boardType = ne.getBoard(slotid).getBoardType();
        if ((boardType == 1195 || boardType == 1246) && portid == 1) {
            return;
        }
        if (boardType == 1278 && portid == 3) {
            return;
        }
        Map<String, Map<String, String>> neMapdata = null;
        if (this.neBoardServerMode.get(neid + "") != null) {
            neMapdata = (Map)this.neBoardServerMode.get(neid + "");
        } else {
            neMapdata = new HashMap();
            this.neBoardServerMode.put(neid + "", neMapdata);
        }
        Map<String, String> boardData = null;
        if (neMapdata.get(slotid + "") != null) {
            boardData = (Map)neMapdata.get(slotid + "");
        } else {
            boardData = new HashMap();
            neMapdata.put(slotid + "", boardData);
        }
        if (portid == 0) {
            switch (boardType) {
                case 1194: {
                    boardData.put("3", mode);
                    boardData.put("4", mode);
                    boardData.put("5", mode);
                    boardData.put("6", mode);
                    boardData.put("7", mode);
                    boardData.put("8", mode);
                    boardData.put("9", mode);
                    boardData.put("10", mode);
                    break;
                }
                case 1185: 
                case 1186: 
                case 1188: 
                case 1193: {
                    boardData.put("3", mode);
                    boardData.put("4", mode);
                    boardData.put("5", mode);
                    boardData.put("6", mode);
                    break;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEAlarmAdapterCache.setPortMode() boardType:" + boardType + " not in case!");
                    break;
                }
            }
        } else {
            boardData.put(portid + "", mode);
        }
        if ((boardType == 1195 || boardType == 1246 || boardType == 1278) && portid == 201) {
            boardData.put("1", mode);
        }
        if (boardType == 1278 && portid == 201) {
            boardData.put("3", mode);
        }
    }

    public boolean isChangeMode(int boardtype) {
        return this.supPortBoard.get(boardtype + "") != null;
    }

    public void queryNeBoardMode(int neid, int slotid, int iBoardType) {
        if (this.isChangeMode(iBoardType)) {
            ArrayList portPropertyList = (ArrayList)this.supPortBoard.get(iBoardType + "");
            int length = portPropertyList.size();
            for (int j = 0; j < length; ++j) {
                int portid = (Integer)portPropertyList.get(j);
                this.queryBoardWorkMode(neid, slotid, portid, iBoardType);
            }
        }
    }

    public void wdmSetServeMode(int neid, int slotid, int portid, int mode) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int boardtype = ne.getBoard(slotid).getBoardType();
        if (this.isChangeMode(boardtype)) {
            String modestr = "WDM_SDHMode";
            switch (mode) {
                case 2: {
                    modestr = WDM_SDHMode;
                    break;
                }
                case 1: {
                    modestr = WDM_OTNMode;
                    break;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEAlarmAdapterCache.wdmSetServeMode() mode:" + mode + " not in case!");
                }
            }
            this.setPortMode(neid, slotid, portid, modestr);
        }
    }

    public void wdmSetServeType(int neid, int slotid, int portid, int type) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int boardtype = ne.getBoard(slotid).getBoardType();
        if (this.isChangeMode(boardtype)) {
            String modestr = "WDM_SDHMode";
            switch (type) {
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 517: 
                case 529: 
                case 530: 
                case 531: 
                case 532: {
                    modestr = WDM_OTNMode;
                    break;
                }
                case 0: {
                    modestr = WDM_NONEMode;
                    break;
                }
                default: {
                    modestr = WDM_SDHMode;
                }
            }
            this.setPortMode(neid, slotid, portid, modestr);
        }
    }

    public void queryNeBoardMode(int neid) {
        this.initData(neid);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = null;
        boardList = ne.getBoardList();
        int len = boardList.size();
        for (int k = 0; k < len; ++k) {
            TEBoard board = (TEBoard)boardList.get(k);
            int iBoardType = board.getBoardType();
            int slotid = board.getSlotID();
            this.queryNeBoardMode(neid, slotid, iBoardType);
        }
    }

    public Integer getAlarmFbType(int neID, int slotID, AlmFBKeyType fbKeyType) {
        Integer fbid = TEAlarmDataMgr.getInstance().getAlarmFbType(fbKeyType);
        if (fbid == 255) {
            return this.getCurFb(neID, slotID, fbKeyType);
        }
        return fbid;
    }

    public Integer getCurFb(int neID, int slotID, AlmFBKeyType fbKeyType) {
        int portNO = fbKeyType.getPort();
        int iBoardType = fbKeyType.getBoadType();
        if (TEConfigurationDataMgr.getInstance().isDynPort(neID, iBoardType, portNO)) {
            return new Integer(QueryWDMMode.queryPortType((int)neID, (int)slotID, (int)portNO));
        }
        String workMode = this.getPortMode(neID, slotID, fbKeyType.getPort());
        String boardMode = this.getBoardMode(neID, slotID);
        ArrayList channelModeData = (ArrayList)TEChannelModeDataMgr.getInstance().getChannelData(iBoardType, portNO);
        if (null != channelModeData) {
            int size = channelModeData.size();
            for (int i = 0; i < size; ++i) {
                ChannelPathNode modeNode = (ChannelPathNode)channelModeData.get(i);
                if (!modeNode.getWorkMode().equalsIgnoreCase(workMode) || !modeNode.getBoardMode().equalsIgnoreCase(boardMode) || !modeNode.isCanHangAlarm()) continue;
                return new Integer(modeNode.getFbType());
            }
        }
        return new Integer(0);
    }

    private void queryBoardWorkMode(int neid, int slotid, int portid, int iBoardType) {
        String workMode = QueryWDMMode.QueryBoardWorkMode((int)neid, (int)slotid, (int)portid, (int)iBoardType);
        this.setPortMode(neid, slotid, portid, workMode);
    }

    public ArrayList getNoList(String ListStr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (null == ListStr || "".equals(ListStr.trim())) {
            return list;
        }
        String[] pathlistStrs = ListStr.substring(1, ListStr.length() - 1).split(",");
        String Str = null;
        int minportno = -1;
        int maxportno = -1;
        for (int i = pathlistStrs.length - 1; i >= 0; --i) {
            Str = pathlistStrs[i];
            if (Str.indexOf("-") > 0) {
                minportno = Integer.parseInt(Str.split("-")[0]);
                maxportno = Integer.parseInt(Str.split("-")[1]);
                for (int portno = minportno; portno <= maxportno; ++portno) {
                    list.add(new Integer(portno));
                }
                continue;
            }
            list.add(Integer.valueOf(Str));
        }
        return list;
    }

    private String queryBoardMode(int neid, int slotid) {
        String boardMode = QueryWDMMode.queryBoardMode((int)neid, (int)slotid);
        this.setBoardMode(neid, slotid, boardMode);
        return boardMode;
    }

    public void setBoardMode(int neid, int slotid, String boardMode) {
        Map<String, String> neMapdata = null;
        if (this.boardModeMap.get(neid + "") != null) {
            neMapdata = (Map)this.boardModeMap.get(neid + "");
        } else {
            neMapdata = new HashMap();
            this.boardModeMap.put(neid + "", neMapdata);
        }
        neMapdata.put(slotid + "", boardMode);
    }

    public void setPayloadMode(int neid, int slotid, int port, String payloadMode) {
        Map<String, String> neMapdata = null;
        if (this.payloadModeMap.get(neid + "") != null) {
            neMapdata = (Map)this.payloadModeMap.get(neid + "");
        } else {
            neMapdata = new HashMap();
            this.payloadModeMap.put(neid + "", neMapdata);
        }
        neMapdata.put(slotid + "_" + port, payloadMode);
    }

    public Map queryPayloadMode(int neid, int slotid, List portList, int path) {
        Map payloadMode = QueryWDMMode.getPayloadMode((int)neid, (int)slotid, (List)portList, (int)path);
        return payloadMode;
    }

    public void needUpdatePayloadMode(int neid, int slotid) {
        if (!this.neBoardServerMode.containsKey(neid + "")) {
            return;
        }
        Map neMapdata = (Map)this.neBoardServerMode.get(neid + "");
        if (!neMapdata.containsKey(slotid + "")) {
            return;
        }
        neMapdata.remove(slotid + "");
    }
}

