/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.marine.ethertest_v2r6c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESetEtherTest
extends TENEExplorerBean {
    private ArrayList logInfoList = new ArrayList();
    private static TEResourceUtil res = null;
    private StringBuffer filePath = new StringBuffer();
    private static final String BOARD_L4G = "927";
    private static final String BOARD_N3EAS2 = "2217";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        QxMapping qxMapping = new QxMapping();
        subFunc.clearQxMapping();
        if (this.isIPBoard(boardTypeParam.getValue())) {
            qxMapping.setContent("NSCMD_ETHN_SET_TESTEN");
            subFunc.addQxMapping(qxMapping);
        } else {
            qxMapping.setContent("NSCMD_CFG_SET_GFPATTRIBUTE");
            subFunc.addQxMapping(qxMapping);
            qxMapping = new QxMapping();
            qxMapping.setContent("NSCMD_CFG_SET_GFPRESPONSE");
            subFunc.addQxMapping(qxMapping);
        }
        this.initInforNeedLog(inputData);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private boolean isIPBoard(String value) {
        if (BOARD_L4G.equals(value) || value.equals("1557")) {
            return true;
        }
        return BOARD_N3EAS2.equals(value);
    }

    private void initInforNeedLog(Datainterface inputData) {
        BussinessParams bparams = inputData.getBussinessParams();
        RowParams row = null;
        if (res == null) {
            this.filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ethernettest_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)this.filePath);
        }
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        int len = bparams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bparams.getRowParams(i);
            String operObj = this.getOperObjStr(neObj, row);
            String detailDes = "";
            String paramName = "";
            String paramValue = "";
            int size = row.getParamCount();
            for (int j = 0; j < size; ++j) {
                paramName = row.getParam(j).getName();
                paramValue = row.getParam(j).getValue();
                if ("sendMode".equals(paramName) || "sendDirection".equals(paramName)) {
                    detailDes = detailDes + res.getString(paramName) + ":" + res.getString(paramName + "_" + paramValue) + ",";
                    continue;
                }
                if (!"testFrameNum".equals(paramName)) continue;
                detailDes = detailDes + res.getString(paramName) + ":" + paramValue;
            }
            TELogInfo loginfo = new TELogInfo();
            loginfo.setOperateDesc(operObj + ":" + detailDes);
            this.logInfoList.add(loginfo);
        }
    }

    private String getOperObjStr(TENE neObj, RowParams rowparams) {
        String operObj = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        String slotid = rowparams.getParam("slotid").getValue();
        String port = rowparams.getParam("portid").getValue();
        int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        if (this.isIPBoard("" + boardType)) {
            operObj = operObj + slotid + "-" + boardName + "-" + this.getVctrunk(port);
        } else {
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, Integer.parseInt(slotid), boardType, Integer.parseInt(port));
            String pathid = rowparams.getParam("pathid").getValue();
            operObj = operObj + slotid + "-" + boardName + "-" + portName + "-" + pathid;
        }
        return operObj;
    }

    private String getVctrunk(String port) {
        int portNO = Integer.parseInt(port);
        return "VCTRUNK" + (portNO - 32768);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            TELogInfo loginfoObj1 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObject = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObject ? String.valueOf(neid) : neObject.getNEName();
            if (errorCode != 2 && errorCode != 1) {
                int size = this.logInfoList.size();
                for (int i = 0; i < size; ++i) {
                    loginfoObj1 = (TELogInfo)this.logInfoList.get(i);
                    loginfoObj1.setCmdID(subfunc.getCode());
                    loginfoObj1.setLocation(ipAddress);
                    loginfoObj1.setUserID(userID);
                    loginfoObj1.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfoObj1.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfoObj1.setOperateObject(operObj);
                    if (errorCode != 0) {
                        loginfoObj1.setResult(2);
                    } else {
                        loginfoObj1.setResult(errorCode);
                    }
                    loginfoObj1.setErrCode(errorCode);
                    loginfoObj1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    TELogMgr.writeLog((TELogInfo)loginfoObj1);
                }
            } else {
                int size = this.logInfoList.size();
                for (int i = 0; i < size; ++i) {
                    loginfoObj1 = (TELogInfo)this.logInfoList.get(i);
                    loginfoObj1.setCmdID(subfunc.getCode());
                    loginfoObj1.setLocation(ipAddress);
                    loginfoObj1.setUserID(userID);
                    loginfoObj1.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfoObj1.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfoObj1.setOperateObject(operObj);
                    errorCode = 0;
                    loginfoObj1.setResult(errorCode);
                    loginfoObj1.setErrCode(errorCode);
                    loginfoObj1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    TELogMgr.writeLog((TELogInfo)loginfoObj1);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

