/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.marine.ethertest_v2r6c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.marine.ethertest_v2r6c01.TEEtherTestReport;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryEtherTest
extends TENEExplorerBean {
    private static final String NSCMD_ETHN_GET_TESTEN = "NSCMD_ETHN_GET_TESTEN";
    private static final String NSCMD_ETHN_GET_TESTCOUNT = "NSCMD_ETHN_GET_TESTCOUNT";
    private static final int VCTRUNK = 32768;
    private static final String INVAILEDNUM = "65535";
    private static final String CFGGETISNULL = "38662";
    private static final String PALOADOVER = "39555";
    private static final String BOARD_L4G = "927";
    private String boardType = "";
    int slotID = -1;
    private String operObj = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            Param reportParam;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
            Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
            this.boardType = boardTypeParam.getValue();
            this.slotID = Integer.parseInt(slotidParam.getValue());
            TEEtherTestReport ethTestReport = TEEtherTestReport.getTthTestReport(neid, this.slotID);
            if (!ethTestReport.hasRegisterd()) {
                ethTestReport.register();
            }
            if (null != (reportParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"report")) && "true".equals(reportParam.getValue())) {
                return this.reportData(ethTestReport);
            }
            this.outputData = new Datainterface();
            this.operationList = this.isIPBoard(boardTypeParam.getValue()) ? this.convertToOperation(subFunc, inputData) : this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean isIPBoard(String value) {
        return value.equals(BOARD_L4G) || value.equals("1557") || value.equals("2217");
    }

    private Datainterface reportData(TEEtherTestReport ethTestReport) {
        Param needReport = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"needReport");
        String[] needReportArray = needReport.getValue().split(",");
        Datainterface reportData = ethTestReport.getReportData();
        String report = "";
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        RowParams rowParams = null;
        for (int len = reportData.getBussinessParams().getRowParamsCount() - 1; len >= 0; --len) {
            rowParams = reportData.getBussinessParams().getRowParams(len);
            report = BOARD_L4G.equals(this.boardType) || "1557".equals(this.boardType) || "2217".equals(this.boardType) ? rowParams.getParam("portid").getValue() : rowParams.getParam("portid").getValue() + "-" + rowParams.getParam("pathid").getValue();
            RowParams rowparams = (RowParams)reportData.getBussinessParams().getRowParams(len).clone();
            int portlen = needReportArray.length;
            for (int i = 0; i < portlen; ++i) {
                if (!report.equals(needReportArray[i])) continue;
                bussinessParams.addRowParams(rowparams);
            }
        }
        return returnReportData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        ArrayList supportVCTRUNKPort;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        Param needReport = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"needReport");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        if (needReport.getValue().isEmpty()) {
            supportVCTRUNKPort = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neid, Integer.valueOf(slotidParam.getValue()).intValue(), boardType);
        } else {
            String[] needReportArray;
            supportVCTRUNKPort = new ArrayList();
            for (String temp : needReportArray = needReport.getValue().split(",")) {
                supportVCTRUNKPort.add(temp);
            }
        }
        Operation oper = null;
        Input input = null;
        Part part = null;
        int len = supportVCTRUNKPort.size();
        for (int i = 0; i < len; ++i) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_TESTEN);
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_TESTCOUNT);
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        String portid = null;
        String slotid = "";
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowParams.getParamCount()) continue;
            portid = rowParams.getParam("portid").getValue();
            if (!this.isIPBoard(this.boardType)) {
                slotid = this.outputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
                portid = TEConfigurationDataMgr.getInstance().getPortName(neid, Integer.parseInt(slotid), Integer.parseInt(this.boardType), Integer.parseInt(portid));
            } else {
                portid = portid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(portid) > 32768 ? "VCTRUNK" + (Integer.parseInt(portid) - 32768) : "PORT" + portid);
            }
            rowParams.getParam("portid").setValue(portid);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(CFGGETISNULL));
        codeList.add(Integer.valueOf(PALOADOVER));
        return codeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            TENE neObj;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfoObj = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            this.operObj = null == (neObj = TENEListMgr.getInstance().getNE(neid)) ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                loginfoObj = new TELogInfo();
                loginfoObj.setResult(0);
                loginfoObj.setErrCode(0);
                loginfoObj.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfoObj);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    String errmsg;
                    String errcode;
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    ArrayList<String> errcodeList = new ArrayList<String>();
                    ArrayList<String> errmsgList = new ArrayList<String>();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        errcode = rowErrors[j].getErrorMessage().getErrorcode();
                        if (errcodeList.contains(errcode)) continue;
                        errmsg = rowErrors[j].getErrorMessage().getErrorinfo();
                        errcodeList.add(errcode);
                        errmsgList.add(errmsg);
                    }
                    size = errcodeList.size();
                    for (int k = 0; k < size; ++k) {
                        errcode = (String)errcodeList.get(k);
                        errmsg = (String)errmsgList.get(k);
                        loginfoObj = new TELogInfo();
                        loginfoObj.setResult(2);
                        loginfoObj.setErrCode(Integer.parseInt(errcode));
                        loginfoObj.setErrInfo(errmsg);
                        loginfoList.add(loginfoObj);
                    }
                }
            } else {
                loginfoObj = new TELogInfo();
                loginfoObj.setResult(2);
                loginfoObj.setErrCode(errorCode);
                loginfoObj.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfoObj);
            }
            TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
            int boardType = configurDataMgr.getBoard(neid, this.slotID).getBoardType();
            configurDataMgr.getBoardTypeName(neid, boardType);
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfoObj = (TELogInfo)loginfoList.get(i);
                loginfoObj.setCmdID(subfunc.getCode());
                loginfoObj.setLocation(ipAddress);
                loginfoObj.setUserID(userID);
                loginfoObj.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfoObj.setOperateName(subfunc.getSubFuncDes(neid));
                loginfoObj.setOperateObject(this.operObj);
                String detailDes = this.operObj;
                if (null != inputData.getBussinessParams().getRowParams(0).getParam("slotid")) {
                    int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
                    String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
                    if (!"".equals(subrackname)) {
                        detailDes = detailDes + "-" + subrackname;
                    }
                    int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    detailDes = detailDes + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                }
                loginfoObj.setOperateDesc(detailDes);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

