/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bundleactivator;

import com.huawei.nglct.bundleactivator.MarineDomainBundleRegCmd;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.TENEMgrLauncher;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDispatcher;
import com.huawei.nglct.jni.asncommu.TEAsnMsgDispatcher;
import com.huawei.nglct.nelist.handler.TENEHandlerInf;
import com.huawei.nglct.nelist.handler.TENEHandlerMgr;
import com.huawei.nglct.nemgr.marine.TEMarineDomainFileProvider;
import com.huawei.nglct.nemgr.marine.bumanagement.bue2e.TEBUMgrTask;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TESLMBUDataMgr;
import com.huawei.nglct.nemgr.marine.e2e.cablemgr.TEMarineCableMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.ctbmgr.TEMarineCTBMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.enginfo.TEMarineEngInfoMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.faultlocatedemo.TEFaultLocateDemoManager;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMETestMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.psumgr.TEMarinePSUMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.quickfault.TEMarineQuickFaultTask;
import com.huawei.nglct.nemgr.marine.e2e.repeatermgr.TEMarineRepeaterMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.stationmgr.TEMarineStationMgrTask;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineNEDeleteHandler;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineStnViewTask;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCableMgrTask;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickFaultLocateTask;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineMgrTask;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.IFileProvider;
import gnu.trove.TIntArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

public class MarineDomainBundleActivator
implements BundleActivator,
BundleListener,
IFileRegisterer {
    private static final int NETYPE_BWS1600ST16 = 96;
    private static final int NETYPE_PFE1670 = 72;
    private Logger log = TELogFactory.getNormalLogger();
    private TIntArrayList fbMapping = new TIntArrayList();
    private ServiceRegistration sr = null;

    public void start(BundleContext context) throws Exception {
        context.registerService(IFileProvider.class.getName(), (Object)new TEMarineDomainFileProvider(), null);
        context.addBundleListener((BundleListener)this);
        try {
            this.fbMapping = TEFileRegisterer.registerFiles((Bundle)context.getBundle());
            this.sr = context.registerService(IFileRegisterer.class.getName(), (Object)this, null);
        }
        catch (Exception e) {
            this.log.error("MarineDomainBundleActivator start() fail!", (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        TESLMOTDRDataMgr.clear();
        this.sr.unregister();
        this.unregisterNoticeHandler();
    }

    public void unregisterNoticeHandler() {
        TEFaultLocateDemoManager.getInstance().unregisterNoticeHander();
    }

    public void bundleChanged(BundleEvent arg0) {
        Bundle bundle = (Bundle)arg0.getSource();
        Bundle commBundle = FrameworkUtil.getBundle(IFileProvider.class);
        Bundle marineBundle = FrameworkUtil.getBundle(TEMarineDomainFileProvider.class);
        if ("com.huawei.weblct.marine_domain".equals(bundle.getSymbolicName()) && bundle.getState() == 32 && commBundle.getState() == 32 || "com.huawei.weblct.common".equals(bundle.getSymbolicName()) && bundle.getState() == 32 && marineBundle.getState() == 32) {
            this.initOTDR();
            this.startMarineNeMgr();
            this.initBUDataMgr();
            this.registerNoticeHandler();
        }
    }

    public void registerNoticeHandler() {
        TEFaultLocateDemoManager.getInstance().registerNoticeHandler();
    }

    private void initOTDR() {
        System.out.println("MARINE ---- BEGIN to load otdr data......");
        this.log.info("MARINE ---- BEGIN to load otdr data......");
        try {
            long start = System.currentTimeMillis();
            TESLMOTDRDataMgr.initOTDR();
            long timeUse = System.currentTimeMillis() - start;
            float timeSecond = (float)timeUse / 1000.0f;
            System.out.println("MARINE ---- time use to load otdr data (s)->" + timeSecond);
            this.log.info("MARINE ---- time used to load otdr data (s)->" + timeSecond);
        }
        catch (Exception e) {
            System.out.println("MARINE ---- FAILED to load otdr data.....");
            this.log.error("MarineDomainBundleActivator.initOTDR()---- FAILED to load otdr data!", (Throwable)e);
        }
        System.out.println("MARINE ---- END to load otdr data......");
        this.log.info("MARINE ---- END to load otdr data......");
    }

    private void initBUDataMgr() {
        try {
            TESLMBUDataMgr dataMgr = TESLMBUDataMgr.getInstance();
            dataMgr.initBUDataMgr();
        }
        catch (Exception e) {
            this.log.error("MarineDomainBundleActivator.initBUDataMgr()---- FAILED to init bu data manager!", (Throwable)e);
        }
    }

    private void startMarineNeMgr() {
        TENEMgrLauncher.start((int)189, (String)"conf/nemgr_marine_4682.cfg");
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            MarineDomainBundleRegCmd.regCmdCode();
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineStationMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEBUMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineCTBMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarinePSUMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineCableMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineRepeaterMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineLineMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineQuickFaultTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineStnViewTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TESLMETestMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineEngInfoMgrTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEMarineStnEleCableMgrTask.class);
            TEAsnMsgDispatcher.getInstance().registerTask(QuickFaultLocateTask.class);
            TENEHandlerMgr.getInstance().registerListener(61, (TENEHandlerInf)new TEMarineNEDeleteHandler());
            TENEHandlerMgr.getInstance().registerListener(56, (TENEHandlerInf)new TEMarineNEDeleteHandler());
            TENEHandlerMgr.getInstance().registerListener(72, (TENEHandlerInf)new TEMarineNEDeleteHandler());
            TENEHandlerMgr.getInstance().registerListener(96, (TENEHandlerInf)new TEMarineNEDeleteHandler());
        }
    }

    public boolean containsResFile(String filePath) {
        int hash = TEStringUtils.hashString((String)filePath);
        return this.fbMapping.contains(hash);
    }
}

