/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.device.marine.subrack;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.EscapeUnescape;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.Vector;

public class TESubrackQueryBean
extends TENEExplorerBean {
    public static final int COMM_ABNORMAL = 1090617361;
    private static final String MAIN_SUBRACK_ID = "0";
    private static final String FIRST_QUERY = "1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            boolean isException;
            this.neid = neid;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            Vector subrackList = neObj.getClonedSubrackList();
            if (subrackList == null || subrackList.isEmpty()) {
                TESubrack defaultSubrack = new TESubrack(MAIN_SUBRACK_ID, String.valueOf(neObj.getNEType()), "");
                this.outputData.getBussinessParams().addRowParams(this.addRow(neObj, defaultSubrack, 1));
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                TELogFactory.getNormalLogger().error("Query Subrack failed! Use default subrack.");
                return this.outputData;
            }
            RowParams rParam = inputData.getBussinessParams().getRowParams()[0];
            String isFirstQuery = rParam.getParam("isFirstQuery").getValue();
            Vector lastSubrackList = neObj.getBackupSubrackList();
            if (lastSubrackList != null) {
                if (subrackList.containsAll(lastSubrackList) && lastSubrackList.containsAll(subrackList) && !FIRST_QUERY.equals(isFirstQuery)) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)38662));
                    return this.outputData;
                }
                lastSubrackList.clear();
                lastSubrackList.addAll((Vector)subrackList.clone());
                neObj.setBackupSubrackList(lastSubrackList);
            }
            if (isException = this.handleExceptionStates(neObj, subrackList)) {
                return this.outputData;
            }
            int size = subrackList.size();
            for (int i = 0; i < size; ++i) {
                TESubrack subrackObj = (TESubrack)subrackList.get(i);
                RowParams rParams = this.addRow(neObj, subrackObj, i + 1);
                this.outputData.getBussinessParams().addRowParams(rParams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!");
            return null;
        }
        return this.outputData;
    }

    private boolean handleExceptionStates(TENE ne, Vector subrackList) {
        if (0 == ne.getComStarus()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090617361));
            return true;
        }
        if (0 == ne.getLogStatus()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)37926));
            return true;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return false;
    }

    private RowParams addRow(TENE neObj, TESubrack subrack, int num) {
        RowParams rParams = new RowParams();
        rParams.addParam("serialNum", String.valueOf(num));
        rParams.addParam("nename", neObj.getNEName());
        rParams.addParam("neType", neObj.getDeviceType());
        rParams.addParam("subrackID", subrack.getSubrackID());
        rParams.addParam("logicSubrackType", subrack.getLogicSubrackType());
        rParams.addParam("subrackState", subrack.getSubrackState());
        rParams.addParam("phySubrackType", subrack.getPhySubrackType());
        rParams.addParam("subrackMemo", EscapeUnescape.escape((String)IOStreamConvertor.replaceSpecialStr((String)subrack.getSubrackName())));
        TENEAlarmAnalyse analyse = neObj.getCurTopLevelAlmOnSubrack(Integer.valueOf(subrack.getSubrackID()).intValue());
        if (analyse == null) {
            rParams.addParam("subrackTopLevelAlm", "");
        } else {
            rParams.addParam("subrackTopLevelAlm", String.valueOf(analyse.getTopAlmLevel()));
        }
        return rParams;
    }
}

