
window.tableconf = [];
window.ctableconf = [];

OPTag.prototype.getName = function()
{
	return this.name;
}

OPTag.prototype.getValue = function()
{
	return this.value;
}

OPTag.prototype.getConvert = function()
{
	return this.convert;
}
/**
 *           QX            
 */
OPTag.prototype.getConvertToNEValue = function()
{
	return this.convertToNEValue;
}
OPTag.prototype.getShow = function()
{
	return this.show;
}

OPTag.prototype.getUnit = function()
{
	return this.unit;
}

OPTag.prototype.getInvalid = function()
{
	return this.invalid;
}

function OPTag()
{
	this.name = null;
	this.value = null;
	this.convert = null;
	/**
	 *           QX            
	 */
	this.convertToNEValue = null;
	this.show = null;
	this.unit = null;
	this.invalid = null;
}

function VerifyObj()
{
	this.type = null;
	this.min = null;
	this.max = null;
	this.decimal = null;
	this.other = null;
	this.length = null;
	this.step = null;
	this.isblock = null;
}
/**
 *          
 * @param {Object} type
 * @param {Object} min
 * @param {Object} max
 * @param {Object} decimal
 * @param {Object} other
 */
VerifyObj.prototype.setRange = function(type,min,max,decimal,other)
{
	if (typeof(type) != "undefined") 
	{
		this.type = type;
	}
	if (typeof(min) != "undefined") 
	{
		this.min = min;
	}
	if (typeof(max) != "undefined") 
	{
		this.max = max;
	}
	if (typeof(decimal) != "undefined") 
	{
		this.decimal = decimal;
	}
	if (typeof(other) != "undefined") 
	{
		this.other = other;
	}
}
/**
 *      
 * @param {Object} min
 */
VerifyObj.prototype.setMin = function(min)
{
	this.min = min;
}
/**
 *      
 * @param {Object} max
 */
VerifyObj.prototype.setMax = function(max)
{
	this.max = max;
}


function ElementTag()
{
	this.verify = null;
	this.defvalue = null;
	this.type = null;
	this.dispval = null;
	this.options = new Array();
}

function CellTag()
{
	this.isEdit = null;
	this.showElement = null;
	this.editElement = null;
}
/**
 *   Option     
 */
CellTag.prototype.clearEditElementOption = function()
{
	if (this.editElement != null
			&& this.editElement.options != null) 
	{
		this.editElement.options.length = 0;
	}
}
/**
 *   EditElement Option     
 * @param {Object} index
 * @param {Object} name
 * @param {Object} value
 */
CellTag.prototype.addEditElementOptionAt = function(index,name,value)
{
	if (this.editElement != null
	&& this.editElement.options != null) 
	{
		var opobj = new OPTag();
		opobj.name = name;
		opobj.value = value;
		this.editElement.options.splice(index,0,opobj);
	}
}
/**
 *   EditElement Option
 * @param {Object} name
 * @param {Object} value
 */
CellTag.prototype.addEditElementOption = function(name,value)
{
	if (this.editElement != null
	&& this.editElement.options != null) 
	{
		var opobj = new OPTag();
		opobj.name = name;
		opobj.value = value;
		this.editElement.options[this.editElement.options.length] = opobj;
	}
}
/**
 *   EditElement  
 */
CellTag.prototype.getEditElement = function()
{
	return this.editElement;
}
/**
 *   EditElement Options   
 */
CellTag.prototype.getEditOptionsLength = function()
{
	var result = 0;
	if(this.editElement != null
	&& this.editElement.options != null)
	{
		result = this.editElement.options.length;
	}
	return result;
}
/**
 *   EditElement     verify
 */
CellTag.prototype.getEditElementVerify = function()
{
	if(this.editElement != null)
	{
		return this.editElement.verify;
	}
	return null;
}

function ColTag()
{
	this.id = null;
	this.name = null;
	this.isSort = null;
	this.width = null;
	this.isSortShow = null;
	this.sortCols = null;
	this.compare = null;
	this.cell = null;
	this.keyArray = new Array();
}
/**
 *       Cell  CellTag
 */
ColTag.prototype.getCell = function()
{
	return this.cell;
}
/**
 *         
 * @param {Object} width
 */
ColTag.prototype.setWidth = function(width)
{
	this.width = width;
}
/**
 *              
 * @param {Object} compare
 */
ColTag.prototype.setCompare = function(compare)
{
	this.compare = compare;
}
TableConf.prototype.getColFromColId = function(colId)
{
	for ( var i = 0, len = this.colArray.length; i < len; i++)
	{
		if (this.colArray[i].id == colId)
		{
			return this.colArray[i];
		}
	}
	return null;
}

TableConf.prototype.getColIdFromKey = function(key)
{
	for ( var index = 0, len = this.colArray.length; index < len; index++)
	{
		for ( var j = 0, size = this.colArray[index].keyArray.length; j < size; j++)
		{
			if (this.colArray[index].keyArray[j].name == key)
			{
				return this.colArray[index].id;
			}
		}
	}
	return null;
}

TableConf.prototype.getColsLength = function()
{
	return this.colArray.length;
}

TableConf.prototype.getColId = function(index)
{
	return this.colArray[index].id;
}

TableConf.prototype.getColName = function(index)
{
	return this.colArray[index].name;
}

TableConf.prototype.getColWidth = function(index)
{
	return this.colArray[index].width;
}

TableConf.prototype.getColIsSort = function(index)
{
	return this.colArray[index].isSort;
}

TableConf.prototype.getColIsSortShow = function(index)
{
	return this.colArray[index].isSortShow;
}
TableConf.prototype.getColSortCols = function(index)
{
	return this.colArray[index].sortCols;
}
TableConf.prototype.getColKeyArray = function(index)
{
	return this.colArray[index].keyArray;
}

TableConf.prototype.getColCompare = function(index)
{
	return this.colArray[index].compare;
}

TableConf.prototype.getColShowType = function(index)
{
	return this.colArray[index].cell.showElement.type;
}

TableConf.prototype.getColShowOptions = function(index)
{
	return this.colArray[index].cell.showElement.options;
}

TableConf.prototype.getColEdit = function(index)
{
	return this.colArray[index].cell.editElement;
}

TableConf.prototype.getColEditType = function(index)
{
	return this.colArray[index].cell.editElement.type;
}

TableConf.prototype.getColEditDispVal = function(index)
{
	return this.colArray[index].cell.editElement.dispval;
}

TableConf.prototype.getColEditOptions = function(index)
{
	return this.colArray[index].cell.editElement.options;
}

TableConf.prototype.getIsEdit = function(index)
{
	return this.colArray[index].cell.isEdit;
}

TableConf.prototype.hasEditElement = function(index)
{
	if (this.colArray[index].cell.editElement)
	{
		return true;
	}
	else
	{
		return false;
	}
}

TableConf.prototype.hasShowElement = function(index)
{
	if (this.colArray[index].cell.showElement)
	{
		return true;
	}
	else
	{
		return false;
	}
}

TableConf.prototype.getIndexByid = function(id)
{
	for ( var i = 0; i < this.colArray.length; i++)
	{
		if (this.colArray[i].id == id)
		{
			break;
		}
	}
	if (this.colArray.length == i)
	{
		return -1;
	}
	return i;
}

function TableConf()
{
	this.id = window.tableconf.length;
	window.tableconf[this.id] = this;
	this.colArray = new Array();
}


function EncapsulateTable(xmldoc)
{
	var tc = new TableConf();

	var tabconf = xmldoc.getElementsByTagName("tabconf")[0];
	if (tabconf.getAttribute("foxwidth"))
	{
		tc.width = tabconf.getAttribute("foxwidth");
	}
	if (tabconf.getAttribute("iewidth"))
	{
		tc.percent = tabconf.getAttribute("iewidth");
	}

	var cols = xmldoc.getElementsByTagName("col");
	for ( var i = 0; i < cols.length; i++)
	{
		var colobj = new ColTag();
		colobj.id = cols[i].getAttribute("id");
		colobj.name = cols[i].getAttribute("name");
		colobj.isSort = cols[i].getAttribute("isSort");
		colobj.width = cols[i].getAttribute("width");
		colobj.isSortShow = cols[i].getAttribute("isSortShow");
		colobj.sortCols = cols[i].getAttribute("sortCols");
		colobj.compare = cols[i].getAttribute("compare");

		var key = cols[i].getElementsByTagName("key")[0];
		if (key)
		{
			var keyoptions = key.getElementsByTagName("option");
			for ( var j = 0; j < keyoptions.length; j++)
			{
				var opobj = new OPTag();
				opobj.name = keyoptions[j].getAttribute("name");
				opobj.convert = keyoptions[j].getAttribute("convert");				
				opobj.convertToNEValue = keyoptions[j].getAttribute("convertToNEValue");
				opobj.show = keyoptions[j].getAttribute("show");
				opobj.unit = keyoptions[j].getAttribute("unit");
				opobj.invalid = keyoptions[j].getAttribute("invalid");
				colobj.keyArray[colobj.keyArray.length] = opobj;
			}
		}

		var cell = cols[i].getElementsByTagName("cell")[0];
		var cellobj = new CellTag();
		cellobj.isEdit = cell.getAttribute("isEdit")
		var show = cell.getElementsByTagName("showElement")[0];
		var showobj = new ElementTag();
		showobj.type = show.getAttribute("type");
		var soptions = show.getElementsByTagName("option");
		for ( var j = 0; j < soptions.length; j++)
		{
			var opobj = new OPTag();
			opobj.name = soptions[j].getAttribute("name");
			opobj.value = soptions[j].getAttribute("value");
			opobj.convert = soptions[j].getAttribute("convert");
			opobj.show = soptions[j].getAttribute("show");
			opobj.unit = soptions[j].getAttribute("unit");
			opobj.invalid = soptions[j].getAttribute("invalid");
			showobj.options[showobj.options.length] = opobj;
		}

		cellobj.showElement = showobj;

		var edit = cell.getElementsByTagName("editElement")[0];
		if (edit)
		{
			var editobj = new ElementTag();
			editobj.type = edit.getAttribute("type");
			if(edit.getAttribute("dispval") != null)
			{
				editobj.dispval = edit.getAttribute("dispval");
			}
			var eoptions = edit.getElementsByTagName("option");
			for ( var j = 0; j < eoptions.length; j++)
			{
				var opobj = new OPTag();
				opobj.name = eoptions[j].getAttribute("name");
				opobj.value = eoptions[j].getAttribute("value");
				opobj.convert = eoptions[j].getAttribute("convert");
				opobj.show = eoptions[j].getAttribute("show");
				opobj.unit = eoptions[j].getAttribute("unit");
				opobj.invalid = eoptions[j].getAttribute("invalid");
				editobj.options[editobj.options.length] = opobj;
			}
			var everify = edit.getElementsByTagName("verify")[0];
			if (everify)
			{
				var vefiobj = new VerifyObj();
				vefiobj.type = everify.getAttribute("type");
				if (vefiobj.type == "num")
				{
					vefiobj.min = everify.getAttribute("min");
					vefiobj.max = everify.getAttribute("max");
					
					if(everify.getAttribute("decimal") != null)
					{
						vefiobj.decimal = everify.getAttribute("decimal");
					}

					if(everify.getAttribute("other") != null)
					{
						vefiobj.other = everify.getAttribute("other");
					}
					
					if(everify.getAttribute("step") != null)
					{
						vefiobj.step = everify.getAttribute("step");
					}
				}
				else if (vefiobj.type == "string")
				{
					vefiobj.length = everify.getAttribute("length");

				}
				else if (vefiobj.type == "func")
				{
					vefiobj.length = everify.getAttribute("length");
					if(everify.getAttribute("isblock") != null)
					{
						vefiobj.isblock = everify.getAttribute("isblock") == "1"?true:false;
					}
				}
				editobj.verify = vefiobj;
			}
			cellobj.editElement = editobj;
		}
		
		colobj.cell = cellobj;
		tc.colArray[tc.colArray.length] = colobj;
	}
	return tc;
}



function CTableConf()
{
	this.id = window.ctableconf.length;
	window.ctableconf[this.id] = this;
	this.attrArray = new Array();
}

function AttrTag()
{
	this.id = null;
	this.name = null;
	this.cell = null;
	this.event = null;
}

function EventTag()
{
	this.onchange = null;
	this.onblur = null;
	this.onkeydown = null;
	this.onkeypress = null;
	this.onpaste = null;
	this.onclick = null;
}

function EncapsulateCTable(xmldoc)
{
	var tc = new CTableConf();

	var ctableconf = xmldoc.getElementsByTagName("tabconf")[0];
	var attrObjs = xmldoc.getElementsByTagName("attr");
	for ( var i = 0; i < attrObjs.length; i++)
	{
		var attrObj = new AttrTag();
		attrObj.id = attrObjs[i].getAttribute("id");
		attrObj.name = attrObjs[i].getAttribute("name");
		
		var cell = attrObjs[i].getElementsByTagName("cell")[0];
		var cellobj = new CellTag();
		cellobj.isEdit = cell.getAttribute("isEdit")
		var edit = cell.getElementsByTagName("editElement")[0];
		if (edit)
		{
			var editobj = new ElementTag();
			editobj.type = edit.getAttribute("type");
			editobj.defvalue = edit.getAttribute("defaultvalue");
			var eoptions = edit.getElementsByTagName("option");
			for ( var j = 0; j < eoptions.length; j++)
			{
				var opobj = new OPTag();
				opobj.name = eoptions[j].getAttribute("name");
				opobj.value = eoptions[j].getAttribute("value");
				opobj.convert = eoptions[j].getAttribute("convert");
				editobj.options[editobj.options.length] = opobj;
			}
			var everify = edit.getElementsByTagName("verify")[0];
			if (everify)
			{
				var vefiobj = new VerifyObj();
				vefiobj.type = everify.getAttribute("type");
				if (vefiobj.type == "num")
				{
					vefiobj.min = everify.getAttribute("min");
					vefiobj.max = everify.getAttribute("max");
				
					if(everify.getAttribute("decimal") != null)
					{
						vefiobj.decimal = everify.getAttribute("decimal");
					}
					if(everify.getAttribute("other") != null)
					{
						vefiobj.other = everify.getAttribute("other");
					}
					if(everify.getAttribute("step") != null)
					{
						vefiobj.step = everify.getAttribute("step");
					}
				}
				else if (vefiobj.type == "string")
				{
					vefiobj.length = everify.getAttribute("length");

				}
				else if (vefiobj.type == "func")
				{
					vefiobj.length = everify.getAttribute("length");
					if(everify.getAttribute("isblock") != null)
					{
						vefiobj.isblock = everify.getAttribute("isblock") == "1"?true:false;
					}
				}
				editobj.verify = vefiobj;
			}
			cellobj.editElement = editobj;
		}
		attrObj.cell = cellobj;
		
		var event = attrObjs[i].getElementsByTagName("event")[0];
		if (event)
		{
			var eventObj = new EventTag();
			eventObj.onchange = event.getAttribute("onchange");
			eventObj.onblur = event.getAttribute("onblur");
			eventObj.onkeydown = event.getAttribute("onkeydown");
			eventObj.onkeypress = event.getAttribute("onkeypress");
			eventObj.onpaste = event.getAttribute("onpaste");
			eventObj.onclick = event.getAttribute("onclick");
			attrObj.event = eventObj;
		}

		tc.attrArray[tc.attrArray.length] = attrObj;
	}
	return tc;
}

function ParamTag()
{
	this.value = null;
	this.options = null;
}

function ErrorTag()
{
	this.code = null;
	this.info = null;
}

function RowError()
{
	this.errorObj = new Object();
	this.error = null;
}
AllError.prototype.getGlobleECode = function()
{
	return this.s_error.code;
}

AllError.prototype.getGlobleEInfo = function()
{
	return this.s_error.info;
}

AllError.prototype.getRowErrLength = function()
{
	return this.rowErrors.length;
}

AllError.prototype.getRowKey = function(index, key)
{
	return this.rowErrors[index].errorObj[key];
}

AllError.prototype.getRowCode = function(index)
{
	return this.rowErrors[index].error.code;
}

AllError.prototype.getRowInfo = function(index)
{
	return this.rowErrors[index].error.info;
}
function AllError()
{
	this.rowErrors = new Array();
	this.s_error = null;
}
DataInterface.prototype.getDataRowLength = function()
{
	return this.rows.length;
}
DataInterface.prototype.getDataRowParam = function(index, key)
{
	if (null == this.rows[index] || null == this.rows[index][key])
	{
		return null;
	}
	return this.rows[index][key].value;
}
DataInterface.prototype.getDataRow = function(index)
{
	if (null == this.rows[index])
	{
		return null;
	}
	return this.rows[index];
}
DataInterface.prototype.getDataRowOptions = function(index, key)
{
	if (null == this.rows[index][key])
	{
		return null;
	}
	return this.rows[index][key].options;
}

DataInterface.prototype.removeDataRowAt = function(index)
{
	this.rows.splice(index,1);
}

DataInterface.prototype.addDataRowAt = function(index,obj)
{
	this.rows.splice(index, 0, obj);
}

DataInterface.prototype.addDataRow = function(obj)
{
	this.rows.push(obj);
}

DataInterface.prototype.getPageParam = function(key)
{
	return this.page[key];
}

DataInterface.prototype.getBErrLength = function()
{
	return this.errObj.rowErrors.length;
}

DataInterface.prototype.getBErrParam = function(index, key)
{
	return this.errObj.rowErrors[index].errorObj[key];
}

DataInterface.prototype.getBErrorCode = function(index)
{
	return this.errObj.rowErrors[index].error.code;
}

DataInterface.prototype.getBErrorInfo = function(index)
{
	return this.errObj.rowErrors[index].error.info;
}

DataInterface.prototype.getSErrorCode = function(index)
{
	return this.errObj.s_error.code;
}

DataInterface.prototype.setSErrorCode = function(code)
{
	this.errObj.s_error.code = code;
}

DataInterface.prototype.getSErrorInfo = function(index)
{
	return this.errObj.s_error.info;
}

DataInterface.prototype.setSErrorInfo = function(info)
{
	this.errObj.s_error.info = info;
}

DataInterface.prototype.getError = function()
{
	return this.errObj;
}
DataInterface.prototype.cloneRows = function()
{
	var rows = new Array();
	for(var i=0,iLength = this.rows.length ;i<iLength;i++)
	{
		var obj = new Object();
		for(var p in this.rows[i])
		{
			 var srcObj = this.rows[i][p];
			 obj[p] =new Object(); 
			 for(var a in srcObj)
			 {
			 	 obj[p][a] = srcObj[a];
			 }
		}
		rows[rows.length] = obj;
	}
	return rows;
}

/**
 *           
 *           true;
 *            false;
 *    
 * 	               
 */
DataInterface.prototype.isAllSuccess = function()
{
	var ret = ( this.getSErrorCode() == 0 );
	
	return ret;
}

function DataInterface()
{
	this.rows = new Array();
	this.errObj = null;
	this.page = new Object();
}

function EncapsulateData(doc)
{
	var dinterface = new DataInterface();
	var allerror = new AllError();
	var filterErrorCode = [];

	var rowerrs = doc.getElementsByTagName("row-errors");
	for ( var i = rowerrs.length - 1; i>= 0; i--)
	{
		var reobj = new RowError();
		var params = rowerrs[i].childNodes;
		for ( var j = 0; j < params.length; j++)
		{
			if (typeof (params[j].tagName) != "undefined"
					&& params[j].tagName.toLowerCase() == "param")
			{
				reobj.errorObj[params[j].getAttribute("name")] = params[j]
						.getAttribute("value");
			}
		}
		var errtag = rowerrs[i].getElementsByTagName("error-message")[0];
		var eTag = new ErrorTag();
		eTag.code = errtag.getAttribute("errorcode");
		eTag.info = errtag.getAttribute("errorinfo");
		reobj.error = eTag;

		if (eTag.code == '37926')
		{
			if (filterErrorCode.contains(eTag.code))
			{
				continue;
			}
			else
			{
				filterErrorCode.push(eTag.code);
			}
		}

		allerror.rowErrors[allerror.rowErrors.length] = reobj;
	}

	var len = rowerrs.length;
	while (len > 0)
	{
		rowerrs[len - 1].parentNode.removeChild(rowerrs[len - 1]);
		len--;
	}

	var errtag = null;
	errtag = doc.getElementsByTagName("error-message")[0];
	var eTag = new ErrorTag();
	eTag.code = (null == errtag) ? null : errtag.getAttribute("errorcode");
	eTag.info = (null == errtag) ? null : errtag.getAttribute("errorinfo");
	allerror.s_error = eTag;

	dinterface.errObj = allerror;

	var rows = doc.getElementsByTagName("row-params");
	for ( var i = 0; i < rows.length; i++)
	{
		var params = rows[i].childNodes;
		var obj = new Object();
		if (params.length > 0)
		{
			var bNotEmptyData = false;
			for ( var j = 0; j < params.length; j++)
			{
				if (typeof (params[j].tagName) != "undefined"
						&& params[j].tagName.toLowerCase() == "param")
				{
					bNotEmptyData = true;
					var ptag = new ParamTag();
					ptag.value = params[j].getAttribute("value");

					if (params[j].getElementsByTagName("option").length > 0)
					{
						var ops = new Array();
						for ( var k = 0; k < params[j]
								.getElementsByTagName("option").length; k++)
						{
							ops[k] = params[j].getElementsByTagName("option")[k]
									.getAttribute("value");
						}
						ptag.options = ops;
					}

					obj[params[j].getAttribute("name")] = ptag;
				}
			}
			if(bNotEmptyData)
      {
				dinterface.rows[dinterface.rows.length] = obj;
			}
		}
	}
	var page = doc.getElementsByTagName("page-params")[0];
	if (page)
	{
		var params = page.childNodes;
		for ( var i = 0; i < params.length; i++)
		{
			if (typeof (params[i].tagName) != "undefined"
					&& params[i].tagName.toLowerCase() == "param")
			{
				var ptag = new ParamTag();
				dinterface.page[params[i].getAttribute("name")] = ptag;
				ptag.value = params[i].getAttribute("value");
			}
		}
	}
	return dinterface;
}

function tagElement(tag,name,value)
{
	this.headstr = "<" + tag;
	this.tailstr = "</" + tag + ">";
	this.text = "";
	this.childNodes = new Array();
	this.attributes = new Array();

	this.appendChild = function(tagElementObj)
	{
		this.childNodes[this.childNodes.length] = tagElementObj;
	}

	this.setAttribute = function(n, v)
	{
		if (n == "value")
		{
			v = encodeURIComponent(convertSpecStr(v));
		}
		this.attributes[this.attributes.length] = " " + n + '="' + v + '"';
	}
	if(typeof(name) != "undefined")
	{
		this.setAttribute("name",name);
		this.setAttribute("value",value);
	}
  this.setAttributeWithoutConvert = function(n, v)
  {
  	if	(n == "value")
  	{	
  			v = encodeURIComponent(v);
  	}	
  	this.attributes[this.attributes.length] = " " + n + '="'+v+'"';
  }
	this.setText = function(str)
	{
		this.text = str;
	}

	this.toString = function()
	{
		var str = this.headstr;
		for ( var i = 0; i < this.attributes.length; i++)
		{
			str += " " + this.attributes[i];
		}
		if ((this.text == null || this.text == "")
				&& this.childNodes.length == 0)
		{
			return str += "/>";
		}
		else
		{
			str += ">" + this.text;
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				str += this.childNodes[i].toString();
			}
			str += this.tailstr;
			return str;
		}
	}
}

function inputxml(roottag)
{

	this.root = new tagElement(roottag);
	this.processingInstruction = '<?xml version="1.0" encoding="utf-8"?>';

	this.getRoot = function()
	{
		return this.root;
	}

	this.toString = function()
	{
		return this.processingInstruction + this.root.toString();
	}
}
function createXMLparam(row, name, value)
{
	var param = new tagElement("param", name, value);
	row.appendChild(param);
	return param;
}
