
/*          waveBandArray                             
 *                                    "C_BANDL_BAND" 
 *                  "C+L"                        
 *                     ,             "ABC",         
 *      "1" ,                                "9527/196050/152916",
 *    "2"(        ) 
 *    waveBandArray              
 *{"C_BANDL_BAND"} {"C+L"} {"ABC"} {"1"} {[("9527/196050/152916") ("2")] [("5842/196000/152955") ("4")]}
 *
 *             
 *	<wave_band value="C_BANDL_BAND"  defined_waveband="ABC">
 *	    <wave_info waveno="2" frequency="196050" wavelength="152916" definedno="9527"/>  
 *		<wave_info waveno="4" frequency="196000" wavelength="152955" definedno="5842"/>  
 */
var waveBandArray = null;//           
 
function getWaveInfoData(neid)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");  
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);   
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    var urll = null;
    var absurl = window.location.href;      
    var pos = absurl.indexOf("devsupport");
    if(pos != -1)
    {
        absurl = absurl.substring(0,pos);
        absurl = absurl + "neExlorerServlet?sfid=69696&flag=1";            	
        urll = absurl;
    }
    loadXMLdoc(urll, "POST", false, query_CallBack, null, "inputdata="+di.toString()); 
}

function query_CallBack(doc)
{
	waveBandArray = [];
    var waveParams = doc.getElementsByTagName("row-params");  //  RowParams     
 	var len1 = waveParams.length;  
 	for(var index1 = 0;index1 < len1; index1++)
 	{
 		var params = waveParams[index1].getElementsByTagName("param");
 		var oneWaveBand = [];
 		oneWaveBand[0] = params[0].getAttribute("name");
 		oneWaveBand[1] = params[1].getAttribute("name");
 		oneWaveBand[2] = params[0].getAttribute("value");
 		oneWaveBand[3] = params[1].getAttribute("value");
 		
 		var waveBand_waveLenArray = []; 		 
 		var len2 = params.length; 		 
 		for(var index2 = 2;index2 < len2; index2++)
 		{
 			var waveAtomArray = [];
 			waveAtomArray[0] = params[index2].getAttribute("name");
 			waveAtomArray[1] = params[index2].getAttribute("value");
 			waveBand_waveLenArray[index2 - 2] = waveAtomArray;
 		}
 		oneWaveBand[4] = waveBand_waveLenArray; 		
 		waveBandArray[index1] = oneWaveBand;
 	}
}

function waveBandToDefinedBand(neid,waveBand)
{		 
	if(null == waveBandArray)
	{
		getWaveInfoData(neid);
	}
	if(waveBandArray != null)
	{
		for(var jj = 3; jj < 6; jj++)
		{
			var j = jj % 4;
			for(var i = 0; i < waveBandArray.length; i++)
			{
				var waveInfoByIndex = waveBandArray[i];				
				if(waveInfoByIndex[j] == waveBand)
				{
					var definedWaveBand = waveInfoByIndex[2];
					return definedWaveBand; 				
				}
			}
		}
	}       
    return waveBand;
}

function waveNoToDefinedNo(neid,waveBand,waveNo)
{
	var waveInfoByBand = getWaveInfoByWaveBand(neid,waveBand);
	if(waveInfoByBand != null && waveNo > 0)
	{
		var waveInfoLen = waveInfoByBand.length;
		if(waveNo < waveInfoLen)
		{
			if(waveNo == waveInfoByBand[waveNo-1][1])
			 {
			 	return waveInfoByBand[waveNo-1][0];
			 }
			 else if(0 != waveNo % 2 && waveNo == waveInfoByBand[96+(waveNo-1)/2][1])
			 {
			 	return waveInfoByBand[96+(waveNo-1)/2][0];
			 }
			 else if(0 == waveNo % 2 && waveNo == waveInfoByBand[(waveNo-2)/2][1])
			 {
			 	return waveInfoByBand[(waveNo-2)/2][0];
			 }
		}
		for(var ii = 0; ii < waveInfoLen; ii++)
		{
			if(waveNo == waveInfoByBand[ii][1])
			{
				return waveInfoByBand[ii][0];
			}
		}		
	}
    return waveNo;
}

function definedNoToWaveNo(neid,waveBand,waveBandLen)
{
	var waveInfoByBand = getWaveInfoByWaveBand(neid,waveBand);
	if(waveInfoByBand != null)
	{
		var waveInfoLen = waveInfoByBand.length;		
		for(var ii = 0; ii < waveInfoLen; ii++)
		{
			if(waveBandLen == waveInfoByBand[ii][0])
			{
				return waveInfoByBand[ii][1];
			}
		}		
	}
    return waveBandLen;
}

function getWaveInfoByWaveBand(neid,waveBand)
{	
	if(null == waveBandArray)
	{
		getWaveInfoData(neid);
	}	 
	if(waveBandArray != null)
	{
		for(var jj = 3; jj < 6; jj++)
		{
			var j = jj % 4;
			for(var i = 0; i < waveBandArray.length; i++)
			{
				var waveInfoByIndex = waveBandArray[i];				
				if(waveInfoByIndex[j] == waveBand)
				{
					var waveInfoByBand = waveInfoByIndex[4];
					return waveInfoByBand; 					
				}
			}
		}
	}
    return null;   
}
 

function getWaveInfoAllData()
{	
    return waveBandArray;
}


 
