 /*
               
 */


/**
 *              XML   
 * @param {Object} inputString
 */
function isValidateXMLString(inputString)
{
    for (var i = 0; i < inputString.length; i++) 
    {
        if (!isValidateXMLChar(inputString.charCodeAt(i))) 
        {
            return false;
        }
    }
    return true;
}

/**
 *            XML  
 *    XML       16  ASCII   
 * #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] |[#x10000-#x10FFFF]
 * @param {Object} inputChar
 */
function isValidateXMLChar(inputChar)
{
    if (inputChar == 0x9 || inputChar == 0xA || inputChar == 0xD ||
    (inputChar >= 0x20 && inputChar <= 0xD7FF) ||
    (inputChar >= 0xE000 && inputChar <= 0xFFFD) ||
    (inputChar >= 0x10000 && inputChar <= 0x10FFFF)) 
    {
        return true;
    }
    return false;
}

/**
 *               XML        
 * @param {Object} inputString
 * @param {Object} errorMessage
 */
function checkValidateXMLString(inputString, errorMessage)
{
    if (!isValidateXMLString(inputString)) 
    {
        if (typeof(errorMessage) == "undefined" || errorMessage == null || errorMessage == "")
		{
			errorMessage=RESOURCE["ID_INVALID_XML_CHAR"];
		} 
        alert(errorMessage);
        return false;
    }
    return true;
}
