/******************************************************************/
/****                                            ****/
/****                                                          ****/
/****       @param  obj                                    ****/
/****       @param  minval                                 ****/
/****       @param  maxval                                 ****/
/****       @param  maxlen                                ****/
/****       @param  defaultval                     ****/
/****       @auther z60014396                                  ****/
/****       @date   2006-8-7                                   ****/
/******************************************************************/


function selectionLen(obj)
{    	
	if(isIE)
	{
	  return document.selection.createRange().text.length;
	}
	else
	{
	  return obj.selectionEnd-obj.selectionStart;	
	}
}

/**
 *      defaultval               
 * defaultval = ""          
 * defaultval =           
 * defaultval     
 */
function validateNum(obj, minval, maxval, maxlen, defaultval)
{
	var minvalue = minval;
	var maxvalue = maxval;
	var maxbyte  = maxlen;
	
	var stayVal = minvalue;
	if (defaultval || defaultval == "")
	{
		stayVal = defaultval;
	}	
	
	var oedit = obj;

	if(oedit == null)
	{
		return;
	}

	oedit.maxLength = maxbyte;
	oedit.style.imeMode = "disabled";
	
	oedit.ondrop = function()
	{
		return false;
	}

	oedit.onkeypress = function()
	{
		var evt=EventUtil.getEvent();
		var code= (evt.keyCode!=0?evt.keyCode:evt.charCode);
		
	    if(code == 13)
	    {
	      evt.srcElement.blur();
	      return;	
	    }
		var ch = String.fromCharCode(code);
		if (event.ctrlKey)
		{
			if (ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A')
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		if (code == 9 || code == 8 || code == 127)
		{
			return true; // DEL   
		}

		if(!evt.shiftKey && code >= 33 && code <= 40)
		{
			if(evt.which || typeof(evt.which) == "undefined")
			{
				return false;
			}
			return true;
		}
		if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
		{
			return true;
		}
		if (code < 48 || code > 57)
		{
			return false;
		}
			
		var numobj = evt.srcElement;
		var position = digitalTag_getPos(numobj);
		if (0 != minvalue) 
		{
			if (position == 0 && numobj.value.length > 0 &&
				(code == 48 || code == 96)) 
			{
				return false;
			}
		}	
	    
	    if(numobj.value=='0' && position>0)
	    {
	      return false;
	    }
	
	    if (numobj.value.length > maxbyte && (selectionLen(numobj)==0))
	    {
	    	alert(RESOURCE["ID_NUMLEFT"] + minvalue + RESOURCE["ID_NUMMIDDLE"] + maxvalue + RESOURCE["ID_NUMRIGHT"]);
	    	return false;
	    }
	    return validateVal2(numobj, code, minvalue, maxvalue);
	}

	oedit.onkeyup = function()
	{
		var event=EventUtil.getEvent();
		var numobj = event.srcElement;
		
		if (event.keyCode != 37 && event.keyCode != 39 && numobj.value 
		    && numobj.value.length > 0 && numobj.value.substring(0,1) == '0')
		{
			numobj.value = parseInt(numobj.value, 10);
		}
		
		validateVal1(numobj, minvalue, maxvalue);
	}

	oedit.onblur = function()
	{
		var event=EventUtil.getEvent();
		var numobj = event.srcElement;
		var tmp = numobj.value;
		if (tmp == "" && stayVal.toString() != "")
		{
				numobj.value = stayVal;
				alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
				return;
		}
		var regex = new RegExp("^[0-9]+$", "ig");
		if (regex.test(numobj.value))
		{
			numobj.value = parseInt(tmp,10);
		}
		else
		{
			numobj.value = stayVal;
			alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
			return;
		}
		validateVal(numobj, minvalue, maxvalue);
		
	}
	
}

/**
 *                       onkeypress, onkeyup, onblur         
 */
function validateVal(valobj, minval, maxval)
{
	var tmp = valobj.value;
	if (parseInt(tmp, 10) > maxval)
	{
		valobj.value = maxval;
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
	}
	else if (parseInt(tmp, 10) < minval)
	{
		valobj.value = minval;
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
	}
}

function validateVal1(valobj, minval, maxval)
{
	var tmp = valobj.value;
	if (parseInt(tmp, 10) > maxval)
	{
		valobj.value = maxval;
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
	}
}

function validateVal2(valobj, keycode, minval, maxval)
{
    var keychar = String.fromCharCode(keycode);
    var pos = digitalTag_getPos(valobj);
    var tmpVal = valobj.value.substring(0,pos) + keychar + valobj.value.substring(pos+selectionLen(valobj));
    if(parseInt(tmpVal,10) > maxval)    
    {
        valobj.value = maxval;
        alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
        return false;
    }
    return true;
}

/**
 *                       
 *                     false
 *     obj      
 */
function checknumobj(obj, minval, maxval)
{
	var num = obj.value;
	if (num == null || num == "" || parseInt(num, 10) > maxval || parseInt(num, 10) < minval)
	{
		obj.value = minval;
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
		obj.focus();
		return false;
	}
	return true;
}

/**
 *     num                          false
 */
function checknumval(num, minval, maxval)
{
	if (num == null || num == "" || parseInt(num, 10) > maxval || parseInt(num, 10) < minval)
	{
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
		return false;
	}
	return true;
}

/**
 *         
 */
function digitalTag_getPos(obj)
{
	if(isIE)
	{
	 		var ml = obj.value.length;
	    var pos = 0;
		  var rng = document.selection.createRange();
		  rng.moveEnd('character',ml);
		  try
		  {
		    pos = ml-rng.text.length;
		  }
		  catch (e){}
		  
		  return pos;
  }
  else
  {
    	return obj.selectionStart;
 	}
}
/**
 *        1-31,32
 * @param pathobj
 * @param minValue
 * @param maxValue
 * @return
 */
function limitPathInput(pathobj, minValue, maxValue)
{
    var minvalue = minValue ;
    var maxvalue = maxValue ;
    
    pathobj.value = "";
    pathobj.style.imeMode = "disabled";
    pathobj.onkeypress = function()
    {
    	var evt= EventUtil.getEvent();
        return restrictPath2(pathobj, evt, minvalue, maxvalue);
    };

    pathobj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = pathobj.value + pasteText;
        return pathTextCheck(pasteText, minvalue, maxvalue);
        
    };
}


function restrictPath2(field, event, minvalue,maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' 
    	|| keychar == '[' || keychar == ']' || keychar == '\\' || keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') 
            		|| (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function pathTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }    
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}




