var isIE = (navigator.userAgent.indexOf("MSIE") > -1);

var CHINESECODE_LENGTH = getChineseCodeLength();

/**
 *            
 */
function getChineseCodeLength()
{
	var url = location.href;  
	var paraString = url.substring(url.indexOf("?")+1,url.length).split("&");  
	var paraObj = {}  
	for (i=0; j=paraString[i]; i++)
	{  
		paraObj[j.substring(0,j.indexOf("=")).toLowerCase()] = j.substring(j.indexOf("=")+1,j.length);  
	}  
	var returnValue = paraObj["codelength"];  
	if(typeof(returnValue) == "undefined" || returnValue == "")
	{
		return 2;
	}
	else
	{  
		return parseInt(returnValue);
	}  
}

/**
 *           
 */
String.prototype.trim = function()
{
	return this.replace(/(^\s*)|(\s*$)/g, "");
}

/**
 *             
 */
function IsNotNull(checkItem, itemName)
{
	var item = checkItem.trim();
	var str = "";
	if(SYSTEMCONF.getLanguage() == "en")
	{
	    str = itemName + " ";
	}
	else
	{
	    str = "\""+itemName +"\"";
	}
	if(item.length == 0)
	{
	     alert(str + RESOURCE["ifnull"])
		return false;
	}
	else
	{
		return true;
	}
}

function selectionLen(obj)
{

	if (isIE)
	{
		return document.selection.createRange().text.length;
	}
	else
	{
		return obj.selectionEnd - obj.selectionStart;
	}

}
/**
 *     IP         
 */
function check_IPaddr(IpAddr)
{
	var pattern = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
	var checker = pattern.test(IpAddr);
	if (!checker)
	{
		alert(RESOURCE["wrongIPaddr"]);
		return false;
	}
	else
	{
		var partaddr = IpAddr.split(".");
		for (i = 0; i < partaddr.length; i++)
		{
			if (partaddr[i] > 255)
			{
				alert(RESOURCE["wrongIPaddr"]);
				return false;
			}
		}
		return true;
	}
}

/**
 *                
 * 
 * @param  
 * @return  
 */
function checkDataCellEvent(atom, minvalue, maxvalue, defaultvalue)
{
	atom.style.imeMode = "disabled";
	if (null == defaultvalue)
	{
		defaultvalue = minvalue;
	}

	atom["onchange"] = function(evt)
	{
		evt = evt?evt:window.event;
		if (!checkDataRange(this, minvalue, maxvalue,evt))
		{
			this.value = defaultvalue;
		}
	}

	atom["onkeydown"] = function()
	{
		var evt = EventUtil.getEvent();
		return digitalTag_checkDown(this, maxvalue, checkDataRange,null,null,null,evt);
	}
}

/**
 *   textinput           
 */
function checkDataRange(textinput, minData, maxData,evt)
{
	var key, keychar;
    if (evt) 
    {
        key = evt.keyCode != 0 ? evt.keyCode : evt.charCode;
    }
    else 
    {
        key = window.event.keyCode;
    }
	keychar = String.fromCharCode(key);
	textcontent = parseInt(textinput.value + keychar);
	if (textcontent < minData || textcontent > maxData)
	{
		var alertStr = RESOURCE["wrong1"] + minData + RESOURCE["wrong2"]
				+ maxData + RESOURCE["wrong3"];
		alert(alertStr);
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *             
 */
function restrict(field, event, strallow)
{
	var key, keychar;

	var key = event.keyCode != 0 ? event.keyCode : event.charCode;

	keychar = String.fromCharCode(key);

	if ((key == null) || (key == 0) || (key == 8) || (key == 9) || (key == 13)
			|| (key == 27))
	{
		return true;
	}
	else if ((strallow.indexOf(keychar) != -1))
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
 *   textinput           
 */
function maxlength(textinput, maxlen)
{
	var code = event.keyCode;

	var ch = String.fromCharCode(code);

	if (code == 13)
	{
		event.srcElement.blur();
		return false;
	}

	if (event.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'A')
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if (code > 36 && code < 41)
	{
		return true; //    
	}

	if (code == 9 || code == 8 || code == 46)
	{
		return true; // DEL   
	}

	textcontent = textinput.value;
	if (textcontent.length + 1 > maxlen)
	{
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *                
 */
function chkinputdata(inputdata, dataname)
{
	var pattern = /^\d{1,5}$/;
	var checker = pattern.test(inputdata);
	if (!checker)
	{
		alert(RESOURCE[dataname]);
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *              16   
 */
function chkhexnum(inputdata, dataname)
{
	var pattern = /^[a-fA-F0-9]{1,26}$/;
	var checker = pattern.test(inputdata);
	if (!checker)
	{
		alert(RESOURCE[dataname]);
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *         
 */
function digitalTag_getPos(obj)
{
	if (isIE)
	{
		var ml = obj.value.length;
		var pos = 0;
		var rng = document.selection.createRange();
		rng.moveEnd('character', ml);
		try
		{
			pos = ml - rng.text.length;
		}
		catch (e)
		{
		}
		return pos;
	}
	else
	{
		return obj.selectionStart;
	}
}

/**
 *                      MAX      submitfunc          ,      ,           ''
 */
function digitalTag_checkDown(obj, max, submitfunc, maxalertflag, resource,
		alertstr,evt)
{
	evt = evt?evt:window.event;
	var code = evt.keyCode != 0 ? evt.keyCode : evt.charCode;
	var ch = String.fromCharCode(code);
	if (code == 13)
	{
		eval(submitfunc);
		return false;
	}

	if (code == 9 || code == 8 || code == 127)
	{
		return true; // DEL   
	}

	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}
	if (evt.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A')
		{ // X C V A
			return true;
		}
		else
		{
			return false;
		}
	}
	if (code < 48 || (code > 57 && code < 96 || code > 105))
	{
		return false; //    
	}
	var value = obj.value;
	pos = digitalTag_getPos(obj); //         
	if ((code == 48 || code == 96) && (pos == 0))
	{
		return false;
	}

	if (pos == 0 && value.length > 0 && selectionLen(obj) < value.length
			&& (code == 48 || code == 96))
	{
		return false;
	}
	if (value == '0' && pos > 0)
	{
		return false;
	}

	if (code < 58)
	{
		ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}

	var newVal = value.substring(0, pos) + ch
			+ value.substring(pos + selectionLen(obj));
	if (parseInt(newVal, 10) > max)
	{
		if (maxalertflag && resource && alertstr)
		{
			alert(resource[alertstr]);
		}
		return false;
	}
	return true;
}
function digitalTag_checkPaste(obj)
{
	var s = window.clipboardData.getData('text');
	for (i = 0; i < s.length; i++)
	{
		if (s.charAt(i) < '0' || s.charAt(i) > '9')
		{
			return false;
		}
		if (s.charAt(0) == '0')
		{
			if (digitalTag_getPos(obj) == 0)
			{
				return false;
			}
		}
	}
}

/**
 *             
 */
function numCellOnBlur(obj, min, max, decimalCount,othervalue)
{
	blurValidate(obj, min, max, decimalCount,null,othervalue);
	var pnode = obj.parentNode;
	if(pnode == null)
	{
		return;
	}
	if(pnode.colid == null)
	{
		pnode = pnode.parentNode;
		if(pnode == null || pnode.colid == null)
		{
			return;
		}
	}

	var hc = pnode.parent.getHeadCell(pnode.colid);
	if (pnode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == pnode.showElement.type)
			{
				pnode.showElement.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				pnode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}

			obj.parentNode.parent.setTdCellValue(pnode,
					hc.element.keys[0], obj.options[obj.selectedIndex].value);
		}
	}
	else if (pnode.editElement.type == "combobox")
	{
		if ("span" == pnode.showElement.type)
		{
			pnode.showElement
					.setValue(pnode.editElement.element.parent.txtview.value);
		}
		else
		{
			pnode.showElement
					.setValue(pnode.editElement.element.parent.value);
		}
		
		pnode.parent.setTdCellValue(pnode, hc.element.keys[0],
				pnode.editElement.element.parent.getValue());
		return;
	}
	else
	{
		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = pnode.offsetWidth;
		var rows = pnode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}
			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);
	pnode.showElement.element.style.display = "";
	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}

/**
 *            
 */
function blurValidate(obj,min,max,decimalCount,stepLen,othervalue)
{
	var containInegalChar = false;
	var pattern = /^[-.0-9]{1,15}$/;
	if (!pattern.test(obj.value))
	{
		containInegalChar = true;
	}
	/**
	 *                               
	 *    alert         
	 */
	var oValue = null;
	if(typeof(othervalue) != "undefined" && othervalue != null)
	{
		oValue = (othervalue.toString().indexOf(".") != -1?parseFloat(othervalue):parseInt(othervalue));
	}
	if(oValue != null && isNaN(oValue))
	{
		oValue = othervalue;
	}

	if (containInegalChar || obj.value == "" || obj.value == "-")
	{
		if(obj.value == othervalue)
		{
			return true;
		}
		obj.value = min;
		if (obj.onchange)
		{
			obj.onchange();
		}
		if (oValue != null)
		{
			return alertDialogWithStepLen(min,max,stepLen,oValue);
		}
		else
		{
    		return alertDialogWithStepLen(min,max,stepLen);
		}
	}
	
	
	if (decimalCount == null)
	{
		decimalCount = 1;
	}

	if ((min.indexOf(".") != -1 || max.indexOf(".") != -1)
			&& obj.value.indexOf(".") == -1)
	{
		var zeroStr = ".";
		for ( var i = 0; i < decimalCount; i++)
		{
			zeroStr += "0";
		}
		obj.value = obj.value + zeroStr;
		if (obj.onchange)
		{
			obj.onchange();
		}
		
	}

	var dotPos = obj.value.indexOf(".");
	var valueSubstr = "";
	if (dotPos != -1)
	{
		valueSubstr = obj.value.substring(dotPos + 1);
		if (valueSubstr.length >= decimalCount)
		{
			obj.value = obj.value.substring(0, dotPos + decimalCount + 1)
			if (obj.onchange)
			{
				obj.onchange();
			}
		}
	}

	if (obj.value.charAt(obj.value.length - 1) == ".")
	{
		var zeroStr = "";
		for ( var i = 0; i < decimalCount; i++)
		{
			zeroStr += "0";
		}
		obj.value = obj.value + zeroStr;
		if (obj.onchange)
		{
			obj.onchange();
		}
		
	}

	valueSubstr = obj.value.substring(dotPos + 1);
	if (valueSubstr.length < decimalCount)
	{
		var diffCount = parseInt(decimalCount) - valueSubstr.length;
		var zeroStr = "";
		for ( var i = 0; i < diffCount; i++)
		{
			zeroStr += "0";
		}
		obj.value = obj.value + zeroStr;
		if (obj.onchange)
		{
			obj.onchange();
		}
	}

	var objValue;
	var minValue;
	var maxValue;
	
	if (min.indexOf(".") != -1 || max.indexOf(".") != -1)
	{
		objValue = parseFloat(obj.value);
		minValue = parseFloat(min);
		maxValue = parseFloat(max);
	}
	else
	{
		minValue = parseInt(min);
		maxValue = parseInt(max);
		var pattern = /^-?\d+$/;
		if (!pattern.test(obj.value)) 
		{
			objValue = minValue - 1;
		}
		else 
		{
			objValue = parseInt(obj.value);
		}
	}
	
	if (objValue < minValue && objValue != oValue)
	{
		obj.value = min;
		if (obj.onchange)
		{
			obj.onchange();
		}
		return alertDialog(min, max,oValue);
	}
	else if (objValue > maxValue && objValue != oValue)
	{
		obj.value = max;
		if (obj.onchange)
		{
			obj.onchange();
		}
		return alertDialog(min, max,oValue);
	}
}

/**
 *     ,           1 
 */
function textCheck(obj, min, max, decimalCount,othervalue)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{		
	}

	obj.onblur = function()
	{
		numCellOnBlur(obj, min, max, decimalCount,othervalue);
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount,othervalue, evt);
	}
}

/**
 *     ,           1          
 */
function checkText(obj, min, max, decimalCount)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}
/**
 *     :DTS2012052408114
 * AM   E1        E1                       AM    E1               
 *       obj.doAfterBlur();
 */
	obj.onblur = function()
	{
		blurValidate(obj, min, max, decimalCount);
		if((typeof obj.doAfterBlur)=="function")
		{
			obj.doAfterBlur();
		}
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount, null, evt);
	}
}

/**
 *     ,           1          ,     
 * 
 * values                                   
 */
function checkTextAllowSomeValue(obj, min, max, decimalCount,values)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}

	obj.onblur = function()
	{
		var i = values.length;
		while(i--)
		{
			if(values[i] == obj.value)
			{
				return true;
			}
		}
		blurValidate(obj, min, max, decimalCount);
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount, null, evt);
	}
}

function changeMinByCondition(cellObj)
{
	return null;
}

function changeMaxByCondition(cellObj)
{
	return null;
}

function digitalCheck(obj, min, max, decimalCount,othervalue, evt)
{         
	 var cMin = changeMinByCondition(obj);
	 if(cMin != null)
	 {
	 	  min = cMin;
	 }
	 var cMax = changeMaxByCondition(obj);
	 if(cMax != null)
	 {
	 	  max = cMax;
	 }
	 
	var code = evt.keyCode||evt.which||evt.charCode;
	
	
	
	if(parseInt(min) >= 0 && parseInt(max) >= 0 && parseInt(othervalue) >=0 && code == 45)
        {
            return false;
        }

	var ch = String.fromCharCode(code);

	if (code == 13)
	{
		evt.srcElement.blur();
		return false;
	}
	var oValue = null;
	if(typeof(othervalue) != "undefined" && othervalue != null)
	{
		oValue = othervalue
	}
	if (code == 9 || code == 8 || code == 127)
	{
		return true; // DEL   
	}

	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}
	if (evt.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'A')
		{ // X C A
			return true;
		}
		else
		{
			return false;
		}
	}
	var value = obj.value;
	pos = digitalTag_getPos(obj);

	if (code == 46)//     
	{
		if (min.indexOf(".") == -1 && max.indexOf(".") == -1)//           ,         
		{
			return false;
		}

		if (pos == 0)//            
		{
			return false;
		}

		if (value.indexOf(".") == -1)//          ,       
		{
			return true;
		}
		else
		{
			return false;
		}

		if (pos == 1)
		{
			if (value.charAt(0) == "-")//       ,           
			{
				return false;
			}
			else
			{
				return true;
			}
		}

	}

	if ((value.charAt(0) == "0") && (pos == 1))//     0    ,          
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if ((value.charAt(0) == "-") && (value.charAt(1) == "0") && (pos == 2))//     -0,         
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if ((value.charAt(0) == "-") && (pos == 0) && (selectionLen(obj) == 0))
	{
		return false;
	}
	
	if ((value.charAt(0) == "/") && (pos != 0))
	{
		return alertDialog(min, max,oValue);
	}
	
	if (((value.charAt(0) >= "0") || (value.charAt(0) <= "9")) && (pos != 0) && (code == 47))
	{
		return alertDialog(min, max,oValue);
	}
	
	if (decimalCount == null)
	{
		decimalCount = 1;
	}
	if (value.charAt(pos - decimalCount - 1) == ".")//            
	{
		return false;
	}
	var dotPos = value.indexOf(".");
	if (dotPos != -1)
	{
		var valueSubstr = value.substring(dotPos + 1);

		if (dotPos < pos && valueSubstr.length >= decimalCount
				&& selectionLen(obj) == 0)
		{
			return false;
		}
	}
	if (code == 45)//   
	{
	    if (othervalue != null && othervalue != undefined && othervalue != "")
	    {
	        if (othervalue >= 0)
	        {
	            return false;
	        }
	    }
	    else if (min >= 0)
		{
			return false;
		}

		if (pos == 0 && (value.indexOf("-") == -1)
				|| selectionLen(obj) == value.length)//            
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	var oValue = null;
	if(typeof(othervalue) != "undefined" && othervalue != null)
	{
		oValue = othervalue
	}
	if ((code == 48) && (pos == 0))
	{
		if (min.indexOf(".") == -1)
		{
			if (min > 0 && oValue != 0)
			{
				obj.value = min;
				doSomethingIfObjDataChanged(obj);
				return alertDialog(min, max,oValue);
			}
			else
			{
				if (value != "" && selectionLen(obj) < value.length)
				{
					return false;
				}
				else
				{
					return true;
				}
			}

		}
		else
		{
			if (oValue != 0 && (min >= 1 || max < 0))
			{
				return false;
			}
		}
		return true;
	}

	if (code < 48 || code > 57)
	{
		if(ch == oValue)
		{
			return true;
		}
		return false; //       
	}

	if (code < 58)
	{
		ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}

	var newVal = value.substring(0, pos) + ch
			+ value.substring(pos + selectionLen(obj));

	var len;
	var newValLength = newVal.indexOf(".");
	if(newValLength < 0)
	{
		newValLength = newVal.length;
	}
	if (min > 0)
	{
		len = max.indexOf(".");
		if(len < 0)
		{
			len = max.length;
		}
	}
	else if (max < 0)
	{
		len = min.indexOf(".");
		if(len < 0)
		{
			len = min.length;
		}
	}
	var otherLen = 0;
	if(oValue != null)
	{
		otherLen = oValue.toString().indexOf(".");
		if(otherLen < 0)
		{
			otherLen = oValue.toString().length;
		}
	}
	if (newValLength < len || newValLength < otherLen)
	{
		return true;
	}

	var tempValue;
	if (newVal.indexOf(".") == -1)
	{
		tempValue = parseInt(newVal, 10);
		if (tempValue > parseInt(max,10) && tempValue != oValue)
		{
			obj.value = max;
		}
		else if (tempValue <  parseInt(min,10) && tempValue != oValue)
		{
			obj.value = min;		
		}
		else
		{
			return true;
		}
	}
	else
	{
		tempValue = parseFloat(newVal, 10);
		if (tempValue > max && tempValue != oValue)
		{
			obj.value = max;
		}
		else if (tempValue < min && tempValue != oValue)
		{
			obj.value = min;		
		}
		else
		{
			return true;
		}
	}
	obj.blur();
	if (obj.onchange)
	{
		obj.onchange();
	}
	doSomethingIfObjDataChanged(obj);

	return alertDialog(min, max,oValue);
}

/**
 *          
 * @return
 */
function doSomethingIfObjDataChanged(obj)
{
}

/**
 *        
 */
function alertDialog(min, max, othervalue)
{
	var alertStr;
	if(min == max)
	{
		if (min.indexOf(".") == -1)
		{
			alertStr = RESOURCE["wrong10"];
		}
		else
		{
			alertStr = RESOURCE["wrong8"];
		}
		alertStr += min;
		alert(alertStr);
		return false;	
	}

	if (min.indexOf(".") == -1 && max.indexOf(".") == -1)
	{
		alertStr = RESOURCE["wrong1"];
		if(typeof(othervalue) != "undefined" && othervalue != null && (othervalue != min && othervalue != max))
		{
			alertStr = RESOURCE["wrong7"];
			alertStr += othervalue + RESOURCE["wrong6"];
		}
		alertStr += min + RESOURCE["wrong2"] + max;
		alertStr += RESOURCE["wrong3"];
	}
	else
	{
		alertStr = RESOURCE["wrong5"];
		if(typeof(othervalue) != "undefined" && othervalue != null && (othervalue != min && othervalue != max))
		{
			alertStr = RESOURCE["wrong8"];	
			alertStr += othervalue + RESOURCE["wrong9"];
		}
		alertStr += min + RESOURCE["wrong2"] + max;
		alertStr += RESOURCE["wrong4"];
	}

	alert(alertStr);
	return false;
}

function checkInputData(textinput, event, min, max)
{
	if (!restrict(textinput, event, "0123456789"))
	{
		return false;
	}
	if (!checkDataRan(textinput, min, max))
	{
		return false;
	}
	return true;
}

/**
 *   textinput           
 */
function checkDataRan(textinput, minData, maxData)
{
	var key, keychar;

	var key = event.keyCode != 0 ? event.keyCode : event.charCode;
	keychar = String.fromCharCode(key);
	oldtextcontent = textinput.value;
	var pos = digitalTag_getPos(textinput);

	if (pos == 0 && keychar == 0 && oldtextcontent != "")
	{
		return false;
	}
	else if (pos != 0 && oldtextcontent == "0")
	{
		return false;
	}
	textcontent = parseInt(textinput.value + keychar);
	if (textcontent < minData || textcontent > maxData)
	{
		var alertStr = RESOURCE["wrong1"] + minData + RESOURCE["wrong2"]
				+ maxData + RESOURCE["wrong3"];
		alert(alertStr);
		return false;
	}
	else
	{
		return true;
	}
}

function maskChinese(obj)
{

	var code = event.keyCode;

	if (code == null)
	{
		return true;
	}

	if (code == 8 || code == 46 || code == 9 || code == 27)
	{
		return true; // DEL    ESC
	}
	if (code > 36 && code < 41)
	{
		return true; //    
	}

	if (obj.value.length > 0)
	{
		var str = obj.value;
		var nstr = '';
		for ( var i = 0; i < obj.value.length; i++)
		{
			var ch = str.charCodeAt(i);
			if (ch < 127)
			{
				nstr += str.charAt(i);
			}
		}
		var maxlen = obj.getAttribute("maxLength");
		if (maxlen)
		{
			obj.value = nstr.substr(0, parseInt(maxlen));
		}

	}
}

/**
 *  onkeyup                                       obj              maxlen:
 *         
 */
function calStrSinoLen(obj, maxlen)
{
	var key = event.keyCode;

	if (obj.onblur == null)
	{
		obj.onblur = function()
		{
			calStrSinoLenCheck(obj, maxlen);
		}
	}

	if (key == 13)
	{
		event.srcElement.blur();
		return false;
	}
	if ((key == null) || (key == 0) || (key == 8) || (key == 9) || (key == 27)
			|| (key == 39) || (key == 37))
	{
		return true;
	}

	calStrSinoLenCheck(obj, maxlen);
}

/**
 * calStrSinoLen         
 */
function calStrSinoLenCheck(obj, maxlen)
{
    var str = obj.value;
	var cnt = 0;
	for (i = 0; i < str.length; i++)
    {
        var value = str.charCodeAt(i);
        if (value < 0x080)
        {
            cnt += 1;
        }
        else if (value < 0x0800)
        {
            cnt += 2;
        }
        else
        {
            cnt += 3;
        }
        
        if (cnt > maxlen)
        {
            obj.value = str.substring(0, i);
            return false;
        }
    }
}

function calStrSinoLenCheck(obj, maxlen)
{
    var str = obj.value;
    var totalLength = 0;
	var i;
	var charCode;
	for (i = 0; i < str.length; i++)
	{
		charCode = str.charCodeAt(i);
		if (charCode < 0x007f)
		{
			totalLength = totalLength + 1;
		}
		else if ((0x0080 <= charCode) && (charCode <= 0x07ff))
		{
			totalLength += 2;
		} 
		else if ((0x0800 <= charCode) && (charCode <= 0xffff))
		{
			totalLength += CHINESECODE_LENGTH;
		}
		
		if (totalLength > maxlen)
        {
            obj.value = str.substring(0, i);
            return false;
        }
	}
}

/*******************************************************************************
 * MAC           
 * @param MAC       
 * @param castFlag          , false               true         
 ******************************************************************************/
function checkMACFormat(obj, castFlag)
{
	obj.style.imeMode = "disabled";
	obj.maxLength = "17";


	obj.onkeypress = function()
	{
		return validateMACAddr(obj);
	}
	
	obj.onblur = function()
    {
		blurFormat(obj, castFlag);
    }
}

/*******************************************************************************
 * MAC        
 ******************************************************************************/
function validateMACAddr(obj)
{
	var code = (event.keyCode != 0 ? event.keyCode : event.charCode);

	var ch = String.fromCharCode(code);

	if (code == 13)
	{
		return false;
	}

	if (code == 9 || code == 8 || code == 127)
	{
		return false;
	}

	if (event.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'A')
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if (code == 45)
	{
		return true;
	}

	if (code < 48 || (code > 57 && code < 65) || (code > 70 && code < 97)
			|| code > 102)
	{
		return false;
	}

	var value = obj.value;
	pos = digitalTag_getPos(obj);
	if (pos <= 16)
	{
		var ach = value.substring(pos, pos + 1);
		if (ach == "-")
		{
			if (isIE)
			{
				var rng = document.selection.createRange();
				if (selectionLen(obj) > 0)
				{
					rng.moveEnd('character', -(selectionLen(obj) - 2));
					rng.text = "-" + ch;
					rng.select();
				}
				else
				{
					rng.moveEnd('character', 1);
					rng.text = "-";
				}
			}
			else
			{
				obj.selectionStart = pos + 1;
			}
		}
		else
		{
			var newVal = "";
			newVal = value.substring(0, pos) + ch + value.substring(pos + 1);
			if (isIE)
			{
				var rng = document.selection.createRange();
				if (selectionLen(obj) > 0)
				{
					rng.moveEnd('character', -(selectionLen(obj) - 1));
					rng.text = "";
					rng.select();
				}
				else
				{
					rng.moveEnd('character', 1);
					rng.text = "";
				}
			}
			else
			{
				var newVal = value.substring(0, pos) + ch
						+ value.substring(pos + 1);
				obj.value = newVal;
				obj.selectionEnd = pos + 1;
			}
		}
	}
}

/*******************************************************************************
 * MAC             
 * @param MAC      
 * @param castFlag          , false               true         
 ******************************************************************************/
function blurFormat(obj, castFlag)
{
	var pattern = /^[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]$/;
	var checker = pattern.test(obj.value);
	if (!checker)
	{
		alert(RESOURCE["format"]);
		obj.value = "00-00-00-00-00-01";
		obj.focus();
		return false;
	}
	else
	{
		if (obj.value == "00-00-00-00-00-00")
		{
			alert(RESOURCE["macaddrerror0"]);
			return false;
		}
		if (!castFlag) //     MAC         1       
	    {
		    var val = obj.value.substring(1, 2);
		    var pattern0 = /^[a-f,A-Z]$/;
		    if (pattern0.test(val))
		    {
			    switch (val.toLowerCase())
			    {
			        case "a":
				        val = 10;
					    break;
				    case "b":
					    val = 11;
					    break;
				    case "c":
					    val = 12;
					    break;
				    case "d":
					    val = 13;
					    break;
				    case "e":
					    val = 14;
					    break;
				    case "f":
					    val = 15;
					    break;
				    default:
					;
			    }
		   }
		   if (parseInt(val) % 2 != 0) //                    
		   {
			   alert(RESOURCE["macaddrerror1"]);
			   return false;
		   }
	    }
		return true;
	}
}

/**
 *             ,    
 */
function numCellOnBlurWithStepLen(obj, min, max, stepLen,other)
{
	blurValidateWithStepLen(obj, min, max, stepLen,other);
	if(!obj.parentNode.parent)
	{
		return;
	}
	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);

	var pnode = obj.parentNode;

	if (pnode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == obj.parentNode.showElement.type)
			{
				pnode.showElement.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				pnode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}

			obj.parentNode.parent.setTdCellValue(obj.parentNode,
					hc.element.keys[0], obj.options[obj.selectedIndex].value);
		}
	}
	else
	{

		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = obj.parentNode.offsetWidth;
		var rows = obj.parentNode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}
			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);

	pnode.showElement.element.style.display = "";

	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}

/**
 *                 
 */
function blurValidateWithStepLen(obj, min, max, stepLen,other)
{
	var containInegalChar = false;
	var pattern = /^[-.0-9]{1,15}$/;
	if (!pattern.test(obj.value))
	{
		containInegalChar = true;
	}

	if (containInegalChar || obj.value == "" || obj.value == "-")
	{
		obj.value = min;
		return alertDialogWithStepLen(min, max, stepLen,other);
	}

	if ((min.indexOf(".") != -1 || max.indexOf(".") != -1)
			&& obj.value.indexOf(".") == -1)
	{
		obj.value = obj.value + ".0";
	}

	if (obj.value.charAt(obj.value.length - 1) == ".")
	{
		obj.value = obj.value + "0";
	}

	var objValue;
	var minValue;
	var maxValue;
	if (min.indexOf(".") != -1 || max.indexOf(".") != -1)
	{
		objValue = parseFloat(obj.value);
		minValue = parseFloat(min);
		maxValue = parseFloat(max);
	}
	else
	{
		objValue = parseInt(obj.value);
		minValue = parseInt(min);
		maxValue = parseInt(max);
	}
	var oValue = null;
	if(typeof(other) != "undefined" && other != null)
	{
		oValue = (other.toString().indexOf(".") != -1?parseFloat(other):parseInt(other));
	}
	if(oValue != null && isNaN(oValue))
	{
		oValue = othervalue;
	}
	if (objValue < minValue && objValue != oValue)
	{
		obj.value = min;
		return alertDialogWithStepLen(min, max, stepLen,oValue);
	}
	else if (objValue > maxValue && objValue != oValue)
	{
		obj.value = max;
		return alertDialogWithStepLen(min, max, stepLen,oValue);
	}
	else
	{
		if (0 != obj.value % stepLen && objValue != oValue)
		{
			obj.value = min;
			return alertDialogWithStepLen(min, max, stepLen,oValue);
		}
	}
}
/**
 *     ,           1 
 */
function textCheckWithStepLen(obj, min, max, stepLen,other)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}

	obj.onblur = function()
	{
		numCellOnBlurWithStepLen(obj, min, max, stepLen,other);
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheckWithStepLen(obj, min, max, stepLen, null, evt,other);
	}
}

/**
 *        ,    
 */
function alertDialogWithStepLen(min, max, stepLen,othervalue)
{
	var alertStr = RESOURCE["wrong1"];

	if(typeof(othervalue) != "undefined" && othervalue != null && (othervalue != min && othervalue != max))
	{
		alertStr = RESOURCE["wrong7"];
		alertStr += othervalue + RESOURCE["wrong6"];
	}
	alertStr += min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"];
	if( stepLen != null )
	{
		alertStr += RESOURCE["steplen"] + stepLen;
	}
	alert(alertStr);
	return false;
}

function digitalCheckWithStepLen(obj, min, max, stepLen, decimalCount, evt,other)
{	
	var code = evt.keyCode||evt.which||evt.charCode;

	var ch = String.fromCharCode(code);

	if (code == 13)
	{
		blurValidate(obj,min,max,null,stepLen,other);
		evt.srcElement.blur();
		return false;
	}

	if (code == 9 || code == 8 || code == 127)
	{
		return true; // DEL   
	}

	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}
	if (evt.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'A')
		{ // X C A
			return true;
		}
		else
		{
			return false;
		}
	}

	var value = obj.value;
	pos = digitalTag_getPos(obj);

	if (code == 46)//     
	{
		if (min.indexOf(".") == -1 && max.indexOf(".") == -1)//           ,         
		{
			return false;
		}

		if (pos == 0)//            
		{
			return false;
		}

		if (value.indexOf(".") == -1)//          ,       
		{
			return true;
		}
		else
		{
			return false;
		}

		if (pos == 1)
		{
			if (value.charAt(0) == "-")//       ,           
			{
				return false;
			}
			else
			{
				return true;
			}
		}

	}

	if ((value.charAt(0) == "0") && (pos == 1))//     0    ,          
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if ((value.charAt(0) == "-") && (value.charAt(1) == "0") && (pos == 2))//     -0,         
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if ((value.charAt(0) == "-") && (pos == 0) && (selectionLen(obj) == 0))
	{
		return false;
	}
	if (decimalCount == null)
	{
		decimalCount = 1;
	}
	if (value.charAt(pos - decimalCount - 1) == ".")//            
	{
		return false;
	}
	var dotPos = value.indexOf(".");
	if (dotPos != -1)
	{
		var valueSubstr = value.substring(dotPos + 1);

		if (dotPos < pos && valueSubstr.length >= decimalCount
				&& selectionLen(obj) == 0)
		{
			return false;
		}
	}
	var oValue = null;
	if(typeof(other) != "undefined" && other != null)
	{
		oValue = other
	}
	if (code == 45)//   
	{
		if (min >= 0 && (oValue != null && oValue >= 0))
		{
			return false;
		}

		if (pos == 0 && (value.indexOf("-") == -1))//            
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if ((code == 48) && (pos == 0))
	{
		if (min.indexOf(".") == -1)
		{
			if (min > 0 && oValue != 0)
			{
				obj.value = min;
				return alertDialogWithStepLen(min, max, stepLen,oValue);
			}
			else
			{
				if (value != "" && selectionLen(obj) < value.length)
				{
					return false;
				}
				else
				{
					return true;
				}
			}

		}
		else
		{
			if (min >= 1 || max < 0)
			{
				return false;
			}
		}
		return true;
	}

	if (code < 48 || code > 57)
	{
		return false; //       
	}

	if (code < 58)
	{
		ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}

	var newVal = value.substring(0, pos) + ch
			+ value.substring(pos + selectionLen(obj));
	var otherLen = 0;
	if(oValue != null)
	{
		otherLen = oValue.toString().indexOf(".");
		if(otherLen < 0)
		{
			otherLen = oValue.toString().length;
		}
	}
	var len;
	var newValLength = newVal.replace(".", "").length;
	if (min > 0)
	{
		len = max.replace(".", "").length;
	}
	else if (max < 0)
	{
		len = min.replace(".", "").length;
	}
	if (newValLength < len || newValLength < otherLen)
	{
		return true;
	}

	var tempValue;
	if (newVal.indexOf(".") == -1)
	{
		tempValue = parseInt(newVal, 10);
		
		if (tempValue > parseInt(max,10) && tempValue != oValue)
		{
			obj.value = max;
		}
		else if (tempValue < parseInt(min,10) && tempValue != oValue)
		{
			obj.value = min;
		}
		else
		{
			return true;
		}		
	}
	else
	{
		tempValue = parseFloat(newVal, 10);
		if (tempValue > max && tempValue != oValue)
		{
			obj.value = max;
		}
		else if (tempValue < min && tempValue != oValue)
		{
			obj.value = min;
		}
		else
		{
			return true;
		}
	}
	obj.blur();
	return alertDialogWithStepLen(min, max, stepLen,other);
}

function blockChars(e, Chars)
{
	if (e == null)
	{
		e = window.event;
	}
	e = EventUtil.formatEvent(e);

	var sChar = String.fromCharCode(e.charCode);

	if (sChar.toLowerCase() == "v" && e.ctrlKey)
	{
		return false;
	}

	var isValidChar = Chars.indexOf(sChar) == -1;
	return isValidChar || e.ctrlKey;
}

/**
 *           noAllow    
 */ 
function restrictByAllow(field,event,noAllow)
{
   var key,keychar;
   
   key = (event.keyCode!=0?event.keyCode:event.charCode);
   
   keychar = String.fromCharCode(key);
   
    if(key == 13){
   	
    event.srcElement.blur();
    return true;	
   }
   if((noAllow.indexOf(keychar) != -1))
   {
      return false;
   }
   else
   {
      return true;
   }
}

/**
 *              
 */ 
function checkTextData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
    
    obj.onkeydown = function()
    {
        var letterFlg = forbidSignInput();
        if (!letterFlg) 
        {
            return letterFlg;
        }
        var code = event.keyCode != 0 ? event.keyCode : event.charCode;
        if (!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16)) 
        {
            if ($("applybtn")) 
			{
				$("applybtn").disabled = false;
			}
        }
    }
}

function forbidSignInput()
{
    var key = event.keyCode != 0 ? event.keyCode : event.charCode;
    
    if (event.shiftKey) 
    {
        if (key == 188 || key == 222) 
        {
            return false;
        }
    }
    return true;
}


function blockSpecialChars(elm)
{
	elm.onpaste = function(e)
	{
		var pasteText = window.clipboardData.getData("Text");
		var re = /^[^=\\\:\;\"\'\?]+$/
		return re.test(pasteText);
	}
	elm.onkeypress=function(e)
	{
		return blockChars(e,"\"\\=,:;?");
	}
}

/**
 *             ,    ,       othervalue   
 */
function numCellOnBlurWithStepLenandOtherValue(obj, min, max, stepLen,othervalue)
{
	blurValidateWithStepLenandOtherValue(obj, min, max, stepLen,othervalue);
	if(!obj.parentNode.parent)
	{
		return;
	}
	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);

	var pnode = obj.parentNode;

	if (pnode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == obj.parentNode.showElement.type)
			{
				pnode.showElement.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				pnode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}

			obj.parentNode.parent.setTdCellValue(obj.parentNode,
					hc.element.keys[0], obj.options[obj.selectedIndex].value);
		}
	}
	else
	{

		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = obj.parentNode.offsetWidth;
		var rows = obj.parentNode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}
			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);

	pnode.showElement.element.style.display = "";

	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}

/**
 *                 ,       othervalue   
 */
function blurValidateWithStepLenandOtherValue(obj, min, max, stepLen,othervalue)
{
	var containInegalChar = false;
	var pattern = /^[-.0-9]{1,15}$/;
	if (!pattern.test(obj.value))
	{
		containInegalChar = true;
	}

	if (containInegalChar || obj.value == "" || obj.value == "-")
	{
		if(obj.value == othervalue)
		{
			return true;
		}
		obj.value = min;
		return alertDialogWithStepLen(min, max, stepLen,othervalue);
	}

	if ((min.indexOf(".") != -1 || max.indexOf(".") != -1)
			&& obj.value.indexOf(".") == -1)
	{
		obj.value = obj.value + ".0";
	}

	if (obj.value.charAt(obj.value.length - 1) == ".")
	{
		obj.value = obj.value + "0";
	}

	var objValue;
	var minValue;
	var maxValue;
	if (min.indexOf(".") != -1 || max.indexOf(".") != -1)
	{
		objValue = parseFloat(obj.value);
		minValue = parseFloat(min);
		maxValue = parseFloat(max);
	}
	else
	{
		objValue = parseInt(obj.value);
		minValue = parseInt(min);
		maxValue = parseInt(max);
	}
	if (objValue == minValue)
	{
		return true;
	}
	if (objValue == othervalue)
	{
		return true;
	}
	if (objValue < minValue)
	{
		obj.value = min;
		return alertDialogWithStepLen(min, max, stepLen,othervalue);
	}
	else if (objValue > maxValue)
	{
		obj.value = max;
		return alertDialogWithStepLen(min, max, stepLen,othervalue);
	}
	else
	{
		if (0 != obj.value % stepLen)
		{
			obj.value = min;
			return alertDialogWithStepLen(min, max, stepLen,othervalue);
		}
	}
}

/**
 *     ,           1 ,       othervalue   
 */
function textCheckWithStepLenandOtherValue(obj, min, max, stepLen,othervalue)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}

	obj.onblur = function()
	{
		numCellOnBlurWithStepLenandOtherValue(obj, min, max, stepLen,othervalue);
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheckWithStepLenandOtherValue(obj, min, max, stepLen, null,othervalue, evt);
	}
}
function digitalCheckWithStepLenandOtherValue(obj, min, max, stepLen, decimalCount,othervalue, evt)
{	
	var code = evt.keyCode||evt.which||evt.charCode;

	var ch = String.fromCharCode(code);

	if (code == 13)
	{
		blurValidateWithStepLenandOtherValue(obj, min, max, stepLen,othervalue)
		evt.srcElement.blur();
		return false;
	}

	if (code == 9 || code == 8 || code == 127)
	{
		return true; // DEL   
	}

	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}

	if (evt.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'A')
		{ // X C A
			return true;
		}
		else
		{
			return false;
		}
	}

	var value = obj.value;
	pos = digitalTag_getPos(obj);

	if (code == 46)//     
	{
		if (min.indexOf(".") == -1 && max.indexOf(".") == -1)//           ,         
		{
			return false;
		}

		if (pos == 0)//            
		{
			return false;
		}

		if (value.indexOf(".") == -1)//          ,       
		{
			return true;
		}
		else
		{
			return false;
		}

		if (pos == 1)
		{
			if (value.charAt(0) == "-")//       ,           
			{
				return false;
			}
			else
			{
				return true;
			}
		}

	}

	if ((value.charAt(0) == "0") && (pos == 1))//     0    ,          
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	if ((value.charAt(0) == "-") && (value.charAt(1) == "0") && (pos == 2))//     -0,         
	{
		if (code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if ((value.charAt(0) == "-") && (pos == 0) && (selectionLen(obj) == 0))
	{
		return false;
	}
	if (decimalCount == null)
	{
		decimalCount = 1;
	}
	if (value.charAt(pos - decimalCount - 1) == ".")//            
	{
		return false;
	}
	var dotPos = value.indexOf(".");
	if (dotPos != -1)
	{
		var valueSubstr = value.substring(dotPos + 1);

		if (dotPos < pos && valueSubstr.length >= decimalCount
				&& selectionLen(obj) == 0)
		{
			return false;
		}
	}

	if (code == 45)//   
	{
		if (min >= 0)
		{
			return false;
		}

		if (pos == 0 && (value.indexOf("-") == -1))//            
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	var oValue = null;
	if(typeof(othervalue) != "undefined" && othervalue != null)
	{
		oValue = othervalue
	}
	if ((code == 48) && (pos == 0))
	{
		if (min.indexOf(".") == -1)
		{
			if (min > 0 && oValue != 0)
			{
				obj.value = min;
				return alertDialogWithStepLen(min, max, stepLen,othervalue);
			}
			else
			{
				if (value != "" && selectionLen(obj) < value.length)
				{
					return false;
				}
				else
				{
					return true;
				}
			}

		}
		else
		{
			if (min >= 1 || max < 0)
			{
				return false;
			}
		}
		return true;
	}

	if (code < 48 || code > 57)
	{
		if(ch == oValue)
		{
			return true;
		}
		return false; //       
	}

	if (code < 58)
	{
		ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}

	var newVal = value.substring(0, pos) + ch
			+ value.substring(pos + selectionLen(obj));

	var len;
	var newValLength = newVal.replace(".", "").length;
	if (min >= 0)
	{
		len = max.replace(".", "").length;	
		if(len<othervalue.replace(".", "").length)
		{
			len=othervalue.replace(".", "").length
		}
	}
	else if (max < 0)
	{
		len = min.replace(".", "").length;
	}
	if (newValLength < len)
	{
		return true;
	}

	var tempValue;
	if (newVal.indexOf(".") == -1)
	{
		tempValue = parseInt(newVal, 10);
		if (tempValue == parseInt(othervalue, 10))
		{
			obj.value = othervalue;
			obj.blur();
			return true;
		}
		if (tempValue > parseInt(max,10))
		{
			obj.value = max;
		}
		else if (tempValue < parseInt(min,10))
		{
			obj.value = min;
		}
		else
		{
			return true;
		}		
	}
	else
	{
		tempValue = parseFloat(newVal, 10);
		if (tempValue == parseInt(othervalue, 10))
		{
			obj.value = othervalue;
			obj.blur();
			return true;
		}
		if (tempValue > max)
		{
			obj.value = max;
		}
		else if (tempValue < min)
		{
			obj.value = min;
		}
		else
		{
			return true;
		}
	}	
	obj.blur();

	return alertDialogWithStepLen(min, max, stepLen,othervalue);
}
