/*
 *     
 * author: c68996
 */

function Node(id, pid, name, array, checked, open) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.array = array;
	this.checked = checked || false;
	this._io = open || false; //     
	this._lockid = -1; //       
	this._is = false; //      
	this._ls = false; //       
	this._hc = false; //       
	this._hn = false; //     
	this._cg = false; //      
	this._ai = -1;
	this._layer = -1; //    
	this._p = -1;
	this._ancestor;
};

/**
 *        
 */ 
function treeTable(objName, colNum, iconPh) {
	this.config = {
		folderLinks : true,
		useCookies : false,
		useSelection : true,
		rowSelection : true,
		rootSelection : false,
		useChecks : false,
		useLines : true, //         
		useIcons : false,
		closeSameLevel : false, //                   
		allowEmpty : true, //        
		inOrder : false,
		valign : 'middle',
		align : 'center'
	};
	this.iconPath = iconPh;

	this.icon = {
		root : this.iconPath + 'base.gif',
		folder : this.iconPath + 'folder.gif',
		folderOpen : this.iconPath + 'folderopen.gif',
		node : this.iconPath + 'page.gif',
		empty : this.iconPath + 'empty.gif',
		line : this.iconPath + 'line.gif',
		join : this.iconPath + 'join.gif',
		joinBottom : this.iconPath + 'joinbottom.gif',
		plus : this.iconPath + 'plus.gif',
		plusBottom : this.iconPath + 'plusbottom.gif',
		minus : this.iconPath + 'minus.gif',
		minusBottom : this.iconPath + 'minusbottom.gif',
		nlPlus : this.iconPath + 'nolines_plus.gif',
		nlMinus : this.iconPath + 'nolines_minus.gif'
	};
	this.obj = objName;
	this.SPLITOR = ',';
	this.colNum = colNum - 1;
	this.aNodes = [];
	this.aIndent = [];
	this.root = new Node(-1, -2, 'root'); //    
	this.onRowSelect = null;
	this.selectedNode = null;
	this.selectedFound = false;
	this.completed = false;
};

/**
 *       
 * 
 * @param sPath
 */
function setImagePath(sPath) {
	this.iconPath = sPath;
}

treeTable.prototype.filterUnRow = function(isFilte) {
	var table = document.getElementById(this.obj);
	var rows = table.getElementsByTagName('tr');
	for ( var i = 0, iLen = rows.length; i < iLen; i++) {
		var boxs = rows[i].getElementsByTagName('input');
		var m = 0;
		for ( var j = 0, jLen = boxs.length; j < jLen; j++) {
			if (!boxs[j].checked) {
				m++;
			}
		}
		var nodeid = rows[i].id.substring(rows[i].id.indexOf(this.obj)
				+ this.obj.length);
		if (m != 0 && m == boxs.length && isFilte) {
			rows[i].style.display = 'none';
			if (nodeid != null && nodeid.length != 0) {
				this.aNodes[nodeid]._hn = true;
			}
		}

		if (!isFilte) {
			if (nodeid != null && nodeid.length != 0) {
				this.aNodes[nodeid]._hn = false;
				var pid = this.aNodes[nodeid].pid;
				if ((0 < pid && this.aNodes[pid]._io) || pid <= 0) {
					rows[i].style.display = '';
				}
			}
		}
	}

	for ( var j = 1, jLen = this.aNodes.length; j < jLen; j++) {
		if (this.aNodes[j]._hc && !this.aNodes[j]._hn) {
			var allchildHidden = true;
			var theID = this.aNodes[j].id;
			for ( var k = 0, kLen = this.aNodes.length; k < kLen; k++) {
				var thePID = this.aNodes[k].pid;
				if (thePID == theID && (!this.aNodes[k]._hn)) {
					allchildHidden = false;
					break;
				}
			}
			if (allchildHidden) {
				this.aNodes[j]._hn = true;
				var eRow = document.getElementById('r' + this.obj + j);
				if (eRow != null) {
					eRow.style.display = 'none';
				}
			}
		}
	}
	for ( var j = 1, jLen = this.aNodes.length; j < jLen; j++) {
		this.setCS(this.aNodes[j]);
		this.nodeStatus(this.aNodes[j]._io, j, this.aNodes[j]._ls);
	}
};

treeTable.prototype.add = function(id, pid, name, array, checked, open) {
	this.aNodes[this.aNodes.length] = new Node(id, pid, name, array, checked,
			open);
};

treeTable.prototype.openAll = function() {
	this.oAll(true);
};

treeTable.prototype.closeAll = function() {
	this.oAll(false);
};

treeTable.prototype.toString = function() {
	this.config.rowSelection = this.config.useSelection
			&& this.config.rowSelection;
	this.config.rootSelection = this.config.useSelection
			&& this.config.rootSelection;
	var str = '<table id="' + this.obj + '" width="100%" border="1" cellSpacing="0" cellpadding="0" isResizeAdjust="true">';
	if (document.getElementById(this.obj) != '') {
		if (this.config.useCookies) {
			this.selectedNode = this.getSelected();
		}
		str += this.addChildren(this.root);
	}
	str += '</tbody>';
	str += '</table>';
	if (!this.selectedFound) {
		this.selectedNode = null;
	}
	this.completed = true;
	return str;
};

/**
 *        
 */
treeTable.prototype.setOnRowSelectHandler = function(func) {
	if (typeof func != "function") {
		return;
	}
	this.onRowSelect = func;
};

treeTable.prototype.handleRowSelected = function(obj) {
	if (this.onRowSelect != null) {
		var func = this.onRowSelect;
		if (obj == null) {
			func(this.obj, null, null, null);
		} else {
			var node = this.aNodes[this.selectedNode];
			var parentName = null;
			if (node.pid != '0') {
				parentName = this.aNodes[node.pid].name;
			}
			func(this.obj, obj, parentName, node.name);
		}
	}
};

treeTable.prototype.getSelectedRows = function() {
	return this.selectedNode;
};

treeTable.prototype.addChildren = function(pNode) {
	var str = '';
	var n = 0;
	if (this.config.inOrder)
		n = pNode._ai + 1;
	for (n; n < this.aNodes.length; n++) {
		if (this.aNodes[n].pid == pNode.id) {
			var cn = this.aNodes[n];
			cn._p = pNode._ai;
			cn._layer = pNode._layer + 1;
			cn._ai = n;
			this.setCS(cn);
			if (cn._hc && !cn._io && this.config.useCookies) {
				cn._io = this.isOpen(cn.id);
			}
			if (this.config.useSelection && cn.id == this.selectedNode
					&& !this.selectedFound) {
				cn._is = true;
				this.selectedNode = n;
				this.selectedFound = true;
			}

			if (this.root.id == pNode.id || this.root.id == pNode.pid) {
				cn._lockid = -1;
			} else {
				cn._lockid = (pNode._io) ? pNode._lockid : pNode.id;
			}
			if (pNode.id == this.root.id) {
				str += '<thead>';
			}
			str += '<tr ';
			if (pNode.id == this.root.id) {
				str += 'class="thead"';
			} else {
				str += 'class="' + ((this.config.useSelection) ? (cn._is ? 'rowSel'
						: 'row')
						: 'row') + '"';
			}
			str += ' id="r' + this.obj + n + '" valign="' + this.config.valign
					+ '" style="width:100%;overflow:hidden;';
			if (this.config.rowSelection) {
				if (this.config.rootSelection || this.root.id != pNode.id) {
					str += 'cursor:hand;';
				}
			}
			if (this.root.id != pNode.id) {
				str += ((cn._lockid == -1) ? 'display:"";' : 'display:none;');
				str += '">';// debugger;
			} else {
				str += 'display:"";">';
			}
			str += this.addRow(cn, n) + '</tr>';

			if (pNode.id == '-1') {
				str += '</thead><tbody>';
			} else if (pNode.id == this.aNodes.length - 1) {
			}
			if (cn._hc) {
				str += this.addChildren(cn);
			}
			this.aIndent.pop();
			if (cn._ls) {
				break;
			}
		}
	}// debugger;
	return str;
};

treeTable.prototype.addRow = function(node, nodeId) {
	var mouseEvent = '';
	if (this.config.rowSelection) {
		if (node.pid != this.root.id) {
			mouseEvent = ' onclick = "javascript: ' + this.obj + '.s(' + nodeId
					+ ');"';
		}
	}
	var str = '<td ';
	if (node.id != this.root.id) {
		str += 'class="' + ((this.config.useSelection) ? (node._is ? 'nodeSel'
				: 'node') : 'node') + '"';
	}
	str += ' id="d' + this.obj + nodeId + '" align="left"' + ' style="'
			+ 'width:28%;overflow:hidden;' + '" valign="' + this.config.valign
			+ '" ' + mouseEvent + '> ' + this.indent(node, nodeId);
	if (this.config.useChecks) {
		str += '<input type="checkbox" name="check" value="' + nodeId
				+ '" id="k' + this.obj + nodeId;
		if (node.checked) {
			str += '" checked ';
		} else {
			str += '" ';
		}
		str += ' ' + this.obj + '.checkRow(' + nodeId + ');">';
	}
	if (this.config.useIcons) {
		if (!node.icon) {
			node.icon = (this.root.id == node.pid) ? this.icon.root
					: ((node._hc) ? this.icon.folder : this.icon.node);
		}
		if (!node.iconOpen) {
			node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;
		}
		if (this.root.id == node.pid) {
			node.icon = this.icon.root;
			node.iconOpen = this.icon.root;
		}
		str += '<img id="i' + this.obj + nodeId + '" src="'
				+ ((node._io) ? node.iconOpen : node.icon) + '" alt="" />';
	}
	if (node._hc && (this.config.rootSelection || node.pid != this.root.id)) {
		str += '<a id="a' + this.obj + nodeId + '" href="javascript: '
				+ this.obj + '.o(' + nodeId + ');">';
	} else {
		str += '<label style="white-space:nowrap;overflow:hidden;">';
	}
	str += node.name;
	if (node._hc && (this.config.rootSelection || node.pid != this.root.id)) {
		str += '</a>';
	} else {
		str += '</label>';
	}
	str += '</td>';// if(node.name.indexOf('3(PORT-3)')>-1){debugger;}
	var col = 0;
	var width = 72 / this.colNum;
	for (col; col < this.colNum; col++) {
		str += '<td id="d' + this.obj + nodeId + '-' + col + '" style="width:'
				+ width + '%;" nowrap align="' + this.config.align
				+ '" class="node"' + mouseEvent + '>';
		if (!node.array || node.array.length <= col) {
			str += ' </td>';
		} else {
			str += node.array[col] + '</td>';
		}
	}
	return str;
};

treeTable.prototype.indent = function(node, nodeId) {
	var str = '';
	if (this.root.id != node.pid) {
		for ( var n = 0; n < this.aIndent.length; n++) {
			str += '<img id="b'
					+ this.obj
					+ nodeId
					+ '" src="'
					+ ((this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line
							: this.icon.empty) + '" alt="" />';
		}
		(node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);
		if (node._hc) {
			str += '<a href="javascript: ' + this.obj + '.o(' + nodeId
					+ ');"><img id="j' + this.obj + nodeId + '" src="';
			if (!this.config.useLines) {
				str += (node._io) ? this.icon.nlMinus : this.icon.nlPlus;
			} else {
				str += ((node._io) ? ((node._ls) ? this.icon.minusBottom
						: this.icon.minus) : ((node._ls) ? this.icon.plusBottom
						: this.icon.plus));
			}
			str += '" alt="" ></a>';
		} else {
			str += '<img id="l'
					+ this.obj
					+ nodeId
					+ '" src="'
					+ ((this.config.useLines) ? ((node._ls) ? this.icon.joinBottom
							: this.icon.join)
							: this.icon.empty) + '" alt="" />';
		}
	}
	return str;
};

treeTable.prototype.filtrate = function(id) {
	for ( var n = 0; n < this.aNodes.length; n++) {
		this.aNodes[n]._ancestor = this.aNodes[n]._p;
	}
	var index;
	var ancestor;
	var alist = [];
	for ( var n = 0; n < this.aNodes.length; n++) {
		index = n;
		ancestor = this.aNodes[index]._ancestor;
		var i = 0;
		while (ancestor != -1 && this.aNodes[ancestor].id != id) {
			alist[i] = index;
			i++;
			index = ancestor;
			ancestor = this.aNodes[index]._ancestor;
		}
		for ( var j = 0; j < i; j++) {
			this.aNodes[alist[j]]._ancestor = ancestor;
		}
	}
};

treeTable.prototype.isLeaf = function(id) {
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n].pid == id) {
			return false;
		} else if (this.aNodes[n].id == id) {
			if (this.aNodes[n]._hc) {
				return false;
			} else {
				return true;
			}
		}
	}
	return true;
};

treeTable.prototype.getLayer = function(id) {
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n].pid == id) {
			return this.aNodes[n]._layer - 1;
		} else if (this.aNodes[n].id == id) {
			return this.aNodes[n]._layer;
		}
	}
	return -1;
};

treeTable.prototype.setCS = function(node) {
	var lastId;
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id && !this.aNodes[n]._hn)
			node._hc = true;
		if (this.aNodes[n].pid == node.pid && !this.aNodes[n]._hn)
			lastId = this.aNodes[n].id;
	}
	if (lastId == node.id && !node._hn) {
		node._ls = true;
	} else {
		node._ls = false;
	}
};

treeTable.prototype.getSelected = function() {
	var sn = this.getCookie('cs' + this.obj);
	return (sn) ? sn : null;
};

treeTable.prototype.s = function(id) {
	if (!this.config.useSelection) {
		return;
	}

	if (this.selectedNode != id) {
		if (this.selectedNode || this.selectedNode == 0) {
			eOld = document.getElementById("d" + this.obj + this.selectedNode);
			if (this.aNodes[this.selectedNode]._cg) {
				eOld.className = "nodeChange";
			} else {
				eOld.className = "node";
			}
			eOld = document.getElementById("a" + this.obj + this.selectedNode);
			if (eOld != null) {
				if (this.aNodes[this.selectedNode]._cg) {
					eOld.className = "nodeChange";
				} else {
					eOld.className = "node";
				}
			}
			eOldRow = document.getElementById("r" + this.obj
					+ this.selectedNode);
			eOldRow.className = "row";
		}
		eNewRow = document.getElementById("r" + this.obj + id);
		eNewRow.className = "rowSel";
		eNew = document.getElementById("d" + this.obj + id);
		if (eNew != null) {
			eNew.className = "nodeSel";
		}
		eNew = document.getElementById("a" + this.obj + id);
		if (eNew != null) {
			eNew.className = "nodeSel";
		}
		this.selectedNode = id;
		if (this.config.useCookies) {
			this.setCookie('cs' + this.obj, id);
		}
		this.handleRowSelected(eNewRow);
	}
};

treeTable.prototype.changeCell = function(id) {
	var eNew = document.getElementById(id);
	this.aNodes[eNew.parentNode.id.split('-')[0]
			.substring(("d" + this.obj).length)]._cg = true;
};

treeTable.prototype.us = function() {
	this.handleRowSelected(null);
	if (this.selectedNode == null || !this.config.useSelection)
		return;
	var eOld = document.getElementById("d" + this.obj + this.selectedNode);
	if (eOld != null) {
		if (this.aNodes[this.selectedNode]._cg) {
			eOld.className = "nodeChange";
		} else {
			eOld.className = "node";
		}
		eOldRow = document.getElementById("r" + this.obj + this.selectedNode);
		eOldRow.className = "row";
		eNew = document.getElementById("a" + this.obj + this.selectedNode);
		if (eNew != null) {
			eNew.className = "node";
		}
		this.selectedNode = null;
		if (this.config.useCookies) {
			this.setCookie('cs' + this.obj, 0);
		}
	}
};

treeTable.prototype.o = function(id) {
	var cn = this.aNodes[id];
	this.nodeStatus(!cn._io, id, cn._ls);
	cn._io = !cn._io;
	if (this.config.closeSameLevel) {
		this.closeLevel(cn);
	}
	if (this.config.useCookies) {
		this.updateCookie();
	}
};

treeTable.prototype.oAll = function(status) {
	for ( var n = 0; n < this.aNodes.length; n++) {
		var node = this.aNodes[n];
		if (node.pid != this.root.id && !node._hn) {
			if (node._hc && node._io != status) {
				this.updateLinkAndIcon(status, n, node._ls);
				node._io = status;
			}
			if (this.aNodes[node._p].pid != this.root.id) {
				node._lockid = (status) ? -1 : node.pid;
				eRow = document.getElementById('r' + this.obj + n);
				eRow.style.display = (status) ? '' : 'none';
			}
		}
	}
	if (this.config.useCookies)
		this.updateCookie();
};

treeTable.prototype.openTo = function(nId, bSelect, bFirst) {
	if (!bFirst) {
		for ( var n = 0; n < this.aNodes.length; n++) {
			if (this.aNodes[n].id == nId) {
				nId = n;
				break;
			}
		}
	}
	var cn = this.aNodes[nId];
	if (cn.pid == this.root.id || !cn._p)
		return;
	cn._io = true;
	cn._is = bSelect;
	if (this.completed && cn._hc)
		this.nodeStatus(true, cn._ai, cn._ls);
	if (this.completed && bSelect)
		this.s(cn._ai);
	else if (bSelect)
		this._sn = cn._ai;
	this.openTo(this.aNodes[cn._p]._ai, false, true);
};

treeTable.prototype.closeLevel = function(node) {
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id
				&& this.aNodes[n]._hc && this.aNodes[n]._io) {
			this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
		}
	}
};

treeTable.prototype.clearAllValues = function(prefices) {
	this.checkAll(false);
	if (prefices != null && prefices.length != 0) {
		for ( var n = 0; n < this.aNodes.length; n++) {
			for ( var i = 0; i < prefices.length; i++) {
				elem = document.getElementById(prefices[i] + this.aNodes[n].id);
				elem.value = null;
			}
		}
	}
};

treeTable.prototype.clear = function() {
	this.aNodes.clear();
	this.selectedNode = null;
};

treeTable.prototype.checkAll = function(value) {
	if (!this.config.useChecks)
		return;
	if (value == null) {
		value = true;
	}
	for ( var n = 0; n < this.aNodes.length; n++) {
		this.aNodes[n].checked = value;
		eBox = document.getElementById('k' + this.obj + n);
		eBox.status = this.aNodes[n].checked;
	}
};

treeTable.prototype.checkRow = function(index) {
	if (!this.config.useChecks)
		return;
	var node = this.aNodes[index];
	node.checked = !node.checked;
	eBox = document.getElementById('k' + this.obj + index);
	eBox.status = node.checked;
	if (node._hc) {
		this.filtrate(node.id);
		for ( var n = 0; n < this.aNodes.length; n++) {
			if (this.aNodes[n]._ancestor == index) {
				this.aNodes[n].checked = node.checked;
				eBox = document.getElementById('k' + this.obj + n);
				eBox.status = node.checked;
			}
		}
	}
};

treeTable.prototype.spanToSpring = function(id, prefix) {
	if (this.isLeaf(id)) {
		return;
	}
	element = document.getElementById(prefix + id);
	this.filtrate(id);
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n]._ancestor != -1) {
			eSpring = document.getElementById(prefix + this.aNodes[n].id);
			eSpring.value = element.value;
		}
	}
};

treeTable.prototype.getCheckedIds = function() {
	var selects = [];
	if (!this.config.useChecks)
		return selects;
	for ( var n = 0; n < this.aNodes.length; n++) {
		var node = this.aNodes[n];
		if (!node._hc && node.checked) {
			selects[selects.length] = node.id;
		}
	}
	return selects;
};

treeTable.prototype.getCheckedValues = function(prefices, splitor) {
	if (splitor == null || splitor.length == 0) {
		splitor = this.SPLITOR;
	}
	var selects = [];
	if (prefices == null) {
		selects[0] = '';
	} else {
		for ( var p = 0; p <= prefices.length; p++) {
			selects[p] = '';
		}
	}
	if (!this.config.useChecks)
		return selects;
	for ( var n = 0; n < this.aNodes.length; n++) {
		var node = this.aNodes[n];
		if (!node._hc && node.checked) {
			selects[0] += node.id + splitor;
			if (prefices != null && prefices.length != 0) {
				for ( var k = 0; k < prefices.length; k++) {
					elem = document.getElementById(prefices[k] + node.id);
					if (!this.config.allowEmpty
							&& (elem.value == null || elem.value == "")) {
						this.s(n);
						return null;
					}
					selects[k + 1] += elem.value + splitor;
				}
			}
		}
	}
	return selects;
};

treeTable.prototype.addCheckedId = function(id) {
	if (!this.config.useChecks)
		return;
	if (id != null) {
		for ( var n = 0; n < this.aNodes.length; n++) {
			if (!this.aNodes[n]._hc && this.aNodes[n].id == id) {
				eBox = document.getElementById('k' + this.obj + n);
				this.aNodes[n].checked = true;
				eBox.status = this.aNodes[n].checked;
				break;
			}
		}
	}
};

treeTable.prototype.setCheckedIds = function(ids) {
	if (!this.config.useChecks)
		return;
	if (ids == null || ids.length == 0) {
		this.checkAll(false);
	} else {
		for ( var n = 0; n < this.aNodes.length; n++) {
			eBox = document.getElementById('k' + this.obj + n);
			this.aNodes[n].checked = false;
			if (!this.aNodes[n]._hc) {
				for ( var i = 0; i < ids.length; i++) {
					if (ids[i] == this.aNodes[n].id) {
						this.aNodes[n].checked = true;
						break;
					}
				}
			}
			eBox.status = this.aNodes[n].checked;
		}
	}
};

treeTable.prototype.updateLinkAndIcon = function(status, id, bottom) {
	if (this.config.useIcons) {
		eIcon = document.getElementById('i' + this.obj + id);
		if (eIcon != null) {
			eIcon.src = (status) ? this.aNodes[id].iconOpen
					: this.aNodes[id].icon;
		}
	}
	eJoin = document.getElementById('j' + this.obj + id);
	if (eJoin != null) {
		eJoin.src = (this.config.useLines) ? ((status) ? ((bottom) ? this.icon.minusBottom
				: this.icon.minus)
				: ((bottom) ? this.icon.plusBottom : this.icon.plus))
				: ((status) ? this.icon.nlMinus : this.icon.nlPlus);
	}
	eJoin = document.getElementById('b' + this.obj + id);
	if (eJoin != null) {
		eJoin.src = ((!this.aNodes[this.aNodes[id].pid]._ls) && this.config.useLines) ? this.icon.line
				: this.icon.empty;
	}
	eLoin = document.getElementById('l' + this.obj + id);
	if (eLoin != null) {
		eLoin.src = (this.config.useLines) ? (bottom ? this.icon.joinBottom
				: this.icon.join) : this.icon.empty;
	}
};

treeTable.prototype.nodeStatus = function(status, id, bottom) {
	this.updateLinkAndIcon(status, id, bottom);

	if (this.aNodes[id]._hc && this.aNodes[id]._io != status) {
		this.springRowStatus(id, status);
	}
};

treeTable.prototype.springRowStatus = function(index, status) {
	var pNode = this.aNodes[index];
	if (!status) {
		this.filtrate(pNode.id);
	}
	for ( var n = 0; n < this.aNodes.length; n++) {
		var cn = this.aNodes[n];
		if (status) {
			if (cn._lockid == pNode.id) {
				cn._lockid = pNode._lockid;
				eRow = document.getElementById('r' + this.obj + n);
				if (!cn._hn) {
					eRow.style.display = '';
				}
			}
		} else {
			if (cn._ancestor == index && cn._lockid == -1) {
				cn._lockid = pNode.id;
				eRow = document.getElementById('r' + this.obj + n);
				eRow.style.display = 'none';
			}
		}
	}
};

treeTable.prototype.clearCookie = function() {
	var now = new Date();
	var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);
	this.setCookie('co' + this.obj, 'cookieValue', yesterday);
	this.setCookie('cs' + this.obj, 'cookieValue', yesterday);
};

treeTable.prototype.setCookie = function(cookieName, cookieValue, expires,
		path, domain, secure) {
	document.cookie = escape(cookieName) + '=' + escape(cookieValue)
			+ (expires ? '; expires=' + expires.toGMTString() : '')
			+ (path ? '; path=' + path : '')
			+ (domain ? '; domain=' + domain : '') + (secure ? '; secure' : '');
};

treeTable.prototype.getCookie = function(cookieName) {
	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1)
			cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else
			cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

treeTable.prototype.updateCookie = function() {
	var str = '';
	for ( var n = 0; n < this.aNodes.length; n++) {
		if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {
			if (str)
				str += '.';
			str += this.aNodes[n].id;
		}
	}
	this.setCookie('co' + this.obj, str);
};

treeTable.prototype.isOpen = function(id) {
	var aOpen = this.getCookie('co' + this.obj).split('.');
	for ( var n = 0; n < aOpen.length; n++) {
		if (aOpen[n] == id)
			return true;
	}
	return false;
};

if (!Array.prototype.push) {
	Array.prototype.push = function array_push() {
		for ( var i = 0; i < arguments.length; i++)
			this[this.length] = arguments[i];
		return this.length;
	}
};
if (!Array.prototype.pop) {
	Array.prototype.pop = function array_pop() {
		lastElement = this[this.length - 1];
		this.length = Math.max(this.length - 1, 0);
		return lastElement;
	}
};
