 /**
 *          
 */
var Icon = {
	plus :"plus.gif",
	cross_plus :"cross_plus.gif",
	end_plus :"end_plus.gif",
	minus :"minus.gif",
	cross_minus :"cross_minus.gif",
	end_minus :"end_minus.gif",
	blank :"blank.gif",
	line :"line.gif",
	cross :"cross.gif",
	end :"end.gif",
	inloop :"inloop.gif",
	outloop :"outloop.gif",
	payload :"payload.gif",
	faceloop :"faceloop.gif",
	xcloop :"xcloop.gif",
	primary_alm :"alarm1.gif",
	exigency_alm :"alarm2.gif",
	no_alm :"alarm3.gif",
	secondary_alm :"alarm4.gif"
}

var bImagePathSet = false;
var nodeSelectedEventHandler;

/**
 * set the directory of the pictures
 * 
 * @param sPath
 *                
 */
function setImagePath(sPath)
{
	if (bImagePathSet)
	{
		return;
	}
	for ( var o in Icon)
	{
		tmp = sPath + Icon[o];
		Icon[o] = new Image();
		Icon[o].src = tmp;
	}
	bImagePathSet = true;
}

/*
 *                    
 */
function handleCheckBoxSelect()
{
	var selectState = this.checked;
	var pos = this.id.indexOf("_");
	var nodeid = this.id.substring(pos + 1);
	var node = window.tree[nodeid];
	if (window.tree.selectMode == 0)
	{
		return;
	}
	setInputNoClarity(this);
	if (selectState)
	{
		var curNode = node;
		var blCheckAll = true;
		
		while (curNode.parent)
		{
			var parentNode = curNode.parent;
			document.getElementById("checkbox_" + parentNode.id).checked = selectState;
			for ( var i = 0; i < parentNode.childNodes.length; i++)
			{
				var childNode = parentNode.childNodes[i];
				if (!document.getElementById("checkbox_" + childNode.id).checked 
						|| document.getElementById("checkbox_" + childNode.id).className == "checkBoxStyle")
				{
					blCheckAll = false;
					break;
				}
			}
			if(!blCheckAll)
			{
				setInputClarity(document.getElementById("checkbox_" + parentNode.id));
			}
			else
			{
				setInputNoClarity(document.getElementById("checkbox_" + parentNode.id));
			}
			curNode = parentNode;
		}
	}
	else
	{

		var curNode = node;
		while (curNode.parent)
		{
			var parentNode = curNode.parent;
			var bdeselected = true;
			for ( var i = 0; i < parentNode.childNodes.length; i++)
			{
				var childNode = parentNode.childNodes[i];
				if (document.getElementById("checkbox_" + childNode.id).checked)
				{
					bdeselected = false;
					break;
				}
			}
			if (bdeselected)
			{
				document.getElementById("checkbox_" + parentNode.id).checked = selectState;
				setInputNoClarity(document.getElementById("checkbox_" + parentNode.id));
			}
			else
			{
				document.getElementById("checkbox_" + parentNode.id).className = "checkBoxStyle";
				setInputClarity(document.getElementById("checkbox_" + parentNode.id));
			}
			curNode = parentNode;
		}
	}

	var iter = function(node)
	{
		for ( var i = 0; i < node.childNodes.length; i++)
		{
			var child = node.childNodes[i];
			document.getElementById("checkbox_" + child.id).checked = selectState;
			setInputNoClarity(document.getElementById("checkbox_" + child.id));
			if (child.hasChildren())
			{
				iter(child);
			}
		}
	}

	iter(node);
	if (nodeSelectedEventHandler)
	{
		nodeSelectedEventHandler();
	}
}

function setInputClarity(obj)
{
	obj.className = "checkBoxStyle";
	if(isIE)
	{
		obj.style.filter = "alpha(opacity=30)";
	}
}

function setInputNoClarity(obj)
{
	obj.className = "";
	if(isIE)
	{
		obj.style.filter = "";
	}
}


/**
 *                  Mochikit/logging
 */
if (typeof log == "undefined")
{
	log = function()
	{

	}
}

/*
 *   tree          @param node        @pram retnodearray                  
 */
getSelectedTreeNode = function(root)
{
	var nodes = [];
	treewalk(root, nodes);
	return nodes;
}

/*
 *                         @param node      @param result      
 */
function treewalk(node, result)
{

	if (node.isNodeSelected())
	{
		result.push(document.getElementById("span_" + node.id).innerHTML);
	}

	for ( var i = 0; i < node.childNodes.length; i++)
	{
		var childnode = node.childNodes[i];
		if (childnode.hasChildren())
		{
			treewalk(childnode, result);
		}
		else
		{
			if (childnode.isNodeSelected())
			{
				result
						.push(document.getElementById("span_" + childnode.id).innerHTML);
			}
		}
	}
}

/*
 * Tree constructor
 */
function Tree()
{

	this.selectID = null;
	this.selectMode = 1;
	this.showCheckBox = 0;
	this.treeCellRender = null;
}

/*
 *                            
 */
Tree.clearNodes = function(tree)
{

	var oldTree = tree;
	window.tree = new Tree();
	window.tree.selectID = oldTree.selectID;
	window.tree.selectMode = oldTree.selectMode;
	window.tree.showCheckBox = oldTree.showCheckBox;
	window.tree.treeCellRender = oldTree.treeCellRender;
	oldTree = null;
}

window.tree = new Tree();

/*
 *          
 */
function focusHandler()
{
	this.blur();
}

/*
 * selfid   id ptreenode     nodestr       , func    onclick argus
 * func                  (argus = [tabName, tabLink])
 * 
 */
function TreeNode(selfid, ptreenode, nodestr, func, argus,beforenode)
{
	this.id = selfid; //     id
	this.parent = ptreenode; //    
	this.text = nodestr; //         
	this.childNodes = new Array();
	window.tree[this.id] = this;
	this.node = null;
	this.children = null;
	this.nodeimage = "";
	this.nodefunc = func;
	nodeSelectedEventHandler = func;
	this.openFlag = false;
	this.argus = argus;

	this.onClick = function()
	{
		if (this.nodefunc)
		{
			this.nodefunc(this.argus);
		}
	}

	this.appendToParent = function(obj)
	{
		if (obj)
		{
			obj.childNodes[obj.childNodes.length] = this;
		}
	}
	if(typeof(beforenode) == "undefined" || beforenode == null)
	{
		this.appendToParent(this.parent);
	}
	else if(this.parent)
	{
		for(var i = 0,m = this.parent.childNodes.length;i < m;i++)
		{
			if(this.parent.childNodes[i] == beforenode)
			{
				this.parent.childNodes.splice(i, 0, this);
				break;
			}
		}
	}
	this.drawNode = function()
	{
		var div = document.createElement("div");
		div.style.whiteSpace = "nowrap";
		div.style.height = "16px";

		var span = document.createElement("span");
		span.appendChild(document.createTextNode(this.text));
		span.setAttribute("id", "span_" + this.id);

		var nodeimage = new Image();
		nodeimage.setAttribute("align", "absmiddle");
		nodeimage.style.border = "0px";
		nodeimage.style.width = "16px";
		nodeimage.style.height = "16px";

		nodeanchor = document.createElement("a");
		nodeanchor.onfocus = focusHandler;
		nodeanchor.setAttribute("target", "_self");

		if (this.nodefunc)
		{
			nodeanchor.setAttribute("href", "javascript:void window.tree['"
					+ this.id + "'].isSelect();window.tree['" + this.id
					+ "'].openFolder();window.tree['" + this.id
					+ "'].onClick()");
		}
		else
		{
			nodeanchor.setAttribute("href", "javascript:void window.tree['"
					+ this.id + "'].isSelect();window.tree['" + this.id
					+ "'].openFolder()");
		}

		if (window.tree.showCheckBox == 1)
		{
			var input = document.createElement("input");
			input.type = "checkbox";
			input.style.width = "16px";
			input.style.height = "16px";
			input.style.margin = "0px";
			input.style.border = "0px";
			input.setAttribute("id", "checkbox_" + this.id);
			input.onclick = handleCheckBoxSelect;
			div.appendChild(input);
		}

		if (window.tree.treeCellRender && this.userObject)
		{
			span.innerHTML = "";
			var render = new window.tree.treeCellRender(this.userObject);
			span.appendChild(render.getDomElement());
		}

		nodeanchor.appendChild(span);
		div.appendChild(nodeanchor);

		if (this.hasChildren())
		{
			var imgstr = this.openFlag?"minus":"plus";
			if (this.parent)
			{
				if (this.isLastChild())
				{
					nodeimage.src = Icon["end_" + imgstr].src;
				}
				else
				{
					nodeimage.src = Icon["cross_" + imgstr].src;
				}
			}
			else
			{
				nodeimage.src = Icon[imgstr].src;
			}

			nodeanchor = document.createElement("a");
			nodeanchor.onfocus = focusHandler;
			nodeanchor.setAttribute("target", "_self");
			nodeanchor.setAttribute("href", "javascript:void window.tree['"
					+ this.id + "'].openHandler();");
			this.nodeimage = nodeimage;
			nodeanchor.appendChild(nodeimage);
			div.insertBefore(nodeanchor, div.firstChild);
		}
		else
		{
			if (this.isLastChild())
			{
				if ((this.childNodes.length > 0) || (this.parent))
				{
					nodeimage.src = Icon["end"].src;
				}
				else
				{
					nodeimage.src = Icon["blank"].src;
				}

			}
			else
			{
				nodeimage.src = Icon["cross"].src;
			}
			div.insertBefore(nodeimage, div.firstChild);
		}
		var p = this;
		while (p.parent)
		{
			nodeimage = new Image();
			nodeimage.setAttribute("align", "absmiddle");
			nodeimage.style.width = "16px";
			nodeimage.style.height = "16px";

			if (p.parent.isLastChild())
			{
				nodeimage.src = Icon["blank"].src;
			}
			else
			{
				nodeimage.src = Icon["line"].src;
			}
			div.insertBefore(nodeimage, div.firstChild);
			p = p.parent;
		}
		return div;
	}

	this.drawChildren = function()
	{
		var div = document.createElement("div");
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				var d = this.childNodes[i].drawTree()
				div.appendChild(d);
			}
			if (this.openFlag)
			{
				div.style.display = "";
			}
			else
			{
				div.style.display = "none";
			}
			return div;

		}
		else
		{
			return null;
		}
	}

	this.isLastChild = function()
	{
		if (this.parent != null)
		{
			return this.parent.childNodes[this.parent.childNodes.length - 1].id == this.id;
		}
		else
		{
			return true;
		}
	}

	this.hasChildren = function()
	{
		return this.childNodes.length > 0;
	}

	this.openHandler = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["plus"].src
					|| this.nodeimage.src == Icon["minus"].src)
			{
				this.nodeimage.src == Icon["plus"].src ? this.nodeimage.src = Icon["minus"].src
						: this.nodeimage.src = Icon["plus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_plus"].src
					|| this.nodeimage.src == Icon["cross_minus"].src)
			{
				this.nodeimage.src == Icon["cross_plus"].src ? this.nodeimage.src = Icon["cross_minus"].src
						: this.nodeimage.src = Icon["cross_plus"].src;
			}
			else
			{
				this.nodeimage.src == Icon["end_plus"].src ? this.nodeimage.src = Icon["end_minus"].src
						: this.nodeimage.src = Icon["end_plus"].src;
			}
			if (this.children.style.display == "")
			{
				this.children.style.display = "none"
				this.openFlag = false;
			}
			else
			{
				this.children.style.display = ""
				this.openFlag = true;
			}
		}
	}

	this.openFolder = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["plus"].src)
			{
				this.nodeimage.src = Icon["minus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_plus"].src)
			{
				this.nodeimage.src = Icon["cross_minus"].src;
			}
			else if (this.nodeimage.src == Icon["end_plus"].src)
			{
				this.nodeimage.src = Icon["end_minus"].src;
			}
			this.children.style.display = "";
			this.openFlag = true;
		}
	}
	/*
	 *      
	 */

	this.closeFolder = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["minus"].src)
			{
				this.nodeimage.src = Icon["plus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_minus"].src)
			{
				this.nodeimage.src = Icon["cross_plus"].src;
			}
			else if (this.nodeimage.src == Icon["end_minus"].src)
			{
				this.nodeimage.src = Icon["end_plus"].src;
			}
			this.children.style.display = "none";
			this.openFlag = false;
		}
	}

	this.drawTree = function()
	{
		var div;
		this.node = this.drawNode();
		this.children = this.drawChildren();
		div = document.createElement("div");
		div.appendChild(this.node);
		if (this.children && (this.children != null))
		{
			div.appendChild(this.children);
		}
		return div;
	}
	this.redrawTree = function()
	{
		if(this.parent && this.node)
		{
			if(this.parent.children)
			{
				var parentnode = this.node.parentNode;
				parentnode.removeChild(this.node);
				this.node = this.drawNode();
				parentnode.appendChild(this.node);
				this.children = this.drawChildren();
				if (this.children && (this.children != null))
				{
					parentnode.appendChild(this.children);
				}
			}
		}
	}
	this.isSelect = function()
	{
		if (window.tree.selectID)
		{
			var lastSelectElem = document.getElementById("span_"
					+ window.tree.selectID);
			if (lastSelectElem)
			{
				lastSelectElem.style.backgroundColor = "";
				lastSelectElem.style.border = "none";
			}
		}
		window.tree.selectID = this.id;
		var currSelectElem = document.getElementById("span_" + this.id);
		if(currSelectElem != null)
		{
			if (window.tree.treeCellRender != null)
			{
				currSelectElem.style.border = "solid 1px black";
			}
			else
			{
				currSelectElem.style.backgroundColor = "#B2C3C4";
			}
		}
	}

	/**
	 *                 checkbox   
	 */
	this.isNodeSelected = function()
	{

		var element = document.getElementById("checkbox_" + this.id);
		if (element)
		{
			return document.getElementById("checkbox_" + this.id).checked;
		}
		else
		{
			return (window.tree.selectID == this.id);
		}

	}

	this.setNodeSelected = function()
	{
		document.getElementById("checkbox_" + this.id).checked = true;
	}
	this.setNodeUnSelected = function()
	{
		document.getElementById("checkbox_" + this.id).checked = false;
	}
	


	this.removeNode = function()
	{
		if (this.parent && this.node)
		{
			if (this.parent.children)
			{
				for ( var i = 0, m = this.parent.childNodes.length; i < m; i++)
				{
					if (this.parent.childNodes[i] == this)
					{
						this.parent.childNodes.splice(i, 1);
					}
				}
				this.parent.children.removeChild(this.node.parentNode);
			}
		}
		else if (!this.parent)
		{
			if (this.children)
			{
				this.node.parentNode.removeChild(this.children);
			}
			this.node.parentNode.removeChild(this.node);
		}
		this.removeWindowTreeNode();
	}
	this.removeWindowTreeNode = function()
	{
		for ( var i = 0; i < this.childNodes.length; i++)
		{
			this.childNodes[i].removeWindowTreeNode();
		}
		delete window.tree[this.id];
	}

	this.expand = function()
	{
		var p = this;
		while (p.parent)
		{
			p.parent.openFolder();
			p = p.parent;

		}
		this.openFolder();
	}
	/*
	 *         
	 */
	this.expandAll = function()
	{
		this.openFolder();
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				this.childNodes[i].expandAll();
			}
		}
	}
	/*
	 *               
	 */
	this.collapseAll = function()
	{
		this.closeFolder();
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				this.childNodes[i].collapseAll();
			}
		}
	}
}
