/*
Define table constant
 */
var TABLE_CONSTANT = {};
TABLE_CONSTANT.BEFOREEDIT = 0;
TABLE_CONSTANT.AFTEREDIT = 1;
var stCacheFor;

var NUMBER_WITH_SUBBOARD = 4;
var bodyPackHeadInsets = ( function()
{
	var vTr = document.createElement("tr");
	var vTd = document.createElement("td");
	vTr.appendChild(vTd);
	return vTr;
})();
/*
 * Handle table row click
 */
function rowclick(event)
{	
	var flag = false;

	if (!event)
		event = window.event;

	if (!this.parent.singleChoiceFlg)
	{
		if (event.shiftKey)
		{
			shiftSelect(this);
			handleRowSelected(this);
			return;
		}
	}
	flag = event.ctrlKey;
	singleClick(this, flag);
	handleRowSelected(this);
}
function tableclick(evt)
{
	if (!event)
		event = window.event;
	setTableSelected(this.parent);
}

function setTableSelected(st)
{
	if (st.element.className == "scrolltable")
	{
		var tables = document.getElementsByTagName("table");
		var selTable = null;
		for ( var i = 0, m = tables.length; i < m; i++)
		{
			if (tables[i].className == "scrolltable scrolltableSelect")
			{
				tables[i].className = tables[i].className.replace(
						"scrolltable scrolltableSelect", "scrolltable");
			}
		}
		st.element.className = st.element.className.replace(
				"scrolltable", "scrolltable scrolltableSelect");
	}
}
var clickrowIndex;
function dragRowSelect(event)
{
	if (!event)
		event = window.event;
	var srcElementTag = "";
	var phase = "";
	if (isIE)
	{
		srcElementTag = event.srcElement.tagName;
	}
	else
	{
		srcElementTag = event.target.tagName;
	}

	if (srcElementTag == "SELECT" || srcElementTag == "OPTION")
	{
		return;
	}
	if (event.button == 2 && this.isDragging == false) // distinguish rigth
	{
		return;
	}
	if (event.ctrlKey || event.shiftKey)
	{
		return;
	}
	setTableSelected(this.parent);
	var row = getRowFromEvent(event);
	clickrowIndex = row.rowIndex;
	endRowIndex = row.rowIndex;
	for ( var i = 0; i < this.parent.getDataRowLength(); i++)
	{
		if (this.parent.getRow(i).element.selectFlag)
		{
			if (i == clickrowIndex)
			{
				continue;
			}
			this.parent.getRow(i).element.className = "weightrow";
		}
	}
	stCacheFor = this.parent;
	dragInitFlag = true;
	for ( var i = 0; i < this.parent.getDataRowLength(); i++)
	{
		this.parent.getRow(i).element.onmousemove = dragRowSelectMouseOver;
		this.parent.getRow(i).element.onmouseout = dragRowSelectMouseOut;
	}
	document.onmouseup = dragRowSelectMouseUp;
	this.parent.element.onmouseout = dragTableMouseOut;
}

function dragTableMouseOut(event)
{
	if (!event)
		event = window.event;
	if (event.toElement == null || event.toElement.tagName == "IMG"
			|| event.toElement.tagName == "BODY")
	{
		var st = stCacheFor;
		if (st == null)
		{
			return;
		}
		for ( var i = 0; i < st.getDataRowLength(); i++)
		{
			st.getRow(i).element.onmousemove = "";
			st.getRow(i).element.onmouseout = "";
			st.getRow(i).element.isDragging = false;
		}
		document.onmouseup = "";
		st.element.onmouseout = ""
	}
}
function dragRowSelectMouseOut(event)
{
	var row = getRowFromEvent(event);
	row.isDragging = false;
}

function getRowFromEvent(event)
{
	if (!event)
		event = window.event;
	var row;
	if (event.srcElement.tagName == "SPAN")
	{
		row = event.srcElement.parentElement.parentElement;
	}
	else if (event.srcElement.tagName == "TD")
	{
		row = event.srcElement.parentElement;

	}
	else if (event.srcElement.tagName == "SELECT")
	{
		row = event.srcElement.parentElement.parentElement.parentElement;

	}
	else if (event.srcElement.tagName == "INPUT")
	{
		if (event.srcElement.parentElement.parentElement.tagName != "TR")
		{
			row = event.srcElement.parentElement.parentElement.parentElement;
		}
		else
		{
			row = event.srcElement.parentElement.parentElement;
		}
	}
	else
	{
		row = event.srcElement.parentElement.parentElement;
	}
	return row;
}
var endRowIndex = 0;
var dragInitFlag = false;
function dragRowSelectMouseOver(event)
{
	if (!event)
		event = window.event;
	var row = getRowFromEvent(event);
	var st = stCacheFor;
	if (st == null)
	{
		return;
	}
	var rowIndex = row.rowIndex;
	changeRowState(st, rowIndex);
}

function changeRowState(st, rowIndex)
{
	if (st.getRow(rowIndex) == null || endRowIndex == rowIndex)
	{
		return;
	}
	if(dragInitFlag)
	{
		dragInitFlag = false;
		for ( var i = 0; i < st.getDataRowLength(); i++)
		{
			if (st.getRow(i).element.selectFlag
					&& st.getRow(i).element.className == "weightrow")
			{
				st.getRow(i).element.selectFlag = false;
			}
		}
	}
	if (endRowIndex < rowIndex)
	{
		for ( var i = endRowIndex; i <= rowIndex; i++)
		{
			if (i < clickrowIndex)
			{
				if (i != rowIndex)
				{
					st.getRow(i).element.className = "weightrow";
					st.getRow(i).element.selectFlag = false;
					st.getRow(i).element.isDragging = false;
				}
			}
			else
			{
				st.getRow(i).element.className = "selectedrow";
				st.getRow(i).element.selectFlag = true;
				st.getRow(i).element.isDragging = true;
			}
		}
	}
	else
	{
		for ( var i = endRowIndex; i >= rowIndex; i--)
		{
			if (i > clickrowIndex)
			{
				if (i != rowIndex)
				{
					st.getRow(i).element.className = "weightrow";
					st.getRow(i).element.selectFlag = false;
					st.getRow(i).element.isDragging = false;
				}
			}
			else
			{
				st.getRow(i).element.className = "selectedrow";
				st.getRow(i).element.selectFlag = true;
				st.getRow(i).element.isDragging = true;
			}
		}
	}
	handleRowSelected(st.getRow(rowIndex).element);
	endRowIndex = rowIndex;
}

function setRowsSelect(st, rowIndex)
{
	st.setRowSelect(rowIndex);
}

function dragRowSelectMouseUp(event)
{
	if (!event)
		event = window.event;
	var st = stCacheFor;
	if (st == null)
	{
		document.onmouseup = "";
		return;
	}
	for ( var i = 0; i < st.getDataRowLength(); i++)
	{
		st.getRow(i).element.onmousemove = "";
		st.getRow(i).element.onmouseout = "";
		st.getRow(i).element.isDragging = false;
	}
	document.onmouseup = "";
	st.element.onmouseout = ""
	stCacheFor = null;
}
/*
 * Handle table row selecte event @param obj sorttable object
 */
function handleRowSelected(obj)
{

	if (!obj.parent)
		return;
	var st = obj.parent;
	if (st.onRowSelect != null)
	{
		var func = st.onRowSelect;
		func(st.getSelectedRows());
	}
}

/*
 * Handle table row selecte event @param obj sorttable object
 */
function handleCellEdit(obj, stage)
{
	if (!obj.parent)
		return;
	var st = obj.parent;
	var param = {};
	param.stage = stage;
	param.rowindex = obj.parentNode.rowIndex;
	param.cellindex = obj.cellIndex;
	param.colid = obj.colid;
	param.value = obj.showElement.getValue();
	param.st = obj.parent;

	if (st.cellEditRangeFunc != null && stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var func = st.cellEditRangeFunc;
		func(param);
	}
	if (st.onCellEdit != null)
	{
		var func = st.onCellEdit;
		func(param);
	}

}

/*
 * Cell onselectstart handler
 */
function returnFalse()
{
	return false;
}

function sortRow(event)
{
	this.parent.sortRows(this);
}

var mozillaComboboxDiv;
/*
 * Cell dblclick handler
 */
function cellondbclick()
{
	mozillaComboboxDiv = 0;
	this.style.backgroundColor = "#d0f946";
	if (isIE)
	{
		this.onselectstart = null;
	}
	else
	{
		this.style.MozUserSelect = "text";
	}
	this.modify = true;
	this.parentNode.modify = true;
	this.showElement.element.style.display = "none";
	var colid = this.colid;
	var editdom = this.parent.editdom[colid];
	if (typeof (handleLinkageAction) != 'undefined')
	{
		var editdomclone = new Object();
		for ( var member in editdom)
		{
			editdomclone[member] = editdom[member];
		}
		editdomclone.element = editdom.element.cloneNode(true);
		editdom = handleLinkageAction(this.parentNode.rowIndex, editdomclone);
		editdom.element.onblur = cellonblur;
	}

	handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
	editdom = null;
	editdom = this.parent.editdom[colid];
	
	if (editdom.type == "text")
	{
		  if(this.showElement.getValue() == " " || this.showElement.getValue() == "\xA0")
		{
			editdom.setValue("");
		}
		else
		{
			editdom.setValue(this.showElement.getValue());
		}
		if (!editdom.element.onkeypress)
		{
			editdom.element.onkeypress = onEnterPress;
		}
	}
	else if(editdom.type == "password")
	{
		if(this.showElement.getValue() == " " || this.showElement.getValue() == "\xA0")
		{
			editdom.setValue("");
		}
		else
		{
			editdom.setValue(this.showElement.getValue());
		}
		if (!editdom.element.onkeypress)
		{
			editdom.element.onkeypress = onEnterPress;
		}
	}
	else if (editdom.type == "select")
	{
		var filterEditdom = filterOptions(editdom,colid);
		if(null != filterEditdom)
		{
			editdom = filterEditdom;
			
		}
		
		for (i = 0; i < editdom.element.options.length; i++)
		{
			if (editdom.element.options[i].text == this.showElement.getValue())
			{
				editdom.element.options[i].selected = true;
				editdom.element.focus();
			}
		}
	}
	else if (this.editElement.type == "combobox")
	{
		this.appendChild(editdom.element);
		window.curEditCell = this.editElement.element;

		var comboObj = this.editElement.element.parent;
		var eleTd = this.editElement.element.parentNode;
		var eleTable = eleTd.offsetParent;

		var wdt = eleTd.offsetWidth - 2;
		var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";

		comboObj.txtview.style.width = wdt;
		comboObj.selview.style.width = wdt;
		comboObj.selview.style.clip = clip;

		if (isIE)
		{
			var absCellY = getPosY(eleTd);
			var absTableY = getPosY(eleTable);
			comboObj.txtview.style.top = absCellY - absTableY + 1;
			comboObj.selview.style.top = absCellY - absTableY + 1;
		}
		else
		{
			var absCellY = getPosY(eleTd);
			var scrollTop = this.parent.bodyPack.scrollTop; // scrollbar scroll
			comboObj.txtview.style.top = absCellY - scrollTop;
			comboObj.selview.style.top = absCellY - scrollTop;
		}

		var showVal = this.showElement.getValue();
		var len = comboObj.selview.options.length;

		var k = 0;
		for ( ; k < len; k++)
		{
			if (parseFloat(comboObj.selview.options[k].value) == parseFloat(showVal)
					|| comboObj.selview.options[k].text == showVal)
			{
				comboObj.setSelectedIndex(k);
				comboObj.txtview.focus();
				break;
			}
		}
		
		if(k>=len)
		{
			comboObj.setSelectedIndex(-1);
		}

    	comboObj.txtview.value = showVal;
		comboObj.txtview.focus();
		return;
	}
	else if (editdom.type == "textarea")
	{
		if (this.showElement.getValue() == " "
				|| this.showElement.getValue() == "\xA0")
		{
			editdom.setValue("");
		}
		else
		{
			editdom.setValue(this.showElement.getValue());
		}
		editdom.element.style.overflow = "visible";
	}

	if (this.offsetWidth)
	{
		editdom.element.style.width = (this.offsetWidth - 1) + "px";
	}

	this.appendChild(editdom.element);

	if(editdom.type ==	"textarea") 
	{
	    var textLength = this.showElement.getValue().length;
	    var rng   = editdom.element.createTextRange();  
      rng.moveStart("character",textLength);  
      rng.collapse(true);            
      rng.select();   
  }
	editdom.element.focus();
}

function onEnterPress(evt)
{
	evt = evt?evt:window.event;
	var code = (evt.keyCode != 0 ? evt.keyCode : evt.charCode);
	var obj = evt.srcElement?evt.srcElement:evt.target;
	
	var ch = String.fromCharCode(code);
	
	if (code == 13)
	{
		obj.blur();
		return false;
	}
}
SortTable.prototype.clearSortFlag = function()
{

	for ( var key in this.element.headRow.element.cols)
	{
		var elem = this.element.headRow.element.cols[key];
		elem.element.firstChild.style.visibility = "hidden";
	}
}

function filterOptions(editdom,colid)
{
	return null;
}
/*
 * Onblur handler for editElement of cell
 */
function cellonblur()
{
	var obj = this;
	if (arguments.length > 0 && arguments[0].tagName)
	{
		obj = arguments[0];
	}

	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);

	var pnode = obj.parentNode;

	if (obj.parentNode.editElement.type == "select")
	{
		if (obj.selectedIndex > -1)
		{
			if ("span" == obj.parentNode.showElement.type)
			{
				obj.parentNode.showElement
						.setValue(obj.options[obj.selectedIndex].text);
			}
			else
			{
				obj.parentNode.showElement
						.setValue(obj.options[obj.selectedIndex].value);
			}

			pnode.parent.setTdCellValue(pnode, hc.element.keys[0],
					obj.options[obj.selectedIndex].value);
		}
	}
	else if (obj.parentNode.editElement.type == "combobox")
	{
		window.curEditCell = null;
		if ("span" == obj.parentNode.showElement.type)
		{
			obj.parentNode.showElement
					.setValue(obj.parentNode.editElement.element.parent.txtview.value);
		}
		else
		{
			obj.parentNode.showElement
					.setValue(obj.parentNode.editElement.element.parent.value);
		}

		pnode.parent.setTdCellValue(pnode, hc.element.keys[0],
				pnode.editElement.element.parent.getValue());
	}
	else
	{
		obj.style.position = "static";
		obj.style.border = "1px solid #999999";
		obj.style.width = obj.parentNode.offsetWidth;
		obj.parentNode.showElement.element.style.display = "";
		var rows = obj.parentNode.parent.getSelectedRows();
		for ( var j = 0; j < rows.length; j++)
		{
			var cell = pnode.parent.getCell(rows[j], pnode.colid);

			if (null == cell.element.editElement || cell.element.isEdit == 0)
			{
				continue;
			}

			cell.element.showElement.setValue(obj.value);

			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
			cell.element.showElement.element.style.display = "";

			handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		}
	}

	pnode.removeChild(pnode.lastChild);
	pnode.showElement.element.style.display = "";
	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}

/*
 * Handle table select with shift key pressed @param obj sorttable instance
 */
function shiftSelect(obj)
{
	var startIndex = -1;
	var endIndex = -1;
	var par = obj.parent;
	if (par.selectTr)
	{

		for ( var i = 0; i < par.getDataRowLength(); i++)
		{
			if (par.getRow(i).element == obj)
			{
				endIndex = i;
			}
			if (par.getRowSelFlag(i))
			{
				par.getRow(i).element.className = "weightrow";
				par.getRow(i).element.selectFlag = false;
			}
		}

		if (clickrowIndex > endIndex)
		{
			for ( var i = endIndex; i <= clickrowIndex; i++)
			{
				par.getRow(i).element.className = "selectedrow";
				par.getRow(i).element.selectFlag = true;
			}
		}
		else
		{
			for ( var i = clickrowIndex; i <= endIndex; i++)
			{
				par.getRow(i).element.className = "selectedrow";
				par.getRow(i).element.selectFlag = true;
			}
		}

	}
}

/*
 * Handle table row single click event
 */
function singleClick(obj, flag)
{
	if (!flag || (flag && obj.parent.singleChoiceFlg && !obj.selectFlag))
	{
		var par = obj.parent;
		var selectedrows = par.getSelectedRows();
		for ( var i = 0, m = selectedrows.length; i < m; i++)
		{
			par.getRow(selectedrows[i]).element.className = "weightrow";
			par.getRow(selectedrows[i]).element.selectFlag = false;
		}
		obj.className = "selectedrow";
		obj.selectFlag = true;
		obj.parent.selectTr = obj;
	}
	else if (flag)
	{
		if (obj.selectFlag && !obj.parent.mustChoiceFlg)
		{
			obj.className = "weightrow";
			obj.selectFlag = false;
			obj.parent.selectTr = null;
		}
		else
		{
			obj.className = "selectedrow";
			obj.parent.selectTr = obj;
			obj.selectFlag = true;
		}
	}
}

/*
 * Set cell edit handler
 */
SortTable.prototype.setOnCellEditHandler = function(func)
{
	if (typeof func != "function")
	{
		alert("argument of setOnCellEditHandler  must be function type");
		return;
	}
	this.onCellEdit = func;
}

SortTable.prototype.setCellEditRangeFunc = function(func)
{
	if (typeof func != "function")
	{
		alert("argument of setCellEditRangeFunc  must be function type");
		return;
	}
	this.cellEditRangeFunc = func;
}

SortTable.prototype.setRowSortHandler = function(func)
{
	if (typeof func != "function")
	{
		alert("argument of setRowSortHandler  must be function type");
		return;
	}
	this.onRowSort = func;
}

SortTable.prototype.setKeyColID = function(keyColId)
{
	this.keyColId = keyColId;
}
SortTable.prototype.getKeyColID = function()
{
	return this.keyColId;
}
/*
 * Create a table only with thead and tbody
 */
SortTable.prototype.createComponent = function()
{
	var element = document.createElement("table");
	var thead = document.createElement("thead");
	var tbody = document.createElement("tbody");
	element.appendChild(thead);
	element.appendChild(tbody);
	return element;
}

/*
 * Return sorttable datarow number
 */
SortTable.prototype.getDataRowLength = function()
{
	return this.element.datarows.length;
}

/*
 * Return table object inside sorttable the table object is used for page show
 */
SortTable.prototype.getTable = function()
{
	return this.element;
}

/*
 * Return table object inside sorttable the table object is used for page show
 */
SortTable.prototype.adjustLayout = function(tc)
{
	if (this.bodyPack.offsetWidth == "0" || !this.element.isResizeAdjust)
	{
		return;
	}
	var appendWidth = getAppendWidth(this, tc);
	var adjustWidth = document.body.clientWidth - 20;
	for (i = 0; i < tc.getColsLength(); i++)
	{

		var cellwidth = 0;
		var colWidth = tc.getColWidth(i) + "";
		if (colWidth.indexOf("%") != -1)
		{
			cellwidth = adjustWidth * parseInt(tc.getColWidth(i)) / 100;
			if (cellwidth == "0")
			{
				this.getHeadCell(tc.getColId(i)).element.style.display = "none";
			}
			else
			{
				var newWidth = cellwidth + appendWidth;
				this.getHeadCell(tc.getColId(i)).element.width = newWidth
						+ "px";
				;
			}
		}
		else
		{
			var headWidth = this.getHeadCell(tc.getColId(i)).element.width
					.replace("px", "");
			if (headWidth != "0%" && headWidth != "0px" && headWidth != "")
			{
				this.getHeadCell(tc.getColId(i)).element.width = parseInt(headWidth)
						+ appendWidth;
			}
		}
	}
	var atomTemp = null;
	for ( var i = 0; i < this.getDataRowLength(); i++)
	{
		for ( var j = 0; j < tc.getColsLength(); j++)
		{
			var colWidth = tc.getColWidth(j) + "";
			if (colWidth.indexOf("%") != -1)
			{
				if (colWidth == "0%")
				{
					continue;
				}
				this.getCellElement(i, tc.getColId(j)).width = adjustWidth
						* parseInt(tc.getColWidth(j)) / 100 + appendWidth;
			}
			else
			{
				var headWidth = parseInt(tc.getColWidth(j).toString().replace("px", ""));
				if (headWidth != "0%" && headWidth != "0px" && headWidth != "")
				{
					if ((headWidth + appendWidth) >= 0)
					{
						this.getCellElement(i, tc.getColId(j)).width = headWidth
								+ appendWidth;
					}
				}
			}

			if (this.getCellElement(i, tc.getColId(j)).childNodes.length > 1)
			{
				atomTemp = this.getCellElement(i, tc.getColId(j)).childNodes[1];
			}
		}
	}
	if (atomTemp
			&& (atomTemp.tagName.toUpperCase() == "TEXT" || atomTemp.tagName
					.toUpperCase() == "SELECT"))
	{
		atomTemp.style.width = (atomTemp.parentElement.offsetWidth - 1) + "px";
	}
	var scrollWidth = parseInt(this.bodyPack.offsetWidth)
			- parseInt(this.bodyPack.clientWidth);
	var bodyWidth = 0;
	var totalWidth = 0;
	if (this.element.parentElement != null)
	{
		this.element.parentElement.style.width = "100%";
		this.element.parentElement.style.overflowX = "hidden";
		totalWidth = this.element.parentElement.offsetWidth - 2;
		bodyWidth = this.headPack.firstChild.offsetWidth;
	}
	else
	{
		bodyWidth = adjustWidth;
		totalWidth = adjustWidth;
	}

	if (scrollWidth > 0)
	{
		this.headPack.style.width = totalWidth - scrollWidth;
		this.headPack.firstChild.style.width = bodyWidth - scrollWidth;
		this.bodyPack.style.width = totalWidth;
		this.bodyPack.firstChild.style.width = bodyWidth - scrollWidth;
		this.bodyPack.style.overflow = "scroll";
	}
	else
	{
		this.headPack.style.width = totalWidth;
		this.headPack.firstChild.style.width = bodyWidth;
		this.bodyPack.style.width = totalWidth;
		this.bodyPack.firstChild.style.width = bodyWidth;
	}
	var headtr = this.element.firstChild.firstChild;
	if (headtr.childNodes[1])
	{
		headtr.removeChild(headtr.childNodes[1]);
	}
}

/*
 * Delete all data rows of sorttable
 */
SortTable.prototype.clearTableData = function()
{
	this.body.style.visibility = "hidden";
	for ( var i = this.getDataRowLength() - 1; i >= 0; i--)
	{
		this.deleteRow(i);
	}
	this.body.style.visibility = "";
	this.adjustDataRows();
}

/*
 * Set SortTable headrow @paarm row Row object
 */
SortTable.prototype.setHeadRow = function(row)
{
	this.element.headRow = row;
}


SortTable.prototype.refreshColsWidth = function(tabconf,basicCalWidth,appendWidth)
{
	for (var j = 0; j < tabconf.getColsLength(); j++) 
	{
		var colid = tabconf.getColId(j);
		var tempWidth = "";
		if (this.headPack.isLayout == true) 
		{
			tempWidth = this.getHeadCell(colid).element.width;
		}
		if (tempWidth == "") 
		{
			if (this.element.cellsWidth[colid] != null) 
			{
				tempWidth = this.element.cellsWidth[colid];
			}
			else 
			{
				var colWidth = tabconf.getColWidth(j) + "";
				if (colWidth.indexOf("%") != -1) 
				{
					tempWidth = basicCalWidth * parseInt(colWidth) / 100;
					if (tempWidth != 0) 
					{
						tempWidth = tempWidth + appendWidth;
					}
				}
				else
				{
					tempWidth = colWidth;
				}
			}
		}
		this.getHeadCell(colid).element.refreshWidth = tempWidth;
	}
}

/**
 * Set sorttable headrow style
 * 
 * @param css
 *            headrow css style
 */
SortTable.prototype.setHeadRowCss = function(css)
{
	this.element.headRow.element.className = css;
}

/**
 * Set sorttable image path
 * 
 * @path sort icon image path
 */
SortTable.prototype.setImage = function(path)
{
	this.imgpath = path;
}

/**
 * Set sorttable single row selection flag
 * 
 * @singleFlag single selection flag;true: single selection;false:
 *             multi-selection.
 */
SortTable.prototype.setSingleChoiceFlg = function(singleFlag)
{
	this.singleChoiceFlg = singleFlag;
}


/**
 * Set sorttable must hava row selection flag
 * 
 * @singleFlag must selection flag;true: mustt selection;false:
 *             no need must select.
 */
SortTable.prototype.setMustChoiceFlg = function(mustFlag)
{
	this.mustChoiceFlg = mustFlag;
}

SortTable.prototype.addHeadCell = function(row, hc)
{
	if ((hc.element.isSort) == 1)
	{
		var img = new Image();
		img.setAttribute("border", "0px");
		img.setAttribute("align", "absmiddle");
		img.src = this.imgpath + "up.gif";
		img.style.display = "none";

		hc.element.insertBefore(img, hc.element.firstChild);
		hc.element.style.cursor = "pointer";
		hc.element.style.cursor = "hand";
		hc.element.onclick = sortRow;
	}
	hc.element.className = "hdr";
	hc.element.onselectstart = returnFalse;
	hc.element.onmousemove = new Function("e",
			"changeCursorState(e||window.event)");
	hc.element.onmousedown = new Function("e",
			"startColResize(e||window.event)");
	hc.element.ondblclick = new Function("e", "dbclickResize(e||window.event)");
	row.element.cols[hc.element.colid] = hc;
	this.element.colsArray[this.element.colsArray.length] = hc.element.colid;
}

SortTable.prototype.addHeadCellAt = function(row, hc, index)
{
	if ((hc.element.isSort) == 1)
	{
		var img = new Image();
		img.setAttribute("border", "0px");
		img.setAttribute("align", "absmiddle");
		img.src = this.imgpath + "up.gif";
		img.style.display = "none";

		hc.element.insertBefore(img, hc.element.firstChild);
		hc.element.style.cursor = "pointer";
		hc.element.style.cursor = "hand";
		hc.element.onclick = sortRow;
	}
	hc.element.className = "hdr";
	hc.element.onselectstart = returnFalse;
	hc.element.onmousemove = new Function("e",
			"changeCursorState(e||window.event)");
	hc.element.onmousedown = new Function("e",
			"startColResize(e||window.event)");
	hc.element.ondblclick = new Function("e", "dbclickResize(e||window.event)");
	row.element.cols[hc.element.colid] = hc;
	this.element.colsArray.splice(index, 0, hc.element.colid);
}
SortTable.prototype.removeHeadCellAt = function(index)
{
	var row = this.element.headRow;
	var colid = this.element.colsArray[index];
	var hc = row.element.cols[colid];
	if ((hc.element.isSort) == 1)
	{
		hc.element.onclick = null;
	}
	hc.element.onselectstart = null;
	hc.element.onmousemove = null;
	hc.element.onmousedown = null;
	hc.element.ondblclick = null;
	row.element.removeChild(hc.element);
	row.element.cols[colid] = null;
	this.element.colsArray.splice(index, 1);
}

/**
 *      
 */
SortTable.prototype.removeEmptyTr = function()
{
	if (this.element.isAppendEmptyTr) 
    {
        var tBody = this.bodyPack.firstChild.lastChild;
        tBody.removeChild(tBody.firstChild);
        this.element.isAppendEmptyTr = false;
    }
}

/**
 *      ,              
 */
SortTable.prototype.appendEmptyTr = function()
{
	if (!this.element.isAppendEmptyTr && this.element.datarows.length == 0) 
    {
        var tr = document.createElement("tr");
        var td = document.createElement("td");
        td.innerHTML = "";
        tr.appendChild(td);
        this.bodyPack.firstChild.lastChild.appendChild(tr);
        if (this.element.cellsWidth["tableWidth"] != null) 
        {
            this.bodyPack.firstChild.style.width = this.element.cellsWidth["tableWidth"];
        }
        else 
        {
            this.bodyPack.firstChild.style.width = this.headPack.firstChild.offsetWidth;
        }
        this.element.isAppendEmptyTr = true;
    }
}

function dbclickResize(ev)
{
	var el = ev.target || ev.srcElement;
	var resizeWidth = 0;
	var changeWidth = 0;
	if (el.tagName == "SPAN")
	{
		el = el.parentElement;
	}
	if (el.style.cursor != "e-resize")
	{
		return;
	}
	var st = getStFromEventTag(el);

	var scrollWidth = parseInt(st.bodyPack.offsetWidth)
			- parseInt(st.bodyPack.clientWidth);
	var bodyWidth = st.element.parentElement.offsetWidth - 2;
	if (st.element.parentElement == null)
	{
		bodyWidth = document.body.clientWidth - 20;
	}
	if (st.headPack.style.width != (bodyWidth - scrollWidth))
	{
		st.headPack.style.width = bodyWidth - scrollWidth;
	}
	var rowNum = st.getDataRowLength();
	var cellIndex = el.colid;
	var maxWidth = el.lastChild.offsetWidth;
	if (maxWidth == null)
	{
		maxWidth = 0;
	}
	if (rowNum != 0)
	{
		for ( var i = 0; i < rowNum; i++)
		{
			if (st.getCellElement(i, cellIndex).lastChild.offsetWidth > maxWidth)
			{
				maxWidth = st.getCellElement(i, cellIndex).lastChild.offsetWidth;
			}
		}
	}

	var fcolW = maxWidth + 2;
	var changeWidth = fcolW - el.offsetWidth;

	st.headPack.firstChild.style.width = st.headPack.firstChild.offsetWidth
			+ changeWidth;

	st.setHeadCellWidth(cellIndex,fcolW);
	
	st.element.cellsWidth[cellIndex] = fcolW;
	if (rowNum != 0)
	{
		st.bodyPack.firstChild.style.width = st.bodyPack.firstChild.offsetWidth
				+ changeWidth;
		for ( var i = 0; i < rowNum; i++)
		{
			st.getCellElement(i, cellIndex).width = fcolW + "px";
			if (st.getCellElement(i, cellIndex).childNodes.length > 1
					&& (st.getCellElement(i, cellIndex).childNodes[1].tagName
							.toUpperCase() == "INPUT" || st.getCellElement(
							i, cellIndex).childNodes[1].tagName
							.toUpperCase() == "SELECT"))
			{
				st.getCellElement(i, cellIndex).childNodes[1].style.width = (st
						.getCellElement(i, cellIndex).offsetWidth - 1)
						+ "px";
			}
		}
	}
	else
	{
		if (!st.element.isAppendEmptyTr)
		{
			var tr = document.createElement("tr");
			var td = document.createElement("td");
			td.innerHTML = "";
			tr.appendChild(td);
			st.bodyPack.firstChild.lastChild.appendChild(tr);
			st.element.isAppendEmptyTr = true;
		}
		st.bodyPack.firstChild.style.width = st.bodyPack.firstChild.offsetWidth
				+ changeWidth;
	}
}

function changeCursorState(ev)
{
	var el = ev.target || ev.srcElement;
	if (el.tagName != "TD")
	{
		return;
	}
	if ((el.offsetWidth - ev.offsetX) < 10 && isIE
			|| (el.offsetWidth - (ev.offsetX - el.offsetLeft)) < 10 && !isIE)
	{
		el.style.cursor = "E-resize";
	}
	else
	{
		el.style.cursor = "default";
	}
}

function startColResize(ev)
{
	if (ev.button && ev.button == 2)
	{
		return; // right button return
	}
	var el = ev.target || ev.srcElement;

	if (el.tagName == "SPAN")
	{
		el = el.parentElement;
	}

	var x = ev.layerX || ev.x;
	var st = el.parent;
	var tabW = st.headPack.firstChild.offsetWidth;
	var startW = parseInt(el.offsetWidth);
	if (el.tagName == "TD" && el.style.cursor != "default"
			|| el.tagName == "SPAN" && el.style.cursor != "default")
	{
		document.body.onmousemove = function(e)
		{
			doColResize(e || window.event, el, startW, x, tabW)
		};
		el.onmouseup = function(e)
		{
			stopColResize(e || window.event, el)
		};
		if (!isIE)
		{
			st.element.onmouseout = function(e)
			{
				dragmouseout(e || window.event, el)
			};
		}
		if (el.setCapture)
		{
			el.setCapture();
		}
		else if (window.captureEvents)
		{
			window.captureEvents(Event.MOUSEUP);
		}
		var rowNum = st.getDataRowLength();
		if (rowNum == 0 && !st.element.isAppendEmptyTr)
		{
			var tr = document.createElement("tr");
			var td = document.createElement("td");
			td.innerHTML = "";
			tr.appendChild(td);
			st.bodyPack.firstChild.lastChild.appendChild(tr);
			st.bodyPack.firstChild.style.width = st.headPack.firstChild.offsetWidth;
			st.element.isAppendEmptyTr = true;
		}

	}
}

function getStFromEventTag(el)
{
	var st;
	if (el.tagName == "SPAN")
	{
		st = el.parentElement.parent;
	}
	else
	{
		st = el.parent;
	}
	return st;
}

function dragmouseout(ev, el)
{
	if (!event)
		event = window.event;
	if (event.toElement == null || event.toElement.tagName == "IMG"
			|| event.toElement.tagName == "BODY"
			|| event.toElement.tagName == "DIV")
	{
		var st = el.parent;
		st.isDragHeadEvent = true;
		st.element.onmouseout = ""
		document.body.onmousemove = "";
		el.onmouseup = "";
		;
	}
}

function stopColResize(ev, el)
{
	if (el.releaseCapture)
	{
		el.releaseCapture();
	}
	else if (window.captureEvents)
	{
		window.releaseEvents(Event.MOUSEUP);
	}
	var st = getStFromEventTag(el);
	st.isDragHeadEvent = true;
	document.body.onmousemove = "";
	st.element.onmouseout = "";
	el.onmouseup = "";
	;
}

function doColResize(ev, el, startW, x, tabW)
{
	var st = getStFromEventTag(el);
	var rowNum = st.getDataRowLength();
	var cellIndex = el.colid;

	var fcolW = startW + ((ev.layerX || ev.x) - x);
	var wtabW = tabW + ((ev.layerX || ev.x) - x)

	var gridWidth = parseInt(st.bodyPack.firstChild.offsetWidth);
	if (fcolW > 10)
	{
		st.headPack.firstChild.style.width = wtabW;
		st.bodyPack.firstChild.style.width = wtabW;

		st.setHeadCellWidth(cellIndex,fcolW);
		
		st.element.cellsWidth[cellIndex] = fcolW;
		st.element.cellsWidth["tableWidth"] = wtabW;
		st.bodyPack.firstChild.style.width = wtabW;
		if (rowNum != 0)
		{
			st.bodyPack.firstChild.style.width = wtabW;
			for ( var i = 0; i < rowNum; i++)
			{
				st.getCellElement(i, cellIndex).width = fcolW + "px";

				if (st.getCellElement(i, cellIndex).childNodes.length > 1
						&& (st.getCellElement(i, cellIndex).childNodes[1].tagName
								.toUpperCase() == "INPUT" || st.getCellElement(
								i, cellIndex).childNodes[1].tagName
								.toUpperCase() == "SELECT"))
				{
					st.getCellElement(i, cellIndex).childNodes[1].style.width = (st
							.getCellElement(i, cellIndex).offsetWidth - 1)
							+ "px";
				}
			}
		}
		else
		{
			if(st.bodyPack.childNodes[0] && st.bodyPack.childNodes[0].childNodes[1] 
			    && st.bodyPack.childNodes[0].childNodes[1].childNodes[0])
			{
				st.bodyPack.childNodes[0].childNodes[1].childNodes[0].childNodes[0].width = wtabW;
			}
		}
	}
}

SortTable.prototype.addHead = function(row)
{
	this.head.firstChild.appendChild(row.element);
	this.sortCells(row);
	this.element.headRow = row;

}
/*
 * get sorttable column count
 */
SortTable.prototype.getColumnCount = function()
{
	return this.head.rows[0].cells.length;
}

SortTable.prototype.sortCells = function(row)
{
	for ( var m = 0; m < this.element.colsArray.length; m++)
	{
		var colid = this.element.colsArray[m];
		var colElm = row.element.cols[colid].element;
		colElm.colid = colid;
		row.element.appendChild(colElm);
	}
}

/**
 * after query data,clear sort flag
 */
SortTable.prototype.clearSortFlag = function()
{

	for ( var key in this.element.headRow.element.cols)
	{
		var elem = this.element.headRow.element.cols[key];
		elem.element.firstChild.style.display = "none";
	}
}

SortTable.prototype.sortRows = function(colEle, imgflag)
{
	if (this.isDragHeadEvent)
	{
		this.isDragHeadEvent = false;
		return;
	}
	if (this.element.colsArray.selectedId
			&& this.element.colsArray.selectedId != colEle.colid)
	{
		if (this.element.headRow.element.cols[this.element.colsArray.selectedId])
		{
			var sortCol = this.element.headRow.element.cols[this.element.colsArray.selectedId].element;
			if (sortCol.firstChild.tagName.toLowerCase() == "img"
					&& sortCol.style)
			{
				this.element.headRow.element.cols[this.element.colsArray.selectedId].element.firstChild.style.display = "none";
			}
		}
		this.element.colsArray.selectedId = colEle.colid;

	}
	else if (!this.element.colsArray.selectedId)
	{
		this.element.colsArray.selectedId = colEle.colid;

	}

	var img = colEle.firstChild;
	var flag;

	if (imgflag == null && img.tagName.toLowerCase() == "img")
	{
		if (img.style.display == "none")
		{
			img.style.display = "";
		}
		if (img.src.lastIndexOf("up.gif") > 0)
		{
			img.src = this.imgpath + "down.gif";
			flag = true;
			this.element.colsArray.imgflag = 0;
		}
		else
		{
			img.src = this.imgpath + "up.gif";
			flag = false;
			this.element.colsArray.imgflag = 1;
		}
	}
	else
	{
		if (imgflag == 1)
		{
			flag = false;
		}
		else
		{
			flag = true;
		}

	}

	var data = []; //            
	var datarows = colEle.parent.element.datarows;
	
	var sortColArray = colEle.keys;
	if(typeof(colEle.sortCols) != "undefined" && colEle.sortCols != null && colEle.sortCols != "")
	{
		sortColArray = colEle.sortCols.split(",");
	}
	if (this.onRowSort != null)
	{
		var func = this.onRowSort;
		func(colEle.colid,flag);
		return;
	}
	var objData = null;
	if (colEle.isSortShow == 1)
	{

		for ( var i = 0; i < datarows.length; i++)
		{
			objData = {
				index :i,
				value :datarows[i].element.cols[colEle.colid].element.showElement
						.getValue()
			};
			data[i] = objData;
		}
	}
	else if (colEle.isSortShow == 0)
	{

		for ( var i = 0; i < datarows.length; i++)
		{
			var obj = datarows[i].element.cols[colEle.colid].element.storeValue;
			var arr = sortColArray;
			var v = '';
			var sp = "";
			for ( var j = 0; j < arr.length; j++)
			{
				v = v + sp + obj[arr[j]];
				sp = "-";
			}
			objData = {
				index :i,
				value :v //DTS2011083002566 
			};
			data[i] = objData;
		}
	}
	else if (colEle.isSortShow == 2)
	{
		for ( var i = 0; i < datarows.length; i++)
		{
			var obj = datarows[i].element.cols[colEle.colid].element.hiddenValue;
			var arr = sortColArray;
			var v = '';

			for ( var j = 0; j < arr.length; j++)
			{
				if (obj[arr[j]])
				{
					v = v + obj[arr[j]] + "-";
				}
			}
			objData = {
				index :i,
				value :v.substring(0, v.length - 1)
			};
			data[i] = objData;
		}
	}
	var c_compare = colEle.compare;

	if (c_compare == null || typeof c_compare != "function")
	{
		c_compare = compare;
	}

	data.sort(generateCompareTRs(flag, c_compare));
	var rows = datarows;
	colEle.parent.element.datarows = new Array()
	for ( var ij = 0; ij < data.length; ij++)
	{
		colEle.parent.addRow(rows[data[ij].index]);
	}
	
	adjustTableToHead(this);
}

SortTable.prototype.sortSpelRows = function(colEle, flagVar, mutFlag)
{
	if (this.isDragHeadEvent)
	{
		this.isDragHeadEvent = false;
		return;
	}

	var data = []; //            
	var sortArray = []; //          
	var sortColArray = colEle.keys;
	if(typeof(colEle.sortCols) != "undefined" && colEle.sortCols != null && colEle.sortCols != "")
	{
		sortColArray = colEle.sortCols.split(",");
	}
	var datarows = colEle.parent.element.datarows;

	if (colEle.isSortShow == 1)
	{
		for ( var i = 0; i < datarows.length; i++)
		{
			data[i] = datarows[i].element.cols[colEle.colid].element.showElement
					.getValue();
			sortArray[i] = i;
		}
	}
	else if (colEle.isSortShow == 0)
	{
		for ( var i = 0; i < datarows.length; i++)
		{
			var obj = datarows[i].element.cols[colEle.colid].element.storeValue;
			var arr = sortColArray;
			var v = '';
			for ( var j = 0; j < arr.length; j++)
			{
				v = v + obj[arr[j]] + "-";
			}
			data[i] = v.substring(0, v.length - 1);
			sortArray[i] = i;
		}
	}
	else if (colEle.isSortShow == 2)
	{
		for ( var i = 0; i < datarows.length; i++)
		{
			var obj = datarows[i].element.cols[colEle.colid].element.hiddenValue;
			var arr = sortColArray;
			var v = '';

			for ( var j = 0; j < arr.length; j++)
			{
				if (obj[arr[j]])
				{
					v = v + obj[arr[j]] + "-";
				}
			}
			data[i] = v.substring(0, v.length - 1);
			sortArray[i] = i;
		}
	}
	for ( var i = mutFlag; i < data.length; i++)
	{
		for ( var j = i + 1; j < data.length; j++)
		{
			if (data[j] == flagVar)
			{
				var tmp = data[i];
				var tflag = sortArray[i];
				data[i] = data[j];
				sortArray[i] = sortArray[j];
				data[j] = tmp;
				sortArray[j] = tflag;
			}
		}
	}

	var rows = datarows;
	colEle.parent.element.datarows = new Array()
	for ( var ij = 0; ij < sortArray.length; ij++)
	{
		colEle.parent.addRow(rows[sortArray[ij]]);
	}
}

function generateCompareTRs(desc, compare)
{
	if (desc)
	{
		return function compareTRs(oTR1, oTR2)
		{
			return (-1 * compare(oTR1.value, oTR2.value));
		}
	}
	else
	{
		return function compareTRs(oTR1, oTR2)
		{
			return compare(oTR1.value, oTR2.value);
		}
	}
}
SortTable.prototype.getId = function()
{
	return this.element.id;
}

SortTable.prototype.setId = function(tableId)
{
	this.element.id = tableId;
}
/*
 * Add row to sorttable @param row row Object
 */
SortTable.prototype.addRow = function(row)
{
	this.element.datarows[this.element.datarows.length] = row;
	this.sortCells(row);
	this.body.childNodes[1].appendChild(row.element);
	row.element.onclick = rowclick;
	if (!this.singleChoiceFlg)
	{
		row.element.onmousedown = dragRowSelect;
		row.element.isDragging = false;
	}
}

SortTable.prototype.setColMaxWordLength = function(colid,wordValue)
{
	var len = getLength(wordValue);
	var headcell = this.getHeadCell(colid);
	if(headcell != null && headcell.element.maxLength)
	{
		if(len > parseInt(headcell.element.maxLength))
		{
			headcell.element.maxLength = len;
		}
	}
}

SortTable.prototype.getColMaxWordLength = function(colid)
{
	var headcell = this.getHeadCell(colid);
	var maxLength = 0;
	if(headcell != null && headcell.element.maxLength)
	{
		maxLength = parseInt(headcell.element.maxLength,10);
	}
	return maxLength;
}

SortTable.prototype.replaceRowAt = function(row, index)
{
	if (this.element.datarows.length < (index + 1)) 
	{
		var rowTmp = this.element.datarows[index];
		var cols = rowTmp.cols;
		for ( var key in cols)
		{
			var cell = cols[key];
			cell._clearLeaks();
			cell = null;
		}
		rowTmp._clearLeaks();
		rowTmp = null;
		row.element.onclick = rowclick;
		this.element.datarows[index] = row;
		this.sortCells(row);
		if (this.element.datarows.length == (index + 1)) 
		{
			this.body.childNodes[1].appendChild(row.element);
		}
		else 
		{
			this.body.childNodes[1].insertBefore(row.element, this.body.childNodes[1].childNodes[index]);
		}
	}
}

/*
 * Insert row at given position @param row rowObject @param index given postion
 */
SortTable.prototype.addRowAt = function(row, index)
{
	if (this.element.datarows.length == 0)
	{
		if (index != 0)
		{
			throw new Error("bad row index value:" + index);
		}
		this.addRow(row);
	}
	else
	{
		index--;
		if (index < 0 || (index >= this.element.datarows.length))
		{
			throw new Error("bad row index value:" + (++index));
		}
		var tmp = this.element.datarows[index];
		this.element.datarows[index] = row;
		this.element.datarows[this.element.datarows.length] = tmp;

		this.sortCells(row);
		this.body.childNodes[1].insertBefore(row.element,
				this.body.childNodes[1].childNodes[index]);
		row.element.onclick = rowclick;
	}

}

/*
 * Insert row at last
 */
SortTable.prototype.appendRowAt = function(row)
{
    if (!this.singleChoiceFlg)
	{
		row.element.onmousedown = dragRowSelect;
		row.element.isDragging = false;
	}
    this.element.datarows[this.element.datarows.length] = row;

    this.sortCells(row);
    this.body.childNodes[1].appendChild(row.element);
    row.element.onclick = rowclick;
}

SortTable.prototype.getRowSelFlag = function(index)
{
	return this.element.datarows[index].element.selectFlag;
}

SortTable.prototype.setRowSelect = function(index)
{
	var obj = this.getRow(index).element;
	obj.className = "selectedrow";
	obj.parent.selectTr = obj;
	obj.selectFlag = true;
}

SortTable.prototype.setRowNoneSelect = function(index)
{
	var obj = this.getRow(index).element;

	obj.className = "weightrow";
	obj.parent.selectTr = null;
	obj.selectFlag = false;
}

/*
 * Delete head row
 */
SortTable.prototype.deleteHeadRow = function()
{
	if(this.editdom != null)
	{
		for(var atom in this.editdom)
		{
			if(typeof(this.editdom[atom]._clearLeaks) != "undefined")
			{
				this.editdom[atom]._clearLeaks();
			}
			this.editdom[atom] = null;
		}
	}
	this.editdom = null;
	if(this.element == null || this.element.headRow == null)
	{
		return;
	}

	var row = this.element.headRow;
	if(row.element != null && row.element.cols != null)
	{
		var cols = row.element.cols;
		for ( var key in cols)
		{
			cols[key]._clearLeaks();
			cols[key] = null;
		}
	}
	row._clearLeaks();
	row.element = null;
}

/*
 * Delete table row,remove tr and td attribute
 */
SortTable.prototype.deleteRow = function(index)
{
	var cols = this.element.datarows[index].element.cols;
	for ( var key in cols)
	{
		var cell = cols[key];
		cell._clearLeaks();
		cell = null;
	}

	var row = this.element.datarows[index];
	row._clearLeaks();
	row = null;
	delete this.element.datarows[index];
}

SortTable.prototype.adjustDataRows = function()
{
	var len = this.element.datarows.length;
	var arr = this.element.datarows;

	var i = 0;
	while (arr[i])
	{
		i++;
	}
	for ( var j = i + 1; j < len; j++)
	{
		if (null == arr[j] || "undefined" == arr[j])
		{
			delete arr[j];
		}
		else
		{
			arr[i] = arr[j];
			i++;
		}
	}
	this.element.datarows.length = i;
	this.appendEmptyTr();
}

SortTable.prototype.createRow = function()
{
	var row = new Row();
	row.element.parent = this;
	return row;
}

SortTable.prototype.createHeadCell = function(colid, name, width)
{

	var hc = new HeadCell(colid, name, width);
	hc.element.parent = this;
	return hc;
}

SortTable.prototype.createCell = function(w)
{
	var ce = new Cell(w);
	ce.element.parent = this;
	return ce;
}

SortTable.prototype.createAtom = function(typstr)
{
	return new Atom(typstr);
}

SortTable.prototype.getRow = function(index)
{
	return this.element.datarows[index];
}

SortTable.prototype.addCell = function(row, colid, cell)
{
	row.element.cols[colid] = cell;
	if (isIE)
	{
		cell.element.onselectstart = returnFalse;
	}
	else
	{
		cell.element.style.MozUserSelect = "none";
	}
}

SortTable.prototype.setRowCss = function(row, css)
{
	row.element.className = css;
}

SortTable.prototype.getModify = function(index)
{
	return this.element.datarows[index].element.modify;
}

SortTable.prototype.getHeadCell = function(colid)
{
	return this.element.headRow.element.cols[colid];
}

SortTable.prototype.setHeadCellWidth = function(colid,width)
{
	var cell = this.element.headRow.element.cols[colid];
	if(cell && cell.element && width != "")
	{
		cell.element.width = width + "px";
		if(cell.element.parentNode && cell.element.parentNode.parentNode 
			&& cell.element.parentNode.parentNode.childNodes.length > 1 
			&& cell.element.parentNode.parentNode.childNodes[0].childNodes[cell.element.cellIndex])
		{
			cell.element.parentNode.parentNode.childNodes[0].childNodes[cell.element.cellIndex].width = width + "px";
		}
	}
}

SortTable.prototype.setHeadCellKey = function(hc, key)
{
	hc.element.keys[hc.element.keys.length] = key;
}

SortTable.prototype.setHeadCellConvert = function(hc, key, cvtarr)
{
	hc.element.convertObj[key] = cvtarr;
}
SortTable.prototype.setHeadCellConvertToNEValue = function(hc, key, cvtarr)
{
	hc.element.convertToNEValue[key] = cvtarr;
}
/*
 *   HeadCell         hc  HeadCell       issort 1    0 1        0         
 * issortshow 1   0 1   SortTable              0                   
 *             issortshow  1               0    cmpare                
 */
SortTable.prototype.setHCAttribute = function(hc, issort, issortshow, cmpare,sortCols)
{
	hc.element.isSort = issort;
	hc.element.isSortShow = issortshow;
	hc.element.compare = cmpare;
	hc.element.sortCols = sortCols;
}

SortTable.prototype.getCellIsEdit = function(cell)
{
	var obj = cell;
	if (cell.element != null && typeof (cell.element) != "undefined")
	{
		obj = cell.element;
	}
	if (obj.tagName == null || typeof (obj.tagName) == "undefined"
			|| obj.tagName.toLowerCase() != "td")
	{
		return "0";
	}
	return obj.isEdit;
}
SortTable.prototype.setCellEdit = function(rowindex,colid,isedit)
{
	var cell = this.getCell(rowindex,colid);
	this.setCellIsEdit(cell,isedit);
}

SortTable.prototype.setCellIsEdit = function(cell, isedit)
{
	var obj = cell;
	if (cell.element != null && typeof (cell.element) != "undefined")
	{
		obj = cell.element;
	}
	if (obj.tagName == null || typeof (obj.tagName) == "undefined"
			|| obj.tagName.toLowerCase() != "td")
	{
		return;
	}
	obj.isEdit = isedit;

	if (isedit.toString() == "0" || !isedit)
	{
		obj.style.backgroundColor = "";
		obj.ondblclick = null;
		if (obj.childNodes[0] && obj.childNodes[0].style)
		{
			obj.childNodes[0].style.color = "";
		}
	}
	else
	{
		obj.style.backgroundColor = "#FFFFFF";
		obj.ondblclick = cellondbclick;
		if (obj.childNodes[0])
		{
			obj.childNodes[0].style.color = "#000000";
		}
	}
}

SortTable.prototype.getCellStoreValue = function(index, colid, key)
{
	if (this.element.datarows[index] != null && this.element.datarows[index].element.cols[colid])
	{
		return this.element.datarows[index].element.cols[colid].element.storeValue[key];
	}
	else
	{
		return null;
	}
}

SortTable.prototype.getCellHiddenValue = function(index, colid, key)
{
	
	return this.element.datarows[index].element.cols[colid].element.hiddenValue[key];
}

SortTable.prototype.getCellCurrentValue = function(index, colid, key)
{
	if (this.element.datarows[index].element.cols[colid])
	{
		return this.element.datarows[index].element.cols[colid].element.currentValue[key];
	}
	else
	{
		return null;
	}

}

SortTable.prototype.setTdCellValue = function(tdelement, key, value)
{
	tdelement.storeValue[key] = value;
	tdelement.currentValue[key] = value;
}

SortTable.prototype.setCellValue = function(cell, key, value)
{
	cell.element.storeValue[key] = value;
	cell.element.currentValue[key] = value;

}
SortTable.prototype.setHiddenCellValue = function(cell, key, hiddenValue)
{
	if (hiddenValue)
	{
		cell.element.hiddenValue[key] = hiddenValue;
	}
}
SortTable.prototype.addCellShow = function(cell, atom)
{
	if(!cell || !cell.element)
	{
		return;
	}
	this.setColMaxWordLength(cell.colid,atom.getValue());
	cell.element.showElement = atom;
	if(atom.type == "hidden")
	{
		cell.element.style.display = "none";
	}
	cell.element.appendChild(atom.element);
}

SortTable.prototype.getCellShow = function(index, colid)
{
	return this.element.datarows[index].element.cols[colid].element.showElement;
}


function atomOnMouseDownHandle()
{
	if (isIE)
	{
		this.parentElement.onselectstart = null;
	}
	else
	{
		this.parentElement.style.MozUserSelect = "text";
	}
	stopEventPropagation();
}

function stopEventPropagation(e)
{

	if (!e)
	{
		var e = window.event;
		e.cancelBubble = true;
	}
	if (e.stopPropagation)
	{
		e.stopPropagation();
	}
}

SortTable.prototype.addCellEdit = function(cell, atom)
{
	var ce = cell.element;
	if (ce.isEdit == 1)
	{

		ce.style.backgroundColor = "#ffffff";
		cell.element.editElement = atom;
		ce.childNodes[0].style.color = "#000000";
		cell.element.style.cursor = "hand";
		ce.ondblclick = cellondbclick;
	}

	else
	{
		cell.element.editElement = atom;
		cell.element.style.cursor = "hand";
		cell.element.ondblclick = null;
	}

}

SortTable.prototype.getCellEdit = function(index, colid)
{

	return this.editdom[colid];

}

SortTable.prototype.getCellElement = function(index, colid)
{
	if(this.element.datarows[index] && this.element.datarows[index].element.cols[colid])
	{
		return this.element.datarows[index].element.cols[colid].element;
	}
	else
	{
		return null;
	}
}

SortTable.prototype.getCell = function(index, colid)
{
	if(this.element.datarows[index])
	{
		return this.element.datarows[index].element.cols[colid];
	}
	else
	{
		return null;
	}
}

SortTable.prototype.setCellClass = function(cell, css)
{
	cell.element.className = css;
}

SortTable.prototype.getCellModify = function(index, colid)
{
	return this.element.datarows[index].element.cols[colid].element.modify;
}

SortTable.prototype.setCellModify = function(index, colid,flag)
{
	var cell = this.element.datarows[index].element.cols[colid];
	cell.element.modify = flag;
	if(flag == true)
	{
		cell.element.parentNode.modify = flag;
		if(this.getCellIsEdit(cell) == "1")
		{
			cell.element.style.backgroundColor = "#d0f946";
		}
	}
}
SortTable.prototype.setCellModify1 = function(index, colid,flag)
{
	var cell = this.element.datarows[index].element.cols[colid];
	if(flag == true)
	{
		if(this.getCellIsEdit(cell) == "1")
		{
			cell.element.style.backgroundColor = "#d0f946";
		}
	}
}
SortTable.prototype.setCellUnModify = function(index, colid,flag)
{
	var cell = this.element.datarows[index].element.cols[colid];
	cell.element.modify = flag;
}
SortTable.prototype.setAtomValue = function(atom, value)
{
	if (atom.type == "span")
	{
		atom.setValue(value);
	}
	else
	{
		atom.element.value = value;
	}
}

SortTable.prototype.getAtomValue = function(atom)
{
	if (atom.type == "span")
	{
		return atom.element.innerText;
	}
	else
	{
		return atom.element.value;
	}
}

SortTable.prototype.setAtomCalss = function(atom, css)
{
	atom.element.className = css;
}

SortTable.prototype.setBodyHeight = function(h)
{
	this.bodyPack.style.height = h;
	this.bodyPack.clip = 'rect(0 auto ' + h + ' 0)';
}

SortTable.prototype.setPageWidth = function()
{
	var percent = "100%";
	this.element.style.width = percent;
	this.headPack.firstChild.style.width = percent;
	this.bodyPack.firstChild.style.width = percent;
}

SortTable.prototype.setBodyWidth = function(width, percent, num)
{
	if (arguments.length != 3)
	{
		return;
	}
	if (isIE)
	{
		if (num != 0)
		{
			this.element.style.width = "100%";
			this.headPack.firstChild.style.width = percent;
			this.bodyPack.firstChild.style.width = percent;
		}
		else
		{
			this.headPack.firstChild.style.width = "100%";
			this.bodyPack.firstChild.style.width = "100%";
			this.element.style.width = "100%";
		}
	}
	else
	{
		this.element.style.width = "100%";
	}
}
SortTable.prototype.setWidth = function(width)
{
	this.element.style.width = width;
}

/**
 * set row selected handler sample: define a row select hanlder function
 * rowSelectedHandler(rows){ } register handler
 * sorttable.setOnRowSelectHandler(rowSelectedHandler);
 * 
 */
SortTable.prototype.setOnRowSelectHandler = function(func)
{
	if (typeof func != "function")
	{
		alert("argument of setOnRowSelectHandler must be function type");
		return;
	}
	this.onRowSelect = func;

}

/**
 * get the count of selected rows of the table.
 */
SortTable.prototype.getSelectedRowCount = function()
{
	var rowSelectedCount = 0;
	for ( var i = 0, rowLength = this.getDataRowLength(); i < rowLength; i++)
	{
		if (this.getRowSelFlag(i))
		{
			rowSelectedCount++;
		}
	}
	return rowSelectedCount;
}

/**
 * get the selected rows of the table
 */
SortTable.prototype.getSelectedRows = function()
{
	var rowindex = [];
	for ( var i = 0, rowLength = this.getDataRowLength(); i < rowLength; i++)
	{
		if (this.getRowSelFlag(i))
		{
			rowindex.push(i);
		}
	}
	return rowindex;
}
SortTable.prototype.getTextContent = function(isSelect,isHead)
{
	var txtContent = "";
	var rowLength = 0;
	var SelectRows = null;
	var indexStr = "i";
	if (typeof (isSelect) != "undefined" && isSelect)
	{
		SelectRows = this.getSelectedRows();
		rowLength = SelectRows.length;
		indexStr = "SelectRows[i]";
	}
	else
	{
		rowLength = this.getDataRowLength();
	}

	var colsArr = this.getTable().colsArray;

	if(typeof(isHead) != "undefined" && isHead)
	{
		for ( var i = 0; i < colsArr.length; i++)
		{
			if ("none" != this.getHeadCell(colsArr[i]).element.style.display)
			{
				maxLength = this.getColMaxWordLength(colsArr[i]);
				colLength = getLength(this.getHeadCell(colsArr[i]).element.lastChild.title);
				txtContent += this.getHeadCell(colsArr[i]).element.lastChild.title;
	
				if (i < colsArr.length - 1)
				{
					txtContent += getSpace(maxLength - colLength) + getSpace(2)
							+ String.fromCharCode(9);
				}
			}
		}
		
		txtContent += String.fromCharCode(13, 10);
	}
	
	for ( var i = 0; i < rowLength; i++)
	{
		index = eval(indexStr);
		for ( var j = 0, arrayLen = colsArr.length; j < arrayLen; j++)
		{
			if ("none" != this.getHeadCell(colsArr[j]).element.style.display)
			{
				maxLength = this.getColMaxWordLength(colsArr[j]);		
				
				/**
				 *   copy  copy  
				 */
				if((this.getCellShow(index, colsArr[j]).type == "spanpwd"  || this.getCellShow(index, colsArr[j]).type == "password") && 
						"" != this.getCellShow(index, colsArr[j]).getValue())		
				{
					colLength = getLength("******");	
					txtContent += "******";
				}
				else
				{
					colLength = getLength(this.getCellShow(index, colsArr[j])
							.getValue());	
					txtContent += this.getCellShow(index, colsArr[j]).getValue();
				}
				if (j < colsArr.length - 1)
				{
					txtContent += getSpace(maxLength - colLength) + getSpace(2)
							+ String.fromCharCode(9);
				}
			}
		}
		txtContent += String.fromCharCode(13, 10);
	}
	return txtContent;
}

SortTable.prototype.appendTableEdit = function(tableConf)
{
	if (this.editdom == null)
	{
		this.editdom = new Array();
		for ( var i = 0; i < tableConf.getColsLength(); i++)
		{
			this.appendCellEdit(tableConf,i);
		}
	}
}
SortTable.prototype.refreshCellEditOptions = function(rowindex,colid,datas)
{
	var celledit = this.getCellEdit(rowindex,colid);
	celledit.clearOptions();
	var convert = celledit.element.getAttribute("convert");
	for(var i = 0,len = datas.length;i < len;i++)
	{
		var listValue = datas[i];
		var listName = listValue;
		if(convert)
		{
			listName = this.convertValue(eval(convert),listValue);
		}
		celledit.addOption(listName, listValue);
	}
}

SortTable.prototype.getCellEditRangeObj = function(rowindex,colid)
{
	var celledit = this.getCellEdit(rowindex,colid);
	var rangeObj = null;
	if(!celledit)
	{
		return null;
	}
	var range = celledit.element.getAttribute("attrRange");
	if(range && range != "")
	{
		var rangeobjlist = JSON.parse(range);
		var keyColId = (this.getKeyColID()?this.getKeyColID():"slotid");

		var slotid = this.getCellStoreValue(rowindex,keyColId,"slotid");
		var port = this.getCellStoreValue(rowindex,keyColId,"port");
		var path = this.getCellStoreValue(rowindex,keyColId,"path");
		for(var i = 0,len = rangeobjlist.length;i < len;i++)
		{
			if(rangeobjlist[i] && rangeobjlist[i].slotid == slotid)
			{
				if(typeof(rangeobjlist[i].port) == "undefined"
					|| port == null || typeof(port) == "undefined"
					|| rangeobjlist[i].port.contains(port))
				{
					if(typeof(rangeobjlist[i].path) == "undefined"
						|| path == null || typeof(path) == "undefined"
						|| rangeobjlist[i].path.contains(path))
					{
						rangeObj = rangeobjlist[i];
						break;
					}
				}
			}
		}
	}
	return rangeObj;
}

SortTable.prototype.appendCellEdit = function(tableConf,colIndex)
{
	var colKeyArray = tableConf.getColKeyArray(colIndex);
	if (tableConf.hasEditElement(colIndex)) 
	{
		var convert = colKeyArray[0].getConvert();
		var atom = this.createAtom(tableConf.getColEditType(colIndex));
		if(atom.type == "combobox")
		{
			if(tableConf.getColEditDispVal(colIndex) == "0")
			{
				atom.element.parent.dispval = false;
			}
		}
		var options = tableConf.getColEditOptions(colIndex);
		var editobj = tableConf.getColEdit(colIndex);
		if (options.length > 0)
		{
			for (var k = 0; k < options.length; k++) 
			{
				var optionName = options[k].getName();
				var optionValue = options[k].getValue();
				if (!optionName) 
				{
					optionName = this.convertValue(eval(convert), options[k].getValue());
				}
				options[k].text = optionName;
				atom.addOption(optionName, optionValue);
			}
		}
		atom.element.onclick = stopEventPropagation;
		atom.element.onmousedown = atomOnMouseDownHandle;
		atom.element.ondblclick = stopEventPropagation;
		atom.element.onblur = cellonblur;
		var range = '';
		if (editobj.verify) 
		{
			var verifyobj = editobj.verify;
			if (verifyobj.type == "num") 
			{
				var textElm = atom.element;
				if(atom.type == "combobox")
				{
					textElm = atom.element.parent.getTextElement();
				}
				range = '{"min":"' + verifyobj.min + '","max":"' + verifyobj.max + '"';
				if(verifyobj.step != null)
				{
					range += ',"step":"' + verifyobj.step + '"';
					if(verifyobj.other != null)
					{
						range += ',"other":"' + verifyobj.other + '"';
					}
					textCheckWithStepLen(atom.element, verifyobj.min, verifyobj.max,verifyobj.step,verifyobj.other);
				}
				else
				{
					if(verifyobj.decimal != null)
					{
						range += ',"decimal":"' + verifyobj.decimal + '"';
					}
					if(verifyobj.other != null)
					{
						range += ',"other":"' + verifyobj.other + '"';
					}
					textCheck(textElm, verifyobj.min, verifyobj.max,verifyobj.decimal,verifyobj.other);
				}
				range += '}';
				
				
			}
			else if (verifyobj.type == "string") 
			{
				atom.element.maxLength = verifyobj.length;
			}
			else if(verifyobj.type == "func")
			{
				var tmpelement = atom.element;
				var maxLength = verifyobj.length;
				var isblock = verifyobj.isblock;
				atom.element.title = maxLength;
				atom.element.onkeyup =  function()
				{
					calStrSinoLenCheck(this,maxLength);
				}
				atom.element.onkeypress=function(evt)
				{
					evt = evt?evt:window.event;
					var code = (evt.keyCode != 0 ? evt.keyCode : evt.charCode);
					var obj = evt.srcElement?evt.srcElement:evt.target;
					
					var ch = String.fromCharCode(code);
					
					if (code == 13)
					{
						obj.blur();
						return false;
					}
					if(typeof(isblock) != "undefined" && isblock == true)
					{
						return blockChars(evt,"~!#$%+^*|[]{}<>\"\\=,:;?'");
					}
					else
					{
						return true;
					}
				}
				if(typeof(isblock) != "undefined" && isblock == true)
				{
					atom.element.onpaste = forbidExtra;
				}
			}
		}
		if(editobj.attrRange && editobj.attrRange != "")
		{
			atom.element.setAttribute("attrRange",editobj.attrRange);
			atom.element.setAttribute("range",range);
			atom.element.setAttribute("convert",convert);
		}
		this.editdom[tableConf.getColId(colIndex)] = atom;
	}
}

/**
 *    
 * @param obj:     key:key 
 * @return String      
 */
SortTable.prototype.convertValue = function(obj, key, attrID)
{
    if ("function" == (typeof obj)) 
    {
        return obj(key, attrID);
    }
    else //       
     {
        if (null == obj) 
        {
            return key;
        }
        var resValue = obj[key];
        if (null == resValue) 
        {
            resValue = INVALIDATE_STR;
        }
        return resValue;
    }
}

SortTable.prototype.getAllRows = function()
{
	return this.element.datarows;
}

SortTable.prototype.selectAllRows = function()
{
	for ( var i = 0, rowLength = this.getDataRowLength(); i < rowLength; i++)
	{
		this.setRowSelect(i);
	}
}

function SortTable()
{
	this.element = this.createComponent();
	this.element.cellSpacing = 0;
	this.element.cellpadding = 0;
	this.element.isResizeAdjust = true; //             

	this.head = this.createComponent();
	this.head.className = "stheadcontent";
	this.head.cellSpacing = 0;
	this.head.cellpadding = 0;
	this.head.style.border = 0;

	this.body = this.createComponent();
	this.body.className = "stbodycontent";

	this.body.cellSpacing = 0;
	this.headPack = document.createElement("div");
	this.headPack.isExistVScrollBar = false;
	this.headPack.isLayout = false;

	this.headPack.cellSpacing = 0;
	this.headPack.cellpadding = 0;
	this.headPack.style.border = 0;

	this.bodyPack = document.createElement("div");
	this.element.className = "scrolltable";
	this.element.parent = this;

	this.headPack.appendChild(this.head);
	this.headPack.className = "sthead";
	this.bodyPack.appendChild(this.body);
	this.bodyPack.className = "stbody";

	this.bodyPack.parent = this;
	this.bodyPack.onscroll = doOnScroll;
	this.bodyPack.onresize = bodyOnResizeTableHandle;

	this.bodyPack.lastScrollTop = 0;
	this.bodyPack.lastScrollLeft = 0;

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.appendChild(this.headPack);
	tr.style.padding = 0;
	tr.appendChild(td);
	this.extratd = document.createElement("td");
	this.element.firstChild.appendChild(tr);
	this.element.onclick = tableclick;

	tr = document.createElement("tr");
	tr.style.padding = 0;
	td = document.createElement("td");
	td.setAttribute("colSpan", "2");
	tr.appendChild(td);
	td.appendChild(this.bodyPack);
	this.element.childNodes[1].appendChild(tr);

	this.element.datarows = new Array();
	this.element.cellsWidth = new Array();
	this.element.isDragHeadEvent = false;
	this.element.isAppendEmptyTr = false;
	this.isListenerRegister = false;
	this.isUsedForSelectList = false;
	this.element.colsArray = new Array();
	this.element.colsArray.selectedId = null;
	this.element.colsArray.imgflag = null;
	this.element.headRow = null;

	this.editdom = null;

	this.onRowSelect = null;
	this.onCellEdit = null;
	this.onRowSort = null;
	this.cellEditRangeFunc = null;

	this.singleChoiceFlg = false;
	this.mustChoiceFlg = false;
	this.keyColId = null;

}

/**
 *    Resize               
 * @param {Object} evt
 */
function bodyOnResizeTableHandle(evt)
{
	evt = evt?evt:window.event;
	var elem = evt.target?evt.target:evt.srcElement;
	var scrollWidth = parseInt(elem.offsetWidth)
			- parseInt(elem.clientWidth);
	if (scrollWidth > 0 
		&& (elem.parent && (elem.parent.headPack.clientWidth > elem.clientWidth)))
	{
		elem.parent.headPack.style.width = elem.clientWidth + "px";
		elem.parent.headPack.firstChild.style.width = elem.clientWidth + "px";
	}
}


function doOnScroll()
{
	this.parent.headPack.scrollLeft = this.scrollLeft;

	this.lastScrollTop = this.scrollTop;
	this.lastScrollLeft = this.scrollLeft;
}

function Row()
{
	this.element = document.createElement("tr");
	this.element.cols = new Object();
	this.element.modify = false;
	this.element.className = "weightrow";
	this.element.parent = null;
	this.element.selectFlag = false;
}

Row.prototype._clearLeaks = function()
{
	if(!this.element)
	{
		return;
	}
	this.element.cols = null;
	this.element.className = null;
	this.element.parent = null;
	this.element.selectFlag = null;
	this.element.onmouseover = null;
	this.element.onmouseout = null;
	this.element.onmousedown = null;
	this.element.onclick = null;
	this.element.onmouseup = null;
	if(this.element.parentNode)
	{
		this.element.parentNode.removeChild(this.element);
	}
	this.element = null;
}


function Cell(width)
{
	this.colid = null;
	this.element = document.createElement("td");

	var e = this.element;
	e.setAttribute("width", width);
	e.modify = false;
	e.parent = null;
	e.isEdit = null;
	e.showElement = null;
	e.editElement = null;
	e.storeValue = new Object();
	e.currentValue = new Object();
	e.hiddenValue = new Object();
}
Cell.prototype._clearLeaks = function()
{
	if(!this.element)
	{
		return;
	}
	if(this.element.showElement != null)
	{
		this.element.showElement._clearLeaks();
		this.element.showElement = null;
	}
	if(this.element.editElement != null)
	{
		this.element.editElement = null;
	}
	this.element.storeValue = null;
	this.element.currentValue = null;
	this.element.hiddenValue = null;
	this.element.modify = null;
	this.element.onselectstart = null;
	/*var clearElementProps = ['data','onmouseover','onmouseout','onmousedown','onmouseup','ondblclick','onclick','onselectstart','oncontextmenu'];
	for(var c = clearElementProps.length;c--;)
	{
		this.element[clearElementProps[c]] = null;
	}*/
	this.element.parent = null;
	if(this.element.parentNode)
	{
		this.element.parentNode.removeChild(this.element);
	}
	this.element = null;
}
Atom.prototype.setValue = function(v)
{
	if (this.type == "span")
	{
		v = '' + v;
		if (v == "")
		{
			if (!isIE)
			{
				this.element.innerHTML = "&nbsp;";
			}
			else
			{
				this.element.innerHTML = "";
			}
		}
		else
		{
			this.element.innerText = v; // convertSpecStr(v);
		}
		this.element.style.cursor = "default";
		if (!isIE)
		{
			this.element.setAttribute("title", v);
		}

	}
	else if(this.type == "spanpwd")
	{
		v = '' + v;
		if (v == "")
		{
			if (!isIE)
			{
				this.element.innerHTML = "&nbsp;";
			}
			else
			{
				this.element.innerHTML = "";
			}
		}
		else
		{
			var pwdshow = "";
			for(var i = 0,len = v.length;i < len;i++)
			{
				pwdshow += "*";
			}
			this.element.innerText = pwdshow;
		}
		this.element.setAttribute("value",v);
	}
	else if(this.type == "combobox"||this.type == "combo-button" || this.type == "text-button")
	{
		this.element.parent.setValue(v);
	}
	else if(this.type == "select")
	{
		for(var i = 0, len = this.element.options.length; i < len; i++)
		{
		    if(this.element.options[i].value == v)
		    {
		        this.element.selectedIndex = i;
		    }
		}
	}
	else
	{
		this.element.value = v;
	}
}

Atom.prototype.getValue = function()
{
	if (this.type == "span")
	{
		return this.element.innerText;
	}
	else if(this.type == "spanpwd")
	{
		return this.element.getAttribute("value");
	}
	else if(this.type == "combobox" || this.type == "combo-button" || this.type == "text-button")
	{
		return this.element.parent.getValue();
	}
	else
	{
		return this.element.value;
	}
}

Atom.prototype.addOption = function(lable, value)
{
	if (this.type == "select")
	{
		this.element.options[this.element.options.length] = new Option(lable,
				value);
	}
	else if (this.type == "combobox" || this.type == "combo-button")
	{
		this.element.parent.addOption(lable,value);
	}
}
/*
 *   Value  select   Option 
 */
Atom.prototype.removeOption = function(value)
{
	if (this.type == "select")
	{
		for ( var i = 0, m = this.element.options.length; i < m; i++)
		{
			var option = this.element.options[i];
			if (option.value == value)
			{
				this.element.options.remove(i);
				break;
			}
		}
	}
	else if (this.type == "combo-button")
	{
		this.element.parent.removeOption(value);
	}
	else if(this.type == "combobox")
	{
		for ( var i = 0, m = this.element.parent.getLength(); i < m; i++)
		{
			var option = this.element.parent.getOption(i);
			if(option.value == value)
			{
				this.element.parent.remove(i);
				break;
			}
		}
	}
}
/*
*   select     Option 
*/
Atom.prototype.removeAllOptions = function()
{
	if(this.type ==	"select")
	{
		for(var i = this.element.options.length;i >= 0;i--)
		{
			var option = this.element.options[i];
			this.element.options.remove(i);
		}
	}
	else if(this.type == "combobox" || this.type == "combo-button")
	{
		this.element.parent.removeAll();
	}
}

/*
 *   index  select   Option 
 */
Atom.prototype.removeAtOption = function(index)
{
	if (this.type == "select")
	{
		this.element.options.remove(this.element.options[index]);
	}
	else if(this.type == "combobox" || this.type == "combo-button")
	{
		this.element.parent.remove(index);
	}
}

Atom.prototype.addOptionObj = function(option)
{
	if (this.type == "select")
	{
		var tmpOption = new Option(option.text, option.value);

		this.element.options[this.element.options.length] = tmpOption;
	}
	else if(this.type == "combobox" || this.type == "combo-button")
	{
		this.element.parent.addOption(options.text,options.value);
	}
}

Atom.prototype.clearOptions = function()
{
	if (this.type == "select")
	{
		this.element.options.length = 0;
	}
	else if(this.type == "combobox" || this.type == "combo-button")
	{
		this.element.parent.removeAll();
	}
}

Atom.prototype.getOptionsLength = function()
{
	if (this.type == "select")
	{
		return this.element.options.length;
	}
	else if(this.type == "combobox" || this.type == "combo-button")
	{
		return this.element.parent.getLength();
	}
}

Atom.prototype.setDisabled = function(flag)
{
	if (this.type == "text-button" || this.type == "combo-button")
	{
		this.element.parent.setDisabled (flag);
	}
	else 
	{
		this.element.disabled = flag;
	}
}

function Atom(type)
{
	this.element = null;
	if (Atom.eleType[type] != "undefined")
	{
		switch (Atom.eleType[type])
		{
			case 0:
			case 1:
				this.element = document.createElement(type);
				break;
			case 2:
			case 3:
			case 4:
			case 5:
			case 6:
			case 7:	
				this.element = document.createElement("input");
				this.element.setAttribute("type", type);
				break;
			case 8:
				this.element = new ComboBox();
				this.element.parent.dispval = true;
				break;
			case 9:
				this.element = document.createElement("textarea");
				break;
			case 10:
				this.element = document.createElement("input");
				this.element.setAttribute("type", type);
				this.element.style.width = "100%";
				break;
			case 11:
				this.element = document.createElement("span");
				break;
			case 12:
				this.element = new TextButton();
				break;
			case 13:
				this.element = new ComboButton();
				break;
			default:
				this.element = null;
				break;
		}

		if (this.element)
		{
			this.type = type;
			if (this.type == "text" || this.type == "select"
					|| this.type == "password")
			{
				this.element.className = "textInput";
			}
		}
		else
		{
			alert("wrong");
		}
	}
	else
	{
		alert("wrong type :::" + type);
		this.element = null;
	}
}
Atom.prototype._clearLeaks = function()
{
	this.type = null;
	try
	{
		/*var clearElementProps = ['data','onmouseover','onmouseout','onmousedown','onmouseup','ondblclick','onclick','onselectstart','oncontextmenu','onkeydown','onkeypress','onkeyup','onblur'];
		for(var c = clearElementProps.length;c--;)
		{
			this.element[clearElementProps[c]] = null;
		}
		while(this.element.childNodes.length > 0)
		{
			this.element.removeChild(this.element.childNodes[0]);
		}*/
		if(this.element.parentNode != null)
		{
			this.element.parentNode.removeChild(this.element);
		}
	}
	catch(e)
	{
	}
	this.element = null;
}

Atom.eleType = [];
Atom.eleType["select"] = 0;
Atom.eleType["span"] = 1;
Atom.eleType["text"] = 2;
Atom.eleType["password"] = 3;
Atom.eleType["checkbox"] = 4;
Atom.eleType["radio"] = 5;
Atom.eleType["button"] = 6;
Atom.eleType["hidden"] = 7;
Atom.eleType["combobox"] = 8;
Atom.eleType["textarea"] = 9;
Atom.eleType["file"] = 10;
Atom.eleType["spanpwd"] = 11;
Atom.eleType["text-button"] = 12;
Atom.eleType["combo-button"] = 13;

function HeadCell(colid, name, width)
{
	this.element = document.createElement("td");
	var spanElement = document.createElement("span");
	spanElement.appendChild(document.createTextNode(name));

	spanElement.setAttribute("title", name);
	spanElement.style.overflow = "hidden";
	this.element.parent = null;
	this.element.colid = colid;
	this.element.appendChild(spanElement);
	this.element.setAttribute("width", width);
	this.element.isSort = null;
	this.element.isSortShow = null;
	this.element.sortCols = null;
	this.element.compare = null;
	this.element.keys = new Array();
	this.element.convertObj = new Object();
	this.element.maxWidth = null;
	this.element.convertToNEValueObj = new Object();
	this.element.maxLength = getLength(name);

}

HeadCell.prototype._clearLeaks = function()
{
	this.element.isSort = null;
	this.element.isSortShow = null;
	this.element.sortCols = null;
	this.element.compare = null;
	this.element.convertObj = null;
	this.element.convertToNEValueObj = null;
	this.element.keys = null;
	this.element.parent = null;
	this.element.colid = null;
	this.element.onclick = null;
	/*while(this.element.childNodes.length > 0)
	{
		this.element.removeChild(this.element.childNodes[0]);
	}*/
	if(this.element.parentNode != null)
	{
		this.element.parentNode.removeChild(this.element);
	}
	this.element = null;
}

HeadCell.prototype.setValue = function(value)
{
	this.element.lastChild.setAttribute("title", value);
	this.element.lastChild.innerHTML = value;
}

HeadCell.prototype.setValue = function(value)
{
	this.element.lastChild.setAttribute("title", value);
	this.element.lastChild.innerHTML = value;
}

function convertMsg(resobj, cvtobj, cvtvalue)
{
	if ("function" == typeof cvtobj)
	{
		return cvtobj(cvtvalue);
	}
	if (cvtvalue == "-")
	{
		return cvtvalue;
	}
	if (null == cvtobj[cvtvalue])
	{
		return cvtvalue;
	}
	else
	{
		if (null == resobj[cvtobj[cvtvalue]])
		{
			return cvtobj[cvtvalue];
		}
		else
		{
			return resobj[cvtobj[cvtvalue]];
		}
	}
}

/*
 *      
 */
function compareFloat(str1, str2)
{
	var value1 = parseFloat(str1);
	var value2 = parseFloat(str2);
	return compare(value1, value2);

}
/*
 *     
 */
function compareDate(str1, str2)
{
	var value1 = new Date(Date.parse(str1));
	var value2 = new Date(Date.parse(str1));
	return compare(value1, value2);

}

/*
 *       ?
 */
function compareNum(str1, str2)
{
	var value1 = 0;
	var value2 = 0;
	if (str1.indexOf(".") != -1 || str2.indexOf(".") != -1)
	{
		value1 = parseFloat(str1);
		value2 = parseFloat(str2);
	}
	else
	{

		value1 = parseInt(str1);
		value2 = parseInt(str2);
	}
	return compare(value1, value2);

}

/*
 *             PORT +   
 */
function comparePortNum(str1, str2)
{

	if (("PORT" == str1.substring(0, 4)) && ("VCTRUNK" == str2.substring(0, 7)))
	{
		return -1;
	}
	else if (("PORT" == str2.substring(0, 4))
			&& ("VCTRUNK" == str1.substring(0, 7)))
	{
		return 1;
	}
	else if (("PORT" == str1.substring(0, 4))
			&& ("PORT" == str2.substring(0, 4)))
	{
		var value1 = parseInt(str1.substring(4, str1.length));
		var value2 = parseInt(str2.substring(4, str2.length));
		return compare(value1, value2);
	}
	else if (("VCTRUNK" == str1.substring(0, 7))
			&& ("VCTRUNK" == str2.substring(0, 7)))
	{
		var value1 = parseInt(str1.substring(7, str1.length));
		var value2 = parseInt(str2.substring(7, str2.length));
		return compare(value1, value2);
	}	
	else if(str1 != null && str1.split("-").length >= 3)
	{	
		return comparePortNumWithSlot(str1, str2);
	}
	else if(!isNaN(str1) && !isNaN(str2))
	{
		var value1 = parseInt(str1);
		var value2 = parseInt(str2);
		return compare(value1, value2);
	}
	else
	{
		var value1 = str1;
		var value2 = str2;
		return compare(value1, value2);
	}

}

function compareSlot(str1,str2)
{
	var str1Array = str1.split("-");
	var str2Array = str2.split("-");
	var compareStr1 = isNaN(str1Array[0])?str1Array[0]:parseInt(str1Array[0]);
	var compareStr2 = isNaN(str2Array[0])?str2Array[0]:parseInt(str2Array[0]);
	if(str1Array.length == 1 && str2Array.length == 1)
	{
		return compare(compareStr1, compareStr2);
	}
	else
	{
		if(compareStr1 != compareStr2)
		{
			if(isNaN(compareStr1) || isNaN(compareStr2))
			{
				compareStr1 = compareStr1 + "";
				compareStr2 = compareStr2 + "";
			}
			return compare(compareStr1,compareStr2);
		}
		var value1 = str1Array[str1Array.length - 1];
		var value2 = str2Array[str2Array.length - 1];
		value1 = isNaN(value1)?value1:parseInt(value1);
		value2 = isNaN(value2)?value2:parseInt(value2);
		return compare(value1,value2);
	}
}

/**
 * @param {Object} str1
 * @param {Object} str2
 */
function compareSlotPortNum(str1,str2)
{
	var str1Array = str1.split("-");
	var str2Array = str2.split("-");
	
	var slot = compareNum(str1Array[0],str2Array[0]);
	var port = compareNum(str1Array[1],str2Array[1]);
	
	if(slot > 0)
	{
		return 1;
	}
	else if(slot == 0)
	{
		return port;
	}
	else
	{
		return -1;
	}
}

/*
 *              -   -   -   -        -   -    
 */
function comparePortNumWithSlot(str1, str2)
{
	
	var str1Array = str1.split("-");
	var str2Array = str2.split("-");

	var value1;
	var value2;

	if(str1Array.length == 3 && -1 != str1Array[2].indexOf("LP") && -1 == str1Array.indexOf("("))
	{
		var tempV1 = str1Array[0];
		var tempV2 = str2Array[0];
		if (isNaN(tempV1) || isNaN(tempV2))
		{
			return -1;
		}
		value1 = parseInt(tempV1);
		value2 = parseInt(tempV2);
		
		if (value1 != value2)
		{
			return compare(value1, value2);
		}
		tempV1 = str1Array[2].substring(2, str1Array[2].length);
		tempV2 = str2Array[2].substring(2, str2Array[2].length);
		if (isNaN(tempV1) || isNaN(tempV2))
		{
			return -1;
		}
		value1 = parseInt(tempV1);
		value2 = parseInt(tempV2);
		
		if (value1 != value2)
		{
			return compare(value1, value2);
		}
	}
	if (-1 != str1Array[0].indexOf("MP"))
	{
		if (-1 == str2Array[0].indexOf("MP"))
		{
			return 1;
		}
		else
		{
			value1 = parseInt(str1Array[0].substring(0,str1Array[0].indexOf("(")));
			value2 = parseInt(str2Array[0].substring(0,str2Array[0].indexOf("(")));
			return compare(value1, value2);
		}
	}
	else
	{
		if (-1 != str2Array[0].indexOf("MP"))
		{
			return -1;
		}
	}

	if (-1 != str1Array[0].indexOf("VEther"))
	{
		if (-1 == str2Array[0].indexOf("VEther"))
		{
			return 1;
		}
		else
		{
			value1 = parseInt(str1Array[0].substring(0,str1Array[0].indexOf("(")));
			value2 = parseInt(str2Array[0].substring(0,str2Array[0].indexOf("(")));
			return compare(value1, value2);
		}
	}
	else
	{
		if (-1 != str2Array[0].indexOf("VEther"))
		{
			return -1;
		}
	}
	value1 = parseInt(str1Array[0]);
	value2 = parseInt(str2Array[0]);

	if (value1 != value2)
	{
		return compare(value1, value2);
	}
	
	var str1NoPortNameArray = null;
	if(str1.indexOf("(") > 0)
	{
		str1NoPortNameArray  = str1.substring(0, str1.indexOf("(")).split("-");
	}
	

	if ((str1NoPortNameArray == null && NUMBER_WITH_SUBBOARD >= str1Array.length) ||
		(str1NoPortNameArray != null && str1NoPortNameArray.length == 3))
	{
		
	      if (str1Array.length > 3 && !isNaN(str1Array[3]))
	      {
	      	value1 = parseInt(str1Array[3]);
	      }
	      else
	      {
		    value1 = parseInt(str1Array[2].substring(0, str1Array[2].indexOf("(")));
	      }
	      if (str2Array.length > 3 && !isNaN(str1Array[3]))
	      {
	      	value2 = parseInt(str2Array[3]);
	      }
	      else
	      {
		      value2 = parseInt(str2Array[2].substring(0, str2Array[2].indexOf("(")));
	      }

		return compare(value1, value2);
	}
	else
	{
		value1 = parseInt(str1Array[2]);
		value2 = parseInt(str2Array[2]);

		if (value1 != value2)
		{
			return compare(value1, value2);
		}

		value1 = parseInt(str1Array[4].substring(0, str1Array[4].indexOf("(")));
		value2 = parseInt(str2Array[4].substring(0, str2Array[4].indexOf("(")));

		return compare(value1, value2);
	}
}

/*
 * IP    
 */
function compareIPAddress(str1, str2)
{
	var str1Array = str1.split(".");
	var str2Array = str2.split(".");
	var value1;
	var value2;

	for ( var i = 0, len = str1Array.length; i < len; i++)
	{
		value1 = parseInt(str1Array[i]);
		value2 = parseInt(str2Array[i]);

		if (value1 != value2)
		{
			return compare(value1, value2);
		}
	}
	return 0;
}

/*
 *      +       
 */

function CompareStrNum(str1, str2)
{

	var stringOfStr1, stringOfStr2, numOfStr1, numOfStr2;
	stringOfStr1 = getStr(str1);
	stringOfStr2 = getStr(str2);
	numOfStr1 = getNum(str1);
	numOfStr2 = getNum(str2);

	if (stringOfStr1 == stringOfStr2)
	{
		return compareNum(numOfStr1, numOfStr2);
	}
	else
	{
		return compare(stringOfStr1, stringOfStr2);
	}
}

/*
 *        -  -    -    -          
 *                          
 */
function flexibleCompare(str1, str2)
{
    if(typeof(str1) == 'object')
    {
        str1 = str1.toString();
        str2 = str2.toString();
    }
    
    var arr1 = str1.split('-');
    var arr2 = str2.split('-');
    var a,b,result;
    var vcreg = /\:\d+$/;
    for(var i = 0, len = arr1.length; i < len; i++)
    {
		if (i == (len - 1) && vcreg.test(arr1[i])
			&& vcreg.test(arr2[i])) 
		{
			var vctmp = arr1[i].split(":");
   			a = parseInt(vctmp[vctmp.length - 1]);  
			vctmp = arr2[i].split(":");
			b = parseInt(vctmp[vctmp.length - 1]);  
		}
		else 
		{
			if (isNaN(parseInt(arr1[i]))) 
			{
				a = arr1[i];
				b = arr2[i];
			}
			else 
			{
				a = parseInt(arr1[i]);
				b = parseInt(arr2[i]);
			}
		}

        result = compare(a, b);
        
        if( result == 0)
        {
            continue;
        } else {
            return result;
        }
    }
    
    return 0;
}

function getStr(str)
{
	var Numbers = "0123456789";
	if ((str) && (str != ""))
	{
		for ( var i = str.length - 1; i >= 0; i--)
		{
			if (Numbers.indexOf(str.substr(i, 1)) < 0)
			{
				return str.substring(0, i + 1);
			}
			if (i == 0)
				return "";
		}
	}
	else
	{
		return "";
	}
}

function getNum(str)
{
	var Numbers = "0123456789";
	if ((str) && (str != ""))
	{
		for ( var i = str.length - 1; i >= 0; i--)
		{
			if (Numbers.indexOf(str.substr(i, 1)) < 0)
			{
				return str.substring(i + 1, str.length);
			}
			if (i == 0)
				return str;
		}
	}
	else
	{
		return "";
	}
}

/*
 *                str1 str2           
 */
function compare(str1, str2)
{
	if (str1 > str2)
	{
		return 1;
	}
	if (str1 < str2)
	{
		return -1
	}
	return 0;
}

/********************************************************************
* attribute  value ??????
* -------------------------------------------------------------
* |                             |                             |
* |        ??????                 |           ??????              |
* |-----------------------------|-----------------------------|
* |                             |                             |
* |-----------------------------|-----------------------------|
* |                             |                             |
* |-----------------------------|-----------------------------|
* |                             |                             |
*--------------------------------------------------------------
**********************************************************************/
function CTable()
{

	this.element = document.createElement("table");
	this.element.appendChild(document.createElement("thead"));
	this.element.appendChild(document.createElement("tbody"));
	this.element.firstChild.appendChild(document.createElement("tr"));
	
	this.attrIDArray = new Array();
	this.attrName = new Object();
	this.attrArray = new Object();
	this.element.className = "attrTable";
	this.addHead = function(head1, head2)
	{
		var th = document.createElement("td");
		span = document.createElement("span")
		span.appendChild(document.createTextNode(head1));
		th.appendChild(span);
		this.element.firstChild.firstChild.appendChild(th);
		th = document.createElement("td");
		span = document.createElement("span")
		span.appendChild(document.createTextNode(head2));
		th.appendChild(span);
		this.element.firstChild.firstChild.appendChild(th);
	}

	this.addAttrRow = function(attrid, attrname, atom, text)
	{
		if (atom.element.type == "hidden")
		{

			tr = document.createElement("tr");
			td = document.createElement("td");
			td.setAttribute("style", "border:0");
			span = document.createElement("span");
			span.appendChild(document.createTextNode(attrname));
			td.appendChild(span);
			tr.appendChild(td);
			td = document.createElement("td");
			td.setAttribute("style", "border:0");
			td.appendChild(atom.element);
			if (text != null)
			{
				td.appendChild(document.createTextNode(text))
				td.setAttribute("style", "border:0");
			}
			tr.appendChild(td);
			this.attrIDArray[this.attrIDArray.length] = attrid;
			this.attrArray[attrid] = atom;
			this.attrName[attrid] = attrname;
			return;
		}
		tr = document.createElement("tr");
		tr.setAttribute("id","ctable" + attrid);
		td = document.createElement("td");
		span = document.createElement("span");
		span.appendChild(document.createTextNode(attrname));
		td.appendChild(span);
		tr.appendChild(td);
		td = document.createElement("td");
		td.appendChild(atom.element);
		if (text != null)
		{
			span = document.createElement("span");
			span.appendChild(document.createTextNode(text));
			td.appendChild(span);
		}
		tr.appendChild(td);
		this.element.childNodes[1].appendChild(tr);
		this.attrIDArray[this.attrIDArray.length] = attrid;
		this.attrArray[attrid] = atom;
		this.attrName[attrid] = attrname;
	}
	
	this.getAttrRow = function(attrid)
	{
		var length = this.element.childNodes[1].childNodes.length;
		for(var i = 0;i < length;i++)
		{
			if(this.element.childNodes[1].childNodes[i].getAttribute("id") 
				&& this.element.childNodes[1].childNodes[i].getAttribute("id") == "ctable" + attrid)
			{
				return this.element.childNodes[1].childNodes[i];
			}
		}
	}

	this.insertAttrRow = function(attrid, attrname, atom, rowid)
	{
		var tr = document.createElement("tr");
		tr.setAttribute("id","ctable" + attrid);
		var td = document.createElement("td");
		var span = document.createElement("span");
		span.appendChild(document.createTextNode(attrname));
		td.appendChild(span);
		tr.appendChild(td);
		td = document.createElement("td");
		td.appendChild(atom.element);
		tr.appendChild(td);
		this.element.childNodes[1].insertBefore(tr,
				this.attrArray[rowid].element.parentNode.parentNode);
		this.attrIDArray[this.attrIDArray.length] = attrid;
		this.attrArray[attrid] = atom;
		this.attrName[attrid] = attrname;
	}

	this.getAttrName = function(attrid)
	{
		return this.attrName[attrid];
	}

	this.getAttrValue = function(attrid)
	{
		return this.attrArray[attrid].getValue();
	}

	this.setAttrValue = function(attrid, value)
	{
		if (this.attrArray[attrid])
		{
			this.attrArray[attrid].setValue(value);
		}
	}

	this.getAtom = function(attrid)
	{
		if (this.attrArray[attrid])
		{
			return this.attrArray[attrid];
		}

	}
	this.getTable = function()
	{
		return this.element;
	}
	
	this.changeColWidth = function(width1, width2)
	{
	    var tableHead = this.element.firstChild.firstChild
	    tableHead.childNodes[0].style.width = width1;
	    tableHead.childNodes[1].style.width = width2;
	    
	    var tableBody = this.element.childNodes[1];
	    for(var i = 0, len = tableBody.childNodes.length; i < len; i++)
	    {
	        tableBody.childNodes[i].childNodes[0].style.width = width1;
	        tableBody.childNodes[i].childNodes[1].style.width = width2;
	    }
	}
}

/*
 * Add table popupmenu handler
 */

function popupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));

	if (rows.contains(rowid))
	{
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}

function createTablePopupMenu(elem, evt)
{
	if (elem != null)
	{
		handleCellEdit(elem, TABLE_CONSTANT.BEFOREEDIT);
	}
	if (elem.editElement.type == "select")
	{
		
		removejsDOMmenu();
		var selectElem = elem.editElement;
		var cursorMenu1 = new jsDOMenu(150);
		var options = elem.editElement.element.options;
		var len = options.length;
		for ( var i = 0; i < len; i++)
		{
			cursorMenu1.addMenuItem(new menuItem(options[i].text, "",
					setOptionValue,
					[ options[i].text, options[i].value, elem ], true,
					"jsdomenuitem jsdomenuitemnowrap",
					"jsdomenuitemover jsdomenuitemnowrap"));
		}

		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
	else if (elem.editElement.type == "text")
	{
		hideMenu();
		elem.appendChild(elem.editElement.element);
		editor = elem.editElement.element;
		if (elem.showElement.getValue() == " " || elem.showElement.getValue() == "\xA0")
		{
			elem.editElement.setValue("");
		}
		else
		{
			elem.editElement.setValue(elem.showElement.getValue());
		}
		if (isIE && !elem.parent.isUsedForSelectList)
		{
			editor.style.position = "absolute";
		}
		else
		{
			elem.showElement.element.style.display = "none";
		}

		editor.style.border = "2px solid red";

		editor.style.width = elem.offsetWidth < 120 ? elem.offsetWidth : 120;
		if (!isIE)
		{
			editor.style.width = elem.offsetWidth < 120 ? elem.offsetWidth - 5
					: 120;
		}
		if (isIE)
		{
			editor.style.left = getEditorLeftPos(parseInt(editor.style.width),
					elem, evt)
					+ elem.parent.bodyPack.scrollLeft;
		}
		else
		{
			editor.style.left = getEditorLeftPos(parseInt(editor.style.width),
					elem, evt);
			editor.style.top = getEditorTopPos(elem, evt);
		}

		if ($("tablecomponent"))
		{
			editor.style.left = parseInt(editor.style.left)
					+ $("tablecomponent").scrollLeft;
		}

		editor.style.display = "";
		editor.style.zIndex = "200";
		editor.focus();
		
		if (!editor.onkeypress)
		{
			editor.onkeypress = onEnterPress;
		}
	}
	else if (elem.editElement.type == "combobox")
	{
		removejsDOMmenu();
		var selectElem = elem.editElement;
		var cursorMenu1 = new jsDOMenu(150);
		var options = elem.editElement.element.parent.selview.options;
		var len = options.length;
       
		if(len == 0 && typeof(getDataArr) == 'function')
		{
		    options = getDataArr();
		    len = options.length;
		}

		for ( var i = 0; i < len; i++)
		{
			cursorMenu1.addMenuItem(new menuItem(options[i].text, "",
					setOptionValue,
					[ options[i].text, options[i].value, elem ], true,
					"jsdomenuitem jsdomenuitemnowrap",
					"jsdomenuitemover jsdomenuitemnowrap"));
		}
		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
}

/*
 *      jsdomenu.js         
 */
function getEditorLeftPos(editwidth, elem, evt)
{

	var x;
	if (isIE)
	{
		x = evt.x;
	}
	else
	{
		x = evt.clientX;
	}
	if (x + editwidth <= getSortTableWidth(elem.parent.bodyPack))
	{
		return x;
	}
	else
	{
		return x - editwidth > 0 ? x - editwidth : x;
	}

}

function getEditorTopPos(elem, evt)
{

	var y;
	if (isIE)
	{
		y = evt.y;
	}
	else
	{
		y = evt.clientY;
	}
	if (y + elem.offsetHeight <= getSortTableHeight(elem.parent.bodyPack))
	{
		return y;
	}
	else
	{
		return y - elem.offsetHeight > 0 ? y - elem.offsetHeight : y;
	}

}

function getSortTableWidth(elem)
{
	return getPosX(elem) + elem.offsetWidth;

}

function getSortTableHeight(elem)
{

	return getPosY(elem) + elem.offsetHeight;

}

function getPosX(obj)
{
	var curleft = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curleft += obj.offsetLeft
			obj = obj.offsetParent;
		}
	}
	else if (obj.x)
		curleft += obj.x;
	return curleft;
}

function getPosY(obj)
{
	var curtop = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		}
	}
	else if (obj.y)
		curtop += obj.y;
	return curtop;
}

function setOptionValue(param)
{
	var showtext = param[0];
	var txtvalue = param[1];
	var elem = param[2];
	var colid = elem.colid;

	var rows = elem.parent.getSelectedRows();
	for ( var i = 0; i < rows.length; i++)
	{
		var cell = elem.parent.getCell(rows[i], colid);
		if (cell.element.isEdit == 0)
		{
			continue;
		}
		elem.parent.setCellValue(cell, colid, txtvalue);
		var showElement = cell.element.showElement;
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		if (showElement.type == 'span' || showElement.type == 'text')
		{
			if(elem.editElement.type == "combobox")
			{
				if(elem.editElement.element.parent.dispval)
				{
					showElement.element.innerText = txtvalue;
				}
				else
				{
					showElement.element.innerText = showtext;
				}
			}
			else
			{
				showElement.element.innerText = showtext;
			}
		}
		else if (showElement.type == 'select')
		{
			var options = showElement.element.options;
			for ( var j = 0; j < options.length; j++)
			{
				if (options[j].value == txtvalue)
				{
					showElement.element.selectedIndex = j;
					break;
				}
			}
		}
		if (cell.element.editElement.element.onchange)
		{
			cell.element.editElement.element.style.display = "none";
			cell.element.appendChild(cell.element.editElement.element);
			hideMenu();
			cell.element.editElement.element.value = txtvalue;
			cell.element.editElement.element.onchange();
			cell.element.editElement.element.style.display = "";
			cell.element.removeChild(cell.element.lastChild);
		}
	}
}
function clearSortTable(sorttable)
{
	try
	{
		sorttable.clearTableData();
		sorttable.bodyPack.parent = null;
		sorttable.bodyPack.onscroll = null;
		sorttable.bodyPack.onresize = null;
		sorttable.bodyPack = null;
		sorttable.body = null;
		sorttable.headPack.scrollLeft = null;
		sorttable.headPack = null;
		sorttable.head = null;
		sorttable.deleteHeadRow();
		sorttable.editdom = null;
		sorttable.element.parent = null;
		sorttable.element.datarows = null;
		sorttable.element.cellsWidth = null;
		sorttable.element.colsArray = null;
		sorttable.element.headRow = null;
		if(sorttable.element.parentNode)
		{
			sorttable.element.parentNode.removeChild(sorttable.element);
		}
		sorttable.element = null;
		sorttable.extratd = null;
		sorttable.onRowSelect = null;
		sorttable.onCellEdit = null;
		sorttable.onRowSort = null;
		sorttable.cellEditRangeFunc = null;

	}
	catch (ex)
	{
	}

}
/**
 *                   
 */
SortTable.prototype.replaceCellEdit = function(colid, atom)
{
	if(this.editdom[colid])
	{
		this.editdom[colid]._clearLeaks()
		this.editdom[colid] = null;
		for(var i = 0,len = this.getDataRowLength();i < len;i++)
		{
			this.getCell(i,colid).element.editElement = null;
		}
	}
	for(var i = 0,len = this.getDataRowLength();i < len;i++)
	{
		this.addCellEdit(this.getCell(i,colid), atom);
	}
	this.editdom[colid] = atom;
}
/*
 * remove sorttable after page unload user may override this function
 */
window.onunload = function()
{

	if (typeof (gencfgObj) != 'undefined')
	{
		try
		{
			clearGencfgObj();
		}
		catch (ex)
		{
		}
	}

	if (typeof (st) != 'undefined' && st instanceof SortTable)
	{
		clearSortTable(st);
	}

	if (typeof (st0) != 'undefined' && st0 instanceof SortTable)
	{
		clearSortTable(st0);
	}

	if (typeof (st1) != 'undefined' && st1 instanceof SortTable)
	{
		clearSortTable(st1);
	}

	if (typeof (workTable) != 'undefined' && workTable instanceof SortTable)
	{
		clearSortTable(workTable);
	}

	if (typeof (protectTable) != 'undefined'
			&& protectTable instanceof SortTable)
	{
		clearSortTable(protectTable);
	}

	if (typeof (filterTable) != 'undefined' && filterTable instanceof SortTable)
	{
		clearSortTable(filterTable);
	}

	if (typeof (dccDisUpTable) != 'undefined'
			&& dccDisUpTable instanceof SortTable)
	{
		clearSortTable(dccDisUpTable);
	}

	if (typeof (dccDisDownTable) != 'undefined'
			&& dccDisDownTable instanceof SortTable)
	{
		clearSortTable(dccDisDownTable);
	}

	if (typeof (excServiceConfTable) != 'undefined'
			&& excServiceConfTable instanceof SortTable)
	{
		clearSortTable(excServiceConfTable);
	}

	if (typeof (protectionGroupSTable) != 'undefined'
			&& protectionGroupSTable instanceof SortTable)
	{
		clearSortTable(protectionGroupSTable);
	}

	if (typeof (pathStatusSTable) != 'undefined'
			&& pathStatusSTable instanceof SortTable)
	{
		clearSortTable(pathStatusSTable);
	}

	if (typeof (ipaTable) != 'undefined' && ipaTable instanceof SortTable)
	{
		clearSortTable(ipaTable);
	}

	if (typeof (dccTransTable) != 'undefined'
			&& dccTransTable instanceof SortTable)
	{
		clearSortTable(dccTransTable);
	}

	if (typeof (cptable) != 'undefined' && cptable instanceof SortTable)
	{
		clearSortTable(cptable);
	}

	if (typeof (alarmtable) != 'undefined' && alarmtable instanceof SortTable)
	{
		clearSortTable(alarmtable);
	}

	if (typeof (securityParamTable) != 'undefined'
			&& securityParamTable instanceof SortTable)
	{
		clearSortTable(securityParamTable);
	}

	if (typeof (userTable) != 'undefined' && userTable instanceof SortTable)
	{
		clearSortTable(userTable);
	}

	if (typeof (userGroupTable) != 'undefined'
			&& userGroupTable instanceof SortTable)
	{
		clearSortTable(userGroupTable);
	}

	if (typeof (userListTable) != 'undefined'
			&& userListTable instanceof SortTable)
	{
		clearSortTable(userListTable);
	}

}

/**
 * when no row with table, the table head will not spread even with a long head.
 * 
 * bodyPack content: <div> <table> <thead>
 * <tr>
 * <td> ... </div>
 * 
 */
function adjustEmptyBodyPack(st, tc)
{
	if (st.getDataRowLength() == 0)
	{
		st.bodyPack.firstChild.firstChild.appendChild(bodyPackHeadInsets);
		st.bodyPack.firstChild.style.backgroundColor = "#E3E8E9";
		adjustTableLayout(st, tc, 1);
	}
	else
	{
		try
		{
			st.bodyPack.firstChild.style.backgroundColor = "#999999";
			st.bodyPack.firstChild.firstChild.removeChild(bodyPackHeadInsets);
		}
		catch (exception)
		{
		}
		adjustTableLayout(st, tc, st.getDataRowLength());
	}
}
function getSpace(len)
{
	var space = "";
	for ( var i = 0; i < len; i++)
	{
		space += " ";
	}
	return space;
}

function getLength(value)
{
	var maxLen = 0;
	var letterCode;
	if (value != null)
	{
		for ( var i = 0; i < value.length; i++)
		{
			letterCode = value.charCodeAt(i);
			if (letterCode >= 127)
			{
				maxLen += 2;
			}
			else
			{
				maxLen++;
			}
		}
	}
	return maxLen;
}

function checkLength(cell)
{
	var maxLength = cell.title;
	var str = cell.value;
	var sum = 0; 
	
	var cCount = 0;
	var eCount = 0;
	for(var i = 0;i<str.length;i++)
	{ 
		if((str.charCodeAt(i)>=0)&&(str.charCodeAt(i)<=255))
		{  
			sum=sum+1;
			eCount++;   
		}
		else
		{   
			sum=sum+2;
			cCount++;   
		}
	
		if(sum>maxLength)
		{ 
			var strTmp=str.substring(0,cCount+eCount-1); 
			cell.value = strTmp;
			break; 
		}
	} 
}


function createCTable(ct, tc)
{
	ct.addHead(RESOURCE["property"], RESOURCE["value"]);
	for (var i = 0,length = tc.attrArray.length; i < length; i++)
	{
		var attrID = tc.attrArray[i].id;
		var attrName = tc.attrArray[i].name;
		var cellobj = tc.attrArray[i].cell;
		var event = tc.attrArray[i].event;
   
	    var atom = new Atom(cellobj.editElement.type);
	    if (cellobj.editElement.defvalue != null)
	    {
		    atom.setValue(cellobj.editElement.defvalue);
	    }
		ct.addAttrRow(attrID, attrName, atom);
		
		var options = cellobj.editElement.options;
		for(var j=0; j<options.length; j++)
	    {	
			atom.addOption(options[j].name, options[j].value);
	    }
		if (cellobj.editElement.verify) 
		{
			var verifyobj = cellobj.editElement.verify;
			if (verifyobj.type == "num") 
			{
				var textElm = atom.element;
				if(verifyobj.step != null)
				{
					textCheckWithStepLen(atom.element, verifyobj.min, verifyobj.max,verifyobj.step,verifyobj.other);
				}
				else
				{
					textCheck(textElm, verifyobj.min, verifyobj.max,verifyobj.decimal,verifyobj.other);
				}
			}
			else if (verifyobj.type == "string") 
			{
				atom.element.maxLength = verifyobj.length;
			}
			else if(verifyobj.type == "func")
			{
				var tmpelement = atom.element;
				var maxLength = verifyobj.length;
				var isblock = verifyobj.isblock;
				atom.element.title = maxLength;
				atom.element.onkeyup =  function()
				{
					calStrSinoLenCheck(this,maxLength);
				}
				atom.element.onkeypress=function(evt)
				{
					evt = evt?evt:window.event;
					var code = (evt.keyCode != 0 ? evt.keyCode : evt.charCode);
					var obj = evt.srcElement?evt.srcElement:evt.target;
					
					var ch = String.fromCharCode(code);
					
					if (code == 13)
					{
						obj.blur();
						return false;
					}
					if(typeof(isblock) != "undefined" && isblock == true)
					{
						return blockChars(evt,"~!#$%+^*|[]{}<>\"\\=,:;?'");
					}
					else
					{
						return true;
					}
				}
				if(typeof(isblock) != "undefined" && isblock == true)
				{
					atom.element.onpaste = forbidExtra;
				}
			}
		}
		
		if (event)
		{
			if (event.onchange)
			{
			   if (atom.type == "text-button" || atom.type == "combo-button")
			   {
		    	   atom.element.parent.getComboElement().onchange = eval(event.onchange);
			   }
			   else
			   {
		           atom.element.onchange = eval(event.onchange);
			   }
			}
			if (event.onblur)
			{
			   if (atom.type == "text-button" || atom.type == "combo-button")
			   {
		    	   atom.element.parent.getComboElement().onblur = eval(event.onblur);
			   }
			   else
			   {
		           atom.element.onblur = eval(event.onblur);
			   }
			}
			if (event.onkeydown)
			{
			   if (atom.type == "text-button" || atom.type == "combo-button")
			   {
		    	  atom.element.parent.getComboElement().onkeydown = eval(event.onkeydown);
			   }
			   else
			   {
		          atom.element.onkeydown = eval(event.onkeydown);
			   }
			}
			if (event.onkeypress)
			{
			   if (atom.type == "text-button" || atom.type == "combo-button")
			   {
		    	  atom.element.parent.getComboElement().onkeypress = eval(event.onkeypress);
			   }
			   else
			   {
		          atom.element.onkeypress = eval(event.onkeypress);
			   }
			}
			if (event.onpaste)
			{
			   if (atom.type == "text-button" || atom.type == "combo-button")
			   {
		    	  atom.element.parent.getComboElement().onpaste = eval(event.onpaste);
			   }
		       atom.element.onpaste = eval(event.onpaste);
			}
		    if (event.onclick)
			{
				if (atom.type == "text-button" || atom.type == "combo-button")
				{
		    	   atom.element.parent.getBtnElement().onclick = eval(event.onclick);
				}
				else
				{
				   atom.element.onclick = eval(event.onclick);
				}
			}
		
		}
		
	}
	
}
