/*********************************************
*              
*
*
*********************************************/    
function Atom(etype, classstr)
{
	var elem;
    switch(etype)
    {
    	case 0:    // 0 text
    	    elem = document.createElement("input");
    	    elem.setAttribute("type","text");
    	    break;
    	case 1:    // 1 span
    	    elem = document.createElement("span");
    	    break;
    	case 2:    // 2 checkbox
    	    elem = document.createElement("input");
    	    elem.setAttribute("type", "checkbox");
    	    break;
    	case 3:    // 3 select
    	    elem = document.createElement("select");
    	    break;
    	case 4:    // 4 hidden
    	    elem = document.createElement("input");
    	    elem.setAttribute("type","hidden");
    	    break;
    	case 5:     // 5 input
    	    elem = document.createElement("input");
    	    elem.setAttribute("type", "password");
    	    break;
    	default:
    	    elem = null;
    	    break;
    }
    this.element = elem;
    this.element.className = classstr;
    
    this.getType = function()
    {
    	if(this.element)
    	{
    		return this.element.nodeName;
    	}else{
    	    return "null";
        }
    }
    
    this.setValue = function(value)
    {
    	if(this.getType() == "INPUT")
    	{
    		this.element.value = value;
    	}else if(this.getType() == "SPAN")
    	{   
    		this.element.innerHTML = "";
    		this.element.appendChild(document.createTextNode(value));
    	}else if(this.getType() == "SELECT")
    	{
    		for(var i=0; i<this.element.options.length; i++)
    		{
    			if(this.element.options[i].value == value)
    			{
    				this.element.options[i].selected = true;
    			}
    		}
    	}
    }
    
    this.getValue = function()
    {
    	if(this.getType() != "SPAN")
    	{
    		return this.element.value;
    	}
    	else
    	{
    		return this.element.innerHTML;
    	}
    }
    
    this.setClass = function(str)
    {
    	this.element.className = str;
    }
    
    this.getElement = function()
    {
    	return this.element;
    }
}

/***********************************************************************************************
*                
*    obj       
*    ename         onclick 
*                       arg1, arg2           
* funcstr           "fun(arg1, arg2)"   func          arg1, arg2      
*               "fun()"
*************************************************************************************************/
function addEventFunction(obj, ename /*arg1, arg2, funcstr*/)
{   
	if(addEventFunction.arguments.length < 2)
	{
		alert("arguments is not enough!");
		return;
	}
	var func = "";
	for(var i = 2; i < addEventFunction.arguments.length; i++)
	{
		func += ", "+ addEventFunction.arguments[i];
	}
	obj[ename] = new Function(func.substring(2));
}

/********************************************************************
* attribute  value   
* -------------------------------------------------------------
* |                             |                             |
* |                           |                           |
* |-----------------------------|-----------------------------|
* |                             |                             |
* |-----------------------------|-----------------------------|
* |                             |                             |
* |-----------------------------|-----------------------------|
* |                             |                             |
*-------------------------------------------------------------- 
**********************************************************************/

function CTable()
{
	this.element = document.createElement("table");
	this.element.cellSpacing = 1;
	this.element.appendChild(document.createElement("thead"));
	this.element.appendChild(document.createElement("tbody"));
	this.element.firstChild.appendChild(document.createElement("tr"));
	
	this.attrArray = new Object();
	this.element.className = "attrTable";
	this.addHead = function(head1, head2)
	{
		var th = document.createElement("td");
		var span = document.createElement("span")
		span.appendChild(document.createTextNode(head1));
		th.appendChild(span);
		this.element.firstChild.firstChild.appendChild(th);
		th = document.createElement("td");
		span = document.createElement("span")
		span.appendChild(document.createTextNode(head2));
		th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
	}
	
	/***********************************************
	*            
	*    
	* attrid       attribute id 
	* attrname attribute  
	* atom       attribute    
	***********************************************/
	this.addAttrRow = function(attrid, attrname, atom)
	{
		var tr = document.createElement("tr");
		var td = document.createElement("td");
		var span = document.createElement("span");
		span.appendChild(document.createTextNode(attrname));
		td.appendChild(span);
		tr.appendChild(td);
		td = document.createElement("td");
		td.appendChild(atom.getElement());
		tr.appendChild(td);
		this.element.childNodes[1].appendChild(tr);
		this.attrArray[attrid] = atom;
	}
	
	this.getAttrValue = function(attrid)
	{
		return this.attrArray[attrid].getValue();
	}
	
	this.setAttrValue = function(attrid, value)
	{
		if(this.attrArray[attrid])
		{
			this.attrArray[attrid].setValue(value);
		}
	}
	
	this.getTable = function()
	{
		return this.element;
	}
}
