/**SVG     tips          
*1.  svgtip.js
*2.  mousemove,mouseout  
*3. title  
*var title = createElement("title");
*var textValue=document.createTextNode(this.name);	
*title.appendChild(textValue); 
*path.appendChild(title);
*/


var MAX_ROW_NUM = 4;//      4 
var ROW_CHAR_LENGTH = 16;//    16   

var SVGTip = function()
{
	this.SVGDocument = null;
	this.SVGRoot = null;
	this.TrueCoords = null;
    
	this.toolTip = null;
	this.tipBox = null;
	this.tipText = null;
	this.tipTitleList = new Array();
	this.lastElement = null;
}

SVGTip.prototype.init = function(evt){
	this.SVGDocument = evt.target.ownerDocument;
	this.SVGRoot = this.SVGDocument.documentElement;
	this.TrueCoords = this.SVGRoot.createSVGPoint();

	
	this.toolTip = createElement("g");
	this.toolTip.setAttribute("id", 'ToolTip');
	this.toolTip.setAttribute("opacity", '1');
	this.toolTip.setAttribute("visibility", 'hidden');
	this.toolTip.setAttribute("pointer-events", 'none');
	this.toolTip.setAttribute("transform", 'translate(156, 22)');
	
	this.tipBox = createElement("rect");
	this.tipBox.setAttribute("id", 'tipbox');
	this.tipBox.setAttribute("x", '0');
	this.tipBox.setAttribute("y", '5');
	this.tipBox.setAttribute("width", '93');
	this.tipBox.setAttribute("height", '47');
	this.tipBox.setAttribute("rx", '2');
	this.tipBox.setAttribute("ry", '2');
	this.tipBox.setAttribute("fill", 'white');
	this.tipBox.setAttribute("stroke", 'black');
	this.tipBox.setAttribute("transform", 'scale(1)');
	this.toolTip.appendChild(this.tipBox);
	
	this.tipText = createElement("text");
	this.tipText.setAttribute("id", 'tipbox');
	this.tipText.setAttribute("x", '5');
	this.tipText.setAttribute("y", '20');
	this.tipText.setAttribute("font-family", 'Arial');
	this.tipText.setAttribute("font-size", '12');
	this.tipText.setAttribute("transform", 'scale(1)');
	this.toolTip.appendChild(this.tipText);
	
	for(var i = 0,iLength = MAX_ROW_NUM;i<iLength;i++)
	{
	 var tipTitle = createElement("tspan");
	tipTitle.setAttribute("id", 'tipTitle'+i);
	tipTitle.setAttribute("x", '5');
	if(i !=0)
	{
		tipTitle.setAttribute("dy", '15');
	}
	tipTitle.setAttribute("font-weight", 'bold');
	tipTitle.setAttribute("display", 'none');
	tipTitle.appendChild(document.createTextNode(""));
	this.tipText.appendChild(tipTitle);
	this.tipTitleList[i] = tipTitle;
	
	
	}
	

	
	this.SVGRoot.appendChild(this.toolTip);

}

SVGTip.prototype.RemoveTooltip = function(evt){
	if(this.toolTip!=null){
	this.SVGRoot.removeChild(this.toolTip);
	}
}
SVGTip.prototype.GetTrueCoords = function(evt){
	var newScale = this.SVGRoot.currentScale;
	var translation = this.SVGRoot.currentTranslate;
	this.TrueCoords.x = (evt.clientX - translation.x) / newScale;
	this.TrueCoords.y = (evt.clientY - translation.y) / newScale;
}

SVGTip.prototype.HideTooltip = function(evt){
	if(this.toolTip!=null){
	this.toolTip.setAttributeNS(null, 'visibility', 'hidden');
	}
}

SVGTip.prototype.ShowTooltip = function(evt){

	this.init(evt);
	this.GetTrueCoords(evt);
	

	var tipScale = 1 / this.SVGRoot.currentScale;
	var textWidth = 0;
	var tspanWidth = 0;
	var boxHeight = 20;

	this.tipBox.setAttributeNS(null, 'transform', 'scale(' + tipScale + ','
			+ tipScale + ')');
	this.tipText.setAttributeNS(null, 'transform', 'scale(' + tipScale + ','
			+ tipScale + ')');

	var titleValue = '';
	var descValue = '';
	var targetElement = evt.target;
	if (this.lastElement != targetElement) {
		var targetTitle = targetElement.getElementsByTagName('titleValue').item(0);
		if (targetTitle) {
			titleValue = targetTitle.firstChild.nodeValue;
		}

		var targetDesc = targetElement.getElementsByTagName('desc').item(0);
		if (targetDesc) {
			descValue = targetDesc.firstChild.nodeValue;

			if ('' == titleValue) {
				titleValue = descValue;
				descValue = '';
			}
		}

		if ('' == titleValue) {
			titleValue = targetElement.getAttributeNS(null, 'id');
		}

		var titleDisplay = 'none';
		if ('' != titleValue) {
			var rowNum =parseInt(titleValue.length/ROW_CHAR_LENGTH);
			
			for(var i = 0;i*ROW_CHAR_LENGTH<titleValue.length;i++)
			{
	
				var sEnd = rowNum == i ?titleValue.length:(i+1)*ROW_CHAR_LENGTH;
				
				this.tipTitleList[i].firstChild.nodeValue = titleValue.substring(i*ROW_CHAR_LENGTH,sEnd);
				titleDisplay = 'inline';
				this.tipTitleList[i].setAttributeNS(null, 'display', titleDisplay);
			}
		}

	}

	if ('' != titleValue) {
		var xPos = this.TrueCoords.x + (10 * tipScale);
		var yPos = this.TrueCoords.y + (10 * tipScale);
		
		
		if(xPos > 560)
		{
			xPos = 560;
		}
		
		if(yPos > 560)
		{
			yPos = 560;
		}

		var outline = this.tipText.getBBox();
		this.tipBox.setAttributeNS(null, 'width', Number(outline.width) + 10);
		this.tipBox.setAttributeNS(null, 'height', Number(outline.height) + 10);

		this.toolTip.setAttributeNS(null, 'transform', 'translate(' + xPos + ','
				+ yPos + ')');
		this.toolTip.setAttributeNS(null, 'visibility', 'visible');
	}
}

var svgTip = new SVGTip();
