var isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var isIE9 = (navigator.userAgent.indexOf("MSIE 9.0") > -1);
var SVG_NS = "http://www.w3.org/2000/svg"; 
var svgDoc;

var PI = Math.PI;

/*      */
function extend(subClass, superClass) {
	function F() {};
	F.prototype = superClass.prototype;
	subClass.prototype = new F;
	subClass.prototype.constructor = subClass;
	subClass.superclass = superClass.prototype;
	if (superClass.prototype.constructor == Object.prototype.constructor) 
	{
		superClass.prototype.constructor = superClass;
	}
}

function getSVGElement(id)
{
	if(!svgDoc)
	{
		return null;
	}
	return svgDoc.getElementById(id);
}

/**
 *   SVG    
 * @param evt
 */
function getSVGDocument(evt)
{
	svgDoc = evt.target.ownerDocument;
	
	return svgDoc;
}

function createElement(tag)
{
	return svgDoc.createElementNS(SVG_NS, tag);
}

/**
 * Utility function to create element with attributes and styles
 * @param tag 
 * @param attribss
 * @param styles
 * @param parent 
 * @param nopad  
 */
function createSVGElement(/*String*/tag, /*Object*/attribs, /*Object*/styles, /*Object*/parent, /*bool*/nopad) 
{
	var el;
	el = svgDoc.createElementNS(SVG_NS, tag);
	if (attribs) 
	{
		extendObj(el, attribs);
	}
	if (nopad) 
	{
		css(el, {padding: 0, border: NONE, margin: 0});
	}
	if (styles) 
	{
		css(el, styles);
	}
	if (parent) 
	{
		parent.appendChild(el);
	}	
	return el;
}

/**
 *       
 * @param text     
 * @returns
 */
function createSVGText(/*String*/text)
{
	var el = svgDoc.createTextNode(text);
	return el;
}

/**
 *          
 * FireFox       
 * @param ele
 */
function setElementStyle(ele, property)
{
	if(!ele)
	{
		return ;
	}
	for(var i in property)
	{
		if(property.hasOwnProperty(i))
		{
			ele.style.setProperty(i, property[i]);	
		}	
	}
}

/**
 *         
 * @param el
 * @param size
 */
function setFontSize(el,size)
{
	if(isFF)
	{
		el.style.fontSize = size + "pt";
	}
	else
	{
		try
		{
			el.style.setProperty("font-size",size + "pt");
		}
		catch(e)
		{
			
		}
	}
}

/**
 *        
 * @param ele
 * @param styles
 */
function css(ele, styles)
{
	extendObj(ele.style, styles);
}

/**
 *           
 * @param elem
 * @param prop
 * @param value
 * @returns
 */
function attr(elem, prop, value) 
{
	var key,
		setAttribute = 'setAttribute',
		ret;
	
	if (isString(prop)) 
	{
		if (isDefined(value)) 
		{

			elem[setAttribute](prop, value);
		
		} 
		else if (elem && elem.getAttribute) 
		{ // elem not defined when printing pie demo...
			ret = elem.getAttribute(prop);
		}
	
	} 
	else if (isDefined(prop) && isObject(prop)) 
	{
		for (key in prop) 
		{
			elem[setAttribute](key, prop[key]);
		}
	}
	return ret;
}

/**
 *     a    b   a 
 * 
 * @param a
 * @param b
 */
function extendObj(/* Object */a, /* Object */b)
{
	if(!a)
	{
		a = [];
	}
	for(var i in b)
	{
		if(b.hasOwnProperty(i))
		{
			a[i] = b[i];
		}
	}
	
	return a;
}
/**
 *  SVG        
 * @param obj
 * @param evtName
 * @param func
 * @param bl
 */
function attachSVGEvent(/*SVGElement*/obj,/*String*/evtName,/*function*/func,/*bool*/bl)
{
	if(typeof(bl) == "undefined")
	{
		bl = false;
	}
	if(obj)
	{
		obj.addEventListener(evtName,func,bl);
	}
}

function isString(s) 
{
	return typeof s == 'string';
}

function isDefined(obj) 
{
	return obj !== 'undefine' && obj !== null;
}

function isObject(obj) 
{
	return typeof obj == 'object';
}

function isNumber(n) 
{
	return typeof n == 'number';
}

/**
 * @param num
 * @returns
 */
function pInt(num)
{
	if(isNumber(num))
	{
		return num;
	}
	else
	{
		return parseInt(num);
	}
}

/**
 * 
 * @param str         
 * @param len      
 * @returns {String}                            
 *                               
 */
function setDemicalDigitLength(str,len)
{
	var outstr = "";
    var dLen = 0; 
    var hasDecimal = false;
	var outstr = "";
    var dLen = 0; 
    var hasDecimal = false;
    for(var i = 0, iLen = str.length; i < iLen; i++)
    {
        if(46 == str.charCodeAt(i))
        {
        	hasDecimal = true;
        }
        if(hasDecimal)
        {
        	if(dLen == len)
        	{
        		break;
        	}
        	dLen++;
        }
    }
    if(hasDecimal)
    {
    	outstr = str.substring(0, dLen + 1);
    }
    else
    {
    	outstr = str;
    }
    
    return outstr;
}
