
var _isFF=false; var _isIE=false;

if ((navigator.userAgent.indexOf('Safari') != -1)||(navigator.userAgent.indexOf('Konqueror')!= -1)){
	var _KHTMLrv=parseFloat(navigator.userAgent.substr(navigator.userAgent.indexOf('Safari')+7,5));
	if (_KHTMLrv > 525){ //mimic FF behavior for Safari 3.1+
		_isFF=true;
	}
}
else if(navigator.appName.indexOf("Microsoft")!=-1)
    _isIE=true;
else {
    _isFF=true;
    }


/**
*   @desc: constructor, creates a new subModelWindows object
*   @type: public
*/
function subModelWindows() {
	
	this.imagePath = "../images/";

	this.setImagePath = function(path) {
		this.imagePath = path;
	}
	
	this.isWindow = function(id) {
		var t = (this.wins[id] != null);
		return t;
	}
	
	this.window = function(id) {
		var win = null;
		if (this.wins[id] != null) { win = this.wins[id]; }
		return win;
	}
	
	this.setNotModalWin = function(){
		for (var a in this.wins) {
			this.wins[a].setModal(false);
		}
	}
	
	this.getTopmostWindow = function() {
		var topmost = {"zi": 0};
		
		for (var a in this.wins) {
			
			if (this.wins[a].zi > topmost.zi) {
				topmost = this.wins[a];
			}
		}
		return (topmost.zi != 0 ? topmost : null);
	}
	
	this.getSpecifyWindow = function(pagename)
	{
		var swin = null;
		for (var a in this.wins)
		{
			if (this.wins[a].contentURL.indexOf(pagename) >= 0) 
			{
				swin = this.wins[a];
				break;
			}
		}
		return swin;
	}
	
	this.getBottommostWindow = function() {
		var bottommost = this.getTopmostWindow();
		for (var a in this.wins) {
			if (this.wins[a].zi < bottommost.zi) {
				bottommost = this.wins[a];
			}
		}
		return (bottommost.zi != 0 ? bottommost : null);
	}
	
	this.wins = {};
	
	this.autoViewport = true;
	this._createViewport = function() {
		this.vp = document.body;
		this.modalCoverD = document.createElement("DIV");
		this.modalCoverD.className = "dhx_modal_cover_dv";
		this.modalCoverD.style.display = "none";
		this.modalCoverD.style.zIndex = 0;
		this.vp.appendChild(this.modalCoverD);
	}
	this._autoResizeViewport = function() {
		if (this.vp == document.body) { return; }
		if (this.autoViewport == false) { return; }
		
		this.vp.style.width = (_isIE ? document.body.offsetWidth - 4 : window.innerWidth) + "px";
		this.vp.style.height = (_isIE ? document.body.offsetHeight - 4 : window.innerHeight) + "px";
		for (var a in this.wins) {
			var win = this.wins[a];
			var overX = false;
			var overY = false;
			if (win.x > this.vp.offsetWidth - 10) {
				win.x = this.vp.offsetWidth - 10;
				overX = true;
			}
			if (win.y + 30 > this.vp.offsetHeight) {
				win.y = this.vp.offsetHeight - 30;
				overY = true;
			}
			if (overX || overY) {
				this._redrawWindow(win);
			}
		}
	}
	this.enableAutoViewport = function(state) {
		if (this.vp != document.body) { return; }
		this.autoViewport = state;
		if (state == false) {
			this.vp = document.createElement("DIV");
			this.vp.className = "popup_winviewport";
			this.vp.style.left = "0px";
			this.vp.style.top = "0px";
			document.body.appendChild(this.vp);
			this.vp.ax = 0;
			this.vp.ay = 0;
			this._autoResizeViewport();
			var that = this;
			if (_isIE) {
				window.attachEvent("onresize", function(){ that._autoResizeViewport(); });
			} else {
				window.addEventListener("resize", function(){ that._autoResizeViewport(); }, false);
			}
			this.vp.appendChild(this.modalCoverD);
		}
	}
	/**
	*   @desc: sets user-defined viewport if enableAutoViewport(false)
	*   @param: x - top-left viewport corner's X-coordinate
	*   @param: y - top-left viewport corner's Y-coordinate
	*   @param: width - viewport's width
	*   @param: height - viewport's height
	*   @type: public
	*/
	this.setViewport = function(x, y, width, height, parentObj) {
		if (this.autoViewport == false) {
			this.vp.style.left = x + "px";
			this.vp.style.top = y + "px";
			this.vp.style.width = width + "px";
			this.vp.style.height = height + "px";
			if (parentObj != null) { parentObj.appendChild(this.vp); }
			this.vp.ax = getAbsoluteLeft(this.vp);
			this.vp.ay = getAbsoluteTop(this.vp);
		}
	}
	
	this.createWindow = function(id, x, y, width, height,parentPage) {
		var win = document.createElement("DIV");
		win.className = "popup_window_active";
		for (var a in this.wins) {
			this.wins[a].zi += this.zIndexStep;
			this.wins[a].style.zIndex = this.wins[a].zi;
		}
		win.zi = this._getTopZIndex(true) + this.zIndexStep;// this._getTopZIndex(true) + this.zIndexStep;
		win.style.zIndex = win.zi;
		win.active = false;
		var that = this;
		win.w = width;
		win.h = height + 30;
		win.x = x;
		win.y = y;

		this._fixWindowPositionInViewport(win);
		win.style.width = win.w + "px";
		win.style.height = win.h + "px";
		win.style.left = win.x + "px";
		win.style.top = win.y + "px";
		win._isModal = false;
		win._allowResize = true;
		win.maxW = "auto"; // occupy all viewport on click or 
		win.maxH = "auto";
		win.minW = 200;
		win.minH = 140;
		win._allowMove = true;
		win._allowMoveGlobal = true;
		win._allowResizeGlobal = true;
		win._keepInViewport = false;
		if(parentPage && parentPage.indexOf("?") > 0)
		{
			parentPage = parentPage.substring(0,parentPage.indexOf("?"));
		}
		win.parentPage = parentPage;

		win.idd = id;
		win.innerHTML = "" +
				"<table border='0' cellspacing='0' cellpadding='0' width='100%' height='"+height+"' class='popup_wins'>"+
					"<tr><td class='popup_wins_td_header_full' style='height:26px;' clearonselect='yes'>"+
						"<table border='0' cellspacing='0' cellpadding='0' width='100%' class='popup_wins_header' clearonselect='yes'>"+
							"<tr clearonselect='yes'>"+
								"<td class='popup_border_header_left' clearonselect='yes'>&nbsp;</td>"+
								"<td class='popup_border_header_middle' align='left' valign='top'>&nbsp;</td>"+
								"<td class='popup_border_header_right' clearonselect='yes'>&nbsp;</td>"+
							"</tr>"+
						"</table>" +
					"</td></tr>"+
					"<tr><td class='popup_wins_td_body_full' height='"+(win.h - 26)+"'>"+
						"<table border='0' cellspacing='0' cellpadding='0' width='100%' height='"+(win.h-26)+"' class='popup_wins_body'>"+
							"<tr>"+
								"<td class='popup_border_middle_left' clearonselect='yes'>&nbsp;</td>"+
								"<td class='popup_wins_body_content' align='left' valign='top'>" +
									"<div class='popup_wins_body_content' style='width: "+(win.w-6)+"px; height:"+(win.h-30)+"px;'>&nbsp;"+
									"</div>"+
								"</td>"+
								"<td class='popup_border_middle_right' clearonselect='yes'>&nbsp;</td>"+
							"</tr>"+
							"<tr clearonselect='yes'>"+
								"<td class='popup_border_bottom_left' clearonselect='yes'>&nbsp;</td>"+
								"<td class='popup_border_bottom_middle' clearonselect='yes'>&nbsp;</td>"+
								"<td class='popup_border_bottom_right' clearonselect='yes'>&nbsp;</td>"+
							"</tr>"+
						"</table>"+
					"</td></tr>"+
				"</table>"+
				"<div clearonselect='yes' class='popup_wins_title'>&nbsp;</div>"+
				"<div clearonselect='yes' class='popup_wins_buttons'>"+
					"<table border='0' cellspacing='0' cellpadding='0'><tr></tr></table>"+
				"</div>"+
				"";

		this.vp.appendChild(win);
		win._content = win.childNodes[0].childNodes[0].childNodes[1].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[1].childNodes[0];
		this._diableOnSelectInWin(win, true);
		this.wins[id] = win;
		
		win.subModelEvent = this.subModelEvent;
		win.subModelEvent();
		this._makeActive(win);
		var hdr = win.childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[1]; // table class='header'
		hdr.onmousedown = function(e)
		{
			if (!win._allowMove || !win._allowMoveGlobal) 
			{
				return;
			}
			e = e || event;
			win.oldMoveX = win.x;
			win.oldMoveY = win.y;
			win.moveOffsetX = win.x - e.clientX;
			win.moveOffsetY = win.y - e.clientY;
			that.movingWin = win;
			that._blockSwitcher("none");
            if (this.vp == document.body) 
            {
                that.movingWin.childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[1].style.cursor = "move";
            }
			that.movingWin.childNodes[1].style.cursor = "move";
		}
		
		var h_title = win.childNodes[1];
		h_title.onmousedown = hdr.onmousedown;
		
		win.setText = function(text) {
			this.childNodes[1].innerHTML = text;
		}
		win.getText = function() {
			return this.childNodes[1].innerHTML;
		}
		win.getId = function() {
			return this.idd;
		}
		win.show = function() {
			that._showWindow(this);
		}

		win.close = function() {
			that._closeWindow(this);
		}

		win.keepInViewport = function(state) {
			this._keepInViewport = state;
		}
		win.setModal = function(state) {
			if (state == true) {
				if (that.modalWin == this) { return; }
				that._setWindowModal(this, true);
			} else {
				if (that.modalWin != this) { return; }
				that._setWindowModal(this, false);
			}
		}
		win.isModal = function() {
			return this._isModal;
		}

		win.allowResize = function() {
			that._allowReszieGlob(this);
		}
		win.denyResize = function() {
			that._denyResize(this);
		}
		win.isResizable = function() {
			return this._allowResizeGlobal;
		}
		win.allowMove = function() {
			if (!this._isMaximized) { this._allowMove = true; }
			this._allowMoveGlobal = true;
		}
		win.denyMove = function() {
			this._allowMoveGlobal = false;
		}
		win.isMovable = function() {
			return this._allowMoveGlobal;
		}
		win.bringToTop = function() {
			that._bringOnTop(this);
			that._makeActive(this);
		}
		win.bringToBottom = function() {
			that._bringOnBottom(this);
		}
		win.isOnTop = function() {
			return that._isWindowOnTop(this);
		}
		win.isOnBottom = function() {
			return that._isWindowOnBottom(this);
		}
		win.setPosition = function(x, y) {
			this.x = x;
			this.y = y;
			that._fixWindowPositionInViewport(this);
			if (_isFF) {
				this.h++;
				that._redrawWindow(this);
				this.h--;
			}
			that._redrawWindow(this);
		}
		win.getPosition = function() {
			return new Array(this.x, this.y);
		}
		win.setDimension = function(width, height) {
			this.w = width;
			this.h = height;
			that._fixWindowDimensionInViewport(this);
			that._fixWindowPositionInViewport(this);
			that._redrawWindow(this);
		}
		win.getDimension = function() {
			return new Array(this.w, this.h);
		}
		win.setMaxDimension = function(maxWidth, maxHeight) {
			this.minW = "auto"; // maxWidth;
			this.minH = "auto"; // maxHeight;
			that._redrawWindow(this);
		}
		win.getMaxDimension = function() {
			return new Array(this.maxW, this.maxH);
		}
		win.setMinDimension = function(minWidth, minHeight) {
			this.minW = minWidth;
			this.minH = minHeight;
			that._fixWindowDimensionInViewport(this);
			that._redrawWindow(this);
		}
		win.getMinDimension = function() {
			return new Array(this.minW, this.minH);
		}
		win.addUserButton = function(id, pos, title, label) {
			var userBtn = that._addUserButton(this, id, pos, title, label);
			return userBtn;
		}
		win.removeUserButton = function(id) {
			if (!(id == "close")) {
				var btn = this.button(id);
				if (btn != null) { that._removeUserButton(this, id, btn); }
			}
		}

		win.canStartResize = false;
		win.onmousemove = function(e) {
			if ((!this._allowResize) || (this._allowResizeGlobal == false)) {
				this.canStartResize = false;
				this.style.cursor = "";
				return;
			}
			
			if (that.resizingWin != null) { return; }
			if (this._isParked) { return; }
			e = e || event;
			var targetObj = e.target || e.srcElement;
			var useDefaultCursor = true;
			this.canStartResize = true;
			if (targetObj.className == "popup_border_top_left") {
				that.resizingDirs = "top_left";
				this.style.cursor = "nw-resize";
				this.resizeOffsetX = this.x - e.clientX;
				this.resizeOffsetY = this.y - e.clientY;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_top_middle") {
				that.resizingDirs = "border_top";
				this.style.cursor = "n-resize";
				this.resizeOffsetY = this.y - e.clientY;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_top_right") {
				that.resizingDirs = "top_right";
				this.style.cursor = "sw-resize";
				this.resizeOffsetY = this.y - e.clientY;
				this.resizeOffsetXW = this.x + this.w - e.clientX;
				useDefaultCursor = false;
			}
			
			if (targetObj.className == "popup_border_middle_left") {
				that.resizingDirs = "border_left";
				this.style.cursor = "w-resize";
				this.resizeOffsetX = this.x - e.clientX;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_middle_right") {
				that.resizingDirs = "border_right";
				this.style.cursor = "e-resize";
				this.resizeOffsetXW = this.x + this.w - e.clientX;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_bottom_middle") {
				that.resizingDirs = "border_bottom";
				this.style.cursor = "n-resize";
				this.resizeOffsetYH = this.y + this.h - e.clientY;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_bottom_left") {
				that.resizingDirs = "corner_left";
				this.style.cursor = "sw-resize";
				this.resizeOffsetX = this.x - e.clientX;
				this.resizeOffsetYH = this.y + this.h - e.clientY;
				useDefaultCursor = false;
			}
			if (targetObj.className == "popup_border_bottom_right") {
				that.resizingDirs = "corner_right";
				this.style.cursor = "nw-resize";
				this.resizeOffsetXW = this.x + this.w - e.clientX;
				this.resizeOffsetYH = this.y + this.h - e.clientY;
				useDefaultCursor = false;
			}
			
			if (useDefaultCursor) {
				this.canStartResize = false;
				this.style.cursor = "";
			}
		}
		win.onmousedown = function() {
			that._makeActive(this);
			that._bringOnTop(this);
			if (this.canStartResize) {
				that._blockSwitcher("none");
				that.resizingWin = this;
			}
		}
		this._addDefaultButtons(win);
		win.button = function(id) {
			var b = null;
			if (this.btns[id] != null) { b = this.btns[id]; }
			return b;
		}
		win.attachObject = function(objId, changeDisp) {
			that._attachContent(this, "obj", document.getElementById(objId), changeDisp);
		}
		win.attachURL = function(url) {
			that._attachContent(this, "url", url, false);
		}
		win.center = function() {
			that._centerWindow(this);
		}
		this._attachContent(win, "empty", null, false);
		win.bringToTop();
		return this.wins[id];
	}
	
	this._diableOnSelectInWin = function(obj, state) {
		for (var q=0; q<obj.childNodes.length; q++) {
			var child = obj.childNodes[q];
			if ((child.tagName == "TD") || (child.tagName == "TR") || (child.tagName == "TABLE")  || (child.tagName == "DIV")) {
				if (child.getAttribute("clearonselect") != null) {
					if (state) {
						child.onselectstart = function(e) { e = e || event; e.returnValue = false; }
						
					} else {
						child.onselectstart = null;
					}
				}
			}
			if (child.childNodes.length > 0) { this._diableOnSelectInWin(child); }
		}
	}
	
	this._redrawWindow = function(win) {
		win.style.left = win.x + "px";
		win.style.top = win.y + "px";
		win.style.width = (win.w == "100%" ? win.w : win.w+"px");
		win.style.height = (win.h == "100%" ? win.h : win.h+"px");
		if (win.w == "100%") {
			var winW = "100%";
			win.w = win.offsetWidth;
		}
		if (win.h == "100%") {
			var winH = "100%";
			win.h = win.offsetHeight;
		}
		win.childNodes[0].style.height = win.h + "px";
		var p = win.childNodes[0].childNodes[0].childNodes[1].childNodes[0];

		p.style.height = win.h-26 + "px";
		p.childNodes[0].style.height = win.h-30 + "px";
		var wdth = win.childNodes[2].offsetLeft - win.childNodes[1].offsetLeft - 5;
		if (wdth < 0) { wdth = 0; }
		win.childNodes[1].style.width = wdth + "px";
		var w = win.w - 6;
		var h = win.h - 30;
		if (w < 0) { w = 0; }
		if (h < 0) { h = 0; }
		var bd = p.childNodes[0].childNodes[0].childNodes[0].childNodes[1].childNodes[0];
		if (win._manageAddons) {
			win._manageAddons(w, h);
		} else {
			bd.style.width = w + "px";
			bd.style.height = h + "px";
		}
		if (winW != null) { win.w = winW; }
		if (winH != null) { win.h = winH; }
	}
	
	this.zIndexStep = 50;
	this._getTopZIndex = function() {
		var topZIndex = 0;
		for (var a in this.wins) {
			if (this.wins[a].zi > topZIndex) { topZIndex = this.wins[a].zi; }
		}
		if(typeof(LoadingProcess) != "undefined"
			&& typeof(LoadingProcess.getDivIndex) != "undefined")
		{
			topZIndex += LoadingProcess.getDivIndex();
		}
		return topZIndex;
	}
	
	this.movingWin = null;
	
	this._moveWindow = function(e) {
		
		if (this.movingWin != null ) {
			if (!this.movingWin._allowMove || !this.movingWin._allowMoveGlobal) { return; }
			this.movingWin.oldMoveX = this.movingWin.x;
			this.movingWin.oldMoveY = this.movingWin.y;
			this.movingWin.x = e.clientX + this.movingWin.moveOffsetX;
			this.movingWin.y = e.clientY + this.movingWin.moveOffsetY;
			this._fixWindowPositionInViewport(this.movingWin);
			this._redrawWindow(this.movingWin);
			if (this._compoEnabled) { this._compoFixMove(this.movingWin); }
		}
		
		if (this.resizingWin != null) {
			if (!this.resizingWin._allowResize) { return; }
			if (this.resizingDirs == "border_top" || this.resizingDirs == "top_left" || this.resizingDirs == "top_right") {
				var ofs = e.clientY + this.resizingWin.resizeOffsetY;
				var sign = (ofs > this.resizingWin.y ? -1 : 1);
				newH = this.resizingWin.h + Math.abs(ofs - this.resizingWin.y)*sign;
				if ((newH < this.resizingWin.minH) && (sign < 0)) {
					this.resizingWin.y = this.resizingWin.y + this.resizingWin.h - this.resizingWin.minH;
					this.resizingWin.h = this.resizingWin.minH;
				} else {
					this.resizingWin.h = newH;
					this.resizingWin.y = ofs;
				}
				this._redrawWindow(this.resizingWin);
			}
			
			if (this.resizingDirs == "border_left" || this.resizingDirs == "corner_left" || this.resizingDirs == "top_left") {
				var ofs = e.clientX + this.resizingWin.resizeOffsetX;
				var sign = (ofs > this.resizingWin.x ? -1 : 1);
				newW = this.resizingWin.w + Math.abs(ofs - this.resizingWin.x)*sign;
				if ((newW < this.resizingWin.minW) && (sign < 0)) {
					this.resizingWin.x = this.resizingWin.x + this.resizingWin.w - this.resizingWin.minW;
					this.resizingWin.w = this.resizingWin.minW;
				} else {
					this.resizingWin.w = newW;
					this.resizingWin.x = ofs;
				}
				this._redrawWindow(this.resizingWin);
			}
			if (this.resizingDirs == "border_right" || this.resizingDirs == "corner_right" || this.resizingDirs == "top_right") {
				var ofs = e.clientX - (this.resizingWin.x + this.resizingWin.w) + this.resizingWin.resizeOffsetXW;
				newW = this.resizingWin.w + ofs;
				if (newW < this.resizingWin.minW) { newW = this.resizingWin.minW; }
				this.resizingWin.w = newW;
				this._redrawWindow(this.resizingWin);
			}
			if (this.resizingDirs == "border_bottom" || this.resizingDirs == "corner_left" || this.resizingDirs == "corner_right") {
				var ofs = e.clientY - (this.resizingWin.y + this.resizingWin.h) + this.resizingWin.resizeOffsetYH;
				newH = this.resizingWin.h + ofs;
				if (newH < this.resizingWin.minH) { newH = this.resizingWin.minH; }
				this.resizingWin.h = newH;
				
				if (this._compoEnabled) {
					this._compoFixResize(this.resizingWin, this.resizingDirs);
				} else {
					this._redrawWindow(this.resizingWin);
				}
			}
		}
	}
	
	/**
	 * stroy   TRANSV1R8C00-586 
	 * mozila                   offsetWidth offsetHeight            
	 * document.documentElement.clientWidth document.documentElement.clientHeight
	 */
	this._fixWindowPositionInViewport = function(win) {
		var clientWidth = document.documentElement.clientWidth;
		var clientHeight = document.documentElement.clientHeight;
		if (win._keepInViewport) { // keep strongly in viewport
			if (win.x < 0) { win.x = 0; }
			if (win.x + win.w > clientWidth) { win.x = clientWidth - win.w; }
			if (win.y < 0) { win.y = 0; }
			if (win.y + win.h > clientHeight) { win.y = clientHeight - win.h; }
		} else {
			if (win.y < 0) { win.y = 0; }
			if (win.y + 30> clientHeight && clientHeight > 0) { win.y = clientHeight - 30; }
			if (win.x + win.w - 10 < 0) { win.x = 10 - win.w; }
			if (win.x > this.clientWidth - 10) { win.x = clientWidth - 10; }
		}
	}
	
	this._fixWindowDimensionInViewport = function(win) {
		if (win.w < win.minW) { win.w = win.minW; }
		if (win.h < win.minH) { win.h = win.minH; }
	}
	
	this._stopMove = function() {
		if (this.movingWin != null) {
			var win = this.movingWin;
			this.movingWin = null;
			this._blockSwitcher("");
			if (this.vp == document.body) 
			{
				win.childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[1].style.cursor = "";
			}
			win.childNodes[1].style.cursor = "";
			if (_isFF) {
				win.h++;
				this._redrawWindow(win);
				win.h--;
				this._redrawWindow(win);
			}
			if (!(win.oldMoveX == win.x && win.oldMoveY == win.y)) {
				if (win.checkEvent("onMoveFinish")) {
					win.callEvent("onMoveFinish",[win]);
				} else {
					this.callEvent("onMoveFinish",[win]);
				}
			}
		}
		if (this.resizingWin != null) {
			var win = this.resizingWin;
			this.resizingWin = null;
			this._blockSwitcher("");
			if (win.checkEvent("onResizeFinish")) {
				win.callEvent("onResizeFinish",[win]);
			} else {
				this.callEvent("onResizeFinish",[win]);
			}
		}
	}
	
	this._bringOnTop = function(win) {
		var cZIndex = win.zi;
		var topZIndex = this._getTopZIndex();
		for (var a in this.wins) {
			if (this.wins[a] != win) {
				if (this.wins[a].zi > cZIndex) {
					this.wins[a].zi = this.wins[a].zi - this.zIndexStep;
					this.wins[a].style.zIndex = this.wins[a].zi;
				}
			}
		}
		win.zi = topZIndex;
		win.style.zIndex = win.zi;
	}
	
	this._makeActive = function(win) {
		for (var a in this.wins) {
			if (this.wins[a] == win) {
				var needEvent = false;
				if (this.wins[a].className != "popup_window_active") { needEvent = true; }
				this.wins[a].className = "popup_window_active";
				if (needEvent == true) {
					if (win.checkEvent("onFocus")) {
						win.callEvent("onFocus",[win]);
					} else {
						this.callEvent("onFocus",[win]);
					}
				}
			} else {
				this.wins[a].className = "popup_window_active";
			}
		}
	}
	
	this._getActive = function() {
		var win = null;
		for (var a in this.wins) {
			if (this.wins[a].className == "popup_window_active") {
				win = this.wins[a];
			}
		}
		return win;
	}
	
	/**
	 * stroy   TRANSV1R8C00-586 
	 * mozila                   offsetWidth offsetHeight ?            
	 * document.documentElement.clientWidth document.documentElement.clientHeight
	 */
	this._centerWindow = function(win) {
		if (win._isMaximized == true) { return; }
		if (win._isParked == true) { return; }
		var vpw = (this.vp == document.body ? document.documentElement.clientWidth : parseInt(this.vp.style.width));
		var vph = (this.vp == document.body ? document.documentElement.clientHeight : parseInt(this.vp.style.height));
		
		var newX = Math.round((vpw/2) - (win.w/2));
		var newY = Math.round((vph/2) - (win.h/2));
		if(newX < 0)
		{
			newX = 0;
		}
		if(newY < 0)
		{
			newY = 0;
		}
		win.x = newX;
		win.y = newY;
		this._fixWindowPositionInViewport(win);
		this._redrawWindow(win);
	}
	
	this._addDefaultButtons = function(win) {
		
		var that = this;
		
		var btnClose = document.createElement("DIV");
		btnClose.className = "button_close_default";
		btnClose.title = "Close";
		btnClose.isVisible = true;
		btnClose._isEnabled = true;
		btnClose.isPressed = false;
		btnClose.label = "close";
		btnClose._doOnClick = function() { that._closeWindow(win); }
		
		win.btns = {};
		win.btns["close"] = btnClose;
		
		var b = win.childNodes[2].childNodes[0].childNodes[0].childNodes[0];
		
		for (var a in win.btns) {
			
			var btn = win.btns[a];
			
			var td = document.createElement("TD");
			td.className = "popup_wins_btn_" + (btn.isVisible ? "visible" : "hidden");
			b.appendChild(td);
			td.appendChild(btn);
			
			this._attachEventsOnButton(win, btn);
		}
	}
	
	this._attachEventsOnButton = function(win, btn) {
		
		btn.onmouseover = function() {
			if (this._isEnabled) {
				this.className = "button_"+this.label+"_over_" + (this.isPressed ? "pressed": "default");
			} else {
				this.className = "button_"+this.label+"_disabled";
			}
		}
		btn.onmouseout = function() {
			if (this._isEnabled) {
				this.isPressed = false;
				this.className = "button_"+this.label+"_default";
			} else {
				this.className = "button_"+this.label+"_disabled";
			}
		}
		btn.onmousedown = function() {
			if (this._isEnabled) {
				this.isPressed = true;
				this.className = "button_"+this.label+"_over_pressed";
			} else {
				this.className = "button_"+this.label+"_disabled";
			}
		}
		btn.onmouseup = function() {
			if (this._isEnabled) {
				var wasPressed = this.isPressed;
				this.isPressed = false;
				this.className = "button_"+this.label+"_over_default";
				if (wasPressed) {
					if (this.checkEvent("onClick")) {
						this.callEvent("onClick", [this.win, this]);
					} else {
						this._doOnClick();
					}
				}
			} else {
				this.className = "button_"+this.label+"_disabled";
			}
		}
		var that = this;
		btn.show = function() {
			that._showButton(win, this.label);
		}
		btn.hide = function() {
			that._hideButton(win, this.label);
		}
		btn.enable = function() {
			that._enableButton(win, this.label);
		}

		btn.disable = function() {
			that._disableButton(win, this.label);
		}
		btn.isEnabled = function() {
			return this._isEnabled;
		}

		btn.isHidden = function() {
			return (!this.isVisible);
		}
		btn.subModelEvent = this.subModelEvent;
		btn.subModelEvent();
	}
	
	this._allowParking = function(win) {
		win._isParkedAllowed = true;
		this._enableButton(win, "park");
	}
	this._denyParking = function(win) {
		win._isParkedAllowed = false;
		this._disableButton(win, "park");
	}
	
	this.enableParkEffect = true;
	this.parkStartSpeed = 80;
	this.parkSpeed = this.parkStartSpeed;
	this.parkTM = null;
	this.parkTMTime = 5;
	
	
	this._enableButton = function(win, btn) {
		win.btns[btn]._isEnabled = true;
		win.btns[btn].className = "button_"+win.btns[btn].label+"_default";
	}
	
	this._disableButton = function(win, btn) {
		win.btns[btn]._isEnabled = false;
		win.btns[btn].className = "button_"+win.btns[btn].label+"_disabled";
	}
	
	
	this._allowReszieGlob = function(win) {
		win._allowResizeGlobal = true;
	}
	
	this._denyResize = function(win) {
		win._allowResizeGlobal = false;
	}
	
	this._showButton = function(win, btn) {
		win.btns[btn].isVisible = true;
		win.btns[btn].parentNode.className = "popup_wins_btn_visible";
	}
	
	this._hideButton = function(win, btn) {
		win.btns[btn].isVisible = false;
		win.btns[btn].parentNode.className = "popup_wins_btn_hidden";
	}
	
	this._showWindow = function(win) {
		win.style.display = "";
		if (win.checkEvent("onShow")) {
			win.callEvent("onShow", [win]);
		} else {
			this.callEvent("onShow", [win]);
		}
		var w = this._getActive();
		if (w == null) {
			this._bringOnTop(win);
			this._makeActive(win);
		}
	}
	
	this._closeWindow = function(win) {
		if (win.checkEvent("onClose")) {
			if (!win.callEvent("onClose", [win])) return;
		} else {
			if(!this.callEvent("onClose", [win])) return;
		}
		for (var a in win.btns) { this._removeButtonGlobal(win, a, win.btns[a]); }
		this._removeWindowGlobal(win);
		var latest = null;
		var latestZi = 0;
		for (var a in this.wins) 
		{
			if (this.wins[a].zi > latestZi) 
			{
				latest = this.wins[a];
				latestZi = this.wins[a].zi;
			}
			this.wins[a].zi -= this.zIndexStep;
			this.wins[a].style.zIndex = this.wins[a].zi;
		}
		if (latest != null)
		{
			this._makeActive(latest);
			if(latest.isModal())
			{
				if(this.modalCoverD && this.modalCoverD.style.zIndex >= latest.zi)
				{
					this.modalCoverD.style.zIndex = latest.zi - 2;
				}
				latest.setModal(true);
			}
		}
	}
	
	this._attachContent = function(win, type, obj, state) {
		while (win._content.childNodes.length > 0) { win._content.removeChild(win._content.childNodes[0]); }
		if (type == "url") {
			var fr = document.createElement("IFRAME");
			fr.frameBorder = 0;
			fr.border = 0;
			fr.style.width = "100%";
			fr.style.height = "100%";
			fr.src = obj;
			win.contentURL = obj;
			win._content.appendChild(fr);
		} else if (type == "obj") {
			win._content.appendChild(obj);
			if (state) { obj.style.display = ""; }
		}
		
		
		var cover = document.createElement("DIV");
		cover.className = "dhx_content_cover_blocker";
		cover.style.display = "none";
		win._content.appendChild(cover);
	}
	
	this._isWindowOnTop = function(win) {
		var state = (this.getTopmostWindow() == win);
		return state;
	}
	
	this._bringOnBottom = function(win) {
		for (var a in this.wins) {
			if (this.wins[a].zi < win.zi) {
				this.wins[a].zi += this.zIndexStep;
				this.wins[a].style.zIndex = this.wins[a].zi;
			}
		}
		win.zi = 50;
		win.style.zIndex = win.zi;
		this._makeActive(this.getTopmostWindow());
	}
	
	this._isWindowOnBottom = function(win) {
		var state = true;
		for (var a in this.wins) {
			if (this.wins[a] != win) {
				state = state && (this.wins[a].zi > win.zi);
			}
		}
		return state;
	}
	
	this._addUserButton = function(win, id, pos, title, label) {
		var btn = document.createElement("DIV");
		
		btn.className = "button_"+label+"_default";
		btn.title = title;
		btn.isVisible = true;
		btn._isEnabled = true;
		btn.isPressed = false;
		btn.label = label;
		win.btns[id] = btn;
		btn._doOnClick = function() {}
			
		var b = win.childNodes[2].childNodes[0].childNodes[0].childNodes[0];
		var td = document.createElement("TD");
		td.className = "popup_wins_btn_" + (btn.isVisible ? "visible" : "hidden");
		if (pos > b.childNodes.length) {
			b.appendChild(td);
		} else {
			if (pos < 0) { pos = 0; }
			b.insertBefore(td, b.childNodes[pos]);
		}
		
		td.appendChild(btn);
		
		this._attachEventsOnButton(win, btn);
	}
	
	this._removeUserButton = function(win, id, btn) {
		this._removeButtonGlobal(win, id, btn);
		
	}
	
	this._blockSwitcher = function(state) {
		for (var a in this.wins) {
			var winContent = this.wins[a]._content;
			var cover = null;
			for (var q=0; q<winContent.childNodes.length; q++) { if (winContent.childNodes[q].className == "dhx_content_cover_blocker") { cover = winContent.childNodes[q]; } }
			if (cover != null) {
				cover.style.display = (state ? "" : "none");
			}
		}
	}
	
	this.resizingWin = null;
	this.modalWin = null;
	this.resizingDirs = "none";
	
	
	this._createViewport();
	this.subModelEvent();
	
	var that = this;
	
	if (_isIE) {
		document.body.attachEvent("onmouseup", function() { that._stopMove(); });
	} else {
		document.body.addEventListener("mouseup", function() { that._stopMove(); }, false);
	}
	
	this.vp.onmousemove = function(e) {
		e = e || event;
		that._moveWindow(e);
	}
	this.vp.onmouseup = function(e) {
		e = e || event;
		that._stopMove(e);
	}
	this._setWindowModal = function(win, state) {
		if (state == true) {
			this._makeActive(win);
			this._bringOnTop(win);
			this.modalWin = win;
			win._isModal = true;
			this.modalCoverD.style.height = (document.body.scrollHeight - 4) + "px";
			this.modalCoverD.style.zIndex = win.zi - 2;
			this.modalCoverD.style.display = "";
		} else {
			this.modalWin = null;
			win._isModal = false;
			this.modalCoverD.style.height = "100%";
			this.modalCoverD.style.zIndex = 0;
			this.modalCoverD.style.display = "none";
		}
	}
	
	this.unload = function() {
		this._clearLeaks();
	}
	this._removeButtonGlobal = function(win, id, btn) {
		btn.onmouseover = null;
		btn.onmouseout = null;
		btn.onmousedown = null;
		btn.onmouseup = null;
		btn._doOnClick = null;
		btn.clearAllEvents();
		btn.subModelEvent = null;
		btn.show = null;
		btn.hide = null;
		btn.enable = null;
		btn.disable = null;
		btn.isEnabled = null;
		btn.isHidden = null;
		btn.isVisible = null;
		btn._isEnabled = null;
		btn.isPressed = null;
		btn.label = null;
		btn.parentNode.removeChild(btn);
		delete win.btns[id];
	}
	this._removeWindowGlobal = function(win) {
		if (this.modalWin == win) { this._setWindowModal(win, false); }
		var winContent = win.childNodes[0].childNodes[0].childNodes[1].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[1].childNodes[0];
		if (winContent != null) {
			winContent.parentNode.removeChild(winContent);
		}
		var hdr = win.childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0];
		hdr.onmousedown = null;
		hdr = null;
		var htl = win.childNodes[2];
		htl.onmousedown = null;
		htl = null;
		win.clearAllEvents();
		win.subModelEvent = null;
		win.setText = null;
		win.getText = null;
		win.getId = null;
		win.show = null;
		win.close = null;
		win.setModal = null;
		win.isModal = null;
		win.allowResize = null;
		win.denyResize = null;
		win.isResizable = null;
		win.allowMove = null;
		win.denyMove = null;
		win.isMovable = null;
		win.sendToFront = null;
		win.sendToBack = null;
		win.isOnTop = null;
		win.isOnBottom = null;
		win.setPosition = null;
		win.getPosition = null;
		win.setDimension = null;
		win.getDimension = null;
		win.setMaxDimension = null;
		win.getMaxDimension = null;
		win.setMinDimension = null;
		win.getMinDimension = null;
		win.addUserButton = null;
		win.removeUserButton = null;
		win.onmousemove = null;
		win.onmousedown = null;
		win.button = null;
		win.attachObject = null;
		win.attachURL = null;
		win.parentNode.removeChild(win);
		delete this.wins[win.idd];
	}
	
	this._clearLeaks = function() {
		for (var a in this.wins) {
			var win = this.wins[a];
			this._diableOnSelectInWin(win, false);
			
			for (b in win.btns) { this._removeButtonGlobal(win, b, win.btns[b]); }
			
			this._removeWindowGlobal(win);
			
		}
		
		this._showButton = null;
		this._hideButton = null;
		this._enableButton = null;
		this._disableButton = null;
		
		this._removeButtonGlobal = null;
		this._removeWindowGlobal = null;
		
		this.autoViewport = null;
		this._createViewport = null;
		this._autoResizeViewport = null;
		this.vp.parentNode.removeChild(this.vp);
		this.vp = null;
		
	}

	if (_isIE) {
		document.body.attachEvent("onselectstart", function(e) {
			e = e||event;
			if (that.resizingWin != null) { e.returnValue = false; }
		});
	}
	
	return this;
}
subModelWindows.prototype.subModelEvent = function() {

	this.attachEvent = function(original, catcher, CallObj) {
		CallObj = CallObj||this;
		original = 'ev_'+original;
		if ((!this[original]) || (!this[original].addEvent)) {
			var z = new this.eventCatcher(CallObj);
			z.addEvent(this[original]);
			this[original] = z;
		}
		return (original + ':' + this[original].addEvent(catcher)); //return ID (event name & event ID)
	}
	this.callEvent = function(name,arg0) {
		if (this["ev_"+name]) return this["ev_"+name].apply(this,arg0);
		return true;
	}
	this.checkEvent = function(name){
		if (this["ev_"+name]) return true;
		return false;
	}
	this.eventCatcher = function(obj) {
		var subcatch = new Array();
		var m_obj = obj;
		var func_server = function(catcher,rpc) {
			catcher = catcher.split(":");
			var postVar = "";
			var postVar2 = "";
			var target = catcher[1];
			if (catcher[1] == "rpc") {
				postVar = '<?xml version="1.0"?><methodCall><methodName>'+catcher[2]+'</methodName><params>';
				postVar2 = "</params></methodCall>";
				target = rpc;
			}
			var z = function() { }
			return z;
		}
		var z = function() {
			if (subcatch) var res=true;
			for (var i=0; i<subcatch.length; i++) {
				if (subcatch[i] != null) {
					var zr = subcatch[i].apply( m_obj, arguments );
					res = res && zr;
				}
			}
			return res;
		}
		z.addEvent = function(ev) {
			if (typeof(ev) != "function")
				if (ev && ev.indexOf && ev.indexOf("server:") == 0)
					ev = new func_server(ev,m_obj.rpcServer);
				else
					ev = eval(ev);
				if (ev)
					return subcatch.push( ev ) - 1;
			return false;
		}
		z.removeEvent = function(id) {
			subcatch[id] = null;
		}
		return z;
	}
	this.detachEvent = function(id) {
		if (id != false) {
			var list = id.split(':'); //get EventName and ID
			this[ list[0] ].removeEvent(list[1]); //remove event
		}
	}
	this.clearAllEvents = function() {
		this.ev_onClick = null;
		this.ev_onMoveFinish = null;
		this.ev_onResizeFinish = null;
		this.ev_onFocus = null;
		this.ev_onParkDown = null;
		this.ev_onParkUp = null;
		this.ev_onMaximize = null;
		this.ev_onMinimize = null;
		this.ev_onShow = null;
		this.ev_onHide = null;
		this.ev_onClose = null;
		this.ev_onHelp = null;
	}
}

var subModelWins = null;

/**
*   @desc: rewrite create window for originally
*   @param: url
*   @param: title
*   @param: width
*   @param: height
*   @param: modal
*   @param: imgpath
*   @type: public
*/
function createwindow(url, title, width, height, modal, imgpath,pageURL)
{
	if(subModelWins == null)
	{
		subModelWins = new subModelWindows();
		subModelWins.enableAutoViewport(true);
	}
	var count = 0;
	for(var a in subModelWins.wins)
	{
		count++;
	}
	if(typeof(pageURL) == "undefined" || pageURL == null)
	{
		pageURL = window.location.href;
	}
	var pos = pageURL.lastIndexOf("/");
	var page = pageURL.substring(pos + 1);
	var w1 = subModelWins.createWindow("popupFrame" + count, 10, 10, width, height,page);
	w1.center();
	w1.setText(title);
	w1.attachURL(url);
	w1.setModal(modal);
}

/**
*   @desc: rewrite close dialog for originally
*   @type: public
*/
function closeDialog()
{
	if(subModelWins != null)
	{
		var win = subModelWins.getTopmostWindow(true);
		
		if(win != null)
		{
			win.close();
		}
	}
}

function closeSpecifyDialog(pagename)
{
	if(subModelWins != null)
	{
		var win = subModelWins.getSpecifyWindow(pagename);
		if(win != null)
		{
			win.close();
		}
	}
}

function getSubModelParentWin(url)
{
	var pos = url.lastIndexOf("/");
	var pagename = url.substring(pos + 1);
	var pWinTmp = null;
	if(subModelWins != null)
	{
		if(pagename.indexOf("?") > 0)
		{
			pagename = pagename.substring(0,pagename.indexOf("?"));
		}
		pWinTmp = subModelWins.getSpecifyWindow(pagename);
		if(isIE)
		{
			if (window.dialogArguments && dialogArguments.location)
			{
				pWinTmp = window.dialogArguments;
			}
			else if (window.opener)
			{
				pWinTmp = window.opener;
			}
		}
		else
		{
			if(pWinTmp != null)
			{
				var frameIndex = -1;
				var iframeArray = document.getElementsByTagName("iframe");
				for ( var i = 0; i < iframeArray.length; i++)
				{
					if (iframeArray[i].src.indexOf("/" + pWinTmp.parentPage) > 0)
					{
						frameIndex = i;
						break;
					}
				}
				if(frameIndex >= 0)
				{
					pWinTmp = window.frames[frameIndex];
				}
				else
				{
					pWinTmp = null;
				}
			}
		}
	}
	return pWinTmp;
}
/**
*   @desc: resize window for height
*   @param: height
*   @type: public
*/
function resizeTo(height)
{
	if(subModelWins != null)
	{
		var win = subModelWins.getTopmostWindow(true);
		
		if(win != null)
		{
			win.setDimension(win.w,height);
		}
	}
}
