/*
 *Spin      
*/
function SpinTable(basicVar)
{
    this.iCurrentPos = 0; //      
    this.iStep = 1; //  
    this.iLowerLimit = 0; //    
    this.iUpperLimit = 10; //    
    
    this.isInteger = true; //      
    
    this.circular = true; //  
    this.editable = true; //     
    this.hasOutRangAlert = true; //      
    
    this.isTime = false; //      
    
    this.textNode = null;
    this.hourTxtNode = null;
    this.midTxtNode = null;
    this.secondTxtNode = null;
    this.upbtn = null;
    this.downbtn = null;
    
    this.focusNode = null;
    
    if(basicVar)
    {
        this.initStatus(basicVar);
    }
    this.element = document.createElement("table");
    this.element.setAttribute("border","0");                                  
    this.element.setAttribute("cellspacing","0");
    this.element.setAttribute("cellpadding","0");
    var spinbody = document.createElement("tbody");
    
    var spintr = document.createElement("tr");
    var texttd = document.createElement("td");
    texttd.className = "tdstyle";
    texttd.setAttribute("rowSpan","2");
    
    if(this.isInteger)
    {
    	this.textNode = document.createElement("input");
        this.textNode.setAttribute("type","text");
        this.textNode.className = "spinText";
        this.textNode.onpaste = returnFalse;
        this.textNode.ondrag = returnFalse;
        this.textNode.value = this.iCurrentPos;
        this.textNode.parent = this;
        
        this.textNode.onblur = function()
        {
        	onBlur(this);
        }
        
        this.textNode.onkeypress = function(evt)
        {
            return integerLimit(this,evt);
        }
        
        texttd.appendChild(this.textNode);
        spintr.appendChild(texttd);
    }
    else
    {
        this.hourTxtNode = document.createElement("input");
        this.hourTxtNode.setAttribute("type","text");
        this.hourTxtNode.setAttribute("id","hourTxt");
        this.hourTxtNode.className = "spinText";
        this.hourTxtNode.style.width = "20px";
        this.hourTxtNode.style.borderRight = "0px";
        this.hourTxtNode.value = "00";
        this.hourTxtNode.parent = this;
        this.hourTxtNode.onpaste = returnFalse;
        this.hourTxtNode.ondrag = returnFalse;
        
        
        this.hourTxtNode.onfocus = this.getFocusPos;
        this.hourTxtNode.onclick = this.getFocusPos;
        
        this.hourTxtNode.onkeydown = function(evt)
        {
            return hourLimit(this,evt);
        }
        this.focusNode = this.hourTxtNode;
        texttd.appendChild(this.hourTxtNode);
        
        this.midTxtNode = document.createElement("input");
        this.midTxtNode.setAttribute("type","text");
        this.midTxtNode.className = "spinText";
        this.midTxtNode.style.width = "7px";
        this.midTxtNode.style.borderLeft = "0px";
        this.midTxtNode.value = ":";
        this.midTxtNode.parent = this;
        this.midTxtNode.readOnly = true; 
        
        texttd.appendChild(this.midTxtNode);
        
        this.secondTxtNode = document.createElement("input");
        this.secondTxtNode.setAttribute("id","secondTxt");
        this.secondTxtNode.setAttribute("type","text");
        this.secondTxtNode.className = "spinText";
        this.secondTxtNode.style.width = "30px";
        this.secondTxtNode.style.borderLeft = "0px";
        this.secondTxtNode.value = "00";
        this.secondTxtNode.parent = this;
        this.secondTxtNode.onpaste = returnFalse;
        this.secondTxtNode.ondrag = returnFalse;
        
        this.secondTxtNode.onclick = this.getFocusPos;
        this.secondTxtNode.onfocus = this.getFocusPos;
        
        this.secondTxtNode.onkeydown = function(evt)
        {
            return secondLimit(this,evt);
        } 
        
        texttd.appendChild(this.secondTxtNode);
        spintr.appendChild(texttd);
    }
    
    var upbtntd = document.createElement("td");
    upbtntd.className = "tdstyle";
    this.upbtn = document.createElement("input");
    this.upbtn.setAttribute("type","button");
    this.upbtn.tabIndex = -1;
    this.upbtn.className = "upbutton";
    this.upbtn.parent = this;
    
    this.upbtn.onclick = function()
    {
    	onClickUp(this);
    }
    this.upbtn.ondblclick = function()
    {
    	onClickUp(this);
    }
    
    upbtntd.appendChild(this.upbtn);
    spintr.appendChild(upbtntd);
    
    spinbody.appendChild(spintr);
    
    spintr = document.createElement("tr");
    
    var downbtntd = document.createElement("td");
    downbtntd.className = "tdstyle";
    this.downbtn = document.createElement("input");
    this.downbtn.setAttribute("type","button");
    this.downbtn.tabIndex = -1;
    this.downbtn.className = "downbutton";
    this.downbtn.parent = this;
    
    this.downbtn.onclick = function()
    {
    	onClickDown(this);
    }
    this.downbtn.ondblclick = function()
    {
    	onClickDown(this);
    }
    
    downbtntd.appendChild(this.downbtn);
    spintr.appendChild(downbtntd);
    
    spinbody.appendChild(spintr);
    this.element.appendChild(spinbody); 
    
    var editable = this.editable;
    this.readOnly(!editable);
}

/*
 *      spinner
*/
SpinTable.prototype.disabled = function(isForbid)
{
     if(this.isInteger)
     {
         this.textNode.disabled = isForbid;
     }
     else
     {
         this.hourTxtNode.disabled = isForbid;
         this.midTxtNode.disabled = isForbid;
         this.secondTxtNode.disabled = isForbid;
     }
     
     this.upbtn.disabled = isForbid;
     this.downbtn.disabled = isForbid;
}

SpinTable.prototype.readOnly = function(setReadOnly)
{
    if(this.isInteger)
    {
        this.textNode.readOnly = setReadOnly;
    }
    else
    {
        this.hourTxtNode.readOnly = setReadOnly;
        this.secondTxtNode.readOnly = setReadOnly;
    }
}

SpinTable.prototype.initStatus = function(basicVar)
{
	if(null != basicVar["iCurrentPos"])
	{
	    this.iCurrentPos = basicVar["iCurrentPos"];
	}
	if(null != basicVar["iStep"])
	{
	    this.iStep = basicVar["iStep"];
	}
	if(null != basicVar["isInteger"])
	{
	    this.isInteger = basicVar["isInteger"];
	    this.isTime = !this.isInteger;
	}
	if(this.isInteger)
	{
	    if(null != basicVar["iLowerLimit"])
	    {
	    	this.iLowerLimit = basicVar["iLowerLimit"];
        }
	    if(null != basicVar["iUpperLimit"])
	    {
	        this.iUpperLimit = basicVar["iUpperLimit"];
	    }
	}
	if(null != basicVar["circular"])
	{
	    this.circular = basicVar["circular"];
	}
	if(null != basicVar["editable"])
	{
	    this.editable = basicVar["editable"];
	}
	if(null != basicVar["hasOutRangAlert"])
	{
	    this.hasOutRangAlert = basicVar["hasOutRangAlert"];
	}
}

SpinTable.prototype.getFocusPos = function()
{
    this.parent.focusNode = this;
}

SpinTable.prototype.getiCurrentPos = function()
{
    if(this.isInteger)
    {
        if(null != this.textNode.value)
        {
            iCurrentPos = this.textNode.value;
        }
    }
    else
    {
        if(null != this.hourTxtNode.value)
        {
            iCurrentPos = this.hourTxtNode.value;
        }
        else
        {
            iCurrentPos = "00";
        }
        if(null != this.secondTxtNode.value)
        {
            iCurrentPos = iCurrentPos + ":" + this.secondTxtNode.value;
        }
        else
        {
            iCurrentPos = iCurrentPos + ":00";
        }
    }
    return iCurrentPos;
}

SpinTable.prototype.getHours = function()
{
    if(this.isTime)
    {
        return this.hourTxtNode.value;
    }
    return null;
}

SpinTable.prototype.getMinutes = function()
{
    if(this.isTime)
    {
        return this.secondTxtNode.value;
    }
    return null;
}

SpinTable.prototype.addUpBtnListener = function(func)
{
    if(this.isInteger)
    {
        this.upbtn.onclick = function()
        {
            onClickUp(this, func);
        }
        this.upbtn.ondblclick = function()
        {
            onClickUp(this, func);
        }
    }
}

SpinTable.prototype.setCurrentValue = function()
{

    if(this.isInteger)
    {
        if((null != arguments[0]) && (parseInt(arguments[0]) >= this.iLowerLimit) && (parseInt(arguments[0]) <= this.iUpperLimit))
        {
            this.textNode.value = arguments[0];
        }
    }
    else if(this.isTime)
    {
        if((null != arguments[0]) && (parseInt(arguments[0]) >= 0) && (parseInt(arguments[0]) <= 23))
        {
            if(1 == arguments[0].toString().length)
            {
                this.hourTxtNode.value = "0" + arguments[0];
            }
            else if(2 == arguments[0].toString().length)
            {
                this.hourTxtNode.value = arguments[0];
            }
        }
        if((null != arguments[1]) && (parseInt(arguments[1]) >= 0) && (parseInt(arguments[1]) <= 59))
        {
            if(1 == arguments[1].toString().length)
            {
                this.secondTxtNode.value = "0" + arguments[1];
            }
            else if(2 == arguments[1].toString().length)
            {
                this.secondTxtNode.value = arguments[1];
            }
        }
    }
}

SpinTable.prototype.addDownBtnListener = function(func)
{
    if(this.isInteger)
    {
        this.downbtn.onclick = function()
        {
            onClickDown(this, func);
        }
        this.downbtn.ondblclick = function()
        {
            onClickDown(this, func);
        }
    }
}

SpinTable.prototype.addBlurListener = function(func)
{
    if(this.isInteger)
    {
        this.textNode.onblur = function()
        {
            onBlur(this, func);
        }
    }
}

SpinTable.prototype.addChangeListener = function(func)
{
    if(this.isInteger)
    {
        this.textNode.onchange = function()
        {
            eval(func);
        }
        
        this.textNode.onkeypress = function(evt)
        {
            var flag = integerLimit(this,evt);
            if(flag)
            {
                eval(func);	
            }
            return flag;
        }
        
        this.downbtn.onclick = function()
        {
            onClickDown(this, func);
        }
        this.downbtn.ondblclick = function()
        {
            onClickDown(this, func);
        }
        
        this.upbtn.onclick = function()
        {
            onClickUp(this, func);
        }
        this.upbtn.ondblclick = function()
        {
            onClickUp(this, func);
        }
    }
}

/**
 *         
*/
function digitalTag_getPos(obj)
{
	if (isIE)
	{
		var ml = obj.value.length;
		var pos = 0;
		var rng = document.selection.createRange();
		rng.moveEnd('character', ml);
		try
		{
			pos = ml - rng.text.length;
		}
		catch (e)
		{
		}
		return pos;
	}
	else
	{
		return obj.selectionStart;
	}
}

function selectionLen(obj)
{
	if (isIE)
	{
		return document.selection.createRange().text.length;
	}
	else
	{
		return obj.selectionEnd - obj.selectionStart;
	}
}
/**
 *     Spinner      
*/
function integerLimit(obj,evt)
{
	evt = evt?evt:window.event;
    var code=evt.keyCode != 0 ? evt.keyCode : evt.charCode;
    var ch = String.fromCharCode(code);

	if (code == 9 || code == 8 || code == 127)
	{
		return true; // DEL   
	}

	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}
	if (evt.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A')
		{ // X C V A
			return true;
		}
		else
		{
			return false;
		}
	}
	if (code < 48 || code > 57)
	{
		return false; //       
	}

    var value = obj.value;
    var pos = digitalTag_getPos(obj);
    if(obj.parent.iLowerLimit < 0)
    {
        if((0 == pos) && (189 == code || 109 == code))
        {
            return true;
        }
        if(("-" == value) && (48 == code || 96 == code))
        {
            return false;
        }
    }
    
    if(('0' == value) && pos > 0)
    {
        obj.value = "";
        return true;
    }
    
    if(code < 58)
    {
        ch = '' + code - 48;
    }
    else
    {
        ch = '' + code - 96;
    }

    if((0 == pos) && (value.length > 0) && (48 == code || 96 == code) && (value.length != selectionLen(obj)))
    { 
        return false;
    }
    
    var newVal = value.substring(0, pos) + ch + value.substring(pos + selectionLen(obj));
    if(parseInt(newVal,10) > obj.parent.iUpperLimit)
    {
        obj.value = obj.parent.iUpperLimit;
        if(obj.parent.hasOutRangAlert)
        {
            alert(RESOURCE["wrong1"] + obj.parent.iLowerLimit + RESOURCE["wrong2"] + obj.parent.iUpperLimit + RESOURCE["wrong3"]);
        }
        return false;
    }
    if((obj.parent.iLowerLimit < 0) && (parseInt(newVal, 10) < obj.parent.iLowerLimit))
    {
        obj.value = obj.parent.iLowerLimit;
        if(obj.parent.hasOutRangAlert)
        {
            alert(RESOURCE["wrong1"] + obj.parent.iLowerLimit + RESOURCE["wrong2"] + obj.parent.iUpperLimit + RESOURCE["wrong3"]);
        }
        return false;
    }
    return true;
}

/**
 *     Spinner       
*/
function hourLimit(obj,evt)
{
	evt = evt?evt:window.event;
    var code=evt.keyCode != 0 ? evt.keyCode : evt.charCode;
    var ch = String.fromCharCode(code);
    var value = obj.value;
    var pos = digitalTag_getPos(obj);
    
    var selectLen = selectionLen(obj);
    if(0 == pos)
    {
        if((code >= 48 && code <= 50) || (code >= 96 && code <= 98))
        {
            if((50 == code || 98 == code) && (obj.value.charAt(1) > 3))
            {
                obj.value = 23;
                return false;
            }
            if(selectLen == 0)
            {
            	if(isIE)
            	{
            		var selectRng = document.selection.createRange();
                	selectRng.moveEnd("character", 1);
                	selectRng.text = "";
            	}
            	else
            	{
            		var newVal = value.substring(0, pos) + ch
						+ value.substring(pos + 1);
					obj.value = newVal;
					obj.selectionEnd = pos + 1;
            	}
                return true;
            }
            else if(1 == selectLen)
            {
                return true;
            }
            else
            {
            	if(isIE)
            	{
	                document.selection.clear();
	                
	                selectRng = document.selection.createRange();
	                selectRng.move("character", -1);
	                selectRng.select();
            	}
            	obj.value = 0;
                return true;
            }
            return false;
        }
        if((code > 50 && code <= 57) || (code > 98 && code <= 105))
        {
            obj.value = 23;
            obj.parent.secondTxtNode.focus();
            obj.parent.secondTxtNode.value = 59;
            return false;
        }
        if(39 == code)
        {
            return true
        }
        
        if(8 == code)
        {
            handleBackSpacePos0(obj);
        }
        return false;
        
    }
    
    if(1 == pos)
    {
        if((code >= 48 && code <= 57) || (code >= 96 && code <= 105))
        {
            if(2 == obj.value.charAt(0) && ((code > 52 && code <= 57) || (code > 100 && code <= 105)))
            {
                obj.value = 23;
                return false;
            }
            if(0 == selectLen)
            {
            	if(isIE)
            	{
	            	var selectRng = document.selection.createRange();
	                selectRng.moveEnd("character", 1);
	                selectRng.text = "";
            	}
            	else
            	{
            		var newVal = value.substring(0, pos) + ch
						+ value.substring(pos + 1);
					obj.value = newVal;
					obj.selectionEnd = pos + 1;
            	}
                return true;
            }
            if(1 == selectLen)
            {
                return true;
            }
            return false;
        }
        if(39 == code || 37 == code)
        {
            return true;
        }
        
        handleBackSpacePos1(obj, selectRng);
        return false;
    }
    if(2 == pos)
    {
        if(37 == code)
        {
            return true;
        }
        if(39 == code)
        {
            obj.parent.secondTxtNode.focus();
            return false;
        }
        if((code >= 48 && code <= 53) || (code >= 96 && code <= 101))
        {
        	obj.parent.secondTxtNode.value = obj.parent.secondTxtNode.value.charAt(1);
        	obj.parent.secondTxtNode.focus();
            return true;
        }
        if(8 == code)
        {
            handleBackSpacePos2(obj, selectRng);
        }
        return false;
    }
}

function secondLimit(obj,evt)
{
	evt = evt?evt:window.event;
    var code=evt.keyCode != 0 ? evt.keyCode : evt.charCode;
    var ch = String.fromCharCode(code);
    var value = obj.value;
    var pos = digitalTag_getPos(obj);
    
    var selectRng = document.selection.createRange();
    
    if(0 == pos)
    {
        if((code >= 48 && code <= 53) || (code >= 96 && code <= 101))
        {
            if(0 == selectRng.text.length)
            {
                selectRng.moveEnd("character", 1);
                selectRng.text = "";
                return true;
            }
            else if(1 == selectRng.text.length)
            {
                return true;
            }
            else
            {
                document.selection.clear();
                obj.value = 0;
                selectRng = document.selection.createRange();
                selectRng.move("character", -1);
                selectRng.select();
                return true;
            }
            return false;
        }

        if((code > 53 && code <= 57) || (code > 101 && code <= 105))
        {
            obj.value = 59;
            obj.focus();
            return false;
        }
        if(39 == code)    
        {
            return true;
        }
        if(37 == code)
        {
            obj.parent.hourTxtNode.focus();
            obj.parent.hourTxtNode.value = obj.parent.hourTxtNode.value;
            return false;
        }
        if(8 == code)
        {
            handleBackSpacePos0(obj);
        }
        return false;
    }
    
    if(1 == pos)
    {
        if((code >= 48 && code <= 57) || (code >= 96 && code <= 105))
        {
            if(0 == selectRng.text.length)
            {
                selectRng.moveEnd("character", 1);
                selectRng.text = "";
                return true;
            }
            else if(1 == selectRng.text.length)
            {
                return true;
            }
            return false;
        }
        if(37 == code || 39 == code)
        {
            return true;
        }
        if(8 == code)
        {
            handleBackSpacePos1(obj,selectRng)
        }
        return false;
    }
    
    if(2 == pos)
    {
        if(37 == code)
        {
            return true;
        }
        if(8 == code)
        {
            handleBackSpacePos2(obj,selectRng)
        }
        return false;
    }
}

function handleBackSpacePos0(obj)
{
	var selectLen = selectionLen(obj);
	
    if(1 == selectLen)
    {
        var tempcha = obj.value.charAt(1);
        obj.value = "0" + tempcha;
        if(isIE)
        {
        	document.selection.clear();
	        selectRng = document.selection.createRange();
	        selectRng.move("character", -2);
	        selectRng.select();
        }
        return false;
    }
    else if(2 == selectLen)
    {
    	obj.value = "00";
    	if(isIE)
        {
	        document.selection.clear();
	        selectRng = document.selection.createRange();
	        selectRng.move("character", -2);
	        selectRng.select();
        }
        return false;
    }
    if(isIE)
    {
	    if("secondTxt" == selectRng.parentElement().id)
	    {
	        if(0 == selectLen)
	        {
	            obj.parent.hourTxtNode.focus();
	            selectRng = document.selection.createRange();
	            selectRng.move("character", 2);
	            selectRng.select();
	            return false;
	        }
	    }
    }
    return false;
}

function handleBackSpacePos1(obj, selectRng)
{
    if(1 == selectRng.text.length)
    {
        document.selection.clear();
        obj.value = obj.value + "0";
        selectRng = document.selection.createRange();
        selectRng.move("character", -1);
        selectRng.select();
    }
    else if(0 == selectRng.text.length)
    {
        obj.value = "0" + obj.value.charAt(1);
        selectRng.move("character", -2);
        selectRng.select();
    }
    return false;
}

function handleBackSpacePos2(obj, selectRng)
{
    obj.value = obj.value.charAt(0) + "0";
    selectRng = document.selection.createRange();
    selectRng.move("character", -1);
    selectRng.select();
    return false;
}

function onBlur(obj, func)
{
    if("" == obj.value || (obj.value < obj.parent.iLowerLimit))
    {
        obj.value = obj.parent.iLowerLimit;
        obj.select();
        if(obj.parent.hasOutRangAlert)
        {
            alert(RESOURCE["wrong1"] + obj.parent.iLowerLimit + RESOURCE["wrong2"] + obj.parent.iUpperLimit + RESOURCE["wrong3"]);
        }
    }
    if(obj.value > obj.parent.iUpperLimit)
    {
        obj.value = obj.parent.iUpperLimit;
        obj.select();
        if(obj.parent.hasOutRangAlert)
        {
            alert(RESOURCE["wrong1"] + obj.parent.iLowerLimit + RESOURCE["wrong2"] + obj.parent.iUpperLimit + RESOURCE["wrong3"]);
        }
    }
    
    if(func)
    {
        eval(func);
    }
}

function onClickUp(obj, func)
{
    var tempobj;
    var value;
    if(obj.parent.isInteger)
    {
        tempobj = obj.parent.textNode;
        value = parseInt(tempobj.value) + tempobj.parent.iStep;
    }
    else
    {
        tempobj = obj.parent.focusNode;
        if("0" == tempobj.value.charAt(0))
        {
            value = parseInt(tempobj.value.charAt(1)) + tempobj.parent.iStep;
        }
        else
        {
            value = parseInt(tempobj.value) + tempobj.parent.iStep;
        }
        
        obj.parent.iLowerLimit = 0;
        obj.parent.circular = true;
        if("secondTxt" == tempobj.id)
        {
            obj.parent.iUpperLimit = 59;
        }
        else if("hourTxt" == tempobj.id)
        {
            obj.parent.iUpperLimit = 23;
        }
    }
    
    if((parseInt(tempobj.value) > obj.parent.iUpperLimit) || (parseInt(tempobj.value) < obj.parent.iLowerLimit))
    {
        return;
    }
    
    if(value <=  obj.parent.iUpperLimit)
    {
        if((obj.parent.isTime) && (value < 10))
        {
            tempobj.value = "0" + value;
        }
        else
        {
            tempobj.value = value;
        }
    }
    else
    {
        if(obj.parent.circular)
        {
            var	delta = value - obj.parent.iUpperLimit;
			value = ( obj.parent.iLowerLimit - 1 ) + delta;
			if(value < 10 && obj.parent.isTime)
			{
			    tempobj.value = "0" + value;
			}
			else
			{
			    tempobj.value = value;	
			}
        }
    }
    if(func)
    {
        eval(func);
    }
}

function onClickDown(obj, func)
{
    var tempobj;
    var value;
    if(obj.parent.isInteger)
    {
        tempobj = obj.parent.textNode;
        value = parseInt(tempobj.value) - tempobj.parent.iStep;
    }
    else
    {
        tempobj = obj.parent.focusNode;
        if("0" == tempobj.value.charAt(0))
        {
            value = parseInt(tempobj.value.charAt(1)) - tempobj.parent.iStep;
        }
        else
        {
            value = parseInt(tempobj.value) - tempobj.parent.iStep;
        }
        
        obj.parent.iLowerLimit = 0;
        obj.parent.circular = true;
        if("secondTxt" == tempobj.id)
        {
            obj.parent.iUpperLimit = 59;
        }
        else if("hourTxt" == tempobj.id)
        {
            obj.parent.iUpperLimit = 23;
        }
    }
    
    if((parseInt(tempobj.value) > obj.parent.iUpperLimit) || (parseInt(tempobj.value) < obj.parent.iLowerLimit))
    {
        return;
    }

    if(value >= obj.parent.iLowerLimit)
    {
        if((obj.parent.isTime) && (value < 10))
        {
            tempobj.value = "0" + value;
        }
        else
        {
            tempobj.value = value;
        }
    }
    else
    {
        if(obj.parent.circular)
        {
            var delta = obj.parent.iLowerLimit - value;
			value = ( obj.parent.iUpperLimit + 1 ) - delta;
			if(value < 10 && obj.parent.isTime)
			{
			    tempobj.value = "0" + value;
			}
			else
			{
			    tempobj.value = value;
			}
        }
    }
    if(func)
    {
        eval(func);
    }
}
