window.tabs = [];

function Tabs()
{
	this.id = window.tabs.length;
	window.tabs[this.id] = this;
	this.TabHead = document.createElement("div");
	this.TabHead.appendChild(document.createElement("ul"));
	this.TabBody = document.createElement("div");
	this.TabBody.setAttribute("align", "center");
	this.TabFrame = document.createElement("iframe");
	this.TabFrame.setAttribute("align", "center");
	this.TabFrame.setAttribute("name", "tabs_iframe_" + this.id);
	this.TabFrame.setAttribute("id", "tabs_iframe_" + this.id);

	this.TabBody.appendChild(this.TabFrame);
	this.addTabs = new Array();
	this.loadOver = 0;
	this.selectTabid;
	this.selectTabClass = "";
	this.t_headClass = "";
	this.t_bodyClass = "";
	this.tabNodes = new Object();
	this.selectFlag = true;
	var _this = this;
	tabsEvent(window, "unload", function(){_this.clear()});
	tabsEvent(this.TabFrame, "load",readystatechange);
	this.getAllTabsID = function()
	{
		var result = [];
		for ( var key in this.tabNodes)
		{
			result.push(key);
		}
		return result;
	}
	
	this.clear = function()
	{
		var nodes = this.tabNodes;
		for(var a in nodes)
		{
			nodes[a].clear();
		}
		this.tabNodes = null;
		this.TabBody.removeChild(this.TabFrame);
		if(this.TabBody.parentElement)
		{
			this.TabBody.parentElement.removeChild(this.TabBody);
		}
		if(this.TabHead.parentElement)
		{
			this.TabHead.parentElement.removeChild(this.TabHead);
		}
		this.TabHead = null;
		this.TabBody = null;
		this.TabFrame = null;
		this.selectTabClass = "";
		this.t_headClass = "";
		this.t_bodyClass = "";
		delete this.selectTabid;
		this.selectTabid = null;
	}

	this.getSelectedTabIndex = function()
	{
		var tempCount = -1;
		for ( var key in this.tabNodes)
		{
			tempCount++;
			if (this.tabNodes[key].id == this.selectTabid)
			{
				return tempCount;
			}
		}
		return -1;
	}

	this.addTab = function(tid, headstr, burl, imgurl)
	{
		if(getTabsNEIDFromURL(burl) == null)
		{
			var neid = getTabsNEIDFromURL(window.location.search);
			if(neid == null && getParentWindow(window))
		    {
		    	neid = getTabsNEIDFromURL(getParentWindow(window).location.search)
		    }
		    if(neid != null)
			{
				if(burl.indexOf("?") != -1)
				{
					burl = burl + "&neid=" + neid;
				}
				else
				{
					burl = burl + "?neid=" + neid;
				}
			}
		}
		if (typeof this.tabNodes[tid] == "undefined")
		{
			this.add(tid, headstr, burl, imgurl);
		}
		else
		{
			this.removeTabNode(tid);
			this.add(tid, headstr, burl, imgurl)
		}
	}

	this.insertTabAt = function(tid, headstr, burl, imgurl, insertAt)
	{
		this.add(tid, headstr, burl, imgurl, insertAt);
	}

	this.getTab = function(tid)
	{

		if (typeof this.tabNodes[tid] == "undefined")
		{

			return null;
		}
		else
		{

			return this.tabNodes[tid];
		}

	}

	this.add = function(tid, headstr, burl, imgurl, insertAt)
	{
		var tabs = this.tabNodes;
		var result = [];
		var t = new Tab(tid, headstr, burl, imgurl)
		this.tabNodes[tid] = t;
		if (typeof this.selectTabid != "undefined")
		{
			this.tabNodes[this.selectTabid].head.className = this.t_headClass;
		}
		this.tabNodes[tid].head.firstChild.setAttribute("href",
				"javascript:void window.tabs[" + this.id + "].selectTab('"
						+ tid + "');");
		this.tabNodes[tid].head.className = this.t_headClass;
		this.tabNodes[tid].body = this.TabFrame;
		this.TabHead.firstChild.appendChild(this.tabNodes[tid].head);
		if (insertAt)
		{
			this.TabHead.firstChild.insertBefore(this.tabNodes[tid].head,
					this.tabNodes[insertAt].head);
		}
		this.addTabs.push(tid);
	}

	this.getSelectedTabID = function()
	{
		if (this.selectTabid != null)
		{
			return this.selectTabid;
		}
		return -1;
	}

	function readystatechange()
	{
		var srcName = "";
		if (isIE)
		{
			srcName = arguments[0].srcElement.name;
		}
		else
		{
			srcName = arguments[0].currentTarget.name;
		}
		for(var i = 0,m = window.tabs.length;i < m;i++)
		{
			if(window.tabs[i].TabFrame.name == srcName)
			{
				window.tabs[i].selectFlag = false;
			}
		}
	}

	this.setClass = function(theadstr, tbodystr, hcontentstr, t_hstr, t_bstr,
			t_selectstr)
	{
		this.TabHead.className = theadstr;
		this.TabBody.className = tbodystr;
		this.TabHead.firstChild.className = hcontentstr;
		this.t_headClass = t_hstr;
		this.t_bodyClass = t_bstr;
		this.selectTabClass = t_selectstr;
	}

	this.selectTab = function(key)
	{
		if (key == "BoardView")
		{
			getModify(getNeProperty(top).neid);
			if (state)
			{
				if (confirm(RESOURCE["ismodify"]))
				{
					this.gotoPage(key);
				}

			}
			else
			{
				this.gotoPage(key);
			}
		}
		else
		{
			if(this.selectTabid != key)
			{
				this.gotoPage(key);
			}
		}
	}

	this.gotoPage = function(key)
	{
		if (getNeProperty(top) != null)
		{
			setTIDOnchangeModify(
					"../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
							+ getNeProperty(top).neid + "&isModify=", false);
		}
		if (this.tabNodes[this.selectTabid])
		{
			this.tabNodes[this.selectTabid].head.className = this.t_headClass;
			this.tabNodes[this.selectTabid].head.firstChild.style.color = "#000000";
			var oldTabWin = this.getTabWindow(this.selectTabid);
			if (oldTabWin && oldTabWin.hideMenu)
			{
				oldTabWin.hideMenu();
			}
		}
		if (!this.tabNodes[key])
		{
			return;
		}
		this.selectTabid = key;
		this.selectFlag = true;
		this.tabNodes[key].head.className = this.selectTabClass;
		this.tabNodes[this.selectTabid].head.firstChild.style.color = "#0000FF";
		window.frames["tabs_iframe_" + this.id].document.location.href = this.tabNodes[key].URL;
		window.setTimeout(this.selectTabSecond,3000);
		if (typeof(this.getTabWindow()) != "undefined" && this.getTabWindow() != null && typeof(this.getTabWindow().tabSelectHandler) != "undefined")
		{
			this.getTabWindow().tabSelectHandler();
		}
	}
	
	this.selectTabSecond = function()
	{
		if(_this.selectFlag)
		{
			window.frames["tabs_iframe_" + _this.id].document.location.href = _this.tabNodes[_this.selectTabid].URL;
		}
	}

	this.getTabWindow = function()
	{
		var frameIndex = -1;
		var iframeArray = document.getElementsByTagName("iframe");
		for ( var i = 0; i < iframeArray.length; i++)
		{
			if (iframeArray[i].name == "tabs_iframe_" + this.id)
			{
				frameIndex = i;
				break;
			}
		}
		return window.frames[frameIndex];
	}

	this.closeTab = function(key)
	{
		var sibling;
		if ((key != this.selectTabid)
				|| (!(this.tabNodes[key].head.nextSibling) && !(this.tabNodes[key].head.previousSibling)))
		{
			this.removeTabNode(key);
		}
		else if ((sibling = this.tabNodes[key].head.nextSibling)
				|| (sibling = this.tabNodes[key].head.previousSibling))
		{
			var t_id = sibling.id.substring(9);
			this.removeTabNode(key);
			this.selectTabid = t_id;
			this.tabNodes[t_id].head.className = this.selectTabClass;
		}
	}

	this.removeTabNode = function(key)
	{
		if (!this.tabNodes[key])
		{
			return;
		}
		this.TabHead.firstChild.removeChild(this.tabNodes[key].head);
		this.addTabs.remove(key);
		this.addTabs.clear();
		delete this.tabNodes[key];
		if (this.selectTabid == key)
		{
			delete this.selectTabid;
		}
	}


	this.getTabs = function()
	{
		var div = document.createElement("div");
		div.appendChild(this.TabHead);
		div.appendChild(this.TabBody);
		this.TabFrame.className = this.t_bodyClass;

		return div;
	}
	function focusHandler()
	{
		this.blur();
	}

	function getTabsNEIDFromURL(url)
	{
		var neid = null;
		if (url.length < 1)
		{
			return null;
		}
		var nearr = url.substring(1, url.length).split("&");
		for ( var i = 0; i < nearr.length; i++)
		{
			var arr = nearr[i].split("=");
			if(arr[0].toLowerCase() == "neid")
			{
				neid = decodeURIComponent(arr[1]);
				arr = null;
				break;
			}
			arr = null;
		}
	  	return neid;
	}

	function Tab(tid, headstr, burl, imgurl)
	{
		this.id = tid;
		this.head = document.createElement("li");
		this.head.setAttribute("id", "tab_head_" + tid);
		var anchor = document.createElement("a");
		anchor.onfocus = focusHandler;
		anchor.setAttribute("target", "_self");
		this.img = document.createElement("img");
		anchor.appendChild(this.img);
		if (imgurl == null || imgurl == "")
		{
			this.img.style.display = "none";
		}
		anchor.appendChild(document.createTextNode(headstr));
		this.head.appendChild(anchor);

		if (burl.indexOf("?") != -1)
		{
			burl = burl + "&r=" + Math.random();
		}
		else
		{
			burl = burl + "?r=" + Math.random();
		}
		this.URL = burl;

		this.getID = function()
		{
			return this.id;
		}

		this.getHead = function()
		{
			return this.head;
		}

		this.setImage = function(imgpath)
		{
			this.img.style.display = "";
			this.img.src = imgpath;
		}
		this.setURL = function(newURL)
		{
			this.URL = newURL;
		}
		this.setTips = function(tips)
		{
			this.head.title = tips;
		}
		this.setText = function(text)
		{
			this.head.childNodes[0].replaceChild(document.createTextNode(text),
					this.head.childNodes[0].childNodes[1]);
		}
		this.setHeadName = function(key, headName)
		{
			this.head.removeChild(this.head.children[0])
			var a = document.createElement("a");
			a.onfocus = focusHandler;
			a.setAttribute("href", "javascript:void window.tabs[" + 0
					+ "].selectTab('" + key + "');");
			a.setAttribute("target", "_self");
			this.img = document.createElement("img");
			this.img.style.display = "none";
			a.appendChild(this.img);
			a.appendChild(document.createTextNode(headName));
			this.head.appendChild(a);
		}
		this.clear = function()
		{
			this.head.parentElement.removeChild(this.head);
			this.img = null;
			this.head = null;
			this.getID = null;
			this.getHead = null;
			this.getBody = null;
			this.setImage = null;
			this.setURL = null;
			this.setTips = null;
			this.setText = null;
			this.setHeadName = null;
			this.setCloseImage = null;
			this.clear = null;
		}
	}

	this.setCloseImage = function(path)
	{
		Tab.imagesrc = path;
	}
}

function tabsEvent(el, event, handler)
{
	if (el.addEventListener)
		el.addEventListener(event, handler, false);

	else if (el.attachEvent)
		el.attachEvent("on"+event, handler);
}
