
var gSelect_isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var selectCacheFor = null;

function optionClick(event)
{
    if(!event)
    {
        event = window.event;
    }
    var blMultiple = false;
    var oParent = this.parent;
    if(this.parent.disabled)
    {
    	return;
    }
    if(event.shiftKey && this.parent.multipleFlag)
    {
        for(var i = 0;i < oParent.getOptionLength();i++)
        {
            oParent.getOption(i).setUnSelect();
        }
        
        if(oParent.selectedIndex == -1)
        {
            oParent.getOption(this.index).setSelect();
            oParent.selectedIndex = this.index;
        }
        else
        {
            var startIndex = oParent.selectedIndex;
            var endIndex = this.index;
            if(startIndex > endIndex)
            {
                startIndex = this.index;
                endIndex = oParent.selectedIndex;
            }
            for(var i = startIndex;i < (endIndex + 1);i++)
            {
                oParent.getOption(i).setSelect();
            }
        }
    }
    else
    {
        if(event.ctrlKey)
        {
            if(this.selectFlag == true && this.parent.multipleFlag)
            {
                oParent.getOption(this.index).setUnSelect();
                oParent.selectedIndex = -1;
            }
            else
            {
                if(!this.parent.multipleFlag)
                {
                    for(var i = 0;i < oParent.getOptionLength();i++)
                    {
                        oParent.getOption(i).setUnSelect();
                    }
                }
                oParent.getOption(this.index).setSelect();
                oParent.selectedIndex = this.index;
            }
        }
        else
        {
            for(var i = 0;i < oParent.getOptionLength();i++)
            {
                oParent.getOption(i).setUnSelect();
            }
            oParent.getOption(this.index).setSelect();
            oParent.selectedIndex = this.index;
        }
    }
    handleSelected(this);
}

function dragOptionSelect(event)
{
   if(!event) event=window.event;
   if(event.button == 2 && this.isDragging == false) //distinguish rigth button event excute or not
   {
        return;
    }
    if(event.ctrlKey || event.shiftKey)
    {
        return;
    }
    if(this.parent.disabled)
    {
    	return;
    }
    this.parent.clickIndex = this.index;
    selectCacheFor = this.parent;
    var nMax = this.parent.getOptionLength();
    for(var i=0;i < nMax;i++)
    {
        this.parent.getOption(i).element.onmouseover=dragOptionSelectMouseOver;
    }
    document.onmouseup = dragOptionSelectMouseUp;
    this.parent.element.onmouseup = dragOptionSelectMouseUp;
}

function dragOptionSelectMouseUp(event)
{
    if(!event) event=window.event;
    var st = selectCacheFor;
    if(st == null)
    {
        document.onmouseup = "";
        st.element.onmouseup = "";
        return;
    }
    for(var i=0;i<st.getOptionLength();i++)
    {
        st.getOption(i).element.onmouseover="";
    }
    document.onmouseup = "";
    st.element.onmouseup = "";
    st.element.onmouseout = ""
    selectCacheFor = null;
}

function dragOptionSelectMouseOver(event)
{
    if(!event) event=window.event;
    if(selectCacheFor == null)
    {
        return;
    }
    var rowIndex = this.index;
    this.parent.endRowIndex = rowIndex;
    changeOptionState(selectCacheFor,rowIndex);
    handleSelected(this);
}

function dragSelectMouseOut(event)
{
    if(!event) event=window.event;
    if(event.toElement == null || event.toElement.tagName == "IMG" || event.toElement.tagName =="BODY")
    {
        var st = selectCacheFor;
        if(st == null)
        {
            return;
        }
        for(var i=0;i<st.getOptionLength();i++)
        {
            st.getOption(i).element.onmouseover="";
        }
        document.onmouseup = "";
        st.element.onmouseup
        st.element.onmouseout = ""
    }
}

function changeOptionState(st,rowIndex)
{
    if(st.getOption(rowIndex) == null)
    {
        return;
    }
    if(st.multipleFlag)
    {
        var startIndex = st.clickIndex;
        var endIndex = rowIndex;
        
        if(startIndex > endIndex)
        {
            startIndex = rowIndex;
            endIndex = st.clickIndex;
        }
        
        for(var i=0,len = st.getOptionLength();i<len;i++)
        {
            if(i >= startIndex && i <= endIndex)
            {
                st.getOption(i).setSelect();
            }
            else
            {
                st.getOption(i).setUnSelect();
            }
        }
    }
    else
    {
        for(var i = 0;i < st.getOptionLength();i++)
        {
            st.getOption(i).setUnSelect();
        }
        st.getOption(rowIndex).setSelect();
        st.selectedIndex = st.getOption(rowIndex).element.index;
    }
}

function CSelect_Compare(str1,str2)
{
    var nResult = 0;
    if(str1 > str2)
    {
        nResult = 1;
    }
    else if(str1 < str2)
    {
        nResult = -1;
    }
    return nResult;
}

function handleSelected(obj){
        
   if(!obj.parent)return;  
   if(obj.parent.disabled)
    {
    	return;
    }
   var st=obj.parent;
   if(st.onSelect!=null){
        var func=st.onSelect;
        func(st.getSelected());         
   }
}

function handleDblClick(evt){
    if(!this.parent)
    {
        return;
    }
    if(this.parent.disabled)
    {
    	return;
    }
    var select = this.parent;
    if(select.ondblclick != null)
    {
        var func = select.ondblclick;
        func(select.getSelected());
    }
}

function CSelect(width,height)
{
    this.element = document.createElement("ul");
    this.element.options = new Array();
    this.selectedIndex = -1;
    this.element.style.margin = "0";
	this.element.style.textAlign = "left";
    this.element.style.padding = "0";
    this.element.style.backgroundColor = "#FFFFFF";
    this.element.style.borderStyle = "groove";
    this.element.style.borderColor = "#E0E0E0";
    this.element.style.fontSize = "13px";
    if(gSelect_isIE)
    {
    	this.element.style.borderWidth = "1px";
        this.element.style.overflowX = "auto";
        this.element.style.overflowY = "auto";
    }
    else
    {
    	this.element.style.borderWidth = "2px";
        this.element.style.overflow = "auto";
    }
    this.element.style.color = "#000000";
    this.element.style.width = width;
    this.element.style.height = height;
    
    this.multipleFlag = false;
    this.clickIndex = -1;
    this.endRowIndex = -1;
    this.onSelect = null;
    this.ondbclick = null;
    this.compare = null;
    this.sortValueFlag = false;
    this.disabled = false;
}

CSelect.prototype.setDisabled = function(bl)
{
	this.disabled = bl;
}


CSelect.prototype.setScrollOrNot = function(blX,blY)
{
    this.element.style.overflowX = blX?"auto":"hidden";
    this.element.style.overflowY = blY?"auto":"hidden";
}

CSelect.prototype.addOption = function(option)
{
    option.element.index = this.element.options.length;
    this.element.options[this.element.options.length] = option;
    option.element.parent = this;
    option.element.onclick = optionClick;
    option.element.onmousedown = dragOptionSelect;
    option.element.ondblclick = handleDblClick;
    if(gSelect_isIE)
    {
        option.element.onselectstart = function(){return false;};
    }
    else
    {
        option.element.style.MozUserSelect = "none";
    }
    if(option.element.innerHTML == "")
	{
		option.element.innerHTML = option.text;
		option.element.title = option.text;
	}
    this.element.appendChild(option.element); 

    if(option.element.selectFlag)
    {
        this.selectedIndex = option.element.index;
    }
}

CSelect.prototype.addOptionAt = function(option,index)
{
    if(index < 0)
    {
        throw new Error("bad option index value:" + index);
    }
    
    option.element.parent = this;
    option.element.onclick = optionClick;
    option.element.onmousedown = dragOptionSelect;
    option.element.ondblclick = handleDblClick;
    if(gSelect_isIE)
    {
        option.element.onselectstart = function(){return false;};
    }
    else
    {
        option.element.style.MozUserSelect = "none";
    }
    
    var nMax = this.getOptionLength();
	if(option.element.innerHTML == "")
	{
		option.element.innerHTML = option.text;
	}
    if(index < nMax)
    {
        this.element.insertBefore(option.element,this.getOption(index).element); 
    }
    else
    {
        this.element.appendChild(option.element); 
        index = nMax;
    }
    
    for(var i = (nMax - 1);i >= index;i--)
    {
        if(null != this.getOption(i) && "undefined" != typeof(this.getOption(i)))
        {
            this.element.options[i + 1] = this.element.options[i];
            this.element.options[i + 1].element.index = i + 1;
            
        }
    }
    this.element.options[index] = option;
    this.element.options[index].element.index = index;
    if(option.element.selectFlag)
    {
        this.selectedIndex = index;
    }
}

CSelect.prototype.getOptionLength = function()
{
    return this.element.options.length;
}

CSelect.prototype.getOption = function(index)
{
    return this.element.options[index];
}
CSelect.prototype.remove = function(index)
{
	return this.removeOption(index);
}

CSelect.prototype.removeOption = function(index)
{
    if(index < 0 || index >= this.element.options.length)
    {
        throw new Error("bad option index value:" + index);
    }
    var option = this.element.options[index];
    
    option.element.parent = null;
    option.element.onclick = null;
    option.element.onselectstart = null;
    this.element.removeChild(option.element);
    
    if(this.selectedIndex == index)
    {
        this.selectedIndex = -1;
    }
    
    delete this.element.options[index];
    for(var i = index + 1;i < this.getOptionLength();i++)
    {
        if(null != this.getOption(i) && "undefined" != typeof(this.getOption(i)))
        {
            this.element.options[index] = this.element.options[i];
            this.element.options[index].element.index = index;
            index = index + 1;
        }
    }
    this.element.options.length = index;

}

CSelect.prototype.getElement = function()
{
    return this.element;
}

CSelect.prototype.getSelected = function()
{
    var select = new Array();
    for(var i = 0;i < this.getOptionLength();i++)
    {
        if(this.getOption(i).element.selectFlag)
        {
            select.push(this.getOption(i));
        }
    }
    return select;
}

CSelect.prototype.setSelectHandler = function(func)
{
    if(typeof func !="function")
    {
        alert("argument of setSelectHandler must be function type");
        return;
    }
    this.onSelect=func;
}

CSelect.prototype.setDblClickHandler = function(func)
{
    if(typeof func !="function")
    {
        alert("argument of setDblClickHandler must be function type");
        return;
    }
    this.ondblclick=func;
}

CSelect.prototype.clear = function()
{
    var nMax = this.getOptionLength();
    var option;
    for(var i = nMax - 1; i >= 0;i--)
    {
        option = this.element.options[i];
    
        option.element.parent = null;
        option.element.selectFlag = null;
        option.element.innerText = "";
        option.element.onclick = null;
        option.element.onselectstart = null;
        this.element.removeChild(option.element);
        
        delete this.element.options[i];
    }
    this.element.options.length = 0;
    this.selectedIndex = -1;
}

CSelect.prototype.setAllUnSelected = function()
{
    var nMax = this.getOptionLength();
    for(var i = 0;i < nMax;i++)
    {
        this.element.options[i].setUnSelect();
    }
    this.selectedIndex = -1;
}

CSelect.prototype.setSelected = function(index)
{
    var blSelect = true;
    if(index < 0 || index >= this.element.options.length)
    {
        blSelect = false;
    }
    if(this.multipleFlag)
    {
        if(blSelect)
        {
            this.element.options[index].setSelect();
            this.selectedIndex = index;
        }
    }
    else
    {
        this.setAllUnSelected();
        if(blSelect)
        {
            this.element.options[index].setSelect();
            this.selectedIndex = index;
        }
        else
        {
            this.selectedIndex = -1;
        }
    }
}
CSelect.prototype.getOptions = function()
{
    return this.element.options;
}

CSelect.prototype.sort = function(blDirect)
{
    var nMax = this.getOptionLength();
    var compare = this.compare;
    if(compare == null || typeof(compare) != "function")
    {
        compare = CSelect_Compare;
    }
    var nResult = 0;
    var temp = null;
    var tempElement = null;
    for(var i = 0;i < nMax;i++)
    {
        for(var j = i+1;j < nMax;j++)
        {
            if(this.sortValueFlag)
            {
                nResult = compare(this.getOption(i).value,this.getOption(j).value);
            }
            else
            {
                nResult = compare(this.getOption(i).text,this.getOption(j).text);
            }
            if((blDirect && nResult > 0) || (!blDirect && nResult < 0))
            {
                temp = this.element.options[i];
                this.element.options[i] = this.element.options[j];
                this.element.options[j] = temp;     
            }
        }
    }
    var options = this.element.options;
    this.element.options = new Array();
    for(var i = 0;i < nMax;i++)
    {
        this.addOption(options[i]);
    }
}

CSelect.prototype.setCompareHandler = function(func)
{
    if(typeof func !="function")
    {
        alert("argument of setCompareHandler must be function type");
        return;
    }
    this.compare=func;
}

function COption(text,value)
{
    this.element = document.createElement("li");
    this.element.parent = null;
    this.element.selectFlag = false;
    this.element.isDragging = false;
	if (typeof(text) != "undefined") 
	{
		this.element.innerHTML = text;
	}
	this.element.style.align="left";
    this.element.style.listStyle = "none";
    this.element.style.whiteSpace = "nowrap";
    this.element.style.width = "100%";
    this.element.style.cursor = "default";
    this.element.style.display = "table-row";
    this.element.title = text;
    this.element.index = -1;
    this.text = text;
    this.value = value;
}

COption.prototype.isSelected = function()
{
	return this.element.selectFlag;
}

COption.prototype.setSelect = function()
{
    this.element.style.backgroundColor = "#006098";
    this.element.style.color = "#FFFFFF";
    this.element.selectFlag = true;
}

COption.prototype.setUnSelect = function()
{
    this.element.style.backgroundColor = "#FFFFFF";
    this.element.style.color = "";
    this.element.selectFlag = false;
}

COption.prototype.getIndex = function()
{
    return this.element.index;
}

COption.prototype.getValue = function()
{
    return this.value;
}

COption.prototype.setValue = function(value)
{
    this.value = value;
}

COption.prototype.getText = function()
{
    return this.text;
}

COption.prototype.setText = function(text)
{
    this.text = text;
    this.element.innerHTML = text;
    this.element.title = text;
}

/**
 *   Select  ,  IE  Select      
 *   :1.   Select  ,          
        2.             Select  ,        
 * @param selects    Select      ,  [select1,select2]
 */
function replaceSelects(selects)
{
	if(!gSelect_isIE ||selects == null)
	{
		return;
	}
	for(var i=0; i < selects.length; i++)
	{
		var selectObj = selects[i];
		if(typeof(selectObj) == "undefined"
			|| selectObj == null)
		{
			return;
		}
		
		var obj = document.getElementById("mySelect_"+i);
		if(obj && selectObj.parentNode)
		{
			selectObj.parentNode.removeChild(obj);
		}
		
		var selectWidth=selectObj.style.width;
		var selectArea = document.createElement('span');
		var textInput = document.createElement('input');
		var button = document.createElement('a');
		selectArea.id = "mySelect_"+i;
		selectArea.className = "zSelect";
		textInput.type = "text";
		textInput.className = "inputText";
		textInput.readOnly=true;
		textInput.style.width=selectWidth;
		textInput.id = "mySelectText_"+i;
		textInput.index = i;
		textInput.value = selectObj.options[0].text;
		textInput.onclick = function()
		{
			showOptions(this.index);
		}
		
		button.id = "mySelectText_a_" + i;
		button.index = i;
		button.className = "arrowimg";
		button.onclick = function()
		{
			showOptions(this.index);
		}
		button.href="#";
		button.hideFocus=true;
		selectArea.appendChild(textInput);
		selectArea.appendChild(button);
		
		selectObj.style.display='none';
		selectObj.parentNode.insertBefore(selectArea, selectObj);
		var optgroup = document.createElement('div');
		optgroup.className = "optgroup";
		optgroup.style.width=selectWidth;
		optgroup.style.display = "none";
		optgroup.id = "optgroup_"+i;
		optgroup.index = i;
		
		optgroup.onblur = function()
		{
			var d = document.elementFromPoint(event.clientX,event.clientY);
			
			if(d.id && (d.id.indexOf("optionsDiv_" + this.index) >= 0
					|| d.id.indexOf("mySelectText_" + this.index) >= 0
					|| d.id.indexOf("mySelectText_a_" + this.index) >= 0))
			{
				return;
			}
			document.getElementById("mySelect_" + this.index).style.zIndex = 0;
			document.getElementById("optgroup_" + this.index).style.display = "none";
		}
		var optionsDiv = document.createElement('div');
		optionsDiv.className = "optionsDiv";
		optionsDiv.id = "optionsDiv_"+i;
		optgroup.appendChild(optionsDiv);
		
		if(selectObj.id=="")
		{
			selectObj.id="select"+i;
		}
		selectArea.appendChild(optgroup);
		var maxWidth = 0;
		
		for(var j=0; j < selectObj.options.length; j++)
		{
			var optionHolder = document.createElement('p');
			var optionLink = document.createElement('a');
			var optionTxt = document.createTextNode(selectObj.options[j].text);
			optionLink.id = optionsDiv.id + "_optionslink_" + j;
			optionLink.href = "#";
			optionLink.indexi = i;
			optionLink.indexj = j;
			optionLink.selectid = selectObj.id;
			optionLink.onclick = function()
			{
				showOptions(this.indexi);
				selectMe(this.selectid,this.indexj,this.indexi);
			}
			optionLink.title = selectObj.options[j].text;
			
			optionLink.onmouseover = function()
			{
				var hrefs = this.parentElement.parentElement.getElementsByTagName("a");
				for(var i = 0,m = hrefs.length;i < m;i++)
				{
					if(hrefs[i].className != "")
					{
						hrefs[i].className = "";
					}
				}
				this.className = "mouseover";
			};
			optionLink.appendChild(optionTxt);
			optionHolder.appendChild(optionLink);
			optionsDiv.appendChild(optionHolder);
			
			if(selectObj.options[j].Selected)
			{
				selectMe(selectObj.id,j,i);
			}
		}
	}
}

/**
 *   /    Option
 * @params g     
 */
function showOptions(g)
{
	var elem = document.getElementById("optgroup_"+g);
	if(elem.style.display == "none")
	{
		document.getElementById("mySelect_" + g).style.zIndex = 666;
		elem.style.display = "";
		elem.focus();
	}
	else
	{
		document.getElementById("mySelect_" + g).style.zIndex = 0;
		elem.style.display = "none";
	}
	var selectObj = document.getElementById(elem.selectedId);
	if(selectObj)
	{
		selectObj.className = "selected";
	}
	var size = document.getElementById("optionsDiv_" + g).childNodes.length;
	var totalHeight = 22;
	if(size > 1)
	{
		totalHeight = size * 22;
	}
	
	var height = document.body.offsetHeight - elem.parentElement.offsetTop - 45;
	if(height < totalHeight)
	{
		height = (height < 100 ? 100:height);
		totalHeight = height;
	}

	totalHeight = (totalHeight > 400 ? 400:totalHeight);
	if(document.getElementById("optgroup_" + g).offsetHeight - document.getElementById("optgroup_" + g).clientHeight >= 18)
	{
		totalHeight = totalHeight + 18;
	}
	elem.style.height = totalHeight + "px";
}

/**
 *     Option,     Select   Option
 * @param selectFieldId  Select  ID
 * @param linkNo   Option   
 * @param selectNo   Select     
 */
function selectMe(selectFieldId,linkNo,selectNo)
{
	var optionLinks = document.getElementById("optionsDiv_"+selectNo).getElementsByTagName("a");
	var selectedId = "";
	
	for(var k = 0; k < optionLinks.length; k++) 
	{
		if(k==linkNo)
		{
			optionLinks[k].className = "selected";
			selectedId = optionLinks[k].id;
		}
		else
		{
			optionLinks[k].className = "";
		}
	}
	
	selectField = document.getElementById(selectFieldId);
	for(var k = 0; k < selectField.options.length; k++)
	{
		if(k==linkNo)
		{
			selectField.options[k].selected = "selected";
		}
		else
		{
			selectField.options[k].selected = "";
		}
	}
	if(typeof(selectField.onchange) != "undefined" && selectField.onchange != null)
	{
		selectField.onchange();
	}
	if(typeof(selectField.onclick) != "undefined" && selectField.onclick != null)
	{
		selectField.onclick();
	}
	document.getElementById("optgroup_"+selectNo).selectedId = selectedId;
	var newText = selectField.options[linkNo].text;
	
	document.getElementById("mySelectText_"+selectNo).value=newText;
}
