document.title = RESOURCE["securitypolicy"];

function init()
{
	$("ok").value=RESOURCE["okbutton"];
	$("cancel").value=RESOURCE["cancelbutton"];
	$("apply").value=RESOURCE["applybutton"];
	$("pwdminlengthtitle").innerText = RESOURCE["pwdminlength"];
	$("pwdmaxlengthtitle").innerText = RESOURCE["pwdmaxlength"];
	$("loginfailtitle1").innerText = RESOURCE["loginfail1"];
	$("loginfailtitle2").innerText = RESOURCE["loginfail2"];
	$("pwvalidatetitle1").innerText = RESOURCE["pwvalidatetitle1"];
	$("pwvalidatetitle2").innerText = RESOURCE["pwvalidatetitle2"];
	$("locktimetitle").innerText = RESOURCE["locktime"];
	$("apply").disabled = true;
	
	validateNum($("pwdminlength"),8,16,2,8);
	validateNum($("pwdmaxlength"),8,16,2,16);
	textCheck($("pwvalidate"),'10','999',0,'0');
	validateNum($("loginfail"),0,99,2,3);
	validateNum($("locktime"),1,999,3,5);
	
	EventUtil.addEventHandler($("pwdminlength"),"keypress",changeBtn);
	EventUtil.addEventHandler($("pwdmaxlength"),"keypress",changeBtn);
	EventUtil.addEventHandler($("pwvalidate"),"keypress",changeBtn);
	EventUtil.addEventHandler($("loginfail"),"keypress",changeBtn);
	EventUtil.addEventHandler($("locktime"),"keypress",changeBtn);

	query();
}

function changeBtn()
{
	$("apply").disabled = false;
}

function query()
{
	var serUrl =  "../neListServlet?sfid=28677"; 
	loadXMLdoc(serUrl,"POST",false,queryCallBack,null,""); 
}

function queryCallBack(doc)
{
	var result = EncapsulateData(doc);
	if(0 == result.getSErrorCode())
	{
	    if(result.getDataRowLength() > 0)
    	    {
    		$("pwdminlength").value = result.getDataRowParam(0, "pwdminlength");
    		$("pwdmaxlength").value = result.getDataRowParam(0, "pwdmaxlength");
    		$("pwvalidate").value = result.getDataRowParam(0, "pwvalidate");
    		$("loginfail").value = result.getDataRowParam(0, "loginfail");
    		$("locktime").value = result.getDataRowParam(0, "locktime");
    	    }
	}
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name","pwdminlength");
    param.setAttribute("value",$("pwdminlength").value);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name","pwdmaxlength");
    param.setAttribute("value",$("pwdmaxlength").value);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name","loginfail");
    param.setAttribute("value",$("loginfail").value);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name","locktime");
    param.setAttribute("value",$("locktime").value);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name","pwvalidate");
    param.setAttribute("value",$("pwvalidate").value);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function apply(bclose)
{
	if(bclose && $("apply").disabled)
	{
		closeWindow();
		return;
	}
	if(!validateInput())
	{
		return;
	}
	$("ok").disabled = true;
	$("apply").disabled = true;
	var xml = createApplyXML();
	var serUrl =  "../neListServlet?sfid=28678";
	loadXMLdoc(serUrl,"POST",false,applyCallBack,bclose,"inputdata="+xml); 
}

function validateInput()
{
	if($("pwdminlength").value == ""
		|| $("pwdmaxlength").value == ""
		|| $("pwvalidate").value == ""
		|| $("loginfail").value == ""
		|| $("locktime").value == "")
	{
		alert(RESOURCE["format"]);
		return false;
	}
	if(parseInt($("pwdminlength").value) > parseInt($("pwdmaxlength").value))
	{
		alert(RESOURCE["pwderror"]);
		$("pwdmaxlength").focus();
		return false;
	}
	return true;
}

function applyCallBack(doc,bclose)
{
	var result = EncapsulateData(doc);
	showErrorDialog(result);
	$("ok").disabled = false;
	if(0 == result.getSErrorCode())
	{
		if(bclose)
		{
			closeWindow();
		}
	}
	else
	{
		$("apply").disabled = false;
	}
}

function closeWindow()
{
	xcloseDialog();
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "neID";
    openErrPage("", data.getError(), errArr)
}
