loadXMLdoc("../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../res/commonres_" + language +".xml");

var printTitle = "";
var printStr = "";

var beginTime = "";
var endTime = "";

var printTableFlg = true;

window.onload = function()
{
	initPage();
}

/**
 *      
 */
function initPage()
{
	var urlStr = parseURLStr(self);
    printTitle = urlStr["title"];
    printStr = urlStr["printStr"];
    printTableFlg = urlStr["tableFlg"];
    beginTime = urlStr["beginTime"]||("");
    endTime = urlStr["endTime"]||("");
    
    if("false" == printTableFlg || !printTableFlg)
    {
        if(window.opener[printStr])
        {
            $("printcontent").innerHTML = window.opener[printStr];
        }
        else
        {
            $("printcontent").innerHTML = printStr;
        }
    }
    else
    {
        saveSortTable();
    }
}

/**
 *      SortTable    
**/
function saveSortTable()
{
    var win = window.opener;
    var titlediv,titleH2,countDiv,countStr,timeDiv,timeStr;
    
    var stTitleArr = [];
    if(-1 == printTitle.indexOf(","))
    {
        stTitleArr[0] = printTitle;
    }
    else
    {
        stTitleArr = printTitle.split(",");
    }    
    
    var stNameArr = [];
    if(-1 == printStr.indexOf(","))
    {
        stNameArr[0] = printStr;
    }
    else
    {
        stNameArr = printStr.split(",");
    }
    
    
    var printTable;
    var st;
    for(var i = 0, len = stNameArr.length; i < len; i++) 
    {        
        if(win[stNameArr[i]])
        {
            st = win[stNameArr[i]];
        }
        else
        {
            return;
        }
        if(i > 0)
        {
            $("printcontent").appendChild(document.createElement("br"));
        }

        if(stTitleArr[i])
        {            
            $("printcontent").appendChild(document.createTextNode(stTitleArr[i]));
        }
        else
        {
            $("printcontent").appendChild(document.createElement("br"));   
        }
        
        var rowlen = st.getDataRowLength();
        countDiv = document.createElement("div");
        countStr = RESOURCE["all"]+ rowlen + RESOURCE["item"]+ RESOURCE["record"];
        countDiv.innerText = countStr;
        
        /*
         * ODU                  http://10.88.32.101:8080/browse/TRANSU2000V1R7C00-1987
         */
        if("" != beginTime.trim())
        {
	        timeDiv = document.createElement("span");
	        timeStr = "  " + RESOURCE["time"] + beginTime 
	        if("" != endTime.trim())
	        {
	        	timeStr += "-" + endTime;
	        }
		    timeDiv.innerText = timeStr;
	        countDiv.appendChild(timeDiv);
        }
        document.getElementById("printcontent").appendChild(countDiv);
        
        printTable = document.createElement("table");
        printTable.cellSpacing = 0;
        
        printTableHead = document.createElement("thead");
        printTableBody = document.createElement("tbody");
        var printHeadTr = document.createElement("tr");
        var printHeadTd;     
        
        var colsArr = new Array();        
        var colid = "";                                   
        colsArr = st.getTable().colsArray;

        var txtContent;
        var colLength;
        var maxLength;
        var spaceoftale = 2;
        for(var j = 0; j < colsArr.length; j++)
        {
            colid = win.tableconf[i].getColId(j);
            if("none" != st.getHeadCell(colid).element.style.display)                      
            {                                                                              
                printHeadTd = document.createElement("td");
                
                maxLength = st.getHeadCell(colsArr[j]).element.maxLength;
            	txtContent = win.tableconf[i].getColName(j).trim();
            	colLength = getLength(txtContent);            	
                if (j < colsArr.length - 1)
                {
                	txtContent += getSpaceHTML(maxLength - colLength + spaceoftale);
                }
                printHeadTd.innerHTML = txtContent;
                
                printHeadTr.appendChild(printHeadTd); 
            }                                                                                         
        }
        printTableHead.appendChild(printHeadTr);
        printTable.appendChild(printTableHead);

        for(var j = 0; j < rowlen; j++)
        {
            printHeadTr = document.createElement("tr");
            for(var k = 0; k < colsArr.length; k++)
            {
                colid = win.tableconf[i].getColId(k);
                if("none" != st.getHeadCell(colid).element.style.display)
                {
                    printHeadTd = document.createElement("td");
                    printHeadTd.style.overflow="hidden";
                    
                    maxLength = st.getHeadCell(colsArr[k]).element.maxLength;
            	    txtContent = st.getCellShow(j,colsArr[k]).getValue().trim();
            	    colLength = getLength(txtContent);
            	    if (k < colsArr.length - 1)
                    {
                	    txtContent += getSpaceHTML(maxLength - colLength + spaceoftale);
                    }
                    printHeadTd.innerHTML = txtContent;
                    printHeadTr.appendChild(printHeadTd);
                }
            }
            printTableBody.appendChild(printHeadTr);
            printTable.appendChild(printTableBody);           
        }
        $("printcontent").appendChild(printTable);        
    }    
}

function getSpaceHTML(len)
{
	var space = "";
	for(var i = 0;i < len;i++)
	{
		space += "&nbsp";
	}
	return space;
}

String.prototype.trim = function()
{
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
