var ct;
var win = getParentWindow();

var neinfoArray = new Array();
var parentSt = win.st;
var connecttype = "normal";


function init()
{
    ct = new CTable();
    
    atom = new Atom("text");
   	ct.addAttrRow("username", RESOURCE["username"], atom);
   	ct.setAttrValue("username", "root");
   	
   	atom = new Atom("password");
   	ct.addAttrRow("password", RESOURCE["password"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element["onchange"] = function()
	{
        changeLocalIP(this);
    }
    ct.addAttrRow("localipAddress", RESOURCE["localip"], atom);
    
    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("neipAddress", RESOURCE["neip"], atom);
    
    
    $("tablecontainer").appendChild(ct.getTable());
    $("submitbtn").value = RESOURCE["okbutton"];
    $("cancel").value = RESOURCE["cancelbutton"];
    $("apply").value = RESOURCE["applybutton"];
    setBtnStatus(true);
    LoadingProcess.showWaitStatus("../images",RESOURCE["loadingtitle"]);
    loadXMLdoc("../deviceSearchServlet?sfid=24607&flag=1&timestamp=" + new Date().getTime(), "GET", true, initCallback, null);
}

function initCallback(doc)
{
    LoadingProcess.removeWaitStatus();    
    var di = EncapsulateData(doc);
    var localIPList = di.rows[0];
    var neipAddressList = di.rows[1];
    var localipElement = ct.getAtom("localipAddress").element;
    localipElement.options[localipElement.length] = new Option(RESOURCE["selecttitle"],"0");
    for (var obj in localIPList) 
		{
        var localip = localIPList[obj].value;
        
        localipElement.options[localipElement.length] = new Option(localip, localip);
    }
    
    /*var neipAddressElement = ct.getAtom("neipAddress").element;
    for (var i = di.getDataRowLength() - 1; i > 0; i--) 
		{
        var diObj = di.rows[i];
        var neipAddress = diObj["searchedip"].value;
        var neinfo = new Object();
        neinfo["neip"] = neipAddress;
        neinfo["neid"] = diObj["searchedneid"].value;
        
        var isAdded = false;
        for (var j = parentSt.getDataRowLength() - 1; j >= 0; j--) 
			{
            var realneid = parentSt.getCellStoreValue(j, "realNEID", "realNEID");
            if (neinfo["neid"] == realneid) 
			{
                isAdded = true;
                break;
            }
        }
        
        if (!isAdded) 
		{
            neipAddressElement.options[neipAddressElement.length] = new Option(neipAddress, neipAddress);
            neinfoArray[neipAddress] = neinfo;
        }
    }*/
    
    
    setBtnStatus(true);
    LoadingProcess.removeWaitStatus();    
}

function setBtnStatus(isEnable)
{
    $("submitbtn").disabled = isEnable;
    $("apply").disabled = isEnable;
}


function changeLocalIP(obj)
{
	setBtnStatus(true);
    LoadingProcess.showWaitStatus("../images",RESOURCE["loadingtitle"]);
    var localip = obj.value;
    if(obj.value == "0")
    {
    	ct.getAtom("neipAddress").element.options.length = 0;
    	/**
    	 *      DTS2012051103829 
    	 *                   
    	 */
    	LoadingProcess.removeWaitStatus();
    	return;
    }
    LoadingProcess.showWaitStatus("../images",RESOURCE["loadingtitle"]);
    
    var di = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "localip");
    param.setAttribute("value", localip);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "username");
    param.setAttribute("value", ct.getAttrValue("username"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "password");
    param.setAttribute("value", EncryptUtils.encrypt(ct.getAttrValue("password")));
    row.appendChild(param);
    
    row.appendChild(createTagElement("connectType", connecttype));
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);

    loadXMLdoc("../deviceSearchServlet?sfid=24608&flag=1&timestamp=" + new Date().getTime(), "POST", true, changeLocalIPCallback, null, "inputdata=" + di.toString());
}


function changeLocalIPCallback(doc)
{
    var di = EncapsulateData(doc);
    LoadingProcess.removeWaitStatus();
    
    var neipAddressElement = ct.getAtom("neipAddress").element;
    neipAddressElement.length = 0;
    neinfoArray = new Array();
     for (var i = di.getDataRowLength() - 1; i >= 0; i--)  
    {
        var diObj = di.rows[i];
        var neipAddress = diObj["searchedip"].value;
        var neinfo = new Object();
        neinfo["neip"] = neipAddress;
        neinfo["neid"] = diObj["searchedneid"].value;
        var isAdded = false;
        for (var j = parentSt.getDataRowLength() - 1; j >= 0; j--) 
				{
            var realneid = parentSt.getCellStoreValue(j, "realNEID", "realNEID");
            if (neinfo["neid"] == realneid) {
                isAdded = true;
                break;
            }
        }
        
        if (!isAdded) 
				{
            neipAddressElement.options[neipAddressElement.length] = new Option(neipAddress, neipAddress);
            neinfoArray[neipAddress] = neinfo;
        }
    }
	if(neipAddressElement.options.length > 0)
	{
    	setBtnStatus(false);
LoadingProcess.removeWaitStatus();
    }
}


function doSubmit(isClose)
{
    setBtnStatus(true);
	
    if(ct.getAtom("neipAddress").element.options.length == 0)
    {
		if (isClose) 
		{
			window.close();
		}
		else 
		{
			setBtnStatus(true);
		}
		return;
    }
    var neInfo = neinfoArray[ct.getAttrValue("neipAddress")];
    
    if (isNumber(neInfo["neid"])) 
		{
        var xml = createXML();
        var URL = "../neListServlet?sfid=12288&flag=0";
        loadXMLdoc(URL, "POST", true, submitCallback, isClose, "inputdata=" + xml);
    }
    else 
		{
        var xml = createTL1XML();
        var URL = "../tl1NEManagerServlet?sfid=12288&flag=0";
        loadXMLdoc(URL, "POST", true, submitCallback, isClose, "inputdata=" + xml);
    }
    
}

function submitCallback(doc, isClose)
{
    var objerr = EncapsulateData(doc);
    
    for (var i = 0, iLength = win.st.getDataRowLength(); i < iLength; i++) 
		{
        win.st.setRowNoneSelect(i);
    }
    
    if (0 == objerr.getSErrorCode()) 
		{
        win.refreshNelist(true);
    }
    else 
		{
        showErrorDialog(objerr);
    }
    
    if (isClose) 
		{
        window.close();
    }
    else 
		{
        setBtnStatus(false);
    }
    
}

function setConnectType()
 {
	var radiovalue = document.getElementsByName("portradio");
	if (radiovalue != null || radiovalue != undefined)
	{
		for ( var i = 0; i < radiovalue.length; i++)
		{
			if (radiovalue[i].checked)
			{
				connecttype = radiovalue[i].value;
			}
		}
	}
	
	changeLocalIP(ct.getAtom("localipAddress").element)
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createXML(neInfo)
{

    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var neInfo = neinfoArray[ct.getAttrValue("neipAddress")];
    secondlevel.appendChild(createTagElement("neID", neInfo["neid"]));
    secondlevel.appendChild(createTagElement("neGWType", "1"));
    secondlevel.appendChild(createTagElement("neGWAddress", neInfo["neip"]));
    secondlevel.appendChild(createTagElement("port", "1400"));
    secondlevel.appendChild(createTagElement("baudRate", "-1"));
    secondlevel.appendChild(createTagElement("userName", ct.getAttrValue("username")));
    secondlevel.appendChild(createTagElement("userPassword", EncryptUtils.encrypt(ct.getAttrValue("password"))));
    secondlevel.appendChild(createTagElement("forceLogin", "1"));
    secondlevel.appendChild(createTagElement("connectType", connecttype));
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    
    var neipAddressElement = ct.getAtom("neipAddress").element;
    neipAddressElement.remove(neipAddressElement.selectedIndex);
    
    return root.toString();
}

function createTL1XML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var neInfo = neinfoArray[ct.getAttrValue("neipAddress")];
    secondlevel.appendChild(createTagElement("neName", neInfo["neid"]));
    secondlevel.appendChild(createTagElement("neGWType", "1"));
    secondlevel.appendChild(createTagElement("neGWAddress", neInfo["neip"]));
    secondlevel.appendChild(createTagElement("port", "3081"));
    secondlevel.appendChild(createTagElement("baudRate", "-1"));
    secondlevel.appendChild(createTagElement("userName", ct.getAttrValue("username")));
    secondlevel.appendChild(createTagElement("userPassword", EncryptUtils.encrypt(ct.getAttrValue("password"))));
    secondlevel.appendChild(createTagElement("forceLogin", "1"));
    secondlevel.appendChild(createTagElement("connectType", connecttype));
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    
    var neipAddressElement = ct.getAtom("neipAddress").element;
    neipAddressElement.remove(neipAddressElement.selectedIndex);
    
    return root.toString();
}


function filterExistNE()
{

    var neipAddressElement = ct.getAtom("neipAddress").element;
    
    for (var i = parentSt.getDataRowLength() - 1; i >= 0; i--) 
		{
        var realneid = parentSt.getCellStoreValue(i, "realNEID", "realNEID");
        
        for (var j = neipAddressElement.length - 1; j >= 0; j--) 
				{
            var neInfo = neinfoArray[ct.getAttrValue("neipAddress")];
            if (neInfo["neid"] == realneid) 
						{
                neipAddressElement.remove(j);
            }
        }
    }
}


function isNumber(inputStr)
{
    var pattern = /^\d{1,9}$/;
    
    return pattern.test(inputStr);
}


function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "neID";
    openErrPage("", data.getError(), errArr)
}
