document.title = RESOURCE["changepswbutton"];

var pwdMinLength = 8;
var pwdMaxLength = 16;

var SpecialCode = "`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/? ";

var EXPAND = "../images/down.gif";
var SHRINK = "../images/right.gif";

/**
 *        
 */
function init()
{
	
	$("confirmbtn").value=RESOURCE["confirmbutton"];
    $("resetbtn").value=RESOURCE["resetbutton"];
    $("cancelbtn").value=RESOURCE["cancelbutton"];
    
	$("oldPass_show").focus();
	$("changepassword").src = "../images/changepassword_" + language + ".gif";
	
	queryPasswordPolicy();
	$("pwdtitle").innerHTML = RESOURCE["pswpolicytitle"];
    $("pwdminlentitle").innerHTML = "1." + RESOURCE["pswlenminerror1"] + pwdMinLength + RESOURCE["pswlenminerror2"];
    $("pwdmaxlentitle").innerHTML = "2." + RESOURCE["pswlenmaxerror1"] + pwdMaxLength + RESOURCE["pswlenmaxerror2"];
    $("pwdnumbertitle").innerHTML = "3." + RESOURCE["pswnumbererror"];
    $("pwdlowtitle").innerHTML = "4." + RESOURCE["pswlowererror"];
    $("pwdsupertitle").innerHTML = "5." + RESOURCE["pswsupererror"];
    $("pwdspecialtitle").innerHTML = "6." + RESOURCE["pswspecialerror1"] + SpecialCode + RESOURCE["pswspecialerror2"];
    $("pwvalidtitile").innerHTML = "7." + RESOURCE["pwdinvaliderror"];
	$("newPass_show").maxLength = pwdMaxLength;
	$("confirmPass_show").maxLength = pwdMaxLength;
	
	dealMsg();
}

function dealMsg()
{
	var urlparam=getNeProperty(self);
	if(urlparam!=null)
	{
	  var msgspan=document.getElementById("msg");
	  var isSucc = urlparam["succ"];
	  if (isSucc == 1)
	  {
	  	alert(urlparam["msg"]);
		if (urlparam["redirecturl"]) 
		{
			top.location.href = urlparam["redirecturl"];
		}
		else 
		{
			top.xcloseDialog();
		}
	  }
	  else if(urlparam["msg"] != null)
	  {
		  msgspan.innerHTML=urlparam["msg"];
		  msgspan.style.color="red";
		}
	}
}


/**
 *          
 */
function queryPasswordPolicy()
{
	var serUrl =  "../neListServlet?sfid=28677"; 
	loadXMLdoc(serUrl,"POST",false,queryCallBack,null,""); 
}

/**
 *          
 */
function queryCallBack(doc)
{
	var result = EncapsulateData(doc);
	if(0 == result.getSErrorCode())
	{
		if(result.getDataRowLength() > 0)
    	{
    		pwdMinLength = result.getDataRowParam(0, "pwdminlength");
    		pwdMaxLength = result.getDataRowParam(0, "pwdmaxlength");
    	}
	}
}

function detailOnclick()
{
	if($("passwordPolicy").style.display=="none")
	{
		$("passwordPolicy").style.display="";
		$("detailimg").src = EXPAND;
	}
	else
	{
		$("passwordPolicy").style.display="none";
		$("detailimg").src = SHRINK;
	}
}

/**
 *       
 */
function checkSubmit()
{
	return validateForm();
}

/**
 *         
 */
function validateForm()
{
	if($("newPass_show").value != $("confirmPass_show").value)
	{
		alert(RESOURCE["bothpsw"]);
		$("confirmPass_show").focus();
		return false;
	}
	if($("oldPass_show").value == $("newPass_show").value)
	{
		alert(RESOURCE["pswnewsameold"]);
		$("newPass_show").focus();
		return false;
	}
	if($("newPass_show").value.length < pwdMinLength)
	{
		alert(RESOURCE["checkpasswordinfo"]);
		$("newPass_show").focus();
		return false;
	}
	if(!isExistLower($("newPass_show").value))
	{
		alert(RESOURCE["checkpasswordinfo"]);
		$("newPass_show").focus();
		return false;
	}
	if(!isExistSuper($("newPass_show").value))
	{
		alert(RESOURCE["checkpasswordinfo"]);
		$("newPass_show").focus();
		return false;
	}
	if(!isExistNumber($("newPass_show").value))
	{
		alert(RESOURCE["checkpasswordinfo"]);
		$("newPass_show").focus();
		return false;
	}
	if(!isExistSpecial($("newPass_show").value))
	{
		alert(RESOURCE["checkpasswordinfo"]);
		$("newPass_show").focus();
		return false;
	}
	
	$("oldPass").value = EncryptUtils.encrypt($("oldPass_show").value);
	$("newPass").value = EncryptUtils.encrypt($("newPass_show").value);
	$("confirmPass").value = EncryptUtils.encrypt($("confirmPass_show").value);
	$("oldPass_show").value = "";
	$("newPass_show").value = "";
	$("confirmPass_show").value = "";
	
	return true;
}

/**
 *       
 */
function isExistNumber(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 48 && code <= 57)
		{
			return true;
		}
	}
	return false;
}
/**
 *         
 */
function isExistLower(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 97 && code <= 122)
		{
			return true;
		}
	}
	return false;
}
/**
 *         
 */
function isExistSuper(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 65 && code <= 90)
		{
			return true;
		}
	}
	return false;
}

/**
 *         
 */
function isExistSpecial(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charAt(i);
		if(SpecialCode.indexOf(code) >= 0)
		{
			return true;
		}
	}
	return false;
}
