 var gencfg = null;
var curSelect;
var gencfgObj;
var genCfgAttrList = null;
var genCfgPNPList = null;

/**
 * Component  
 * @param  
 * @return  
 */
function Component()
{
    this.title = null;
    this.componentType = null;
    this.link = null;
    this.supportAttr = null;
    this.childs = [];
}

/**
 *     
 * @param obj:Component   nodes:   
 * @return  
 */
function addComponent(obj, nodes)
{

    var supportAttrArr = "";
    for (var i = 0; i < nodes.length; i++) 
    {
        if (nodes[i].nodeType == 1) //     
        {
            var componentObj = new Component();
            componentObj.title = nodes[i].getAttribute("title");
            componentObj.componentType = nodes[i].getAttribute("component");
            componentObj.link = nodes[i].getAttribute("link");
            componentObj.supportAttr = nodes[i].getAttribute("attrList");
            if (nodes[i].getAttribute("component").toLowerCase() != "table") 
            {
                addComponent(componentObj, nodes[i].childNodes);
            }
            obj.childs[obj.childs.length] = componentObj;
            if ("" != supportAttrArr) 
            {
                supportAttrArr += ",";
            }
            supportAttrArr += componentObj.supportAttr;
        }
        
    }
    obj.supportAttr = supportAttrArr;
}

Component.prototype.getTitle = function()
{
    return this.title;
}

Component.prototype.getComponentType = function()
{
    return this.componentType;
}

Component.prototype.getLink = function()
{
    return this.link;
}

Component.prototype.getSupportAttr = function()
{
    return this.supportAttr;
}

Component.prototype.getChilds = function()
{
    return this.childs;
}

Component.prototype.getChildAt = function(index)
{
    return this.childs[index];
}

/**
 * toString()  
 * @param  
 * @return String
 */
Component.prototype.toString = function()
{
    var str = "";
    str += "title:" + RESOURCE[this.title];
    str += " componentType:" + this.componentType;
    str += " link:" + this.link;
    str += " supportAttrList:" + this.supportAttr;
    for (var i = 0; i < this.childs.length; i++) 
    {
        str += "\nchild[" + i + "]=" + this.childs[i].toString();
    }
    return str;
}





function GenCfg()
{
    gencfg = this;
    this.componentType = "tabbed";
    this.supportAttr = "";
    this.childs = [];
}

GenCfg.prototype.getChildAt = function(index)
{
    if (index < 0 || index > this.childs.length) 
    {
        return null;
    }
    return this.childs[index];
}

GenCfg.prototype.getChildFromName = function(childName)
{
    for (var i = 0, len = this.childs.length; i < len; i++) 
    {
        if (this.childs[i].title == childName) 
        {
            return this.childs[i];
        }
    }
    return null;
}


GenCfg.prototype.getChilds = function()
{
    return this.childs;
}

GenCfg.prototype.getComponentType = function()
{
    return this.componentType;
}
GenCfg.prototype.getSupportAttr = function()
{
    return this.supportAttr;
}

/**
 * toString()  
 * @param  
 * @return String:
 */
GenCfg.prototype.toString = function()
{
    var str = "";
    str += "The Component is " + this.componentType;
    str += "\nSupport Attr List is:" + this.supportAttr;
    for (var i = 0; i < this.childs.length; i++) 
    {
        str += "\ncomponent[" + i + "]=" + this.childs[i].toString();
    }
    return str;
}


/**
 *             
 * @param xmldoc:      
 * @return  
 */
function EncapsulateGenCfg(xmldoc)
{
    var tc = new GenCfg();
    var nodes = xmldoc.getElementsByTagName("combox");
    
    if (nodes.length > 0) 
    {
        tc.componentType = "combox";
    }
    else 
    {
        nodes = xmldoc.getElementsByTagName("radio");
        if (nodes.length > 0) 
        {
            tc.componentType = "radio";
        }
        else 
        {
            nodes = xmldoc.getElementsByTagName("tabbed");
            tc.componentType = "tabbed";
        }
    }
    
    nodes = nodes[0].childNodes;
    addComponent(tc, nodes);
    return tc;
}

/**
 * combox change  
 * @param gencfgObj:         urlStr       obj combox  
 * @return  
 */
function refreshComponent(gencfgObj, urlStr, obj)
{
    var nodes = document.getElementById("componentForm");
    if (nodes == null) 
    {
        nodes = document.createElement("div");
        nodes.setAttribute("id", "componentForm");
        document.body.appendChild(nodes);
        
        nodes.style.height = getComponetHeight($("componentForm"), 40) + "px";
        window.onresize = function()
        {
            nodes.style.height = getComponetHeight($("componentForm"), 40) + "px";
        }
    }
    
    for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
    {
        nodes.removeChild(nodes.childNodes[i]);
    }
    var componentObj = gencfgObj.getChildFromName(obj);
    
    if (componentObj.getChilds().length > 0) 
    {
        tab = new Tabs();
        var notSupportAttr = "";
        for (var i = 0; i < componentObj.getChilds().length; i++) 
        {
            tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame2", "tabs_li_select");
            tab.addTab(i + 1, RESOURCE[componentObj.getChildAt(i).getTitle()], componentObj.getChildAt(i).getLink() + urlStr + "&supportAttr=" + componentObj.getChildAt(i).getSupportAttr());
        }
        tab.selectTab(1);
        nodes.appendChild(tab.getTabs());
        firstSelectTab();
    }
    else //               
    {
		if(typeof(tab) != "undefined" && tab != null && typeof(tab.clear) == "function")
    	{
    		tab.clear();
    		tab = null;
    	}
        var frame = document.createElement("iframe");
        frame.setAttribute("align", "center");
        frame.style.width = "100%";
        frame.style.height = "100%";
        frame.style.borderWidth = "0px";
        frame.setAttribute("src", componentObj.getLink() + urlStr + "&supportAttr=" + componentObj.getSupportAttr());
        nodes.appendChild(frame);
    }
}

/**
 *         
 * @param componentArr:     supportAttrArr      
 * @return  
 */
function filterComponent(componentArr, supportAttrArr, unFilterComponetArr)
{
    var componentObj = null;
    
    for (var i = componentArr.length - 1; i >= 0; i--) 
    {
        componentObj = componentArr[i];
        if (null != unFilterComponetArr && unFilterComponetArr.contains(componentObj.getTitle())) 
        {
            continue;
        }
        if ("" == supportAttrArr || null == supportAttrArr) 
        {
            componentArr.removeAt(i);
            continue;
        }
        if (0 == componentObj.getChilds().length && (null == componentObj.getSupportAttr() || "" == componentObj.getSupportAttr())) 
        {
            componentArr.removeAt(i);
        }
        else 
        {
            if (componentObj.getChilds().length > 0) 
            {
                filterComponent(componentObj.getChilds(), supportAttrArr, unFilterComponetArr);
                if (0 == componentObj.getChilds().length) 
                {
                    componentArr.removeAt(i);
                }
                else if(1 == componentObj.getChilds().length)
                {
                	componentObj.supportAttr = componentObj.getChilds()[0].supportAttr;
                }
            }
            else 
            {
                var tmp = componentObj.getSupportAttr().split(",");
                var supportAttr = "";
                for (var index = 0; index < tmp.length; index++) 
                {
                    for (var len = 0; len < supportAttrArr.length; len++) 
                    {
                        if (tmp[index] == supportAttrArr[len]) 
                        {
                            if (supportAttr != "") 
                            {
                                supportAttr += ",";
                            }
                            supportAttr += tmp[index];
                            break;
                        }
                    }
                }
                if (supportAttr != "") 
                {
                    componentObj.supportAttr = supportAttr;
                }
                else //               
                 {
                    componentArr.removeAt(i);
                }
            }
        }
    }
}

function getAllSupportAttr(allData)
{
    var allSupportAttr = [];
    var genCfgAttrObj = null;
    genCfgAttrList = new Object();
    for (var i = 0; i < allData.getDataRowLength(); i++) 
    {
        var belongFunId = allData.getDataRowParam(i, "belongFunID");
        if (belongFunId != null && belongFunId != "") 
        {
            processPNPData(allData, i);//   PNP     PNP      
            continue;
        }
        var attrId = allData.getDataRowParam(i, "attrId");
        if(attrId == null)
        {
        	continue;
        }
        allSupportAttr.push(attrId);
        genCfgAttrObj = parseGenCfgAttrObj(allData,i);
        genCfgAttrList[genCfgAttrObj.attrId] = genCfgAttrObj;
    }
    return allSupportAttr;
}

/**
 *                 Set         
 * @param {Object} allData
 */
function getAllSupportAttrAsSet(allData)
{
    var allSupportAttr = new Object();
    var genCfgAttrObj = null;
    genCfgAttrList = new Object();
    for (var i = 0; i < allData.getDataRowLength(); i++) 
    {
        var belongFunId = allData.getDataRowParam(i, "belongFunID");
        if (belongFunId != null && belongFunId != "") 
        {
            processPNPData(allData, i);//   PNP     PNP      
            continue;
        }
        var attrId = allData.getDataRowParam(i, "attrId");
        if(attrId == null)
        {
        	continue;
        }
        allSupportAttr[attrId] = null;
        genCfgAttrObj = parseGenCfgAttrObj(allData,i);
        genCfgAttrList[genCfgAttrObj.attrId] = genCfgAttrObj;
    }
    return allSupportAttr;
}

function parseGenCfgAttrObj(allData,rowIndex)
{
    var genCfgAttrObj = new GenCfgAttribute();
    genCfgAttrObj.attrId = allData.getDataRowParam(rowIndex, "attrId");
    genCfgAttrObj.attrAccess = allData.getDataRowParam(rowIndex, "attrAccess");
    genCfgAttrObj.domain_list = allData.rows[rowIndex]["domain_list"];
    if (allData.rows[rowIndex]["minValue"]) 
    {
        genCfgAttrObj.valueRange = new Object();
        genCfgAttrObj.valueRange.minValue = allData.getDataRowParam(rowIndex, "minValue");
        genCfgAttrObj.valueRange.maxValue = allData.getDataRowParam(rowIndex, "maxValue");
    }
    var attrRange = allData.rows[rowIndex]["attrRange"];
    if(attrRange && attrRange.value != "")
    {
    	genCfgAttrObj.attrRange = attrRange.value;
    }
	return genCfgAttrObj;
}

/**
 *         
 * @param doc:     XML   gencfgObj       
 * @return  
 */
function filterAttr(doc, gencfgObj, unFilterComponetArr)
{
    var data = EncapsulateData(doc);
    var allSupportAttr = getAllSupportAttrAsSet(data);
    var supportAttr = "";
    if (data.getDataRowLength() < 1) 
    {
        gencfgObj.supportAttr = "";
        filterComponent(gencfgObj.getChilds(), supportAttr.split(","), unFilterComponetArr);
        return;
    }
    
    addPNPData(gencfgObj);
    var beforSupportAttr = gencfgObj.getSupportAttr().split(",");
    
    for (var index = 0; index < beforSupportAttr.length; index++) 
    {
        if (beforSupportAttr[index] in allSupportAttr) 
        {
            if (supportAttr != "") 
            {
                supportAttr += ",";
            }
            supportAttr += beforSupportAttr[index];
        }
    }
    gencfgObj.supportAttr = supportAttr;
    filterComponent(gencfgObj.getChilds(), supportAttr.split(","), unFilterComponetArr);
    return;
}


/**
 *      
 * @param urlStr:      gencfgObj       
 * @return  
 */
function init(gencfgObj, urlStr)
{
    var component = gencfgObj.getComponentType();
    var childs = gencfgObj.getChilds();
    if (childs.length == 0) 
    {
        return;
    }
    if (component == "combox") 
    {
        handleCombox(gencfgObj, urlStr, childs);
    }
    else if (component == "radio") // radio   
    {
        var componentObj = null;
        var title = null;
        var fieldset = document.createElement("fieldset");
        var table = document.createElement("table");
        table.setAttribute("width", "100%");
        table.style.fontSize = "12px";
        var thead = document.createElement("thead");
        var tbody = document.createElement("tbody");
        var tr = document.createElement("tr");
        var td = null;
        fieldset.setAttribute("id", "selectForm");
        var defaultValue = "";
        for (var i = 0; i < childs.length; i++) 
        {
            td = document.createElement("td");
            td.setAttribute("align", "center");
            componentObj = childs[i];
            title = componentObj.getTitle();
            var innerStr = '<input type="radio" id="' + title + '" name="funcRadio" value="' + title + '" ';
            if (i == 0) 
            {
                defaultValue = title;
                curSelect = title;
                td.innerHTML = innerStr + "checked/>";
            }
            else 
            {
                td.innerHTML = innerStr + "/>";
            }
            td.appendChild(document.createTextNode(RESOURCE[title]));
            tr.appendChild(td);
        }
        
        tbody.appendChild(tr);
        table.appendChild(thead);
        table.appendChild(tbody);
        fieldset.appendChild(table);
        document.body.appendChild(fieldset);
        for (var i = 0; i < childs.length; i++) 
        {
            componentObj = childs[i];
            title = componentObj.getTitle();
            var radio = $(title);
            radio["onclick"] = function()
            {
                if (curSelect != this.id) 
                {
                    refreshComponent(gencfgObj, urlStr, this.value);
                    curSelect = this.id;
                }
            }
        }
        refreshComponent(gencfgObj, urlStr, defaultValue);
    }
    else //    tab  
     {
        var tab = new Tabs();
        if (childs.length > 1) 
        {
            for (var i = 0; i < childs.length; i++) 
            {
                tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame2", "tabs_li_select");
                tab.addTab(i + 1, RESOURCE[childs[i].getTitle()], childs[i].getLink() + urlStr + "&supportAttr=" + childs[i].getSupportAttr());
            }
            tab.selectTab(1);
            document.body.appendChild(tab.getTabs());
            firstSelectTab();
            
        }
        else if (childs.length == 1) //                        
        {
            var frame = document.createElement("iframe");
            frame.setAttribute("align", "center");
            frame.style.width = "100%";
            frame.style.height = "100%";
            frame.style.borderWidth = "0px";
            frame.setAttribute("src", childs[0].getLink() + urlStr + "&supportAttr=" + childs[0].getSupportAttr());
            document.body.appendChild(frame);

            selectFrameTabSelectHandler(window.frames[0]);
        }
    }
}

function handleCombox(gencfgObj, urlStr, childs)
{
    var selectForm = document.createElement("div");
    selectForm.setAttribute("id", "selectForm");
    var selectObj = document.createElement("select");
    selectObj.setAttribute("id", "selectObj");
    var defaultValue = "";
    for (var i = 0; i < childs.length; i++) 
    {
        var componentObj = childs[i];
        var option = document.createElement("option");
        option.appendChild(document.createTextNode(RESOURCE[componentObj.getTitle()]));
        option.value = componentObj.getTitle();
        selectObj.appendChild(option);
        if (i == 0) 
            defaultValue = componentObj.getTitle();
    }
    selectObj["onchange"] = function()
    {
        refreshComponent(gencfgObj, urlStr, this.options[this.selectedIndex].value);
    }
    selectObj["onkeydown"] = function()
    {
        return handleOnkeydown();
    }
    
    selectForm.appendChild(selectObj);
    document.body.appendChild(selectForm);
    refreshComponent(gencfgObj, urlStr, defaultValue);
}

function clearGencfgObj()
{

    var selectElem = $("selectObj");
    purge(selectElem);
    
    if(gencfgObj == null)
    {
    	return;
    }
    
    var childs = gencfgObj.getChilds();
    
    for (var i = 0; i < childs.length; i++) 
    {
        componentObj = childs[i];
        title = componentObj.getTitle();
        var radio = $(title);
        purge(radio);
    }
    
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "boardname";
    errArr[2] = "portid";
    openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *          
 * @param doc:     XML   params     
 * @return  
 */
function initGenCfgPage(doc, params)
{
    genCfgPNPList = new Object();
    var data = EncapsulateData(doc);
    if (0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        params[2] = false;
    }
    else 
    {
        gencfgObj = params[0];
        var urlStr = params[1];
        var unFilterComponetArr = params[2];
        filterAttr(doc, gencfgObj, unFilterComponetArr);
        init(gencfgObj, urlStr);
        params[2] = true;
    }
    
}

/**
 * Tab                     
 * @param doc:     XML   params     
 * @return  
 */
function firstSelectTab()
{
    if (window.frames[0].tabSelectHandler && window.frames[0].document.body) 
    {
        window.frames[0].tabSelectHandler();
    }
    else 
    {
        window.setTimeout(firstSelectTab, 500);
    }
}

function selectFrameTabSelectHandler(frame)
{
    if (frame && frame.document && frame.document.body && frame.loadXMLdoc) 
    {
    	if(frame.tabSelectHandler)
    	{
        	frame.tabSelectHandler();
        }
    }
    else 
    {
        window.setTimeout(function(){selectFrameTabSelectHandler(frame);}, 500);
    }
}

/**
 *         ,   PC          
 * @param  
 * @return  
 */
function handleOnkeydown()
{
    var code = event.keyCode != 0 ? event.keyCode : event.charCode;
    if (code == 38 || code == 40) 
    {
        return false;
    }
}

/**
 *         
 */
function GenCfgAttribute()
{
    this.attrId = "";
    this.attrAccess = "";
    this.domain_list = "";
    this.valueRange = null;
    this.attrRange = null;
}


/**
 *        PNP  
 * @param {Object} data           
 */
function processPNPData(data, rowIndex)
{
    var sysLanguage = SYSTEMCONF.getLanguage();
    var pnpDataObj = new Object();//     PNP       
    var attrId = data.getDataRowParam(rowIndex, "attrId");
    var belongFunId = data.getDataRowParam(rowIndex, "belongFunID");//    ID
    var attrZHName = data.getDataRowParam(rowIndex, "attrZHName");
    var attrENName = data.getDataRowParam(rowIndex, "attrENName");
    var subPageName = data.getDataRowParam(rowIndex, "subPageName");
    var enNameOption = data.getDataRowOptions(rowIndex, "enNameOption");
    var zhNameOption = data.getDataRowOptions(rowIndex, "zhNameOption");
    
    pnpDataObj.attrId = attrId;
    pnpDataObj.belongFunId = belongFunId;
    pnpDataObj.subPageName = subPageName;
    if (sysLanguage == "zh") 
    {
        pnpDataObj.name = attrZHName;
		pnpDataObj.convertArr = zhNameOption;
    }
    else 
    {
        pnpDataObj.name = attrENName;
		pnpDataObj.convertArr = enNameOption;
    }
    
    var colObj = new ColTag();//     
    pnpDataObj.colObj = colObj;
    
    var colId = data.getDataRowParam(rowIndex, "colId");
    var colWidth = data.getDataRowParam(rowIndex, "colWidth");
    var isSort = data.getDataRowParam(rowIndex, "isSort");
    var showElement = data.getDataRowParam(rowIndex, "showElement");
    var keyOption = data.getDataRowOptions(rowIndex, "keyOption");
    var isEdit = data.getDataRowParam(rowIndex, "isEdit");
    
    colObj.id = colId;
    colObj.name = pnpDataObj.name;
    colObj.isSort = isSort;
    colObj.width = colWidth;
    
    if (keyOption != null && keyOption != "") 
    {
        for (var j = 0; j < keyOption.length; j++) 
        {
            var opobj = new OPTag();
            opobj.name = keyOption[j];
            opobj.convert = "convertPNPAttr";
            colObj.keyArray[colObj.keyArray.length] = opobj;
        }
    }
    
    var cellobj = new CellTag();//     
    colObj.cell = cellobj;
    cellobj.isEdit = isEdit;//     
    var showobj = new ElementTag();//    
    showobj.type = showElement;
    cellobj.showElement = showobj;
    
    if (isEdit == "" || isEdit == "0") 
    {
        return;//              
    }
    
    var editElement = data.getDataRowParam(rowIndex, "editElement");//       
    var editobj = new ElementTag();
    editobj.type = editElement;
    if (editElement == "text") //          
    {
        var inputType = data.getDataRowParam(rowIndex, "inputType");
        var vefiobj = new VerifyObj();
        vefiobj.type = inputType;
        if (vefiobj.type == "num") //     
        {
            var range = data.getDataRowParam(rowIndex, "range").split("-");
            vefiobj.min = range[0];
            vefiobj.max = range[1];
        }
        else if (vefiobj.type == "string")//       
        {
            vefiobj.length = data.getDataRowParam(rowIndex, "inputLength");
        }
        else if (vefiobj.type == "func") //    
        {
            vefiobj.length = data.getDataRowParam(rowIndex, "convertFun");
        }
        
        editobj.verify = vefiobj;
    }
    else if (editElement == "select") //        
    {
        var editElementOptions = data.getDataRowOptions(rowIndex, "option");
        var nameParamKey = sysLanguage + "Option";
        var selectOptions = data.getDataRowOptions(rowIndex, nameParamKey);//    
        for (var j = 0; j < editElementOptions.length; j++) 
        {
            var opobj = new OPTag();
            opobj.name = selectOptions[j];//             
            opobj.value = editElementOptions[j];//        
            opobj.convert = "";
            editobj.options[editobj.options.length] = opobj;
        }
    }
    
    cellobj.editElement = editobj;
    
    genCfgPNPList[attrId] = pnpDataObj;//          
}


/**
 *        
 * @param {Object} gencfgObj
 */
function handleSubPage(gencfgObj, subPageName, attrID)
{
    var gencfgChildren = gencfgObj.getChilds();
    for (var j = 0; j < gencfgChildren.length; j++) 
    {
        var gencfgChild = gencfgChildren[j];
        if (gencfgChild.getTitle() == subPageName)//                  
        {
            gencfgChild.supportAttr = gencfgChild.supportAttr + "," + attrID;
        }
        else 
        {
            if (gencfgChild.getChilds().length > 0) 
            {
                handleSubPage(gencfgChild, subPageName, attrID);
            }
        }
    }
}


/**
 *                   PNP  
 * @param {Object} gencfgObj
 */
function addPNPData(gencfgObj)
{
    if (genCfgPNPList.length == 0) 
    {
        return;
    }
    
    var tempPro = getNeProperty(self);
    for (var i in genCfgPNPList) 
    {
        var pnpObj = genCfgPNPList[i];
        if (pnpObj.belongFunId != tempPro.funnodeid)//    ID    
        {
            continue;
        }
        
        gencfgObj.supportAttr = gencfgObj.supportAttr + "," + pnpObj.attrId;
        var subPageName = pnpObj.subPageName;
        if (subPageName != null && subPageName != "") 
        {
            handleSubPage(gencfgObj, subPageName, pnpObj.attrId);//                
        }
    }
}

/**
 *   PNP         
 * @param {Object} arg    
 * @param {Object} attrID   ID
 */
function convertPNPAttr(arg, attrID)
{
    var attrValue = "";
	var pnpObj = parent.genCfgPNPList[attrID];//       PNP      
	if(pnpObj == null)
	{
		return arg;
	}
	else
	{
		return pnpObj.convertArr[arg];//        
	}
}
