
var isBackupToCFSelect = false;

/**
 *        CF 
 *      3   ,         ,        
 * 1.  TL1  
 * 2.   
 * 3.NGWDM R5   
 **/
function backupNeDataToCF()
{
	removejsDOMmenu();
	if (!confirm(RESOURCE["backuptips"]))
	{
		return;
	}
	var selectedrows = st.getSelectedRows();
	var TL1NEIDs = [];
	var NGWDMR5IDs = [];
	var SelectSCCNEIDs = [];
	var OtherNEIDModes = [];
	var neConnectType;
	var rowindex = 0;
	var neid;
	for(var i = 0; i < selectedrows.length; i++)
	{
		rowindex = selectedrows[i];
		neid = st.getCellCurrentValue(rowindex, "neID", "neID");
		neConnectType = st.getCellStoreValue(rowindex, "neConnectType", "neConnectType");
		if(neConnectType == "1")
		{
			TL1NEIDs.push(neid);
		}
		else
		{
			var supportNew = st.getCellStoreValue(rowindex, "supportstatus", "CFNew");
			if(supportNew == "true")
			{
				NGWDMR5IDs.push(neid);
			}
			else
			{
				var beforeFlag = st.getCellStoreValue(rowindex, "supportstatus", "CFBefore");
				if(beforeFlag == "true")
				{
					SelectSCCNEIDs.push(neid);
				}
				else
				{
					var mode = st.getCellStoreValue(rowindex, "supportstatus", "CFMode");
					OtherNEIDModes.push({neid:neid,mode:mode});
				}
			}
		}
	}
	if(TL1NEIDs.length > 0)
	{
		backupTL1NeData(TL1NEIDs);
	}
	if(NGWDMR5IDs.length > 0)
	{
		backupNeCFDataNew(NGWDMR5IDs);
	}
	if(OtherNEIDModes.length > 0)
	{
		backupNeDataToCFOther(OtherNEIDModes);
	}
	if(SelectSCCNEIDs.length > 0)
	{
		beforeBackupToCF(SelectSCCNEIDs);
	}
}

function backupTL1NeData(neids)
{
	GlobalStatus.isBackuping = true;
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	GlobalStatus.sending = true;
	$("backupNeData").disabled = true; //              
	disableAllBtn();
	for (i = 0; i < neids.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neids[i]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "DATAMOD");
		param.setAttribute("value", "BACKUP");
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	var backupURL = "../tl1NEManagerServlet?sfid=" + TECMDCODE_CFCARD_BACKUP + "&flag=1&timestamp=" + new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, backupHandler, null, "inputdata=" + di.toString());
	
	showLoadProcess();
}

function backupNeCFDataNew(neids)
{
	GlobalStatus.isBackuping = true;
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	GlobalStatus.sending = true;
	$("backupNeData").disabled = true; //              
	disableAllBtn();
	for (i = 0; i < neids.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neids[i]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", 0);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "snkmemory");
		param.setAttribute("value", 2);
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	var backupURL = "../neListServlet?sfid=" + 1087 + "&flag=1&timestamp="+new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, backupHandler, null, "inputdata=" + di.toString());
	
	showLoadProcess();
}

function backupNeDataToCFOther(neidmode)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	for (i = 0; i < neidmode.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neidmode[i].neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcmemory");
		param.setAttribute("value", 2);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkmemory");
		param.setAttribute("value", neidmode[i].mode);
		row.appendChild(param);
		bussiness.appendChild(row);

		row = null;
		param = null;
	}
	di.getRoot().appendChild(bussiness);
	_backupNeData(di);
}

var cfDi;
function beforeBackupToCF(neIDs)
{
	 cfDi = null;
    var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
    var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neids");
	param.setAttribute("value", neIDs.toString());
	row.appendChild(param);				
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
	
	cfDi = di;
	
    var backupURL = "../neListServlet?sfid=" + 1086 + "&flag=1&timestamp="+new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, beforeBackupToCFHandler, null, "inputdata=" + di.toString());
}
var cfData;

function beforeBackupToCFHandler(doc)
{
    cfData = null;
 
    var data = EncapsulateData(doc);
    if(data.getDataRowLength() <= 0)
    {
        alert(RESOURCE["nores"]);
        return;
    }
    cfData = data;   
    xshowModalDialog("backupcf.html", RESOURCE["backuptocf"], 520, 320, "../images/");
}

function backupNeDataToSCC()
{
	removejsDOMmenu();
	if (!confirm(RESOURCE["backuptips"]))
	{
		return;
	}
	
	var selectedrows = st.getSelectedRows();
	var TL1NEIDs = [];
	var OtherNEIDModes = [];
	for(var i = 0; i < selectedrows.length; i++)
	{
		rowindex = selectedrows[i];
		neid = st.getCellCurrentValue(rowindex, "neID", "neID");
		neConnectType = st.getCellStoreValue(rowindex, "neConnectType", "neConnectType");
		if(neConnectType == "1")
		{
			TL1NEIDs.push(neid);
		}
		else
	
		{
			var mode = st.getCellStoreValue(rowindex, "supportstatus", "SCCMode");
			OtherNEIDModes.push({neid:neid,mode:mode});
		}
	}
	if(TL1NEIDs.length > 0)
	{
		backupTL1SCCData(TL1NEIDs);
	}
	if(OtherNEIDModes.length > 0)
	{
		backupNeDataToSCCOther(OtherNEIDModes);
	}
}

function backupTL1SCCData(neids)
{
	GlobalStatus.isBackuping = true;
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	GlobalStatus.sending = true;
	$("backupNeData").disabled = true; //              
	disableAllBtn();
	for (i = 0; i < neids.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neids[i]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "SRCAREA");
		param.setAttribute("value", "DRDB");
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "DSTAREA");
		param.setAttribute("value", "FDB0");
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	var backupURL = "../tl1NEManagerServlet?sfid=524468180&flag=1&timestamp=" + new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, backupHandler, null, "inputdata=" + di.toString());
	
	showLoadProcess();
	
	
}

function backupNeDataToSCCOther(neidmode)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	for (i = 0; i < neidmode.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neidmode[i].neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcmemory");
		param.setAttribute("value", 2);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkmemory");
		param.setAttribute("value", neidmode[i].mode);
		row.appendChild(param);
		bussiness.appendChild(row);

		row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value",neidmode[i].neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcmemory");
		param.setAttribute("value", 2);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "snkmemory");
		param.setAttribute("value", 1);
		row.appendChild(param);
		bussiness.appendChild(row);
		row = null;
		param = null;
	}
	di.getRoot().appendChild(bussiness);
	_backupNeData(di);
}


function _backupNeData(di)
{    
	
    GlobalStatus.sending = true;
    $("backupNeData").disabled = true; //              
    var rows = di.getRoot().childNodes[0].childNodes;
    if(rows.length <= 0)
    {
        GlobalStatus.sending = false;
        return;
    }
    var backupURL = "../neListServlet?sfid=" + TECMDCODE_CFCARD_BACKUP + "&flag=1&timestamp="+new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, backupHandler, null, "inputdata=" + di.toString());
	if(!isBackupToCFSelect)
	{
	   showLoadProcess();
	}
}

function backupHandler(doc)
{
	
	if(isBackupToCFSelect)
	{
		isBackupToCFSelect = false;
	}
	
	removeLoadProcess();
	
	var result = EncapsulateData(doc);// deal with the data.
	var errorCode = result.getSErrorCode();

	if (errorCode != 0)
	{
		var errArr = [];
		errArr[0] = "nename";
		openErrPage("", result.getError(), errArr)
		errArr = null;
	}
	else
	{
		/**
		 * 2012-01-31 14:36   wangxun 00145400   NSCMD_DBMS_COPY_ALL                
		 */
		alert(RESOURCE["operatesucc"]);//              
	}
	GlobalStatus.sending = false;
	GlobalStatus.isBackuping = false;
	$("backupNeData").disabled = true; //              
	enableButton(st.getSelectedRows());
	$("searchNe").disabled = false;
	$("addNe").disabled = false;
}

function restoreDatabase()
{
	removejsDOMmenu();
	
	if (!confirm(RESOURCE["restoretips"]))
	{
		return;
	}
	GlobalStatus.isBackuping = true;
	var selectedrows = st.getSelectedRows();

	var TL1NEIDs = [];
	var OtherNEIDs = [];
	for(var i = 0; i < selectedrows.length; i++)
	{
		rowindex = selectedrows[i];
		neid = st.getCellCurrentValue(rowindex, "neID", "neID");
		neConnectType = st.getCellStoreValue(rowindex, "neConnectType", "neConnectType");
		if(neConnectType == "1")
		{
			TL1NEIDs.push(neid);
		}
		else
		{
			OtherNEIDs.push(neid);
		}
	}
	if(TL1NEIDs.length > 0)
	{
		restoreDatabaseTL1(TL1NEIDs);
	}
	if(OtherNEIDs.length > 0)
	{
		restoreDatabaseOther(OtherNEIDs);
	}
}

function restoreDatabaseTL1(neids)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	$("restoreNeData").disabled = true; //              
	disableAllBtn();
	for (i = 0; i < neids.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neids[i]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "DATAMOD");
		param.setAttribute("value", "RECOVER");
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	var backupURL = "../tl1NEManagerServlet?sfid=524468181&flag=1&timestamp=" + new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, restoreHandler, null, "inputdata=" + di.toString());
	
	showLoadProcess();
}

function restoreDatabaseOther(neids)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	$("restoreNeData").disabled = true; //              
	disableAllBtn();
	for (i = 0; i < neids.length; i++)
	{
		var row = new tagElement("row-params");
		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neids[i]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", 0);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "datatype");
		param.setAttribute("value", 2);
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	var backupURL = "../neListServlet?sfid=1088&flag=1&timestamp=" + new Date().getTime();
	loadXMLdoc(backupURL, "POST", true, restoreHandler, null, "inputdata=" + di.toString());
	
	showLoadProcess();
}

function restoreHandler(doc)
{
	removeLoadProcess();
	var result = EncapsulateData(doc);// deal with the data.
	var errorCode = result.getSErrorCode();
	if (errorCode != 0)
	{
		var errArr = [];
		errArr[0] = "nename";
		openErrPage("", result.getError(), errArr)
		errArr = null;
	}
	else
	{
		alert(RESOURCE["restoretips1"]);//              
	}
	$("restoreNeData").disabled = false;
	
	GlobalStatus.isBackuping = false;
	enableButton(st.getSelectedRows());
	$("searchNe").disabled = false;
	$("addNe").disabled = false;
}

function showAutoDlg()
{
	removejsDOMmenu();
	var selectedrows = st.getSelectedRows();
	xshowModalDialog("autobackup.html", RESOURCE["autobackTitle"], 480,
			290, "../images/");
}

function showLoadProcess()
{
	LoadingProcess.showWaitStatus("../images");
}

function removeLoadProcess()
{
	LoadingProcess.removeWaitStatus();
}
