var parentwin = getParentWindow();//     
var winurlobj = getNeProperty(self);
var oldNeIdMap = [];

/**
 *        
 */
function init()
{
    if (!parentwin) 
    {
        return;
    }
    st = new SortTable();
    st.setImage("../images/");
    st.setBodyHeight(180);
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(dataChange);
    document.getElementById("tablecontainer").appendChild(st.getTable());
    
    var resobj = new Object();
    addEleToObj(resobj, "ok", "okbutton");
    addEleToObj(resobj, "cancle", "cancelbutton");
    addEleToObj(resobj, "apply", "applybutton");
    convert_res(resobj, RESOURCE, document);
    
    document.getElementById("apply").disabled = true;
    
    initData();//        
}

/**
 *         
 */
function initData()
{
    var selRows = parentwin.st.getSelectedRows();
    var root = document.createElement("datainterface");
    for (var i = 0; i < selRows.length; i++) 
    {
    	if(!parentwin.isSupportModifyNeID(selRows[i]))
		{
			continue;
		}
        var neidval = parentwin.st.getCellStoreValue(selRows[i], "realNEID", "realNEID");
        var neidvalue = getNeid(neidval).split("-");//   ID ID    
        var row = document.createElement("row-params");
        var param = document.createElement("param");//  ID
        param.setAttribute("name", "extendid");
        param.setAttribute("value", neidvalue[0]);
        row.appendChild(param);
        
        param = document.createElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neidvalue[1]);
        row.appendChild(param);
        
        param = document.createElement("param");//    ID
        param.setAttribute("name", "neLogicID");
        var neLogicID = parentwin.st.getCellStoreValue(selRows[i], "neID", "neID");
        param.setAttribute("value", neLogicID);
        row.appendChild(param);
        
        var nename = parentwin.st.getCellStoreValue(selRows[i], "neName", "neName");
        param = document.createElement("param");//    
        param.setAttribute("name", "neName");
        param.setAttribute("value", nename);
        row.appendChild(param);
        
        var deviceType = parentwin.st.getCellStoreValue(selRows[i], "deviceType", "deviceType");
        param = document.createElement("param");//    
        param.setAttribute("name", "deviceType");
        param.setAttribute("value", deviceType);
        row.appendChild(param);
        
        root.appendChild(row);
        oldNeIdMap[neLogicID] = getNeid(neidval);
    }
    
    if (root.childNodes.length > 0) 
    {
        di = EncapsulateData(root);
        createTableBody(st, window.tableconf[0], di, RESOURCE);
		for (var i = 0, m = st.getDataRowLength(); i < m; i++)
		{
			var cell = st.getCellEdit(i, "extendid", "extendid");
			textCheck(cell.element, "1", "254");
			
			cell = st.getCellEdit(i, "neid", "neid");
			textCheck(cell.element, "1", "49151");
		}
    }
}

/**
 *       
 */
function dataChange()
{
    document.getElementById("apply").disabled = false;
}

/**
 *       
 */
function okClick()
{
	if(document.getElementById("apply").disabled == true)
	{
		xcloseDialog();
	}
    sendModify(true);
}

/**
 *       
 */
function closeClick()
{
    xcloseDialog();
}

/**
 *       
 */
function applyClick()
{
    sendModify(false);
}

/**
 *       ID
 */
function sendModify(isCloseDlg)
{
    document.getElementById("ok").disabled = true;
    document.getElementById("cancle").disabled = true;
    document.getElementById("apply").disabled = true;
    var notChangeRowCount = 0;
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        if (!st.getModify(i)) 
        {
            notChangeRowCount++;
            continue;
        }
        var neLogicID = st.getCellStoreValue(i, "neLogicID", "neLogicID");//    ID
        var parentRowIndex = st.getCellStoreValue(i, "parentRowIndex", "parentRowIndex");//        
        var extendId = st.getCellStoreValue(i, "extendid", "extendid");//    ID
        var neid = st.getCellStoreValue(i, "neid", "neid");//  ID
        var oldNeid = oldNeIdMap[neLogicID].split("-");
        if (oldNeid[0] == extendId && oldNeid[1] == neid)//           
        {
            notChangeRowCount++;
            continue;
        }
		var paramArr = [];
		paramArr.push(isCloseDlg);
		paramArr.push(parentRowIndex);
		paramArr.push(neLogicID);
        var urlreq = "../neExlorerServlet?sfid=" + TECMDCODE_MODIFY_NEID;
        loadXMLdoc(urlreq, "POST", true, modifyHandler, paramArr, "inputdata=" + createModifyXML(neLogicID, neid, extendId));
    }
    
    if (notChangeRowCount == st.getDataRowLength()) 
    {
        alert(RESOURCE["dataNotChange"]);//               
        if (isCloseDlg) 
        {
            xcloseDialog();
        }
        else 
        {
            document.getElementById("ok").disabled = false;
            document.getElementById("cancle").disabled = false;
            document.getElementById("apply").disabled = false;
        }
    }
}

/**
 *      xml  
 * @param {Object} neLogicID
 * @param {Object} newBaseID
 * @param {Object} newEID
 */
function createModifyXML(neLogicID, newBaseID, newEID)
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neLogicID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "baseid");
    param.setAttribute("value", newBaseID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eid");
    param.setAttribute("value", newEID);
    row.appendChild(param);
    
    var logstr = RESOURCE["newBaseID"] + newBaseID + ";" + RESOURCE["newEID"] + newEID + ";";
    param = new tagElement("param");
    param.setAttribute("name","opDesc");
    param.setAttribute("value",logstr);    
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *     ID    
 * @param {Object} doc
 */
function modifyHandler(doc, paramArr)
{
    $("ok").disabled = false;
    $("cancle").disabled = false;
    var data = EncapsulateData(doc);
    var result = data.getSErrorCode();
    
    if (41020008 == result || 1090650120 == result || result == 0) 
    {
        alert(RESOURCE["modifySuccAlert"]);
        if (paramArr[0]) 
        {
            xcloseDialog();
            return;
        }
        document.getElementById("ok").disabled = false;
        document.getElementById("cancle").disabled = false;
    }
    else 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", data.getError(), errArr);
        document.getElementById("ok").disabled = false;
        document.getElementById("cancle").disabled = false;
        document.getElementById("apply").disabled = false;
    }
    refreshTableState(st, window.tableconf[0], data);
}
