window.tabs = [];
function Tabs()
{
 this.id = window.tabs.length;
 window.tabs[this.id] = this;
 this.TabHead = document.createElement("div");
 this.TabHead.appendChild(document.createElement("ul"));
 this.TabBody = document.createElement("div");
 this.TabBody.parent = this;
 this.TabBody.setAttribute("align", "center");
 this.selectTabid;             
 this.selectTabClass = "";    
 this.t_headClass = "";
 this.t_bodyClass = "";
 this.tabNodes = new Object();
 this.lazyNodes = new Array();  
 
 this.getAllTabsID= function (){
    var result =[];  
  for( var key in this.tabNodes){
   result.push(key);
  }
  return result;
 }

 this.addTab = function(tid, headstr, burl)
 {
  
    if(typeof this.tabNodes[tid] == "undefined")
    {
       this.add(tid, headstr, burl);
     }else{
         this.removeTabNode(tid);
         this.add(tid, headstr, burl)
     }
 }

 this.getTab=function(tid){
  
   if(typeof this.tabNodes[tid] == "undefined"){
    
     alert("not found "+tid+" page"); 
     return ; 
  }else{
   
   return this.tabNodes[tid];
  }
  
 } 
 

 this.add = function(tid, headstr, burl)
 {
  var t = new Tab(tid, headstr, burl)
  this.tabNodes[tid] = t;
  if(typeof this.selectTabid != "undefined")
  {
   this.tabNodes[this.selectTabid].head.className = this.t_headClass;
   this.tabNodes[this.selectTabid].body.style.display = "none";
  }
  this.tabNodes[tid].head.className = this.t_headClass; 
  this.tabNodes[tid].body.className = this.t_bodyClass;
  this.TabHead.firstChild.appendChild(this.tabNodes[tid].head);
 }
 this.disableTabs = function()
 {
 	  var tids = this.getAllTabsID();
 	  for(var i=0;i<tids.length;i++)
 	  {
 	  	var tempstr = tids[i];
 	  	this.tabNodes[tempstr].head.firstChild.removeAttribute("href");
 	  }
 }
 
 this.activeAllTab = function()
 {
 	  var tids = this.getAllTabsID();
 	  for(var i=0;i<tids.length;i++)
 	  {
 	  	var tempstr = tids[i];
 	  	this.tabNodes[tempstr].head.firstChild.setAttribute("href", "javascript:void window.tabs[" + this.id + "].selectTab('" + tids[i] + "');");
 	  }
 }
 this.loadTab = function(tid)
 {
 	 	this.disableTabs();
 	
	 	
 	  this.TabBody.appendChild(this.tabNodes[tid].body);
 	  
 	  this.lazyNodes[tid] = tid;
		EventUtil.addEventHandler(this.tabNodes[tid].body,"load",readystatechange);  
 }
 
 
 function readystatechange()
 {
 	  

		var tabsid = window.tabs.length -1;
		var tabs = window.tabs[tabsid].tabNodes;
		
		var result =[];  
	  for( var key in tabs){
	   result.push(key);
	  }
		for(var i=0;i<result.length;i++)
 	  {
 	  	window.tabs[tabsid].tabNodes[result[i]].head.firstChild.setAttribute("href", "javascript:void window.tabs[" + tabsid + "].selectTab('" + result[i] + "');");
 	  	EventUtil.removeEventHandler(window.tabs[tabsid].tabNodes[result[i]].body,"load",readystatechange);
 	  }
 	  
 }
 this.setClass = function(theadstr, tbodystr, hcontentstr, t_hstr, t_bstr, t_selectstr)
 {
  this.TabHead.className = theadstr;   
  this.TabBody.className = tbodystr;   
  this.TabHead.firstChild.className = hcontentstr; 
  this.t_headClass = t_hstr;    
  this.t_bodyClass = t_bstr;   
  this.selectTabClass = t_selectstr;    
 }
 
 this.selectTab = function(key)
 {
 	 if(this.lazyNodes[key] == null)
 	 {
 	 	  this.loadTab(key);
 	 }
   if(this.tabNodes[this.selectTabid])
   {
    this.tabNodes[this.selectTabid].head.className = this.t_headClass;
    this.tabNodes[this.selectTabid].head.firstChild.style.color = "#000000";
    this.tabNodes[this.selectTabid].body.style.display = "none";
    var  oldTabWin=this.getTabWindow(this.selectTabid);
    if(oldTabWin && oldTabWin.hideMenu){
     oldTabWin.hideMenu();
    }
    }
    if(!this.tabNodes[key]){
   return;
  }
  this.selectTabid = key;
  this.tabNodes[key].head.className = this.selectTabClass;
  this.tabNodes[this.selectTabid].head.firstChild.style.color = "#0000FF";
  this.tabNodes[key].body.style.display = "";
   
    var tabWin=this.getTabWindow(key);
    if(tabWin && tabWin.hideMenu){
      tabWin.hideMenu();
    }
     if(tabWin && tabWin.frames){
     var len=tabWin.frames.length;
    for(var i=0; i<len; i++){
         if(tabWin.frames[i].hideMenu){
          tabWin.frames[i].hideMenu();
         }
     }
     }
  
      
  if(tabWin && tabWin.tabSelectHandler)
  {
   tabWin.tabSelectHandler();
  }
  
 }
 
 
 this.getTabWindow = function (key){
 
   var frameIndex=-1;
    var iframeArray=document.getElementsByTagName("iframe");
  for(var i=0; i< iframeArray.length; i++)
  {
   if(iframeArray[i].name==key)
   {
     frameIndex =i;
     break; 
   }
      }
  return window.frames[frameIndex];
 }
 
 
 this.closeTab = function(key)
 {
  var sibling;
  if((key != this.selectTabid) || (!(this.tabNodes[key].head.nextSibling) && !(this.tabNodes[key].head.previousSibling)))
  {
   this.removeTabNode(key);
  }
  else if((sibling = this.tabNodes[key].head.nextSibling) || (sibling = this.tabNodes[key].head.previousSibling))
  {
   var t_id = sibling.id.substring(9);
   this.removeTabNode(key);
   this.selectTabid = t_id;
   this.tabNodes[t_id].head.className = this.selectTabClass;
   this.tabNodes[t_id].body.style.display = "";
  }
 }
 
 this.removeTabNode = function(key)
 {
  if(!this.tabNodes[key]){
    return; 
  }
  this.TabHead.firstChild.removeChild(this.tabNodes[key].head);
  this.TabBody.removeChild(this.tabNodes[key].body);
  delete this.tabNodes[key];
  if(this.selectTabid == key)
  {
   delete this.selectTabid;
  }
 }
 
 this.getTabs = function()
 {
  var div = document.createElement("div");
  div.appendChild(this.TabHead);
  div.appendChild(this.TabBody);
  return div;
 }
    function focusHandler(){
     this.blur();
   }
 
    function Tab(tid, headstr, burl)
    {   
     this.id = tid;
     this.head = document.createElement("li");
     this.head.setAttribute("id", "tab_head_"+tid)
     var anchor = document.createElement("a");
     anchor.onfocus=focusHandler;
     anchor.setAttribute("target", "_self");
     anchor.appendChild(document.createTextNode(headstr));
     this.head.appendChild(anchor);

     this.body = document.createElement("iframe");
     this.body.setAttribute("name", this.id);
     this.body.setAttribute("align", "center");
     this.body.setAttribute("id", "tab_body_"+tid);
     if(burl.indexOf("?")!=-1){
     	 burl=burl+"&r="+ Math.random();
     }else{
       burl=burl+"?r="+ Math.random();
     }
     this.body.src = burl;
     
     this.body.style.display = "none";
     
     this.getID = function()
     {
      return this.id;
     }
     
     this.getHead = function()
     {
      return this.head;
     }
     
     this.getBody = function()
     {
      return this.body;
     }
    }
    
    this.setCloseImage = function(path)
    {   
     Tab.imagesrc = path;
    }
}
