hfSysActions = new Object();

/**
 * Tree Widget
 * -------------------------------------------------
 * DOM-Tree         class        Element-Type
 * -------------------------------------------------
 * li               TreeNode
 *   table
 *   . tbody
 *   .   tr                      object
 *   .     td       TreeButton* 
 *   .     td       <icon 1>     attribute
 *   .     td       <icon 2>     attribute
 *   .     ...
 *   .     td       <icon n>     attribute
 *   .     td                    attribute
 *   .       #text
 *   ul             TreeFolder
 * -------------------------------------------------
 */

function hfTree_GetButtonElement(node) {
	return node.firstChild.firstChild.firstChild.firstChild;
}

function hfTree_GetNodeElement(ele) {
	var x = ele;
	while (x && x.className != "TreeNode")
		x = x.parentNode;
	if (x)
		return x;
	else
		return null;
}

function hfTree_GetFolderElement(node) {
	return node.parentNode;
}

function hfTree_GetSubFolderElement(node) {
	if (node.childNodes.length == 2)
		return node.lastChild;
	else
		return null;
}

function hfTree_GetAttributeElement(node, attrName) {
	var eid = new HFEID(node.id);
	return node.getElementById(eid.asAID(attrName));
}

function hfTree_AddNodeElement(container, eid, label, icons) {
	var doc = container.ownerDocument;
	var li = doc.createElement('li');
	li.className = "TreeNode";
	var item = li.appendChild(doc.createElement('table'));
	item.cellSpacing = "0";
	var itemB = item.appendChild(doc.createElement('tbody'));
	var itemC = itemB.appendChild(doc.createElement('tr'));
	if (eid != null)
		itemC.id = eid.asOID();
	var btn = itemC.appendChild(doc.createElement('td'));
	btn.className = "TreeButtonNone";
	for (var name in icons) {
		var iconName = icons[name];
		var td = itemC.appendChild(doc.createElement('td'));
		if (eid != null)
			td.id = eid.asAID(name);
		td.className = iconName;
	}
	var td = itemC.appendChild(doc.createElement('td'));
	if (eid != null)
		td.id = eid.asAID("_");
	td.className = "TreeLabel SelStateOff";
	td.appendChild(doc.createTextNode(label));
	container.appendChild(li);
	return li;
}

function hfTree_CreateFolderElement(node, isOpen) {
	var doc = node.ownerDocument;
	var btn = hfTree_GetButtonElement(node);
	hfAttachEvent(btn, 'click', hfTree_OnButtonClick);
	var ul = node.appendChild(doc.createElement('ul'));
	ul.className = "TreeFolder";
	if (isOpen)
		btn.className = "TreeButtonOpen";
	else {
		btn.className = "TreeButtonClose";
		ul.style.display = "none";
	}
	
	return ul;
}

function hfTree_OnButtonClick(evt) {
	var btn = evt.currentTarget;
	var folder = btn.parentNode.parentNode.parentNode.nextSibling;
	hfConsumeEvent(evt);

	if (folder) {
		if (btn.className == "TreeButtonOpen") {
			folder.style.display = "none";
			btn.className = "TreeButtonClose";
		}
		else {
			folder.style.display = "block";
			btn.className = "TreeButtonOpen";
		}
	}
}

function hfTree_ExpandNode(node, isExpand) {
	var folder = hfTree_GetSubFolderElement(node);
	if (folder == null)
		return;
	var btn = hfTree_GetButtonElement(node);
	isExpand = (isExpand == null) ? true : isExpand;
	if (isExpand) {
		folder.style.display = "block";
		btn.className = "TreeButtonOpen";
	}
	else {
		folder.style.display = "none";
		btn.className = "TreeButtonClose";
	}
}

/**
 * Tabel Widget
 */

function hfTable_AddRow(container, id, className) {
	var doc = container.ownerDocument;
	var ele = container.appendChild(doc.createElement('tr'));
	if (id != null)
		ele.id = id;
	if (className != null)
		ele.className = className;
	return ele;
}

function hfTable_AddCell(container, id, className, text) {
	var doc = container.ownerDocument;
	var ele = container.appendChild(doc.createElement('td'));
	if (id != null)
		ele.id = id;
	if (text != null)
		ele.appendChild(doc.createTextNode(text));
	if (className != null)
		ele.className = className;
	return ele;
}

/**
 * Menu Widget
 */

function HFMenu(width) {
	this.width = width;
	this.items = new Array();
	this.add = function(item) {
		this.items.push(item);
	}

	this.popup = function(evt,eid) {
		var pt = new HFPoint(evt.clientX, evt.clientY);
		var win = hfGetTopContainer(pt);
		if (win)
			win.hfPopupMenuOnTop(this, pt,eid);
	}
}

function hfHidePopup() {
	var win = hfGetTopContainer(null);
	if (win)
		win.hfHidePopupMenuOnTop();
}

function HFAction(name, label, icon, handler, updater) {
	this.name  = name;
	this.label = label;
	this.icon  = icon;
	this.handler = handler;
	this.updater = updater;
}

