hfSelection = new Array();
hfViewName = null;
hfForm = null;

function hfGetSelHighLightElement(eid) { return document.getElementById(eid.asOID()); }
function hfPostInitView() {}
function hfGetPopupMenu(eid) { return null; }

function _hf_hidePopupHandler(evt) {
	evt = evt ? evt : window.event;
	evt.cancelBubble = true;
	if (evt.preventDefault)
		;//evt.preventDefault();
	else
		evt.returnValue = false;
	hfHidePopup();
}

function hfInitView() {
	document.body.onclick = _hf_hidePopupHandler;
	document.body.oncontextmenu = _hf_hidePopupHandler;

	hfLogEnabled = true;
	
	var win = window.window;
	while (win && win.parent != win) {
		if (win.parent.hfDispatch != null) {
			hfForm = win.parent;
			hfViewName = win.frameElement.id;
			break;
		}
		else
			win = win.parent;
	}

	hfHidePopup();
	hfPostInitView();
}

function hfNotifyForm() {
	if (hfForm) {
		var args = new Array();
		var eventName = arguments[0];
		for (var i = 1; i < arguments.length; ++i)
			args.push(arguments[i]);
		hfForm.hfDispatch(hfViewName, eventName, args);
	}
}

function hfSetSelectedItem(oid, inc) {
	var changed = false;
	if (!inc) {
		hfSelection = new Array();
		changed = true;
	}

	if (oid) {
		hfSelection[oid] = true;
		changed = true;
	}

	if (changed) {
		hfNotifyForm('selchanged', oid);
	}
}

function hfClearSelState() {
	for (var oid in hfSelection) {
		var ele = hfGetSelHighLightElement(new HFEID(oid));
		if (ele)
		{
			ele.className = ele.className.replace("SelStateOn", "SelStateOff");
			ele.className = ele.className.replace("SelSStateOn", "SelSStateOff");
		}
	}
}

function hfSetSelState(eid) {
	var ele = hfGetSelHighLightElement(eid);
	if (ele)
	{
		ele.className = ele.className.replace("SelStateOff", "SelStateOn");
		ele.className = ele.className.replace("SelSStateOff", "SelSStateOn");
	}
}

function hfGetEIDFromEvent(evt) {
	var ele = evt.target;
	while (ele != null) {
		var id = ele.id;
		if (id != null) {
			var eid = new HFEID(id);
			eid.bstate = ele.bstate ;
			eid.btype = ele.bdid;
			eid.bname = ele.blabel;
			eid.bslotlist = ele.slotlist;
			eid.subslot = ele.subslot;
			eid.issupportsubcard = ele.issupportsubcard;
			eid.supportsubtypes = ele.supportsubtypes;
			if (eid.type != null)
				return eid;
		}
		
		ele = ele.parentNode;
	}
	
	return null;
}

function hfItemClickHandler(evt) {
	hfHidePopup();
	hfClearSelState();
	var eid = hfGetEIDFromEvent(evt);
	hfConsumeEvent(evt);
	if (!eid)
		return;

	hfSetSelState(eid);
	hfSetSelectedItem(eid.asOID());
}

function hfItemContextMenuHandler(evt) {
	hfClearSelState();
	var eid = hfGetEIDFromEvent(evt);
	hfConsumeEvent(evt);
	if (!eid)
		return;

	hfSetSelState(eid);
	hfSetSelectedItem(eid.asOID());
	var menu = hfGetPopupMenu(eid);
	if (menu)
		menu.popup(evt,eid);
}

function hfCommitHandler(evt) {
	if (hfCommitView != null)
		hfCommitView();
}

function hfRefreshHandler(evt) {
	if (hfUpdateView != null)
		hfUpdateView();
}

hfSysActions.commit = new HFAction("commit", "Commit", "COMMIT", hfRefreshHandler);
hfSysActions.refresh = new HFAction("refresh", "Refresh", "REFRESH", hfRefreshHandler);
hfSysActions.logger = new HFAction("logger", "L", null, hfToggleLogger);
