function HFDecoratorBuilder(node) {
	this.cname = node.getAttribute('class');
	this.top = node.getAttribute('top');
	this.right = node.getAttribute('right');
	this.bottom = node.getAttribute('bottom');
	this.left = node.getAttribute('left');
	this.width = node.getAttribute('width');
	this.height = node.getAttribute('height');
	this.content = node.getAttribute('content');
	this.build = function(container) {
		var div = document.createElement('div');
		container.appendChild(div);
		div.style.position = "absolute";
		if (this.cname) div.className = this.cname;
		if (this.top) div.style.top = this.top + 'px';
		if (this.right) div.style.right = this.right + 'px';
		if (this.bottom) div.style.bottom = this.bottom + 'px';
		if (this.left) div.style.left = this.left + 'px';
		if (this.width) div.style.width = this.width + 'px';
		if (this.height) div.style.height = this.height + 'px';
		if (this.content)
			div.appendChild(document.createTextNode(this.content));
	}
}

function HFLayoutPosition() {
	this.top = null;
	this.right = null;
	this.bottom = null;
	this.left = null;
	this.width = null;
	this.height = null;
	this.read = function(node) {
		this.top = node.getAttribute('top');
		this.right = node.getAttribute('right');
		this.bottom = node.getAttribute('bottom');
		this.left = node.getAttribute('left');
		this.width = node.getAttribute('width');
		this.height = node.getAttribute('height');
	}
}

function HFLayoutTemplate() {
	this.cname = null;
	this.width = null;
	this.height = null;
	this.decos = new Array();
	this.slots = new Array();
	this.read = function(root) {
		this.cname = root.getAttribute('class');
		this.width = parseInt(root.getAttribute('width'));
		this.height = parseInt(root.getAttribute('height'));
		for (var i = 0; i < root.childNodes.length; ++i) {
			var node = root.childNodes.item(i);
			if (node.tagName == 'slot') {
				var pos = new HFLayoutPosition();
				pos.read(node);
				this.slots[node.getAttribute('n')] = pos;
			}
			else if (node.tagName == 'deco') {
				this.decos.push(new HFDecoratorBuilder(node));
			}
		}
	}

	this.build = function(c, layout, pos) {
		var div = c.appendChild(document.createElement('div'));
		if (this.cname)
			div.className = this.cname + ' SelStateOff';
		if (layout.oid)
			div.setAttribute('id', layout.oid);
		div.style.position = 'absolute';
		div.style.padding = '1px';
		if (pos != null) {
			if (pos.top) div.style.top = pos.top + 'px';
			if (pos.right) div.style.right = pos.right + 'px';
			if (pos.bottom) div.style.bottom = pos.bottom + 'px';
			if (pos.left) div.style.left = pos.left + 'px';
			if (pos.width) div.style.width = pos.width + 'px';
			if (pos.height) div.style.height = pos.height + 'px';
		}

		var content = div.appendChild(document.createElement('div'));
		content.style.position = "relative";
		content.style.width = this.width + 'px';
		content.style.height = this.height + 'px';

		for (var i in this.decos) {
			var deco = this.decos[i];
			deco.build(content);alert(deco.cname+" deco.build()");
		}

		return content;
	}
}

function hfLoadLayoutTemplate(layout, data, cb) {
	var type = layout.type;
	hfAsyncLoad("GET", "../cfg/layout/" + type + ".xml", function(doc) {
		var template = new HFLayoutTemplate();
		template.read(doc.documentElement);alert("hfLoadLayoutTemplate")
		priv.layoutTemplates[type] = layout;
		layout.template = template;
		if (cb)
			cb(layout, data);
	});
}

function HFLayout(oid, type) {
	this.oid = oid;
	this.type = type;
	this.subs = new Array();
	
	this.add = function(n, sub) {
		this.subs[n] = sub;
		return sub;
	}

	this.build = function(c, pos) {
		var x = this;
		hfAsyncLoad("GET", "../cfg/layout/" + type + ".xml", function(doc) {
			var t = new HFLayoutTemplate();
			t.read(doc.documentElement);alert(type + ".xml"+" HFLayoutTemplate.build()")
			var content = t.build(c, x, pos);
			for (var sn in t.slots) {
				var subpos = t.slots[sn];
				var sub = x.subs[sn];
				if (sub)
					sub.build(content, subpos);alert("HFLayout.subs:"+t.slots[sn])
			}
		});
	}
}

