hfLogEnabled = false;
hfLogLevel = 0;
hfErrorHandler = null;

priv = new Object();
priv.hfHeader = null;

function hfUnsupportBrowserError(msg) {
	throw new Error("Unsupport Browser", msg);
}

/**
 * Logger
 */

function hfLogMsg(msg, level) {
	if (!hfLogEnabled || level < hfLogLevel)
		return;
	var logger = hfGetHeader().logger;
	while (logger.childNodes.length > 20)
		logger.removeChild(logger.firstChild);
	var li = logger.appendChild(document.createElement("li"));
	li.appendChild(document.createTextNode(msg));
	li.className = "LogLevel_" + level;
}

function hfDebugFine(msg) {
	hfLogMsg(msg, 0);
}

function hfDebug(msg) {
	hfLogMsg(msg, 1);
}

function hfWarning(msg) {
	hfLogMsg(msg, 2);
}

function hfError(msg) {
	hfLogMsg(msg, 3);
}

function hfToggleLogger(evt) {
	evt.cancelBubble = true;
	evt.preventDefault();
	var logger = hfGetHeader().logger;
	var btn = evt.currentTarget;
	if (logger.style.display == "none") {
		logger.style.display = "block";
	}
	else {
		logger.style.display = "none";
	}
}

/**
 * Event Wrapper
 */
function _hf_Event_preventDefault() {
	this.returnValue = false;
}

function hfConsumeEvent(evt) {
	evt.cancelBubble = true;
	if (evt.simulated) {
		evt.simulated = null;
		evt.target = null;
		evt.currentTarget = null;
		evt.returnValue = false;
	}
	else {
		evt.preventDefault();
	}
}

function hfWrapEvent(evt, ele) {
	evt = evt ? evt : window.event;
	if (!evt.preventDefault) {
		evt.simulated = true;
		evt.currentTarget = ele;
		evt.target = evt.srcElement;
		evt.preventDefault = _hf_Event_preventDefault;
	}

	return evt;
}

function hfAttachEvent(ele, name, func) {
	if (func) {
		ele['on' + name] = function(evt) {
			evt = hfWrapEvent(evt, ele);
			func(evt);
		};
	}
	else {
		ele['on' + name] = null;
	}
}

/**
 * AJAX interface
 */

if (window.XMLHttpRequest) {
	hfAsyncLoad = function(methd, uri, func) {
		var req = new XMLHttpRequest();
		req.onload = function() {
			func(req.responseXML);
		}
		
		req.open(methd, uri, true);
		req.send(null);
	}
}
else if (window.ActiveXObject) {
	_hf_handlers = new Array();
	_hf_reqs = new Array();
	_hf_checkAllResponse = function() {
		for (var i in _hf_reqs) {
			var req = _hf_reqs[i];
			if (req == null)
				continue;
			if (req.readyState == 4) {
				var h = _hf_handlers[i];
				delete _hf_reqs[i];
				delete _hf_handlers[i];
				if (req.status == 200 || req.status == 0) {
					var doc = new ActiveXObject("MSXML2.DOMDocument");
					doc.loadXML(req.responseText);
					h(doc);
					req = null;
					h = null;
				}
			}
		}
	}

	hfAsyncLoad = function(methd, uri, func) {
		var req = new ActiveXObject("MSXML2.XMLHTTP");
		_hf_handlers.push(func);
		_hf_reqs.push(req);
		req.open(methd, uri, true);
		req.send(null);
	}

	setInterval("_hf_checkAllResponse()", 100);
}

function hfAsyncCall(uri, params, func) {
	var a = new Array();
	var now = new Date();
	a.push('t=' + now.getTime());

	if (params != null) {
		for (var key in params)
			a.push(key + '=' + params[key]);
	}

	var fullURI = uri + '?' + a.join('&');
	return hfAsyncLoad("GET", fullURI, func);
}

function hfSerializeXML(doc) {
	if (doc.innerHTML)
		return doc.innerHTML;
	else if (window.XMLSerializer) {
		var ser = new XMLSerializer();
		return ser.serializeToString(doc);
	}
	else if (doc.xml)
		return doc.xml;
	else
		hfUnsupportBrowserError("hfSerializeXML");
}

/**
 * ID format of element
 * ------------------------------------------------------
 * Element-Type        Element-ID-Format
 * ------------------------------------------------------
 * object              o.<class-id>.<id>
 * attribute           a.<class-id>.<id>.<attribute name>
 * ------------------------------------------------------
 */
function HFEID(s) {
	var a = s.split('.');
	var t = a[0];
	if (t == 'o') {
		this.type = t;
		this.cid = a[1];
		this.id = a[2];
		
		if(a[3])
		{
		    this.subslot = a[3];
		}
	}
	else if (t == 'a') {
		this.type = t;
		this.cid = a[1];
		this.id = a[2];
		this.aname = a[3];
	}
	else {
		this.type = null;
	}

	this.toString = function() {
		if (this.type == 'o')
			return this.asOID();
		else if (this.type == 'a')
			return this.asAID();
	}

	this.asOID = function() {
	        var objID = 'o.' + this.cid + '.' + this.id;
	        
	        if(this.subslot)
	        {
	            objID = objID + '.' + this.subslot;
	        }
	        
		return objID;
	}

	this.asAID = function(n) {
		n = (n != null) ? n : this.aname;
		return 'a.' + this.cid + '.' + this.id + '.' + n;
	}

	this.isNull = function() {
		return (this.cid == 0);
	}
}

/**
 * Facilities
 */

function hfGetFirstNonTextChild(parent) {
	var n = parent.firstChild;
	while (n != null && n.nodeType == 3)
		n = n.nextSibling;
	return n;
}

function hfGetNextNonTextSibling(n) {
	n = n.nextSibling;
	while (n != null && n.nodeType == 3)
		n = n.nextSibling;
	return n;
}

function hfGetFirstChild(parent, tagName) {
	var n = parent.firstChild;
	while (n != null && n.tagName != tagName)
		n = n.nextSibling;
	return n;
}

function hfGetNextSibling(n, tagName) {
	n = n.nextSibling;
	while (n != null && n.tagName != tagName)
		n = n.nextSibling;
	return n;
}

function HFDOMIter(parent, tagName) {
	this.done = function() {
		return (this.node == null);
	}

	if (tagName == null) {
		this.node = hfGetFirstNonTextChild(parent);
		this.next = function() {
			this.node = hfGetNextNonTextSibling(this.node);
		}
	}
	else {
		this.node = hfGetFirstChild(parent, tagName);
		this.next = function() {
			this.node = hfGetNextSibling(this.node, tagName);
		}
	}
}

function hfCheckResponse(doc) {
	var root = doc.documentElement;
	if (root.tagName == "exception")
		throw new Error(root.getAttribute("class"), root.firstChild);
	return root;
}

function hfEscape(s) {
	return s.replace(/&/g, "&amp;")
		.replace(/</g, "&lt;").replace(/>/g, "&gt;")
		.replace(/"/g, "&quot;").replace(/'/g, "&apos;");
}

function hfUnescape(s) {
	return s.replace(/&apos;/g,"'").replace(/&quot;/g,"\"")
		.replace(/&gt;/g,">").replace(/&lt;/g,"<")
		.replace(/&amp;/g,"&");
}

function hfGetObjectInfo(ob) {
	var s = '';
	for (key in ob) {
		var value = '';
		try {
			value = ob[key];
		}
		catch(ex) {
			value = '[can not get]';
		}
		s = s + '\n' + key + ' = ' + value;
	}
	return s;
}

function HFDimension(width, height) {
	this.width = width ? width : 0;
	this.height = height ? height : 0; 
}

function HFPoint(x, y) {
	this.x = x ? x : 0;
	this.y = y ? y : 0;
}

function hfGetWindowSize() {
	var w = 0, h = 0;
	if (typeof(window.innerWidth) == 'number') {
		w = window.innerWidth;
		h = window.innerHeight;
	} else if (document.documentElement &&
			(document.documentElement.clientWidth
			|| document.documentElement.clientHeight)) {
		w = document.documentElement.clientWidth;
		h = document.documentElement.clientHeight;
	} else if (document.body &&
			(document.body.clientWidth || document.body.clientHeight)) {
		w = document.body.clientWidth;
		h = document.body.clientHeight;
	}

	return new HFDimension(w, h);
}

function hfGetTopContainer(d) {
	var win = window.window;
	var dx = 0;
	var dy = 0;
	while (win && !win.hfIsTopContainer) {
		if (win == win.parent)
			return null;
		dx += win.frameElement.offsetLeft;
		dy += win.frameElement.offsetTop;
		win = win.parent;
	}

	if (win != null && d != null) {
		d.x = d.x + dx;
		d.y = d.y + dy;
	}

	return win;
}

function hfGetHeader() {
	if (priv.hfHeader == null) {
		priv.hfHeader = new Object();
		priv.hfHeader.addToolButton = function(action) {
			var btn = priv.hfHeader.toolbar.appendChild(document.createElement("a"));
			if (action.icon)
				btn.className = "ToolIconButton ACTION_" + action.icon;
			else
				btn.className = "ToolButton";
			btn.appendChild(document.createTextNode(action.label));
			btn.href = "#";
			hfAttachEvent(btn, "click", function(evt) {
				if (action.handler)
					action.handler(evt);
			});
		}

		priv.hfHeader.setTitle = function(text) {
			priv.hfHeader.title.innerHTML = text;
		}

		var div = document.body.insertBefore(
			document.createElement("div"), document.body.firstChild);
		div.className = "ViewHeader";
		priv.hfHeader.element = div;

		var table = div.appendChild(document.createElement("table"));
		table.style.width = "100%";
		table.cellSpacing = "0";
		var tbody = table.appendChild(document.createElement("tbody"));
		var tr = tbody.appendChild(document.createElement("tr"));
		var title = tr.appendChild(document.createElement("td"));
		title.className = "ViewTitle";
		title.appendChild(document.createTextNode("View"));
		priv.hfHeader.title = title;

		var tbc = tr.appendChild(document.createElement("td"));
		var tb = tbc.appendChild(document.createElement("div"));
		tb.className = "Toolbar";
		priv.hfHeader.toolbar = tb;
		var ul = div.appendChild(document.createElement("ul"));
		ul.id = "logger";
		ul.style.display = "none";
		priv.hfHeader.logger = ul;
	}

	return priv.hfHeader;
}

function hfInvokeLater(f) {
	window.setTimeout(f, 0);
}

function hfRelayout(eleID, padH, padV) {
	var d = hfGetWindowSize();
	var f = document.getElementById(eleID);
	var w = d.width - padH;
	var h = d.height - padV;
	if (w < 0)
		w = 0;
	if (h < 0)
		h = 0;
	f.style.width = w + 'px';
	f.style.height = h + 'px';
}
