 		function Guides(guideid,pretitle,nexttitle,finishtitle,aborttitle)
		{
			/**
			* @desc get Element
			* @param id
			*/
			this.$ = function(id)
			{
				return document.getElementById(id);
			}
			var _this = this;
			this.guides = [];			
			this.leftid = guideid + "_left";
			var left = document.createElement("div");
			left.setAttribute("id",_this.leftid);
			left.style.styleFloat = "left";
			left.style.width = "30%";
			_this.$(guideid).appendChild(left);
			this.contentid = guideid + "_content";
			var content = document.createElement("div");
			content.style.styleFloat = "right";
			content.style.width = "70%";
			content.setAttribute("id",_this.contentid);
			_this.$(guideid).appendChild(content);
			
			this.count = 0;
			this.nexttitle = nexttitle;
			this.pretitle = pretitle;
			this.finishtitle = finishtitle;
			this.aborttitle = aborttitle;
			this.buttonDiv = document.createElement("div");
			_this.buttonDiv.style.textAlign = "right";
			this.abortfunc = null;
			this.showIndex = 0;
			function Guide(index,title,id,func)
			{
				this.index = index;
				this.title = title;
				this.id = id;
				this.func = func;
				var _this = this;
				this.parent = null;
			}
			
			
			/**
			*  @desc add guide
			*  @param title guide's title
			*  @param id the container id of guide
			*  @param func next guide's func
			*/
			this.add = function(title,id,func)
			{
				var guide = new Guide(_this.count,title,id,func);
				_this.$(_this.contentid).appendChild($(id));
				guide.parent = _this;
				this.guides[this.guides.length] = guide;
				_this.addLeft(guide);
				_this.count++;
			}
			
			/**
			* @desc add left
			* @param title
			* @param id
			*/
			this.addLeft = function(guide)
			{
				var left = document.createElement("div");
				var leftidtemp = _this.getLeftId(_this.count);
				left.setAttribute("id",leftidtemp);
				var lefta = document.createElement("a");
				lefta.innerHTML = guide.title;
				lefta.setAttribute("href","#");
				lefta.onclick = function()
				{
					_this.showGuide(guide.index);
				}
				left.appendChild(lefta);
				_this.$(_this.leftid).appendChild(left);
			}
			
			this.getLeftId = function(index)
			{
				return "guide_" + _this.leftid + "_" + index;
			}
			
			/**
			* @desc show guide
			* @param id
			*/
			this.showGuide = function(index)
			{
				for(var i = 0,m = _this.guides.length;i < m;i++)
				{
					var leftidtemp = _this.getLeftId(i);
					if(index == i)
					{
						_this.$(leftidtemp).childNodes[0].style.color = "blue";
					}
					else
					{
						_this.$(leftidtemp).childNodes[0].style.color = "#000000";
					}
				}
				if(_this.showIndex < index)
				{
					_this.showIndex = index;
				}
				if(_this.$(_this.contentid))
				{
					_this.$(_this.contentid).appendChild(_this.buttonDiv);
				}
				var guide = _this.guides[index]
				_this.hideAll();
				_this.$(guide.id).style.display = '';
				var button = null;
				_this.clearButton();
				if(guide.index != 0)
				{
					button = _this.createButton(_this.pretitle);
					button.onclick = function()
					{
						_this.showGuide(guide.index - 1);
					}
					_this.buttonDiv.appendChild(button);
				}
				if(guide.index == _this.guides.length - 1)
				{
					button = _this.createButton(_this.finishtitle);
				}
				else
				{
					button = _this.createButton(_this.nexttitle);
				}
				button.onclick = function()
				{
					if(typeof(guide.func) == "function")
					{
						var bResult = guide.func();
						if(!bResult)
						{
							return;
						}
					}
					if(guide.index != _this.guides.length - 1)
					{
						_this.showGuide(guide.index + 1);
					}
				}

				_this.buttonDiv.appendChild(button);

				button = _this.createButton(_this.aborttitle);
				
				if(_this.abortfunc != null && typeof(_this.abortfunc) == "function")
				{
					button.onclick = function()
					{
						var func = _this.abortfunc;
						func();
					}
				}
				_this.buttonDiv.appendChild(button);
			}
			
			this.createButton = function(title)
			{
					var button = document.createElement("input");
					button.setAttribute("type","button");
					button.setAttribute("value",title);
					button.className = "buttonstyle1";
					button.style.marginLeft = "10px";
					return button
			}

			/**
			* @desc clear all buttons
			*/
			this.clearButton = function()
			{
				while(_this.buttonDiv.childNodes.length > 0)
				{
					_this.buttonDiv.removeChild(_this.buttonDiv.childNodes[0]);
				}
			}
			
			/**
			* @desc hide all guide
			*/
			this.hideAll = function()
			{
				for(var i = 0,m = _this.guides.length;i < m;i++)
				{
					_this.$(_this.guides[i].id).style.display = 'none';
				}
			}

		}
