var INVALIDATE_STR = "/";
var NOT_SUPPORT_STR = "-";
/**
 *             XML  
 * @param neid:  ID slotid:  ID
 * @return String:          XML  
 */
function createQuerySupportAttrXML(neid, slotid, boardType)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    if (slotid != isNaN && "" != slotid) 
    {
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        if (null != boardType) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "boardType");
            param.setAttribute("value", boardType);
            row.appendChild(param);
        }
    }
	
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tableconf:        
 * @return String:       XML  
 * @queryflag                  
 * @callfrom               (      )       
 * @portid   ID    
 * @pathid   ID    
 */
function createQueryXML(neid, slotid, tableconf, extendattr, isbyFun, queryflag, callfrom, portid, pathid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var slotidArr = [];
    if (typeof slotid != "object") 
    {
        slotidArr.push(slotid);
    }
    else 
    {
        slotidArr = slotid;
    }
    
    for (var slotIdIndex = 0; slotIdIndex < slotidArr.length; slotIdIndex++) 
    {
    
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        
        if (null != queryflag) 
        {
            param.setAttribute("name", "queryflag");
            param.setAttribute("value", queryflag);
            row.appendChild(param);
        }
        if (null != callfrom) 
        {
        	  param = new tagElement("param");
            param.setAttribute("name", "callfrom");
            param.setAttribute("value", callfrom);
            row.appendChild(param);
        }
        if (null != callfrom) 
        {
        	  param = new tagElement("param");
            param.setAttribute("name", "portid");
            param.setAttribute("value", portid);
            row.appendChild(param);
        }
        if (null != callfrom) 
        {
        	  param = new tagElement("param");
            param.setAttribute("name", "pathid");
            param.setAttribute("value", pathid);
            row.appendChild(param);
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        if (typeof(isbyFun) != "undefined" && isbyFun != null && isbyFun) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "byFun");
            param.setAttribute("value", "true");
            row.appendChild(param);
        }
        if (null != slotid && "" != slotid) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "slotid");
            param.setAttribute("value", slotidArr[slotIdIndex]);
            row.appendChild(param);
            param = new tagElement("param");
            param.setAttribute("name", "srcObjType");
            param.setAttribute("value", "ID_OBJECT_TYPE_NE_BOARD");
            row.appendChild(param);
        }
        else 
        {
            param = new tagElement("param");
            param.setAttribute("name", "srcObjType");
            param.setAttribute("value", "ID_OBJECT_TYPE_NE");
            row.appendChild(param);
        }
        var colid;
        for (var i = 1; i < tableconf.getColsLength(); i++) 
        {
            colid = tableconf.getColId(i);
            param = new tagElement("param");
            param.setAttribute("name", "attrId");
            param.setAttribute("value", colid);
            row.appendChild(param);
        }
        if (typeof(extendattr) != "undefined" && extendattr != null) 
        {
            for (var j = 0; j < st.getDataRowLength(); j++) 
            {
                for (var k = 0; k < extendattr.length; k++) 
                {
                    param = new tagElement("param");
                    param.setAttribute("name", extendattr[k]);
                    if (!st.getCell(j, extendattr[k])) 
                    {
                        continue;
                    }
                    param.setAttribute("value", st.getCellStoreValue(j, extendattr[k], extendattr[k]));
                    row.appendChild(param);
                }
            }
        }
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetXML(neid, st, tc)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var rowData = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        rowData = st.getRow();
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        for (var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++) 
        {
            colid = tc.getColId(colindex);
            cellModifyFlag = st.getCellModify(rowindex, colid);
            colkeyarray = tc.getColKeyArray(colindex);
            for (var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++) 
            {
                param = new tagElement("param");
                key = colkeyarray[keyindex].name;
                param.setAttribute("name", key);
                param.setAttribute("value", st.getCellStoreValue(rowindex, colid, key));
                param.setAttribute("modifyFlag", cellModifyFlag);
                row.appendChild(param);
            }
        }
        bussiness.appendChild(row);
    }
    if (0 == bussiness.childNodes.length) 
    {
        alert(RESOURCE["osinochange"]);
        return null;
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *             
 * @param tableconfObj:         supportAttrArr         unfilterAttr:        
 * @return  
 */
function filterAttrCol(tableconfObj, supportAttrList, unfilterAttr, genCfgAttrList)
{
    var flag = false; //       false:    true:  
    var allSupportAttr = supportAttrList.concat(unfilterAttr);
    var genCfgAttObj = null;
    var domain_list = null;
    if (null == genCfgAttrList) 
    {
        genCfgAttrList = new Object();
    }
    
    addPNPCol(tableconfObj, supportAttrList);//  PNP        
    for (var len = tableconfObj.getColsLength() - 1; len >= 1; len--) 
    {
        flag = false;
        if (allSupportAttr.contains(tableconfObj.getColId(len))) 
        {
            flag = true;
            
            genCfgAttObj = genCfgAttrList[tableconfObj.getColId(len)];
            if (null != genCfgAttObj && null != genCfgAttObj.domain_list.options) 
            {
                domain_list = genCfgAttObj.domain_list.options;
                var colEdit = tableconfObj.getColEdit(len);
                if (colEdit != null && colEdit.type == "select") 
                {
                    colEdit.options = [];
                    for (var index = 0, optionLen = domain_list.length; index < optionLen; index++) 
                    {
                        var opTag = new OPTag();
                        opTag.value = domain_list[index];
                        colEdit.options.push(opTag);
                    }
                }
            }
            if(null != genCfgAttObj && genCfgAttObj.attrRange)
            {
            	var colEdit = tableconfObj.getColEdit(len);
                if (colEdit != null) 
                {
                	colEdit.attrRange = genCfgAttObj.attrRange;
                }
            }
        }
        if (!flag) 
        {
            tableconfObj.colArray.removeAt(len);
        }
    }
}

function atomOnMouseDownHandle()
{
    if (isIE) 
    {
        this.parentElement.onselectstart = null;
    }
    else 
    {
        this.parentElement.style.MozUserSelect = "text";
    }
    stopEventPropagation();
}

/**
 *             
 * @param st:   tc:         di:      res:     flag:        
 * @return  
 */
function createGenCfgTableBody(st, tc, di, flag)
{
    st.removeEmptyTr();
    if (!st.isListenerRegister) 
    {
        EventUtil.addEventHandler(window, "resize", windowOnResizeTableHandle);
        EventUtil.addEventHandler(window, "unload", windowUnloadTableHandle);
        st.isListenerRegister = true;
    }
    
    var colslength = tc.getColsLength();
    
    st.appendTableEdit(tc);
    if ((typeof(flag) == "undefined" || null == flag) || (flag)) 
    {
        st.clearTableData();
    }
    
    var basicCalWidth = document.body.clientWidth - 20;
    if (st.isUsedForSelectList) 
    {
        basicCalWidth = st.bodyPack.offsetWidth;
        st.element.setAttribute("tableWidth", basicCalWidth);
    }
    
    var appendWidth = getAppendWidth(st, tc);
    var tempWidth = 0;
    var colWidth;
	st.refreshColsWidth(tc,basicCalWidth,appendWidth);
    for (var rowindex = 0, rowlen = di.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        var row = createGenCfgTableRow(st,tc,di,rowindex);
        st.addRow(row);
    }
    st.removeEmptyTr();
    st.body.style.padding = "1px";
    adjustTableLayout(st, tc);
    st.body.style.padding = "0px";
    
    st.appendEmptyTr();
}

function createGenCfgTableRow(st,tc,di,diindex)
{
	var row = st.createRow();
    for (var colindex = 0, collen = tc.getColsLength(); colindex < collen; colindex++) 
    {
		var colid = tc.getColId(colindex);
        tempWidth = st.getHeadCell(colid).element.refreshWidth;
        
        var colKeyArray = tc.getColKeyArray(colindex);
        var cell = st.createCell(tempWidth);
        cell.colid = colid;
        st.setCellIsEdit(cell, tc.getIsEdit(colindex));
        var atom = st.createAtom(tc.getColShowType(colindex));
        var options = tc.getColShowOptions(colindex);
        if (options) 
        {
            for (var optionindex = 0, optionlen = options.length; optionindex < optionlen; optionindex++) 
            {
                atom.addOption(options[optionindex].getName(), options[optionindex].getValue());
            }
        }
        var showvalue = new Array();
        
        for (var k = 0, len = colKeyArray.length; k < len; k++) 
        {
        	var colKey = colKeyArray[k];
            var convert = colKey.getConvert();
            var name = colKey.getName();
            var show = colKey.getShow();
            var unit = colKey.getUnit();
            var invalid = colKey.getInvalid();
            var paramData = di.getDataRowParam(diindex, name);
            if (null != paramData) 
            {
                var storeValue = paramData;
                if (unit && unit != "") 
                {
                    var rx1 = new RegExp("^[-]{0,1}[0-9][0-9]*(.[0-9]{1,6}){0,1}$");
                    if (rx1.test(storeValue) && rx1.test(unit)) 
                    {
                        var intUnit = Number(unit);
                        storeValue = Number(storeValue) / intUnit;
                        decvalue = Math.round(Math.LOG10E * Math.log(intUnit));
                        if (storeValue.toString().indexOf(".") == -1) 
                        {
                            storeValue = new Number(storeValue).toFixed(decvalue);
                        }
                    }
                }
				if (invalid && invalid != "" && invalid == paramData) 
                {
                    paramData = "/";
                }
                else
                {
                	paramData = storeValue;
                }
                
                if (convert != null && convert == "hidden") 
                {
                    st.setHiddenCellValue(cell, colKeyArray[k].getName(), storeValue);
                    continue;
                }
                st.setCellValue(cell, colKeyArray[k].getName(), storeValue);
                
                if (show && show != "") 
                {
                    paramData = di.getDataRowParam(diindex, show);
                }
                if (colKeyArray[k].getName().toLowerCase() == "slotid" && convert == null) 
                {
                    convert = "getSlotIDFromSlot";
                }

                
                if (convert && convert != "" && "" != paramData) 
                {
                    if (convert != "nojoin") 
                    {
                        var v = convertValue(eval(convert), paramData, colKeyArray[k].getName());
                        if ("" != v) 
                        {
                            showvalue.push(v);
                        }
                    }
                }
                else //      key "-"    
                 {
                    if ("" != paramData || k == 0) 
                    {
                        showvalue.push(paramData);
                    }
                }
            }
        }
        if (showvalue.length > 0)//                  
        {
            atom.setValue(showvalue.join('-'));
        }
        else //                        
         {
            atom.setValue(NOT_SUPPORT_STR);
            st.setCellIsEdit(cell, 0);
        }
        st.addCellShow(cell, atom);
        if (tc.hasEditElement(colindex)) 
        {
            st.addCellEdit(cell, st.editdom[cell.colid]);
        }
        st.addCell(row, tc.getColId(colindex), cell);
        var cellwidth = tc.getColWidth(colindex);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
    }
	return row;
}
/**
 *    
 * @param obj:     key:key 
 * @return String      
 */
function convertValue(obj, key, attrID)
{
    if ("function" == (typeof obj)) 
    {
        return obj(key, attrID);
    }
    else //       
     {
        if (null == obj) 
        {
            return key;
        }
        var resValue = obj[key];
        if (null == resValue) 
        {
            resValue = INVALIDATE_STR;
        }
        return resValue;
    }
}

/**
 *       
 * @param tc:         attrId:  ID
 * @return String     
 */
function getAttrName(tc, attrId)
{
    for (var i = 0, len = tc.getColsLength(); i < len; i++) 
    {
        for (var j = 0, size = tc.getColKeyArray(i).length; j < size; j++) 
        {
            if (tc.getColKeyArray(i)[j].name == attrId) 
            {
                return tc.getColName(i);
            }
        }
    }
    return attrId;
}

/**
 *         PNP      
 * @param {Object} tableconfObj       
 * @param {Object} supportAttrList            
 */
function addPNPCol(tableconfObj, supportAttrList)
{
 	if(!parent.genCfgPNPList)
	{
		return;
	}
	
    for (var i = supportAttrList.length - 1; i >= 0; i--) 
    {
        var attrId = supportAttrList[i];
        if (parent.genCfgPNPList[attrId] != null) //     PNP                      
        {
            tableconfObj.colArray.push(parent.genCfgPNPList[attrId].colObj);
        }
    }
}

/**
 *                 
 * RangeValue    
 * [{slotid:***,port:[*,*,*],type:0,list[*,*,*]],defaultValue:*}]
 * [{slotid:***,port:[*,*,*],type:1,list[*(min),*(max)],defaultValue:*,exclude:*,step:*,decimal:*}]
 */
function gencfgEditRangeFunc(param)
{
	var colid = param.colid;
	var rowindex = param.rowindex;
	var cellindex = param.cellindex;
	var stTmp = param.st;
	var celledit = stTmp.getCellEdit(rowindex,colid);

	if(typeof(JSON) != "undefined" && param.stage == TABLE_CONSTANT.BEFOREEDIT && celledit)
	{
		var rangeObj = stTmp.getCellEditRangeObj(rowindex,colid);

		if(rangeObj && rangeObj != "")
		{
			if(stTmp.getSelectedRows().length == 1)
			{
				if(celledit.type == "text" && rangeObj.list.length >= 2)
				{
					if(typeof(rangeObj.step) != "undefined" && rangeObj.step != null)
					{
						textCheckWithStepLen(celledit.element, rangeObj.list[0], rangeObj.list[1],rangeObj.step,rangeObj.exclude);
					}
					else
					{
						textCheck(celledit.element, rangeObj.list[0], rangeObj.list[1],rangeObj.decimal,rangeObj.exclude);
					}
				}
				else if(celledit.type == "select")
				{
					stTmp.refreshCellEditOptions(rowindex,colid,rangeObj.list);
				}
				else if(celledit.type == "combobox")
				{
					
				}
			}
			else
			{
				
				if(celledit.type == "text")
				{
					var rangestr = celledit.element.getAttribute("range");
					if(rangestr && rangestr != "")
					{
						var allrange = JSON.parse(rangestr);
						if(allrange)
						{
							if(typeof(allrange.step) != "undefined" && allrange.step != null)
							{
								textCheckWithStepLen(celledit.element, allrange.min, allrange.max,allrange.step,allrange.other);
							}
							else
							{
								textCheck(celledit.element, allrange.min, allrange.max,allrange.decimal,allrange.other);
							}
						}
					}
					
				}
				else if(celledit.type == "select")
				{
					var range = celledit.element.getAttribute("attrRange");
					var rangeobjlist = JSON.parse(range);
					
					var keyColId = (stTmp.getKeyColID()?stTmp.getKeyColID():"slotid");
					var selectRows = stTmp.getSelectedRows();
					
					var allList = [];
					var setTmp = {};
					for(var i = 0,len = rangeobjlist.length;i < len;i++)
					{
						if(rangeobjlist[i] && rangeobjlist[i].list)
						{
							/**
							 * DTS2013091301637
							 *                                   
							 *           
							 *                             "-"                   
							 *                                         
							 *      
							 * 1.                                    
							 * 2.                                               
							 * 3.      ok         OTN        
							 */
							var rangeObjTemp = null;
							for (var m = 0, lenm = selectRows.length; m < lenm; m++)
							{
								if (stTmp.getCellIsEdit(stTmp.getCell(selectRows[m],colid)) == "0")
								{
									continue;
								}
								var slotid = stTmp.getCellStoreValue(selectRows[m],keyColId,"slotid");
								if(rangeobjlist[i].slotid == slotid)
								{
									var port = stTmp.getCellStoreValue(selectRows[m],keyColId,"port");
									var path = stTmp.getCellStoreValue(selectRows[m],keyColId,"path");
									if(typeof(rangeobjlist[i].port) == "undefined"
										|| port == null || typeof(port) == "undefined"
										|| rangeobjlist[i].port.contains(port))
									{
										if(typeof(rangeobjlist[i].path) == "undefined"
											|| path == null || typeof(path) == "undefined"
											|| rangeobjlist[i].path.contains(path))
										{
											rangeObjTemp = rangeobjlist[i];
											break;
										}
									}
								}
							}
							if (rangeObjTemp != null)
							{
								for(var j = 0,lenj = rangeObjTemp.list.length;j < lenj;j++)
								{
									var objTmp = rangeObjTemp.list[j];
									if(!(objTmp in setTmp))
									{
										allList.push(objTmp);
										setTmp[objTmp] = null;
									}
								}
							}
							
						}
					}
					setTmp = null;
					allList.sort();
						stTmp.refreshCellEditOptions(rowindex,colid,allList);
				}
			}
		}
	}
}

/**
 *                                    
 *                     
 * @st     
 * @rowindex   
 * @colid   
 * @dValue            
*/
function getGencfgCellEditDefault(st,rowindex,colid,dValue)
{
	var celledit = st.getCellEdit(rowindex,colid);
	var defaultValue = dValue;
	if(typeof(JSON) != "undefined" && celledit)
	{
		var range = celledit.element.getAttribute("attrRange");
		if(range && range != "")
		{
			var rangeobjlist = JSON.parse(range);
			var slotid = st.getCellStoreValue(rowindex,"slotid","slotid");
			var port = st.getCellStoreValue(rowindex,"slotid","port");
			var rangeObj = null;
            for (var i = 0, len = rangeobjlist.length; i < len; i++) 
            {
                if (rangeobjlist[i] && rangeobjlist[i].slotid == slotid) 
                {
                    if (typeof(rangeobjlist[i].port) == "undefined" ||
                    port == null ||
                    typeof(port) == "undefined" ||
                    rangeobjlist[i].port.contains(port)) 
                    {
                        rangeObj = rangeobjlist[i];
                        break;
                    }
                }
            }
			if(rangeObj && typeof(rangeObj.defaultValue) != "undefined")
			{
				defaultValue = rangeObj.defaultValue;
			}
		}
	}
	return defaultValue;
}
