(function()
{
	var doc = document;
	var win = window;
	function blockChars(e, Chars)
	{
		if (e == null)
		{
			e = window.event;
		}
		e = EventUtil.formatEvent(e);
	
		var sChar = String.fromCharCode(e.charCode);
	
		var isValidChar = Chars.indexOf(sChar) == -1;
		return isValidChar || e.ctrlKey;
	}
	
	function documentKeyPress(e)
	{
		var evt = e?e:window.event;
		var code = evt.keyCode ? evt.keyCode : evt.charCode;
		var sChar = String.fromCharCode(code);
		var obj = evt.srcElement?evt.srcElement:evt.target;
		if(obj.tagName && obj.tagName.toLowerCase() == "input")
		{
			if(!blockChars(e,"~!#$%+^*|[]{}<>\"\\=:;?'"))
			{
				if (evt.preventDefault)
					evt.preventDefault();
				if (document.all && window.event && !evt.preventDefault)
				{
					evt.cancelBubble = true;
					evt.returnValue = false;
					evt.keyCode = 0;
				}
				return false;
			}
			return;
		}
	}
	
	function windowLoad()
	{
		var objs = document.getElementsByTagName("input");
		for(var i = 0,len = objs.length;i < len;i++)
		{
			if(objs[i].type && objs[i].type == "text")
			{
				objs[i].onpaste = checkInputPaste;
			}
		}
	}
	
	function checkInputPaste(e)
	{
		var evt = e?e:window.event;
		var re = /^[^=\>\<\]\}\[\{\|\*\%\$\~\!\#\\\:\;\"\'\?]+$/;
		if(window.clipboardData)
		{
			var pasteText = window.clipboardData.getData("Text");
			alert(re.test(pasteText));
			if(!re.test(pasteText))
			{
				
				if (evt.preventDefault)
					evt.preventDefault();
				if (document.all && window.event && !evt.preventDefault)
				{
					evt.cancelBubble = true;
					evt.returnValue = false;
					evt.keyCode = 0;
				}
				return false;
			}
		}
		else
		{
			netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
			var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);   
		    if (!clip) return;   
		    var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);   
		    if (!trans) return;   
		    trans.addDataFlavor('text/unicode');   
		    clip.getData(trans, clip.kGlobalClipboard);   
		    var str = new Object();   
		    var len = new Object();   
		    try {   
		        trans.getTransferData('text/unicode', str, len);   
		    } catch(error) {   
		        return null;   
		    }   
		    if (str) {   
		        if (Components.interfaces.nsISupportsWString)
		        {
		        	str = str.value.QueryInterface(Components.interfaces.nsISupportsWString);   
		        }
		        else if (Components.interfaces.nsISupportsString)
		        {
		        	str = str.value.QueryInterface(Components.interfaces.nsISupportsString);   
		        }
		        else
		        {
		        	str = null;   
		        }
		    }   
		    if (str)
		    {   
		        str = str.data.substring(0, len.value / 2);
		        if(!re.test(str))
		        {
		        	return false;
		        }
		        return true;
		    }
		    return false;
		}
	}
	
	EventUtil.addEventHandler(doc, "keypress", documentKeyPress);
	EventUtil.addEventHandler(win, "load", windowLoad);
}
)()
