
var tabList = new Array();
var tabHeadList = new Array();

function EmbedTabs()
{
	this.view = document.createElement("div");
	this.tabHead = document.createElement("div");
	this.view.appendChild(this.tabHead);
	
	this.getEmbedTabs = function()
	{
		return this.view;
	}
	
	this.getEmbedTab = function(key)
	{
		return tabList[key];
	}
	
	this.getSelectEmbedTab = function()
	{
		for (var key in tabList)
		{
			if (!tabList[key] || !tabList[key].tagName || tabList[key].tagName.toLowerCase() != "div")
			{
				continue;
			}
			
			if (tabHeadList[key].className == "tabs_head_select")
			{
				return key;
			}
		}
		return null;
	}
	
	this.addEmbedTab = function(id, name, tab)
	{
		var tabHeadSpan = document.createElement("span");
		tabHeadSpan.name = id;
		tabHeadSpan.className = "tabs_head";
		tabHeadSpan.onclick = function()
		{
			var tabId = this.name;
			setSelectedEmbedTab(tabId);
		}

		tabHeadSpan.appendChild(document.createTextNode(name));
		this.tabHead.appendChild(tabHeadSpan);
		
		tabHeadList[id] = tabHeadSpan;
		
		if (!tab)
		{
			tab = document.createElement("div");
			tab.id = id;
		}
		tab.style.display = "none";
		tabList[id] = tab;
		tab.style.clear = "both";
	}
	
	this.insertEmbedTab = function(id, name, tab, insertBefore)
	{
	    var isInsertBeforeTabExist = false;
	    for(var i = 0; i < this.tabHead.children.length; i++)
	    {
	        if(this.tabHead.children[i].name == insertBefore)
	        {
	            isInsertBeforeTabExist = true;
	            break;
	        }
	    }
	    
	    if(!isInsertBeforeTabExist)
	    {
	        this.addEmbedTab(id, name, tab);
            return;
	    }
	    
	    var tabHeadSpan = document.createElement("span");
        tabHeadSpan.name = id;
        tabHeadSpan.className = "tabs_head";
        tabHeadSpan.onclick = function()
        {
            var tabId = this.name;
            setSelectedEmbedTab(tabId);
        }

        tabHeadSpan.appendChild(document.createTextNode(name));
        this.tabHead.insertBefore(tabHeadSpan, tabHeadList[insertBefore]);
        
        tabHeadList[id] = tabHeadSpan;
        if (!tab)
        {
            tab = document.createElement("div");
            tab.id = id;
        }
        tab.style.display = "none";
        tabList[id] = tab;
	}
	
	this.removeEmbedTab = function(id)
	{
	    if(tabHeadList[id] == null)
	    {
	        return;
	    }
	    this.tabHead.removeChild(tabHeadList[id]);
	    tabHeadList.remove(tabHeadList[id]);
	    tabList.remove(tabList[id]);
	    
	}
}

function setSelectedEmbedTab(id)
{
	for (var key in tabList)
	{
		if (!tabList[key] || !tabList[key].tagName || tabList[key].tagName.toLowerCase() != "div")
		{
			continue;
		}
		
		if (key == id)
		{
			tabHeadList[key].className = "tabs_head_select";
			tabList[key].style.display = "";
		}
		else
		{
			tabHeadList[key].className = "tabs_head";
			tabList[key].style.display = "none";
		}
	}
	
	if (window.embedTabSelectHandler)
	{
		embedTabSelectHandler(id);
	}
}
