 /***********************************************
  1.        
  2.                   
***********************************************/

var timeformatStr = null;//    
var MILLISECONDS_FORMAT = 0;//    
var STANDARD_FORMAT = 1;//     :2007-01-21 14:16:00

/**
	                    
	@param aDate   Date  
	@return           
*/
function createTime(aDate, modify)
{
  if(!timeformatStr)
  {
		getTimeFormat();
  }
  Date.parse(aDate);
  
  if (modify) aDate = new Date(aDate);
  	
  var timeformat = timeformatStr.replace("yyyy",aDate.getFullYear());//   
  var convertMin = aDate.getMinutes();
  convertMin = (convertMin < 10) ? ("0" + convertMin) : convertMin;
  timeformat = timeformat.replace("mm",convertMin);//    
  var convertSec = aDate.getSeconds();
  convertSec = (convertSec < 10) ? ("0" + convertSec) : convertSec;
  timeformat = timeformat.replace("ss",convertSec);//   
  
  var convertMon = aDate.getMonth() + 1;
  if(timeformat.search("MM") != -1)
  {
  	if(convertMon < 10)
  	{
  		convertMon = "0" + convertMon;
  	}
  	timeformat = timeformat.replace("MM",convertMon);
  }
  else
  {
    timeformat = timeformat.replace("M",convertMon);
  }
  
  var convertDay = aDate.getDate();
  if(timeformat.search("dd") != -1)
  {
  	if(convertDay < 10)
  	{
  		convertDay = "0" + convertDay;
  	}
  	timeformat = timeformat.replace("dd",convertDay);
  }
  else
  {
    timeformat = timeformat.replace("d",convertDay);
  }
  
  var convertHour = aDate.getHours();
  if(timeformat.search("HH") == -1)//12   
  {
  	if(convertHour > 12)//    
  	{
  		timeformat = timeformat.replace("a","PM");
  		convertHour = convertHour - 12;
  	}
  	else
  	{
  		timeformat = timeformat.replace("a","AM");
  	}
  	if(convertHour < 10)
  	{
  		convertHour = "0" + convertHour;
  	}
  	timeformat = timeformat.replace("hh",convertHour);
  }
  else//24   
  {
    if(convertHour < 10)
  	{
  		convertHour = "0" + convertHour;
  	}
  	timeformat = timeformat.replace("HH",convertHour);
  }
  return timeformat;//    ,  
} 
  

/**
	                          
	@param timeStr     
	@returnFormat         ,        (        )
	@custFormat          ,       ,   timeStr          
	@return       
*/
function getTimeFromString(timeStr,returnFormat,custFormat) 
{
	var year = 0;
	var month = -1;
	var day = 0;
	var hour = 0;
	var minute = 0;
	var second = 0;
	var timeArr = timeStr.split(/\W+/);
	if(custFormat != null)
	{
		var timeFormatArr = custFormat.split(/\W+/);
	}
	else
	{
		if(timeformatStr == null)
		{
			getTimeFormat();
		}
		var timeFormatArr = timeformatStr.split(/\W+/);
	}
	var bConvertHour = false;
	for(var i = 0;i < timeArr.length;i++)
	{
		if(timeFormatArr[i] == "yyyy")
		{
			year = parseInt(timeArr[i], 10);
			continue;
		}
		if(timeFormatArr[i] == "MM" || timeFormatArr[i] == "M")
		{
			month = parseInt(timeArr[i], 10);
			continue;
		}
		if(timeFormatArr[i] == "dd" || timeFormatArr[i] == "d")
		{
			day = parseInt(timeArr[i], 10);
			continue;
		}		
		if(timeFormatArr[i] == "HH" || timeFormatArr[i] == "hh")
		{
			hour = parseInt(timeArr[i], 10);
			continue;
		}
		if(timeFormatArr[i] == "mm")
		{
			minute = parseInt(timeArr[i], 10);
			continue;
		}
		if(timeFormatArr[i] == "ss")
		{
			second = parseInt(timeArr[i], 10);
			continue;
		}		
		if(timeArr[i] == "PM" || timeArr[i] == RESOURCE["PM"])
		{
			bConvertHour = true;
		}
	}
	if(bConvertHour == true)
	{
		hour = hour + 12;
	}
	if(returnFormat == null || returnFormat == MILLISECONDS_FORMAT)
	{
		return new Date(year,month - 1,day,hour,minute,second).getTime();
	}
	if(returnFormat == STANDARD_FORMAT)
	{
		month = month < 10 ? ("0" + month) : month;
		day = day < 10 ? ("0" + day) : day;
		hour = hour < 10 ? ("0" + hour) : hour;
		minute = minute < 10 ? ("0" + minute) : minute;
		second = second < 10 ? ("0" + second) : second;
		return year + "-" + month + "-" + day+ " " + hour + ":" + minute + ":" +second;
	}
}

/**
	             
*/
function getDateString(sDate)
{
	if(sDate == null)
	{
		return null;
	}
	Date.parse(sDate);
	if(!timeformatStr)
  {
		getTimeFormat();
  }
  var dateString = timeformatStr.replace("yyyy",sDate.getFullYear());
  var convertMon = sDate.getMonth() + 1;
  if(dateString.search("MM") != -1)
  {
  	if(convertMon < 10)
  	{
  		convertMon = "0" + convertMon;
  	}
  	dateString = dateString.replace("MM",convertMon);
  }
  else
  {
    dateString = dateString.replace("M",convertMon);
  }
  
  var convertDay = sDate.getDate();
  if(dateString.search("dd") != -1)
  {
  	if(convertDay < 10)
  	{
  		convertDay = "0" + convertDay;
  	}
  	dateString = dateString.replace("dd",convertDay);
  }
  else
  {
    dateString = dateString.replace("d",convertDay);
  }
  if(dateString.search("a") != -1)
  {
  	return dateString.substring(0,dateString.indexOf(" "));
  }
  else
  {
  	return dateString.substring(0,dateString.indexOf("HH"));
  }
}

/**
	             
*/
function getTimeString(sDate)
{
	if(sDate == null)
	{
		return null;
	}
	Date.parse(sDate);
	if(!timeformatStr)
  {
		getTimeFormat();
  }	
	var timeString;
	var convertMin = sDate.getMinutes();
  convertMin = (convertMin < 10) ? ("0" + convertMin) : convertMin;
  timeString = timeformatStr.replace("mm",convertMin);//    
  var convertSec = sDate.getSeconds();
  convertSec = (convertSec < 10) ? ("0" + convertSec) : convertSec;
  timeString = timeString.replace("ss",convertSec);//   
  var convertHour = sDate.getHours();
  if(timeString.search("HH") == -1)//12   
  {
  	timeString = timeString.substring(timeString.indexOf(" ") + 1);
  	if(convertHour > 12)//    
  	{
  		timeString = timeString.replace("a","PM");
  		convertHour = convertHour - 12;
  	}
  	else
  	{
  		timeString = timeString.replace("a","AM");
  	}
  	if(convertHour < 10)
  	{
  		convertHour = "0" + convertHour;
  	}
  	timeString = timeString.replace("hh",convertHour);
  }
  else//24   
  {
  	timeString = timeString.substring(timeString.indexOf("HH"));
    if(convertHour < 10)
  	{
  		convertHour = "0" + convertHour;
  	}
  	timeString = timeString.replace("HH",convertHour);
  }	
	return timeString;
}


/**
	      (private function)
*/
function getTimeFormat()
{
	var timeFormatFilePath = getTimeFormatFilePath();
	loadXMLdoc(timeFormatFilePath,"GET",false,getTimeFormatHandle,timeformatStr,null);
}


/**
	                  (private function)
*/
function getTimeFormatHandle(xmldoc,timeFormat)
{
	var timeFormatObj = xmldoc.getElementsByTagName("formatName");
	timeformatStr = timeFormatObj[0].firstChild.data;
}


/**
	             (private function)
	@return        
*/
function getTimeFormatFilePath()
{
	var path = window.location.href;
	var pos = path.indexOf("devsupport");
	if(pos == -1)
	{
		pos = path.indexOf("page");
	}	
	
	/**
	 timeformat.xml    conf                  
	*/
	var pos2 = path.indexOf("nemgr");
	if(pos2 != -1 && pos2 < pos)
	{
		pos = pos2;
	}
	return path.substring(0,pos) + "conf/timeformat.xml";
}
