/************************************************************/
/****       1.               IP         ****/
/****       2.      IP                  ****/
/****       addby z60014396 2006-8-1                     ****/
/************************************************************/
 
function convertNumToIpaddr(intparam)
{
	var hex = tenToHex(intparam);
	len = hex.length;

	
	if(len > 8)
	{
		return;
	}
	else
	{
		while(len < 8)
		{
			hex = "0" + hex;			
			len++;
		}	
	}

	
	var i = 0;
	var context = new Array(4);
	while(hex.length != 0)
	{
		context[i] = hex.substr(0, 2);
		hex = hex.substring(2, hex.length);
		i++;
	}

	var ipAddr = getIpAddr(context);
	return ipAddr;
}

/**
 *       IP           
 */
function convertIpaddrToHexcode(strparam)
{
	var ipAry = strparam.split(".");
	var rs = "";
	var hex;
	for(var i = 0; i < ipAry.length; i++)
	{
		hex = tenToHex(ipAry[i]);		
		rs += addLength(hex, 2);
	}
	return rs;
}

/**
 *                       IP     
 */
function getIpAddr(hexAry)
{
	var rs = "";
	var dot = ".";
	for(var i = 0; i < hexAry.length - 1; i++)
	{
		rs += hexToTen(hexAry[i]) + dot;
	}
	rs += hexToTen(hexAry[hexAry.length-1]);
	return rs;
}

/**
 *                
 *    172442092 --> A4741EC
 */
function tenToHex(param)
{
	var hexChars = "0123456789ABCDEF";
	var respart = param % 16;
	var intpart = (param - respart) / 16;
	var result = hexChars.charAt(respart);
	while((intpart >= 16) || (intpart % 16 != 0))
	{
		respart = intpart % 16;
		intpart = (intpart - respart) / 16;
		result = hexChars.charAt(respart) + result;
	}

	return result;
}

/**
 *                 
 */
function hexToTen(param)
{
	var hexChars = "0123456789ABCDEF";
	var len = param.length;
	var tenVal = hexChars.indexOf(param.charAt(0), 0);
	for(var i = 0; i < len-1; i++)
	{
		tenVal = tenVal*16 + hexChars.indexOf(param.charAt(i+1), 0);
	}

	return tenVal;
}

/**
 *        str      obj    maxlen      0  
 */
function addLength(str, maxlen)
{
		while (str.length < maxlen)
		{
			str = "0" + str;	
		}
		return str;
}

/**
* xx.xx.xx.xx hexip    10  
*/
function convertHexIpAddrtoTen(hexipaddr)
{
	    return   parseInt("0x" + hexipaddr.substring(0,2)) + "."
    	                 + parseInt("0x" + hexipaddr.substring(2,4)) + "."
    	                 + parseInt("0x" + hexipaddr.substring(4,6)) + "."
    	                 + parseInt("0x" + hexipaddr.substring(6,8));
	
}
/*IP     IP      
*/
function convertIPStrToLong(ipstr)
{
     if (null == ipstr)
     {
         return 0;
     }
     var result = 0;
     var sum = 0;
     var TCount = 0;
     var frontIsPoint = true;
     var firstConvert = 16777216;
     var secondConvert = 65536;
     var thirdConvert = 256;
     var firstMax = 223;
     var secondMax = 255;
     var thirdMax = 255;
     var fourthMax = 254;
     
     var T = new Array(firstConvert, secondConvert, thirdConvert);
     var nMax = new Array(firstMax, secondMax, thirdMax, fourthMax);
     for (i = 0; i < ipstr.length; i++)
     {
        var ipchar = ipstr.charAt(i);
        if ((ipchar>= '0') && (ipchar <= '9'))
         {
             sum = (sum * 10) + (ipchar - '0');
             frontIsPoint = false;
         }
        else if (ipchar == '.')
        {
            if (frontIsPoint)
            {
                return 0;
            }
            frontIsPoint = true;
            if ((sum == 0) && (TCount == 0)) // 1  0  
            {
                return 0;
            }
            if (TCount >= 3)
            {
                 return 0;
             }
             if (sum > nMax[TCount])
             {
                  return 0;
             }
             result = result + (sum * T[TCount++]);
             sum = 0;
         }
         else if (ipchar != ' ') //    IP    
         {
             return 0; //   129.  9.  0.  1        
         }
     }
     if (frontIsPoint)
     {
          return 0;
     }
     if (TCount != 3)
     {
          return 0;
     }    
     if (sum > nMax[TCount])
     {
          return 0;
     }
     return (result + sum);
}
/**
 *      IP  
 *    127.0.0.1   --->   127.0.0.2
 *       127.0.0.255 --->   127.0.1.0
 */
function calcuteNetIPStr(ipstr)
{
	var defaultIp="129.9.0.1";
    var ipList=getSeperatrIpList(ipstr);
    if(null == ipList)
    {
    	return defaultIp;
    }
    var fourthInt=parseInt(ipList[ipList.length-1]);
    if(fourthInt<255)
    {
    	ipList[ipList.length-1]=fourthInt+1;
    }
    else
    {
    	ipList[ipList.length-1]=0;
    	var thirdInt=parseInt(ipList[ipList.length-2]);
    	if(thirdInt<255)
    	{
    		ipList[ipList.length-2]=thirdInt+1;
    	}
    	else
    	{
    		ipList[ipList.length-2]=0;
    		var secondInt=parseInt(ipList[ipList.length-3]);
    		if(secondInt<255)
    		{
    			ipList[ipList.length-3]=secondInt+1;
    		}
    		else
    		{
    			ipList[ipList.length-3]=0;
    			var firstInt=parseInt(ipList[ipList.length-4]);
    			if(firstInt<255)
    			{
    				ipList[ipList.length-4]=firstInt+1;
    			}
    			else
    			{
    				return defaultIp;
    			}
    		}
    	}
    }
    return getSeperatrIpStr(ipList);
}
/**
 *  IP    "."    
 */
function getSeperatrIpList(ipstr)
{
	if (null == ipstr||""== ipstr)
    {
         return null;
    }
    var count=0;
    var ipList = new Array();
    var startPos=0;
    ipstr=ipstr+".";
    for (i = 0; i < ipstr.length; i++)
    {
        var ipchar = ipstr.charAt(i);
		if (ipchar == '.')
        {
        	ipList[count]=ipstr.substring(startPos,i);
        	count++;
        	startPos=i+1;
         }
     }
     return ipList;
}
function getSeperatrIpStr(ipList)
{
	var ipStr;
	for(var i=0;i<4;i++)
	{
		if(null!=ipList[i])
		{
			if(i==0)
			{
				ipStr=ipList[0];
			}
			else
			{
				ipStr=ipStr+"."+ipList[i];
			}
			
		}
		else
		{
			ipStr=ipStr+"0";
		}
	}
	return ipStr;
}
