function selectionLen(obj){
    	
    	if(isIE){
    	  return document.selection.createRange().text.length;
    	}else{
    	  return obj.selectionEnd-obj.selectionStart;	
    	}
	
} 

/*
 *       16  
 */
function toHex(dec)
{
	var hexChars = "0123456789ABCDEF";
	var defaultValue = "00";
	if(dec > 255)
	{
		return defaultValue;
	}
	var i = dec%16;
	var j = (dec-i)/16;
	var result = "0X";
	result = hexChars.charAt(j);
	result += hexChars.charAt(i);
	return result;
}
/*
 *        16    
 */
function text2Hex(text)
{
	var strHex = "";
	for(var i=0;i<text.length;i++)
	{
		strHex += toHex(text.charCodeAt(i));
		
		if(i<text.length-1)
		{
			strHex += " ";
		}
	}
	return strHex;
}

/*
 * 16           
 */
function hex2Text(strHex)
{
	if(strHex == "/")
	{
		return strHex;
	}
	strHex = removeSpace(strHex);
	var strText = "";
	var dd;
	var mm;
	for (var i = 0; i <strHex.length; i++)
	{		
	    if ((i + 1) == strHex.length)
	    {
	        dd = strHex.substring(i,i+1)+ 0;
	    }
	    else
	    {
	        dd = strHex.substring(i,i+2);

	    }
	    
    	i += 1;
	    mm = parseInt(dd,16);
	    
	     if(mm == 0)
	    {
	    	strText+=String.fromCharCode("256");
	    }
	    else
	    {
	       strText += String.fromCharCode(mm);
	    }
	}
	return strText;
}

/**
 *            
 * @param hexValue 16   
 * @return  
 */
function removeSpace(hexValue)
{
	var reg = /\s/g;
	hexValue = ("" + hexValue).replace(reg,"");
	return hexValue;
}

function textKeyDown(obj)
{
	var event=EventUtil.getEvent();
  var code = event.keyCode;
  if(code>255)
  {
    	event.returnValue=false;
    	return false;
  }
  
  var ch = String.fromCharCode(code).toLocaleUpperCase();

	var cursorindex = digitalTag_getPos(obj);
	var selectlen = selectionLen(obj);
	var endpos = cursorindex+selectlen;

	if(code == 13 && obj.blur)
  {  	
    obj.blur();
    return true;	
  }
    if(code > 36 && code < 41)
    {
    	event.returnValue=true;
    	return;        
    }
    if(event.ctrlKey)
    {
    	
    	if(ch == 'c' || ch == 'a')
    	{  //X C V A
    	   event.returnValue=true;        	   
    	}
        else
        {
            event.returnValue=false;
        }
        return false;
   }
   
   var curValue = obj.value;
    var len = curValue.length;
    
    if((code >= 48 && code <=57)  || (code >= 65 && code <= 70) || (code >= 96 && code <= 105))
    {
    	if(code >= 96 && code <= 105)
    	{
    		ch = code - 96;
    	}
    	
    	
    	if(0 == selectlen) //                  
    	{
		    if(len >= obj.maxLength && cursorindex >= obj.maxLength)
		    {
		    	setDigitalTag_Pos(obj,len);
		    	event.returnValue=false;
		    	return false;
		    }
		    
		    if(len < 1)
	    	{
	    		obj.value = curValue+ch;
	    		event.returnValue=false;
	    		setDigitalTag_Pos(obj,endpos+1);
	    		globleHexValue = text2Hex(ch);
	    		return false;
	    	} 
	    	
	    	if(cursorindex == len)
	    	{	    		
	    		obj.value = curValue+ch;
	    		globleHexValue = globleHexValue + ' '+text2Hex(ch);
	    		setDigitalTag_Pos(obj,endpos+1);
	    	}
		    else 		
	    	{
	    		obj.value = curValue.substring(0,cursorindex)+ch+curValue.substring(cursorindex+1);	
	    		globleHexValue = globleHexValue.substring(0,3*cursorindex) + text2Hex(ch) + ' '+globleHexValue.substring(3*(cursorindex+1));
	    		setDigitalTag_Pos(obj,cursorindex+1);	 
	    	}
		    
		  }
		  else  //                  
    	{
    		if(endpos >= curValue.length)
    		{
	    		obj.value = curValue.substring(0,cursorindex)+ch;
	    		globleHexValue = globleHexValue.substring(0,3*cursorindex)+ text2Hex(ch);
	    		setDigitalTag_Pos(obj,cursorindex+1);    			
    		}
    		else
    		{
	    		var selectText = curValue.substring(cursorindex,cursorindex + 1);
	    		var reg = /[(0-9)|(A-F)|(a-f)]/g;
	    		selectText = selectText.replace(reg,ch);
	    		obj.value = curValue.substring(0,cursorindex)+ch+curValue.substring(cursorindex + 1);
	    		globleHexValue = globleHexValue.substring(0,3*cursorindex) + text2Hex(ch) + ' '+globleHexValue.substring(3*(cursorindex+1));
	    		setDigitalTag_Pos(obj,cursorindex + 1);	
    	 }
    	}
    }
    
	if(code == 8 || event.keyCode == 46)
	{
		if(endpos >= len)//      ,      
		{
		    event.returnValue=true;
		    globleHexValue = globleHexValue.substring(0,globleHexValue.length-3);
				return true;	
		}
		else //         0   
		{
            if(cursorindex == endpos)
         	{
	            if(code == 8)	
	            {
	            	cursorindex -= 1;
	            }	
	            else
	            {
	            	endpos += 1;
	            }
         	}

    		obj.value = curValue.substring(0,cursorindex)+curValue.substring(endpos);
    		globleHexValue = globleHexValue.substring(0,3*cursorindex) + globleHexValue.substring(3*(cursorindex+1));
    		
    		setDigitalTag_Pos(obj,endpos-1);	
		}
  } 	
 
	event.returnValue=false;
	return false;		   
}

/**
 * 16          OnkeyDown  ,  IE
 * @param obj      splitChar:       
 * @return  
 */
function hexTextKeyDownCheck(obj,splitChar)
{
	var event=EventUtil.getEvent();
	if(null == splitChar)
	{
		splitChar = " ";
	}
    var code = event.keyCode;
    if(code>255)
    {
    	event.returnValue=false;
    	return false;
    }

	var ch = String.fromCharCode(code).toLocaleUpperCase();

	var cursorindex = digitalTag_getPos(obj);
	var selectlen = selectionLen(obj);
	var endpos = cursorindex+selectlen;

	if(code == 13 && obj.blur)
  {  	
    obj.blur();
    return true;	
  }
    if(code > 36 && code < 41)
    {
    	event.returnValue=true;
    	return;        
    }
    if(event.ctrlKey)
    {
		var chtmp = ch.toLowerCase();
    	if(chtmp == 'c' || chtmp == 'a' || chtmp == 'v' || chtmp == 'x')
    	{  //X C V A
    	   event.returnValue=true;        	   
    	}
        else
        {
            event.returnValue=false;
        }
        return false;
   }
	var curValue = obj.value;
    var len = curValue.length;
    if((code >= 48 && code <=57)  || (code >= 65 && code <= 70) || (code >= 96 && code <= 105))
    {
    	
    	if(code >= 96 && code <= 105)
    	{
    		ch = code - 96;
    	}
    	
    	if(0 == selectlen) //                  
    	{
		    if(len >= obj.maxLength && cursorindex >= obj.maxLength)
		    {
		    	setDigitalTag_Pos(obj,len);
		    	event.returnValue=false;
		    	return false;
		    }
		    
	    	if(len <= 1)
	    	{
	    		obj.value = curValue+ch;
	    		event.returnValue=false;
	    		setDigitalTag_Pos(obj,endpos+1);
	    		return false;
	    	} 
			    
	    	if(cursorindex == len)
	    	{	    		
	    		if(curValue.charAt(cursorindex-1)!=splitChar && curValue.charAt(cursorindex-2)!=splitChar)
	    		{
	    			setDigitalTag_Pos(obj,cursorindex+2);
	    			obj.value = curValue+splitChar+ch;
	    		}
	    		else
	    		{
	    			setDigitalTag_Pos(obj,cursorindex+1);
	    			obj.value = curValue+ch;
	    		}
	    	}
	    	
	    	else if(curValue.charAt(cursorindex) != splitChar && (curValue.charAt(cursorindex-1) != splitChar || curValue.charAt(cursorindex+1) != splitChar))
	    	{
	    		obj.value = curValue.substring(0,cursorindex)+ch+curValue.substring(cursorindex+1);
	    		setDigitalTag_Pos(obj,cursorindex+1);	
	    	}
	    	else //if(curValue.charAt(cursorindex-1)!=splitChar && curValue.charAt(cursorindex-2)!=splitChar)	    		
	    	{
	    		obj.value = curValue.substring(0,cursorindex+1)+ch+curValue.substring(cursorindex+2);	
	    		setDigitalTag_Pos(obj,cursorindex+2);	  
	    	}
    	}
    	else  //                  
    	{
    		if(endpos >= curValue.length)
    		{
    			if(curValue.charAt(cursorindex) == splitChar)
    			{
    				cursorindex = cursorindex+1;
    			}
	    		obj.value = curValue.substring(0,cursorindex)+ch;
	    		setDigitalTag_Pos(obj,cursorindex+1);    			
    		}
    		else
    		{
	    		var selectText = curValue.substring(cursorindex,cursorindex + 1);
	    		var reg = /[(0-9)|(A-F)|(a-f)]/g;
	    		selectText = selectText.replace(reg,ch);
	    		obj.value = curValue.substring(0,cursorindex)+selectText+curValue.substring(cursorindex + 1);
	    		setDigitalTag_Pos(obj,cursorindex + 1);	
    	 }
    	}
    }
    
	if(code == 8 || event.keyCode == 46)
	{
		if(endpos >= len)//      ,      
		{
		    event.returnValue=true;
			return true;	
		}
		else //         0   
		{
            if(cursorindex == endpos)
         	{
	            if(code == 8)	
	            {
	            	cursorindex -= 1;
	            }	
	            else
	            {
	            	endpos += 1;
	            }
         	}
    		var selectText = curValue.substring(cursorindex,endpos);
    		var reg = /[(0-9)|(A-F)|(a-f)]/g;
    		selectText = selectText.replace(reg,0);	  
    		obj.value = curValue.substring(0,cursorindex)+selectText+curValue.substring(endpos);
    		setDigitalTag_Pos(obj,endpos);	
		}
  } 	
 
	event.returnValue=false;
	return false;		   
}

/**
 * 16        OnkeyPress  ,  Mozilla
 * @param obj      splitChar:       
 * @return  
 */
function hexTextKeyPressCheck(obj,splitChar,evt)
{
	var event=EventUtil.getEvent();
	if(null == splitChar)
	{
		splitChar = " ";
	}
    var code = (event.keyCode!=0?event.keyCode:event.charCode);
    
    if(code == null && evt != null)
    {
    	event = evt;
	code = event.which;
    }
    
    if(code>255)
    {
    	event.returnValue=false;
    	return false;
    }
	var ch = String.fromCharCode(code).toLocaleUpperCase();
	var cursorindex = digitalTag_getPos(obj);
	var selectlen = selectionLen(obj);
	var endpos = cursorindex+selectlen;
	if(code == 13 && obj.blur)
  {  	
    obj.blur();
    return true;	
  }
    if(code > 36 && code < 41)
    {
    	event.returnValue=true;
    	return;        
    }
    if(event.ctrlKey)
    {
    	
    	if(ch == 'c' || ch == 'a')
    	{  //X C V A
    	   event.returnValue=true;        	   
    	}
        else
        {
            event.returnValue=false;
        }
        return false;
   }
	var curValue = obj.value;
    var len = curValue.length;
    if((code >= 48 && code <=57) || (code >= 97 && code <= 102)) 
    {
    	
    	if(0 == selectlen) //                  
    	{
		    if(len >= obj.maxLength && cursorindex >= obj.maxLength)
		    {
		    	setDigitalTag_Pos(obj,len);
		    	event.returnValue=false;
		    	return false;
		    }
		    
	    	if(len <= 1)
	    	{
	    		obj.value = curValue+ch;
	    		event.returnValue=false;
	    		setDigitalTag_Pos(obj,endpos+1);
	    		return false;
	    	}	    	
	    	
			    
	    	if(cursorindex == len)
	    	{	    		
	    		if(curValue.charAt(cursorindex-1)!=splitChar && curValue.charAt(cursorindex-2)!=splitChar)
	    		{
	    			setDigitalTag_Pos(obj,cursorindex+2);
	    			obj.value = curValue+splitChar+ch;
	    		}
	    		else
	    		{
	    			setDigitalTag_Pos(obj,cursorindex+1);
	    			obj.value = curValue+ch;
	    		}
	    	}
	    	
	    	else if(curValue.charAt(cursorindex) != splitChar && (curValue.charAt(cursorindex-1) != splitChar || curValue.charAt(cursorindex+1) != splitChar))
	    	{
	    		obj.value = curValue.substring(0,cursorindex)+ch+curValue.substring(cursorindex+1);
	    		setDigitalTag_Pos(obj,cursorindex+1);	
	    	}
	    	else //if(curValue.charAt(cursorindex-1)!=splitChar && curValue.charAt(cursorindex-2)!=splitChar)	    		
	    	{
	    		obj.value = curValue.substring(0,cursorindex+1)+ch+curValue.substring(cursorindex+2);	
	    		setDigitalTag_Pos(obj,cursorindex+2);	  
	    	}
    	}
    	else  //                  
    	{
    		if(endpos >= curValue.length)
    		{
    			if(curValue.charAt(cursorindex) == splitChar)
    			{
    				cursorindex = cursorindex+1;
    			}
	    		obj.value = curValue.substring(0,cursorindex)+ch;
	    		setDigitalTag_Pos(obj,cursorindex+1);    			
    		}
    		else
    		{
	    		var selectText = curValue.substring(cursorindex,endpos);
	    		var reg = /[(0-9)|(A-F)|(a-f)]/g;
	    		selectText = selectText.replace(reg,ch);
	    		obj.value = curValue.substring(0,cursorindex)+selectText+curValue.substring(endpos);
	    		setDigitalTag_Pos(obj,endpos);	
    	 }
    	}
    }
    
	if(code == 8 || (event.keyCode == 46 && event.charCode == 0))
	{
		if(endpos >= len)//      ,      
		{
		    event.returnValue=true;
			return true;	
		}
		else //         0   
		{
            if(cursorindex == endpos)
         	{
	            if(code == 8)	
	            {
	            	cursorindex -= 1;
	            }	
	            else
	            {
	            	endpos += 1;
	            }
         	}
    		var selectText = curValue.substring(cursorindex,endpos);
    		var reg = /[(0-9)|(A-F)|(a-f)]/g;
    		selectText = selectText.replace(reg,0);	  
    		obj.value = curValue.substring(0,cursorindex)+selectText+curValue.substring(endpos);
    		setDigitalTag_Pos(obj,endpos);	
		}
  } 	
 
	event.returnValue=false;
	return false;	
}

/**
 * 16          
 * @param obj       splitChar:       
 * @return  
 */
function hexCellEvent(obj,splitChar)
{
	if(isIE)
	{
		obj.onkeydown = function()
		{			
			hexTextKeyDownCheck(obj,splitChar);
		}
		obj.onkeypress = function()
		{
			var event=EventUtil.getEvent();
			var code = (event.keyCode!=0?event.keyCode:event.charCode);
	    if(code>255)
	    {
	    	event.returnValue=false;
	    	return false;
	    }
		}
  }
  else
  {
		obj.onkeypress = function()
		{
			var evt=EventUtil.getEvent();
			hexTextKeyPressCheck(obj,splitChar,evt);
	  }
  }
}
	
/**
 *        
 * @param obj      endpos:    
 * @return  
 */
function setDigitalTag_Pos(obj,endpos)
{
	if(isIE)
	{
		document.selection.empty();
		var rng = document.selection.createRange();  
		rng.move('character',endpos);
		rng.select();
	}
	else
	{
		obj.selectionEnd = endpos;
	}
}

/**
 * MAC       
 * @param obj      isSortTable:   SortTable    false
 * @return  
 */
function checkMACAddEvent(obj, isSortTable)
{
	  obj.style.imeMode = "disabled";
	  obj.maxLength = "17";
	  
	  obj.onpaste = returnFalse;
	  
	  obj.onblur = function()
	  {
	  	checkMACValidate(this,isSortTable);
	  }
    
		if(isIE)
		{
			obj.onkeydown = function()
			{			
				hexTextKeyDownCheck(obj,"-");
			}
			obj.onkeypress = function()
			{
				var event=EventUtil.getEvent();
				var code = (event.keyCode!=0?event.keyCode:event.charCode);
		    if(code>255)
		    {
		    	event.returnValue=false;
		    	return false;
		    }
			}
	  }
	  else
	  {
			obj.onkeypress = function()
			{
				var evt=EventUtil.getEvent();
				hexTextKeyPressCheck(obj,"-",evt);
		  }
	  }
}

/**
 *   MAC                       0  
 * @param obj      isSortTable:   SortTable    false
 * @return  
 */
function checkMACValidate(obj,isSortTable)
{
	var macFormat = "00-00-00-00-00-00";	
	if(obj.value.length < obj.maxLength)
	{
		obj.value = obj.value + macFormat.substring(obj.value.length,17);	
	}
	if(isSortTable)
	{
		cellonblur(obj);
	}
}

/**
 * 10          
 * @param obj       splitChar:       
 * @return  
 */
function tenCellEvent(obj,splitChar)
{
	if(isIE)
	{
		obj.onkeydown = function()
		{	
			var event=EventUtil.getEvent();
			var code = (event.keyCode!=0?event.keyCode:event.charCode);

			if (code >= 65 && code <= 90)
			{
				event.returnValue=false;
		    	return false;
			}	
				
			hexTextKeyDownCheck(obj,splitChar);
		}
		obj.onkeypress = function()
		{
			var event=EventUtil.getEvent();
			var code = (event.keyCode!=0?event.keyCode:event.charCode);
			if (code >= 65 && code <= 90)
			{
				event.returnValue=false;
		    	return false;
			}
			
		    if(code>255)
		    {
		    	event.returnValue=false;
		    	return false;
		    }
		}
  }
  else
  {
		obj.onkeypress = function()
		{
			var event=EventUtil.getEvent();
			var code = (event.keyCode!=0?event.keyCode:event.charCode);
			
			if (code >= 65 && code <= 90)
			{
				event.returnValue=false;
		    	return false;
			}
			
			hexTextKeyPressCheck(obj,splitChar,event);
	  }
  }
}
function portmacConvert(value)
{
	var strResult = "/";
	if(value != null && value.length >= 12)
	{
		strResult = "";
		var strSplit = ""
		for(var i = 0;i < 6;i++)
		{
			strResult += strSplit + value.substr(i * 2,2);
			strSplit = "-";
		}
	}
	return strResult;
}
/**
 *     
 */
function addSpace(value)
{
	var temp = "";
	for(var i = 0,len = value.length;i<len;i++)
	{
		temp += value.substring(i,i+2);
		
		if(i<value.length-1)
		{
			temp += " ";
		}
		i++;
	}
	return temp;
}

/**
 *              
 * @param {Object} value
 */
function checkHexValid(value)
{
	var hexs = value.split(" ");
	var reg = /^[a-f,A-Z,0-9]{2}$/;
	for(var i = 0,len = hexs.length;i < len;i++)
	{
		if(hexs[i] != "" && !reg.test(hexs[i]))
		{
			return false;
		}
	}
	return true;
}

