 /**
 *                JS          
 */
(function(){
	var doc = document,
		win = window,
		INT_TYPE = "INT",
		LONG_TYPE = "LONG",
		FLOAT_TYPE = "FLOAT",
		STRING_TYPE = "STRING",
		LIST_TYPE = "LIST";
		CurrentNEInfo = null;
		SpecialAttrCache = null,
		SpecialAttrSupportCP = null,
		SpecialAttrSupportState = null,
		SpecialAttrNotSupportState = null,
		SpecialAttrDescrip = null,
		SpecialAttrSupportSlot = null,
		SpecialFunID = "",
	/**
	 *   WebLCT    ,  http://10.**.**.**\weblct
	 */
	function getRootPath()
	{		
		var strPath=window.document.location.pathname;
        	var processReg = /^\/\S[^\/]+\/\d+\/\d+\/\S+/g;
        	var rootPath = "";
        	if(processReg.test(strPath))
        	{
        		var paths = strPath.substr(1).split('/');
        		postPath = "/" + paths[0] + "/" + paths[1] + "/" + paths[2];
        	}
        	else
        	{
        		postPath=strPath.substring(0,strPath.substr(1).indexOf('/') + 1);
        	}
        	if(postPath.indexOf("/") != 0)
        	{
        		postPath = "/" + postPath;
        	}
        	return postPath;
	}
	
	/**
	 *                   
	 * @param {Object} attrids
	 */
	function getAttrs(funid,attrids)
	{
		if(typeof(attrids) == "undefined")
		{
			attrids = funid;
		}
		if(typeof(attrids) == "string")
		{
			var attrid = attrids;
			attrids = new Array();
			attrids[0] = attrid;
		}
		return attrids;
	}
	/**
	 *   NE XML  
	 * @param {Object} neid
	 */
	function createNeXML(neid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		row.appendChild(new tagElement("param","neid",neid));
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}

	/**
	 *     Attr   XML  
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrids
	 */
	function createAttrXML(neid,slotid,funid,attrid)
	{
		if(typeof(attrid) == "undefined")
		{
			funid = SpecialFunID;
		}
		var attrids = getAttrs(funid,attrid);
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var attrid = attrids[i];
			var row = new tagElement("row-params");
			row.appendChild(new tagElement("param","neid",neid));
			if(typeof(slotid) != "undefined" && slotid != null && slotid != "")
			{
				row.appendChild(new tagElement("param","slotid",slotid));
			}
			row.appendChild(new tagElement("param","funid",funid));
			row.appendChild(new tagElement("param","attrid",attrid));
			bussiness.appendChild(row);
		}
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	/**
	 *     Attr   XML          
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrids
	 */
	function createBoardTypeAttrXML(neid,boardType,funid,attrid)
	{
		if(typeof(attrid) == "undefined")
		{
			funid = SpecialFunID;
		}
		var attrids = getAttrs(funid,attrid);
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var attrid = attrids[i];
			var row = new tagElement("row-params");
			row.appendChild(new tagElement("param","neid",neid));
			row.appendChild(new tagElement("param","boardType",boardType));
			row.appendChild(new tagElement("param","funid",funid));
			row.appendChild(new tagElement("param","attrid",attrid));
			bussiness.appendChild(row);
		}
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	
	/**
	 *     Attr   XML          
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrids
	 */
	function createNeTypeAttrXML(neid,neType,funid,attrid)
	{
		if(typeof(attrid) == "undefined")
		{
			funid = SpecialFunID;
		}
		var attrids = getAttrs(funid,attrid);
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var attrid = attrids[i];
			var row = new tagElement("row-params");
			row.appendChild(new tagElement("param","neid",neid));
			row.appendChild(new tagElement("param","neType",neType));
			row.appendChild(new tagElement("param","funid",funid));
			row.appendChild(new tagElement("param","attrid",attrid));
			bussiness.appendChild(row);
		}
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}

	/**
	 *     Fun   XML  
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 */
	function createFunXML(neid,slotid,funid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		row.appendChild(new tagElement("param","neid",neid));
		if(typeof(slotid) != "undefined" && slotid != null && slotid != "")
		{
			row.appendChild(new tagElement("param","slotid",slotid));
		}
		row.appendChild(new tagElement("param","funid",funid));
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	function createNeTypeFunXML(neid,neType,funid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		row.appendChild(new tagElement("param","neid",neid));
		row.appendChild(new tagElement("param","neType",neType));
		row.appendChild(new tagElement("param","funid",funid));
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	function createBoardTypeFunXML(neid,boardType,funid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		row.appendChild(new tagElement("param","neid",neid));
		row.appendChild(new tagElement("param","boardType",boardType));
		row.appendChild(new tagElement("param","funid",funid));
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	/**
	 *                       
	 *                                  
	 *             Map          Key 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrids
	 */
	function getSupportCPList(neid,funid,attrids)
	{
		SpecialAttrSupportCP = null;
		var xml = createAttrXML(neid,null,funid,attrids);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_SUPPORTCP + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getSupportCPListCallBack,null,"inputdata="+xml);
		var resultList = SpecialAttrSupportCP;
		if(resultList == null)
		{
			resultList = [];
		}
		SpecialAttrSupportCP = null;
		return resultList;
	}
	/**
	 *                         
	 *                                  
	 *             Map          Key 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrids
	 */
	function getSupportSlotList(neid,funid,attrids)
	{
		SpecialAttrSupportSlot = null;
		var xml = createAttrXML(neid,null,funid,attrids);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_SUPPORTSLOT + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getSupportSlotListCallBack,null,"inputdata="+xml);
		var resultList = SpecialAttrSupportSlot;
		if(resultList == null)
		{
			resultList = [];
		}
		SpecialAttrSupportSlot = null;
		return resultList;
	}
	/**
	 *          
	 * @param {Object} doc
	 */
	function getSupportCPListCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if(data.getSErrorCode() == 0)
		{
			SpecialAttrSupportCP = [];
			for(var i = 0,len = data.getDataRowLength();i < len;i++)
			{
				var attrid = data.getDataRowParam(i,"attrid");
				var boardtypes = data.getDataRowParam(i,"boardtypes");
				if(typeof(attrid) == "undefined" || attrid == null
					|| typeof(boardtypes) == "undefined" || boardtypes == null)
				{
					continue;
				}
				if (len == 1) 
				{
					SpecialAttrSupportCP = boardtypes.split(",");
				}
				else 
				{
					SpecialAttrSupportCP[attrid] = boardtypes.split(",");
				}
			}
		}
	}
	/**
	 *            
	 * @param {Object} doc
	 */
	function getSupportSlotListCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if(data.getSErrorCode() == 0)
		{
			SpecialAttrSupportSlot = [];
			for(var i = 0,len = data.getDataRowLength();i < len;i++)
			{
				var attrid = data.getDataRowParam(i,"attrid");
				var slotids = data.getDataRowParam(i,"slotids");
				if(typeof(attrid) == "undefined" || attrid == null
					|| typeof(slotids) == "undefined" || slotids == null)
				{
					continue;
				}
				if (len == 1) 
				{
					SpecialAttrSupportSlot = slotids.split(",");
				}
				else 
				{
					SpecialAttrSupportSlot[attrid] = slotids.split(",");
				}
			}
		}
	}

	/**
	 *              JSON  
	 * name:**,type**,value
	 * @param {Object} attrdescrip
	 */
	function parseAttrDescrip(data,i)
	{
		var attrdescripname = data.getDataRowParam(i,"attrdescripname");
		var attr = null;
		if(typeof(attrdescripname) != "undefined" && attrdescripname != null && attrdescripname != "")
		{
			var attrdescriptype = data.getDataRowParam(i,"attrdescriptype");
			var attrdescripvalue = data.getDataRowParam(i,"attrdescripvalue");
			attr = new AttrDescrip(attrdescripname,attrdescriptype,attrdescripvalue);
		}
		return attr;
	}
	/**
	 *       
	 */
	function AttrDescrip(name,type,value)
	{
		this.name = name;
		this.type = type;
		this.value = value;
	}
	
	/**
	 *   Function           
	 * @param {Object} doc
	 */
	function getFunInfoCallBack(doc,params)
	{
		var data = EncapsulateData(doc);
		SpecialAttrCache = new Object();
		SpecialAttrCache.Key = params;
		if (data.getSErrorCode() == 0) 
		{
			SpecialAttrCache.attrdescrip = new Object();
			for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
			{
				var support = data.getDataRowParam(i,"support");
				if(typeof(support) != "undefined" && support != null && support != "")
				{
					SpecialAttrCache.support = support.split(",");
					continue;
				}
				var notsupport = data.getDataRowParam(i,"notsupport");
				if(typeof(notsupport) != "undefined" && notsupport != null && notsupport != "")
				{
					SpecialAttrCache.notsupport = notsupport.split(",");
					continue;
				}
				var attrdescripname = data.getDataRowParam(i,"attrdescripname");
				if(typeof(attrdescripname) != "undefined" && attrdescripname != null && attrdescripname != "")
				{
					var attrdescriptype = data.getDataRowParam(i,"attrdescriptype");
					var attrdescripvalue = data.getDataRowParam(i,"attrdescripvalue");
					SpecialAttrCache.attrdescrip[attrdescripname] = parseAttrDescrip(data,i);
					continue;
				}
			}
		}
	}
	/**
	 *         
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 */
	function getCPFunInfo(neid,slotid,funid)
	{
		SpecialAttrCache = null;
		SpecialFunID = funid;
		var xml = createFunXML(neid,slotid,funid);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_FUNATTR + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getFunInfoCallBack,[neid,slotid,funid],"inputdata="+xml);
	}
	
	function getCPFunInfoByType(neid,boardType,funid)
	{
		SpecialAttrCache = null;
		SpecialFunID = funid;
		var xml = createBoardTypeFunXML(neid,boardType,funid);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_FUNATTR + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getFunInfoCallBack,[neid,boardType,funid],"inputdata="+xml);
	}
	/**
	 *         
	 * @param {Object} neid
	 * @param {Object} funid
	 */
	function getNEFunInfo(neid,funid)
	{
		SpecialAttrCache = null;
		SpecialFunID = funid;
		var xml = createFunXML(neid,null,funid);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_FUNATTR + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getFunInfoCallBack,[neid,null,funid],"inputdata="+xml);
	}
	
	function getNEFunInfoByType(neid,neType,funid)
	{
		SpecialAttrCache = null;
		SpecialFunID = funid;
		var xml = createNeTypeFunXML(neid,neType,funid);
		var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_FUNATTR + "&neid=" + neid;
		loadXMLdoc(url,"POST",false,getFunInfoCallBack,[neid,neType,funid],"inputdata="+xml);
	}
	
	/**
	 *             
	 * @param {Object} doc
	 */
	function isSupportCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0) 
		{
			SpecialAttrSupportState = new Object();
			for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
			{
				var attrid = data.getDataRowParam(i,"attrid");
				var support = data.getDataRowParam(i,"support");
				if(typeof(attrid) == "undefined" || attrid == null
					|| typeof(support) == "undefined" || support == null)
				{
					continue;
				}
				var bSupport = (support=="true")?true:false;
				if(len == 1)
				{
					SpecialAttrSupportState = bSupport;
				}
				else
				{
					SpecialAttrSupportState[attrid] = bSupport;
				}
			}
		}
	}
	
	/**
	 *              
	 * @param {Object} doc
	 */
	function isNotSupportCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0) 
		{
			SpecialAttrNotSupportState = new Object();
			for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
			{
				var attrid = data.getDataRowParam(i,"attrid");
				var notsupport = data.getDataRowParam(i,"notsupport");
				if(typeof(attrid) == "undefined" || attrid == null
					|| typeof(notsupport) == "undefined" || notsupport == null)
				{
					continue;
				}
				var bNotSupport = (notsupport=="true")?true:false;
				if(len == 1)
				{
					SpecialAttrNotSupportState = bNotSupport;
				}
				else
				{
					SpecialAttrNotSupportState[attrid] = bNotSupport;
				}
			}
		}
	}
	/**
	 *              true      false
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 */
	function isNotSupportCache(neid,slotid,funid,attrid)
	{
		if(typeof(attrid) == "undefined")
		{
			funid = SpecialFunID;
		}
		var bResult = true;
		if(SpecialAttrCache != null 
			&& SpecialAttrCache.Key != null 
			&& SpecialAttrCache.Key.length >= 3
			&& neid == SpecialAttrCache.Key[0]
			&& SpecialAttrCache.Key[1] == slotid
			&& funid == SpecialAttrCache.Key[2])
		{
			bResult = false;
		}
		return bResult;
	}
	
	/**
	 *         
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function cacheSupport(neid,slotid,funid,attrid)
	{
		var attrids = getAttrs(funid,attrid);
		var result = new Object();
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var bSupport = false;
			if(SpecialAttrCache.support != null && typeof(SpecialAttrCache.support) != "undefined")
			{
				bSupport = SpecialAttrCache.support.contains(attrids[i]);
			}

			if(len == 1)
			{
				result = bSupport;
				break;
			}
			else
			{
				result[attrids[i]] = bSupport;
			}
		}
		return result;
	}
	/**
	 *        
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function cacheNotSupport(neid,slotid,funid,attrid)
	{
		var attrids = getAttrs(funid,attrid);
		var result = new Object();
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var bSupport = false;
			if(SpecialAttrCache.notsupport != null && typeof(SpecialAttrCache.notsupport) != "undefined")
			{
				bSupport = SpecialAttrCache.notsupport.contains(attrids[i]);
			}
			
			if(len == 1)
			{
				result = bSupport;
				break;
			}
			else
			{
				result[attrids[i]] = bSupport;
			}
		}
		return result;
	}
	
	/**
	 *            
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function cacheAttrDescrip(neid,slotid,funid,attrid)
	{
		var attrids = getAttrs(funid,attrid);
		var result = new Object();
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			if(typeof(SpecialAttrCache.attrdescrip) == "undefined")
			{
				continue;
			}
			var descrip = SpecialAttrCache.attrdescrip[attrids[i]];
			if(typeof(descrip) != "undefined" && descrip != null)
			{
				result[attrids[i]] = descrip;
			}
		}
		return result;
	}
	/**
	 *                 ID  
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isCPSupport(neid,slotid,funid,attrid)
	{
		if (isNotSupportCache(neid,slotid,funid,attrid)) 
		{
			SpecialAttrSupportState = null;
			var xml = createAttrXML(neid, slotid, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_SUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrSupportState;
		}
		else
		{
			return cacheSupport(neid,slotid,funid,attrid);
		}
	}
	
	/**
	 *                 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
    function isCPSupportByType(neid, boardType, funid, attrid)
    {
		if (isNotSupportCache(neid, boardType, funid, attrid)) 
		{
			var xml = createBoardTypeAttrXML(neid, boardType, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_SUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrSupportState;
		}
		else
		{
			return cacheSupport(neid,boardType,funid,attrid);
		}
    }
	
	/**
	 *         
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isNESupport(neid,funid,attrid)
	{
		return isCPSupport(neid,null,funid,attrid);
	}
	/**
	 *               
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
    function isNESupportByType(neid, neType, funid, attrid)
    {
		if (isNotSupportCache(neid, neType, funid, attrid)) 
		{
			var xml = createNeTypeAttrXML(neid, neType, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_SUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrSupportState;
		}
		else
		{
			return cacheSupport(neid,neType,funid,attrid);
		}
    }
	/**
	 *           
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isCPNotSupport(neid,slotid,funid,attrid)
	{
		if (isNotSupportCache(neid,slotid,funid,attrid)) 
		{
			SpecialAttrNotSupportState = null;
			var xml = createAttrXML(neid, slotid, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_NOTSUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isNotSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrNotSupportState;
		}
		else
		{
			return cacheNotSupport(neid,slotid,funid,attrid);
		}
	}
	/**
	 *                 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isCPNotSupportByType(neid,boardType,funid,attrid)
	{
		if (isNotSupportCache(neid, boardType, funid, attrid)) 
		{
			SpecialAttrNotSupportState = null;
			var xml = createBoardTypeAttrXML(neid, boardType, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_NOTSUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isNotSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrNotSupportState;
		}
		else
		{
			return cacheNotSupport(neid,boardType,funid,attrid);
		}
	}
	
	/**
	 *           
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isNENotSupport(neid,funid,attrid)
	{
		return isCPNotSupport(neid,null,funid,attrid);
	}
	
	/**
	 *           
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function isNENotSupportByType(neid,neType,funid,attrid)
	{
		if (isNotSupportCache(neid, neType, funid, attrid)) 
		{
			SpecialAttrNotSupportState = null;
			var xml = createNeTypeAttrXML(neid, neType, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_NOTSUPPORTSTATE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, isNotSupportCallBack, null, "inputdata=" + xml);
			return SpecialAttrNotSupportState;
		}
		else
		{
			return cacheNotSupport(neid,neType,funid,attrid);
		}
	}
	/**
	 *                    
	 * @param {Object} doc
	 */
	function getAttrDescripCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0) 
		{
			SpecialAttrDescrip = new Object();
			for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
			{
				var attrid = data.getDataRowParam(i, "attrid");
				var attrdescripname = data.getDataRowParam(i, "attrdescripname");
				if (typeof(attrid) == "undefined" || attrid == null ||
					typeof(attrdescripname) == "undefined" ||
					attrdescripname == null) 
				{
					continue;
				}
				var descrip = parseAttrDescrip(data,i);
				if(descrip != null)
				{
					SpecialAttrDescrip[descrip.name] = descrip;
				}
			}
		}
	}
	
	/**
	 *                 slotid        
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getAttrDescrip(neid,slotid,funid,attrid)
	{
		if (isNotSupportCache(neid,slotid,funid,attrid)) 
		{
			SpecialAttrDescrip = null;
			var xml = createAttrXML(neid, slotid, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_ATTRVALUE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, getAttrDescripCallBack, null, "inputdata=" + xml);
			return SpecialAttrDescrip;
		}
		else
		{
			return cacheAttrDescrip(neid,slotid,funid,attrid);
		}
	}
	
	/**
	 *                 
	 * @param {Object} neid
	 * @param {Object} boardType
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getAttrDescripByBoardType(neid,boardType,funid,attrid)
	{
		if (isNotSupportCache(neid, boardType, funid, attrid)) 
		{
			SpecialAttrDescrip = null;
			var xml = createBoardTypeAttrXML(neid, boardType, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_ATTRVALUE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, getAttrDescripCallBack, null, "inputdata=" + xml);
			return SpecialAttrDescrip;
		}
		else
		{
			return cacheAttrDescrip(neid,boardType,funid,attrid);
		}
	}
	
	/**
	 *                 
	 * @param {Object} neid
	 * @param {Object} netype
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getAttrDescripByNeType(neid,netype,funid,attrid)
	{
		if (isNotSupportCache(neid, netype, funid, attrid)) 
		{
			SpecialAttrDescrip = null;
			var xml = createNeTypeAttrXML(neid, netype, funid, attrid);
			var url = getRootPath() + "/neListServlet?sfid=" + TECMDCODE_SPECIAL_GET_ATTRVALUE + "&neid=" + neid;
			loadXMLdoc(url, "POST", false, getAttrDescripCallBack, null, "inputdata=" + xml);
			return SpecialAttrDescrip;
		}
		else
		{
			return cacheAttrDescrip(neid,netype,funid,attrid);
		}
	}
	/**
	 *        Int 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCPAttrIntValue(neid,slotid,funid,attrid)
	{
		var descrips = getAttrDescrip(neid,slotid,funid,attrid);
		if(descrips == null)
		{
			return null;
		}
		var attrids = getAttrs(funid,attrid);
		var result = null;
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var obj = descrips[attrids[i]];
			var rValue = null;
			if(typeof(obj) != "undefined" && obj != null
			&& (obj.type == INT_TYPE || obj.type == LONG_TYPE))
			{
				rValue = parseInt(obj.value);
			}
			if(len == 1)
			{
				result = rValue;
			}
			else
			{
				if(i == 0)
				{
					result = new Object();
				}
				result[attrids[i]] = rValue;
			}
		}
		return result;
	}
		
	/**
	 *        Int 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrIntValue(neid,funid,attrid)
	{
		return getCPAttrIntValue(neid,null,funid,attrid);
	}
	
	/**
	 *        Long 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCPAttrLongValue(neid,slotid,funid,attrid)
	{
		return getCPAttrIntValue(neid,slotid,funid,attrid);
	}
	/**
	 *        Long 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrLongValue(neid,funid,attrid)
	{
		return getCPAttrLongValue(neid,null,funid,attrid);
	}
	/**
	 *        Float 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCPAttrFloatValue(neid,slotid,funid,attrid)
	{
		var descrips = getAttrDescrip(neid,slotid,funid,attrid);
		
		if(descrips == null)
		{
			return null;
		}
		
		var attrids = getAttrs(funid,attrid);
		var result = null;
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var obj = descrips[attrids[i]];
			var rValue = null;
			if(typeof(obj) != "undefined" && obj != null
			&& obj.type == FLOAT_TYPE)
			{
				rValue = parseFloat(obj.value);
			}
			if(len == 1)
			{
				result = rValue;
			}
			else
			{
				if(i == 0)
				{
					result = new Object();
				}
				result[attrids[i]] = rValue;
			}
		}
		return result;
	}
	/**
	 *        Float 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrFloatValue(neid,funid,attrid)
	{
		return getCPAttrFloatValue(neid,null,funid,attrid);
	}
	/**
	 *               
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCPAttrValue(neid,slotid,funid,attrid)
	{
		var descrips = getAttrDescrip(neid,slotid,funid,attrid);
		if(descrips == null)
		{
			return null;
		}
		var attrids = getAttrs(funid,attrid);
		var result = null;
		for(var i = 0,len = attrids.length;i < len;i++)
		{
			var obj = descrips[attrids[i]];
			if(typeof(obj) == "undefined" || obj == null)
			{
				continue;
			}
			var rValue = obj.value;
			if(len == 1)
			{
				result = rValue;
			}
			else
			{
				if(i == 0)
				{
					result = new Object();
				}
				result[attrids[i]] = rValue;
			}
		}
		return result;
	}
	/**
	 *         ,     
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrValue(neid,funid,attrid)
	{
		return getCPAttrValue(neid,null,funid,attrid);
	}
	
	/**
	 *        List 
	 * @param {Object} neid
	 * @param {Object} slotid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCPAttrListValue(neid,slotid,funid,attrid)
	{
		var descrips = getAttrDescrip(neid,slotid,funid,attrid);
		
		return getAttrListValue(descrips,funid,attrid);
	}
	
	/**
	 *            List 
	 * @param {Object} neid
	 * @param {Object} boardType
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getCpAttrListValueByType(neid,boardType,funid,attrid)
	{
		var descrips = getAttrDescripByBoardType(neid,boardType,funid,attrid);
		return getAttrListValue(descrips,funid,attrid);
	}
	
	/**
	 *   descrips    AttrList 
	 * @param {Object} descrips
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getAttrListValue(descrips,funid,attrid)
	{
		if(descrips == null)
		{
			return [];
		}
		var attrids = getAttrs(funid,attrid);
		var result = null;
		for (var i = 0, len = attrids.length; i < len; i++) 
		{
			var obj = descrips[attrids[i]];
			var rValue = null;
			if(typeof(obj) != "undefined" && obj != null)
			{
				rValue = obj.value.split(",");
			}
			if(len == 1)
			{
				result = rValue;
			}
			else
			{
				if(i == 0)
				{
					result = new Object();
				}
				result[attrids[i]] = rValue;
			}
		}
		return result;
	}
	/**
	 *        List 
	 * @param {Object} neid
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrListValue(neid,funid,attrid)
	{
		return getCPAttrListValue(neid,null,funid,attrid);
	}
	
	/**
	 *          List 
	 * @param {Object} neid
	 * @param {Object} neType
	 * @param {Object} funid
	 * @param {Object} attrid
	 */
	function getNEAttrListValueByType(neid,neType,funid,attrid)
	{
		var descrips = getAttrDescripByNeType(neid,neType,funid,attrid);
		return getAttrListValue(descrips,funid,attrid);
	}
	
	/**
	 *     ID
	 */
	function setFunID(funid)
	{
		SpecialFunID = funid;
	}
	
	/**
	 *          ,    /  /  /      /  
	 *     
	 * @param doc
	 */
	function getNeInfoCallBack(doc)
	{
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0 && data.getDataRowLength() > 0) 
		{
			CurrentNEInfo = new Object();
			CurrentNEInfo.neid = data.getDataRowParam(0,"neid");
			CurrentNEInfo.nename = data.getDataRowParam(0,"nename");
			CurrentNEInfo.netype = data.getDataRowParam(0,"netype");
			CurrentNEInfo.shelftype = data.getDataRowParam(0,"shelftype");
			CurrentNEInfo.netypenms = data.getDataRowParam(0,"netypenms");
			CurrentNEInfo.domain = data.getDataRowParam(0,"domain");
			var issupportshelf = data.getDataRowParam(0,"issupportshelf");
			if(typeof(issupportshelf) != "undefined" && issupportshelf != null && issupportshelf == "true")
			{
				CurrentNEInfo.issupportshelf = true;
			}
			else
			{
				CurrentNEInfo.issupportshelf = false;
			}
			CurrentNEInfo.neversion = data.getDataRowParam(0,"neversion");
		}
	}
	
	/**
	 *          ,    /  /  /      /  
	 * @param neid
	 */
	function getNeInfo(neid)
	{
		CurrentNEInfo = null;
		var xml = createNeXML(neid);
		var url = getRootPath() + "/neListServlet?sfid=" + 2000124 + "&neid=" + neid;
		loadXMLdoc(url, "POST", false, getNeInfoCallBack, null, "inputdata=" + xml);
		return CurrentNEInfo;
	}
	
	win.SpecialAttrMgr = {
		setFunID:setFunID,
		getNeInfo:getNeInfo,
		getSupportCPList:getSupportCPList,
		getSupportSlotList:getSupportSlotList,
		getCPFunInfo:getCPFunInfo,
		getCPFunInfoByType:getCPFunInfoByType,
		getNEFunInfo:getNEFunInfo,
		getNEFunInfoByType:getNEFunInfoByType,
		isCPSupport:isCPSupport,
		isCPSupportByType:isCPSupportByType,
		isNESupport:isNESupport,
		isNESupportByType:isNESupportByType,
		isCPNotSupport:isCPNotSupport,
		isCPNotSupportByType:isCPNotSupportByType,
		isNENotSupport:isNENotSupport,
		isNENotSupportByType:isNENotSupportByType,
		getCPAttrIntValue:getCPAttrIntValue,
		getNEAttrIntValue:getNEAttrIntValue,
		getCPAttrLongValue:getCPAttrLongValue,
		getNEAttrLongValue:getNEAttrLongValue,
		getCPAttrFloatValue:getCPAttrFloatValue,
		getNEAttrFloatValue:getNEAttrFloatValue,
		getCPAttrValue:getCPAttrValue,
		getNEAttrValue:getNEAttrValue,
		getCPAttrListValue:getCPAttrListValue,
		getCpAttrListValueByType:getCpAttrListValueByType,
		getNEAttrListValue:getNEAttrListValue,
		getNEAttrListValueByType:getNEAttrListValueByType
	};
}
)()

/**
 **  configmodel           
 **funStr           ':param'                    
 **/
function addCheckByConfigModel(neid, slotid, funID, attrID, funStr)
{
    var rangeArr 
    if(slotid <= 0 )
    {
        rangeArr = SpecialAttrMgr.getNEAttrListValue(neid, funID, attrID);
    } else {
        rangeArr = SpecialAttrMgr.getCPAttrListValue(neid, slotid, funID, attrID);
    }
    
    if(rangeArr && rangeArr.length >= 2)
    {
        for(i = 0, len = rangeArr.length; i < len; i++)
        {
            funStr = funStr.replace(":param" + i, rangeArr[i].trim());
        }
        
        eval(funStr);
    }
}

/**
 **   configmodel       
 ** defaultValue                 
 **/
function getValueByConfigModel(neid, slotid, funID, attrID, defaultValue)
{
    var value; 
    if(slotid <= 0 )
    {
        value = SpecialAttrMgr.getNEAttrValue(neid, funID, attrID);
    } else {
        value = SpecialAttrMgr.getCPAttrValue(neid, slotid, funID, attrID);
    }
    
    if(value)
    {
        return value;
    } else {
        return defaultValue;
    }
}

/**
 **   configmodel       select        
 ** obj select   keyToResource option text  
 **/
function addOptionsByConfigModel(neid, slotid, funID, attrID, obj, keyToResource)
{
    var values; 
    if(slotid <= 0 )
    {
        values = SpecialAttrMgr.getNEAttrListValue(neid, funID, attrID);
    } else {
        values = SpecialAttrMgr.getCPAttrListValue(neid, slotid, funID, attrID);
    }
    
    if(values)
    {
        obj.options.length = 0;
        
        for(var i = 0, len = values.length; i < len; i++)
        {
            if(keyToResource)
            {
                obj.options[obj.options.length] = new Option(keyToResource[parseInt(values[i].trim())], values[i].trim());
            } else {
                obj.options[obj.options.length] = new Option(values[i].trim(), values[i].trim());
            }
        }
    } 
}
