var total = 0; //     
window.curEditCell=null;

function ComboButton()
{
	total ++;
	this.id = "combobutton_" + total;
	this.name = this.id;

	this.view = document.createElement("DIV");
	
	this.selview = document.createElement("SELECT");
	this.selview.className = "combo-select";
	this.selview.style.width = "82%";
	this.view.appendChild(this.selview);
	
	this.btnview = document.createElement("BUTTON");
	this.btnview.className = "combo-button";
	this.btnview.style.width = "17%";
	this.btnview.style.height = "70%";
	this.btnview.value = "...";
	this.view.appendChild(this.btnview);
	
	this.view.parent = this;

	this.selview.onchange = selvalueChangeHandler;
	
	if (isIE)
	{
		document.onmousedown = ComboButton_mouseDown;
	}
	else if (document.addEventListener) 
	{
		document.addEventListener("mousedown", ComboButton_mouseDown, true);
	}	
	return this.view;
	
}


ComboButton.prototype.removeAll = function()
{
	while(this.selview.options.length > 0)
	{
		this.selview.remove(0);
	}
}

ComboButton.prototype.addOption = function(name,value)
{
	this.selview.options[this.selview.options.length] = new Option(name,
				value);
}

ComboButton.prototype.removeOption = function(value)
{
	for ( var i = 0, len = this.selview.options.length; i < len; i++)
	{
		if(this.selview.options[i].value == value)
		{
			this.selview.remove(i);
			
			break;
		}
	}
}

ComboButton.prototype.getValue = function()
{
	return this.selview.value;
}

ComboButton.prototype.setValue = function(value)
{
	for(var i = 0, len = this.selview.options.length; i < len; i++)
	{
	    if(this.selview.options[i].value == value)
	    {
	    	this.selview.selectedIndex = i;
	    }
	}
}

ComboButton.prototype.getLength = function()
{
	return this.selview.options.length;
}

ComboButton.prototype.getOption = function(i)
{
	return this.selview.options[i];
}

ComboButton.prototype.setOptions = function(optionsAry)
{	
	if (null != optionsAry) 
	{
		for ( var i = 0; i < optionsAry.length; i++) 
		{
			if (isIE) 
			{
				this.selview.add(optionsAry[i]);
			}
			else 
			{
				this.selview.appendChild(optionsAry[i]);
			}
		}
	}
}

ComboButton.prototype.remove = function(index)
{
	this.selview.remove(index);
}

ComboButton.prototype.setSelectedIndex = function(index)
{
	if(index == -1)
	{
		this.selview.selectedIndex = -1;
		return;
	}
	
	this.selview.selectedIndex = index;
}

ComboButton.prototype.getBtnElement = function()
{
	return this.btnview;
}

ComboButton.prototype.getComboElement = function()
{
	return this.selview;
}
/**
 *     disabled  
 * @param {Object} flag
 */
ComboButton.prototype.setDisabled = function(flag)
{
	this.selview.disabled = flag;
	this.btnview.disabled = flag;
}
/**
 * @param ops   Option[]
 * @param str   component's id
 * @param index selected option's index
 */
ComboButton.prototype.initComboBox = function(str,ops,index)
{	
	this.name = str;
	this.id = str;
	this.setOptions(ops);
	this.setSelectedIndex(index);
}

function ComboButton_mouseDown(e)
{
  if (!e)
  {
		e = window.event;
  }
  var obj,len,el,i;
  el = e.target ? e.target : e.srcElement;

  if (window.curEditCell)
  {
  	if(window.curEditCell.contains(el))
  	{
    }
    else
    {
    	if (isIE)
    	{
	   		window.curEditCell.focus();
	   		window.curEditCell.blur();
	   	}
	   	else
	   	{
	   		window.curEditCell.parent.selview.focus();
	   		window.curEditCell.parent.selview.blur();
			if(el != window.curEditCell.parent.selview
				&& el.parentNode != window.curEditCell.parent.selview)
			{
				window.curEditCell.onblur();
			}
	   	}
   	}
  }
}
 

function selvalueChangeHandler(args)
{	
	var obj;
	if(args) 
	{
		obj = args.target;
 	} 
	else 
	{
		obj = this;	
	}
	if (arguments.length > 0 && arguments[0].tagName=="SELECT")
	{
		obj = arguments[0];
	}
	
	var selval = obj.value;
	
	for (var i=0,len=obj.options.length; i<len; i++)
	{
		if (obj.options[i].value == selval)
		{
			selval = obj.options[i].text;
			break;
		}
	}

	obj.parentNode.parent.value = obj.value;
	obj.parentNode.parent.text = selval;
}
