 
var CHINESECODE_LENGTH = getChineseCodeLength();


/**
 *            
 */
function getChineseCodeLength()
{
	var url = location.href;  
	var paraString = url.substring(url.indexOf("?")+1,url.length).split("&");  
	var paraObj = {}  
	for (i=0; j=paraString[i]; i++)
	{  
		paraObj[j.substring(0,j.indexOf("=")).toLowerCase()] = j.substring(j.indexOf("=")+1,j.length);  
	}  
	var returnValue = paraObj["codelength"];  
	if(typeof(returnValue) == "undefined" || returnValue == "")
	{  
		return 2;
	}
	else
	{  
		return parseInt(returnValue);
	}  
} 

/**
 *            
 */
String.prototype.trim = function()
{
    return this.replace(/(^\s*)|(\s*$)/g, "");
}

/**
 *                
 */
function IsNotNull(checkItem,itemName)
{
	
	var item = checkItem.trim();
	var str = "";
	if(SYSTEMCONF.getLanguage() == "en")
	{
	    str = itemName + " ";
	}
	else
	{
	    str = "\""+itemName +"\"";
	}
	if(item.length == 0)
	{
	     alert(str + RESOURCE["ifnull"])
	     return false;
	}
	else
	{
	     return true;	
        }
}


function selectionLen(obj){
    	
    	if(isIE){
    	  return document.selection.createRange().text.length;
    	}else{
    	  return obj.selectionEnd-obj.selectionStart;	
    	}
	
} 

/**
 *     IP           
 */
function check_IPaddr(IpAddr)
{
    var pattern = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    var checker = pattern.test(IpAddr);
    if (!checker)
    {
        alert(RESOURCE["wrongIPaddr"]);
        return false;
    }
    else
    {       
        var partaddr = IpAddr.split(".");
        for(i = 0; i<partaddr.length; i++)
        {
           if(partaddr[i]>255)
           {
              alert(RESOURCE["wrongIPaddr"]);
              return false;
           }
        }
        return true;
    }
}

/**
 *        SortTable     CTable
 *                
 * @param  
 * @return  
 */
function checkDataCellEvent(atom,minvalue,maxvalue,defaultvalue)
{
	atom.style.imeMode = "disabled";
	if(null == defaultvalue)
	{
		defaultvalue = minvalue;
	}

	atom["onchange"] = function(evt)
	{
		evt = evt?evt:window.event;
		if(!checkDataRange(this,minvalue,maxvalue,evt))
		{
			this.value = defaultvalue;
		}	
	}
	
	var str = RESOURCE["ID_NUMLEFT"] + minvalue + RESOURCE["ID_NUMMIDDLE"] + maxvalue + RESOURCE["ID_NUMRIGHT"];
	
	atom["onkeypress"] = function()
	{
		var evt = EventUtil.getEvent();
		if (str)
		{
			return digitalTag_checkDown(this,maxvalue,checkDataRange,true,"",str,evt);
		}
		else
		{
			return digitalTag_checkDown(this,maxvalue,checkDataRange,null,null,null,evt);
		}
	}
}

function checkDataCellEventForEVPL(atom,minvalue,maxvalue,defaultvalue)
{
	atom.style.imeMode = "disabled";
	if(null == defaultvalue)
	{
		defaultvalue = minvalue;
	}
	atom.onpaste = function()
	{
	}

	atom["onchange"] = function(evt)
	{
		evt = evt?evt:window.event;
		if(!checkDataRange(this,minvalue,maxvalue,evt))
		{
			this.value = defaultvalue;
		}	
	}
	
	var str = RESOURCE["ID_NUMLEFT"] + minvalue + RESOURCE["ID_NUMMIDDLE"] + maxvalue + RESOURCE["ID_NUMRIGHT"];
	
	atom["onkeypress"] = function()
	{
		var evt = EventUtil.getEvent();	
		if (str)
		{
			return digitalTag_checkDown(this,maxvalue,checkDataRange,true,"",str,evt);
		}
		else
		{
			return digitalTag_checkDown(this,maxvalue,checkDataRange,null,null,null,evt);
		}
	}
	
}

/**
 *       CTable
 *                
 * @param  
 * @return  
 */
function checkAtomNumEvent(atom,minvalue,maxvalue,defaultvalue)
{
	atom.style.imeMode = "disabled";
	if(null == defaultvalue)
	{
		defaultvalue = minvalue;
	}
	atom.onpaste = function()
	{
		return false;
	}

	atom["onblur"] = function(evt)
	{	
		evt = evt?evt:window.event;
		if(!checkDataRange(this,minvalue,maxvalue,evt))
		{
			this.value = defaultvalue;
		}	
	}
	
	atom["onkeydown"] = function()
	{
		var evt = EventUtil.getEvent();	
		return digitalTag_checkDown(this,maxvalue,checkDataRange,null,null,null,evt);
	}
}

/**
 *   textinput             
 */
function checkDataRange(textinput,minData,maxData,evt)
{
   var key,keychar;
   
   if (evt) 
   {
       key = evt.keyCode != 0 ? evt.keyCode : evt.charCode;
   }
   else 
   {
       key = window.event.keyCode;
   } 
   keychar = String.fromCharCode(key);
   textcontent = parseInt(textinput.value + keychar);
   
   if(isNaN(textcontent) || textcontent < minData || textcontent > maxData)
   {
   	   var alertStr = RESOURCE["wrong1"] + minData + RESOURCE["wrong2"] + maxData + RESOURCE["wrong3"];
		   alert(alertStr);
       return false;
   }
  else
  {
  	if(textinput.value == 0 && textinput.value.length > 1)
    {
       textinput.value = 0;
    }
  	return true;
  }
}

/**
 *              
 */ 
function restrict(field,event,strallow)
{
   var key,keychar;
   
   key = (event.keyCode!=0?event.keyCode:event.charCode);
   
   keychar = String.fromCharCode(key);
   
    if(key == 13){
   	
    event.srcElement.blur();
    return true;	
   }
   
   if((key == null) || (key == 0) || (key == 8) || (key == 9) ||(key == 27))
    { 
      return true;
    }
   else if((strallow.indexOf(keychar) != -1))
   {
      return true;
   }
   else
   {
      return false;
   }
}
 
/**
 *   textinput              
 */
function maxlength(textinput,maxlen)
{   
   textcontent = textinput.value;
   if(textcontent.length + 1 > maxlen)
   {
      return false;
   }
   else 
   {
   	return true;
   }
}

/**
 *                  
 */
function chkinputdata(inputdata, dataname)
{
   var pattern = /^\d{1,5}$/;
   var checker = pattern.test(inputdata);
   if(!checker)
   {
       alert(RESOURCE[dataname]);
       return false;
   }
   else
   {
       return true;
   }
}

/**
 *              16     
 */
function chkhexnum(inputdata, dataname)
{
   var pattern = /^[a-fA-F0-9]{1,26}$/;
   var checker = pattern.test(inputdata);
   if(!checker)
   {
      alert(RESOURCE[dataname]);
      return false;
   }
   else
   {
      return true;
   }
}

/**
 *         
*/
function digitalTag_getPos(obj)
{
	if(isIE){
 		var ml = obj.value.length;
    var pos = 0;
	  var rng = document.selection.createRange();
	  rng.moveEnd('character',ml);
	  try{
	    pos = ml-rng.text.length;
	  }catch (e){}
	  return pos;
 }else{
    return obj.selectionStart;
 	}
}

/**
 *                      MAX      
 * submitfunc          ,      ,           ''
 */
function digitalTag_checkDown(obj, max, submitfunc, maxalertflag, resource, alertstr, evt)
{
    evt = ((typeof(evt) == "undefined" || !evt) ? EventUtil.getEvent() : evt);
    var code = evt.keyCode != 0 ? evt.keyCode : evt.charCode;
    var ch = String.fromCharCode(code);
    if (code == 13) 
    {
		var obj =evt.target?evt.target:evt.srcElement;
        obj.blur();
        return true;
    }
    
	if (code == 9 || code == 8 || code == 127)
    {
        return true; //DEL   
    }
	if(!evt.shiftKey && code >= 33 && code <= 40)
	{
		if(evt.which || typeof(evt.which) == "undefined")
		{
			return false;
		}
		return true;
	}
	if(typeof(evt.which) != "undefined" && evt.which == 0 && (code == 46))
	{
		return true;
	}
    if(evt.ctrlKey){
        if(ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A'){  //X C V A
            return true;
        }
        else{
            return false;
        }
    }

    if(evt.type == "keydown")
    {
        if(code < 48 || (code > 57 && code < 96) ||code > 105)
        {
            return false;  //   
        }
    }
    else
    {
        if(code < 48 || code > 57)
        {
            return false;  //   
        }
    }
    var value=obj.value;
    pos=digitalTag_getPos(obj);                 //        

    if((value.length == 0) && (pos==0) ){
        return true;
    }
    
    if(evt.type == "keydown")
    {
        if(pos == 0 && value.length > 0 && (code == 48 || code == 96) && selectionLen(obj) != value.length)
        { 
            return false;
        }
    }
    else
    {
        if(pos == 0 && value.length > 0 && code == 48 && selectionLen(obj) != value.length)
        { 
            return false;
        }
    }
    if(value=='0' && pos>0){
        return false;
    }
    
    if(code < 58){
        ch = '' + code - 48
    }
    else if(evt.type == "keydown")
    {
        ch = '' + code - 96
    }
    
    var newVal = value.substring(0, pos) + ch + value.substring(pos + selectionLen(obj));
    if (parseInt(newVal, 10) > max) 
    {
        if (maxalertflag && alertstr) 
        {
            obj.value = max;
            if (resource) 
            {
                alert(resource[alertstr]);
            }
            else 
            {
                alert(alertstr);
            }
            
            obj.value = max;
            return false;
        }
        else 
        {
            obj.value = max;
            return false;
        }
    }
    return true;
}

function validateNumRange(valobj, minval, maxval)
{
	var tmp = valobj.value;
	if (parseInt(tmp, 10) > maxval)
	{
		valobj.value = maxval;
		alert(RESOURCE["ID_NUMLEFT"] + minval + RESOURCE["ID_NUMMIDDLE"] + maxval + RESOURCE["ID_NUMRIGHT"]);
	}
}

function digitalTag_checkPaste(obj){
    var s=window.clipboardData.getData('text');
    for(i=0;i<s.length;i++){
        if(s.charAt(i)<'0' || s.charAt(i)>'9'){
	        return false;
	    }
        if(s.charAt(0) == '0'){
          if(digitalTag_getPos(obj)==0){
          	  return false;
          }
        }
    }
}

/**
 *                           minData maxData  
 */
function checkkinputdata(inputdata, minData, maxData, dataname)
{
   var pattern = /^\d{1,5}$/;
   var checker = pattern.test(inputdata);
   if(!checker)
   {
       alert(RESOURCE[dataname]);
       return false;
   }
   else
   {
   	   if(inputdata < minData || inputdata > maxData)
   	   {
   	   	   alert(RESOURCE[dataname]);
   	   	   return false;
   	   }
       return true;
   }
}

/**
 *                 "," "-"
 */
function chkinputdata2(inputdata, dataname)
{ 
	 if(inputdata == "")
	 {
	 	  alert(RESOURCE[dataname]);
   	  return false;
	 }
   for(var i = 0, len = inputdata.length; i < len; i++)
   {
   	  var ch = inputdata.charAt(i);
   	  if(ch != "1" && ch !="2" && ch!="3" && ch!="4" && ch!="5" && ch!="6"
   	  && ch != "7" && ch !="8" && ch!="9" && ch!="0" && ch!="," && ch!="-")
   	  {
   	  	  alert(RESOURCE[dataname]);
   	  	  return false;
   	  }
   }
   return true;
}

/**
 *  onkeyup                                   
 *     obj             
 *        maxlen:         
 */
function calStrSinoLen(obj, maxlen)
{
    var key = event.keyCode;
    
    if(obj.onblur == null)
    {
    	obj.onblur = function()
	    {
	    	calStrSinoLenCheck(obj, maxlen);
	    }
    }
    if(key==13)
	{
		event.srcElement.blur();
		return false;
    }

    if((key == null) || (key == 0) || (key == 8) || (key == 9) ||(key == 27) || (key == 39) || (key == 37))
    { 
      return true;
    }
    if(key==13)
	  {
	  	event.srcElement.blur();
		  return false;
    }
   	
    calStrSinoLenCheck(obj, maxlen);
}

/**
 * calStrSinoLen         
 */
function calStrSinoLenCheck(obj, maxlen)
{
    var str = obj.value;
    var totalLength = 0;
	var i;
	var charCode;
	for (i = 0; i < str.length; i++)
	{
		charCode = str.charCodeAt(i);
		if (charCode < 0x007f)
		{
			totalLength = totalLength + 1;
		}
		else if ((0x0080 <= charCode) && (charCode <= 0x07ff))
		{
			totalLength += 2;
		} 
		else if ((0x0800 <= charCode) && (charCode <= 0xffff))
		{
			totalLength += CHINESECODE_LENGTH;
		}
		
		if (totalLength > maxlen)
        {
            obj.value = str.substring(0, i);
            return false;
        }
	}
}

function maskChinese(obj){
	
		 var code = event.keyCode;
 
    if(code == null)
    { 
      return true;
    }
   
    if(code == 8 || code == 46 || code == 9||code==27){
    	return true;   //DEL    ESC
    }
    if(code > 36 && code < 41){
        return true;        //   
    } 
    
		
	  if(obj.value.length>0){
	     var str=obj.value;
	     var nstr='';
	     for(var i=0; i<obj.value.length; i++){
	        var ch=str.charCodeAt(i);
	        if(ch<127){
	          nstr+=str.charAt(i);	
	        }	
	     }
	    var maxlen=obj.getAttribute("maxLength");
	    if(maxlen){
	    	obj.value=nstr.substr(0,parseInt(maxlen));
	    }
	     	
	  }
	}
	
	
	/**
 * 
 *          
 * @param  
 * @return  
 */
function checkNonChinesCellEvent(atom)
{
	atom.style.imeMode = "disabled";
	if(null == defaultvalue)
	{
		defaultvalue = minvalue;
	}
	atom.onpaste = chines_checkPaste;	

	atom["onkeypress"] = function()
	{				
		var key = event.keyCode;
		if(key > 255)
		{
			return false;
		}
	}

}

	/**
 * 
 *        
 * @param  
 * @return  
 */
function disableChines(evt)
{
    evt = evt ? evt : window.event;
    var key = evt.keyCode;
    if (key > 255) 
    {
        return false;
    }
}

function chines_checkPaste(obj){
    var s=window.clipboardData.getData('text');
    for(i=0;i<s.length;i++){
        if(s.charCodeAt(i)>255){
	        return false;
	    }        
    }
}
/**
 *           noAllow    
 */ 
function restrictByAllow(field,event,noAllow)
{
   var key,keychar;
   
   key = (event.keyCode!=0?event.keyCode:event.charCode);
   
   keychar = String.fromCharCode(key);
   
    if(key == 13){
   	
    event.srcElement.blur();
    return true;	
   }
   if((noAllow.indexOf(keychar) != -1))
   {
      return false;
   }
   else
   {
      return true;
   }
}
