
var ct;

var win = getParentWindow();

/*
 *      
 */
function initPage()
{
	  ct = new CTable();
    ct.addHead(RESOURCE["attibutename"],RESOURCE["attrvalue"]);
    
    atom = new Atom("select");
    atom.element.style.width="100%";
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipdomain"],"1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipaddress"],"2");
    ct.addAttrRow("domainType", RESOURCE["domaintype"], atom);
    
    atom = new Atom("text");
    
    ct.addAttrRow("domainAddress", RESOURCE["domainaddress"], atom);
    
    document.getElementById("domainaddtable").appendChild(ct.getTable());
    
    var objip = ct.getAtom("domainAddress").element;
	  validateIp(objip);
    
    document.getElementById("okbtn").value=RESOURCE["okbutton"];
	  document.getElementById("cancel").value=RESOURCE["cancelbutton"];
	  document.getElementById("applybtn").value=RESOURCE["applybutton"];
}

/*
 *   ip      
 */
function getSection(section)
{
	var temp = parseInt(section);
	
	if(temp < 0 || temp > 255)
	{
		return -1;
	}
	
	if(section != temp)
	{
		return -1;
	}
	
	return temp;
}

/*
 *     ip   ip      
 */
function validSearchDomain()
{
	var domainAddress = ct.getAtom("domainAddress").element.value;
	var domainType = ct.getAtom("domainType").element.options[ct.getAtom("domainType").element.options.selectedIndex].value;
	var section1 = null;
	var section2 = null;
	var section3 = null;
	var section4 = null;
	
	var sections = domainAddress.split(".");
	
	if( sections && (sections.length != 4) )
	{
	    alert(RESOURCE["invalidIPAddrStr"]);
	    return false;
	}

    for(var i = 0, len = sections.length; i < len; i++)
    {
    	if("" == sections[i])
    	{
    		alert(RESOURCE["invalidIPAddrStr"]);
    		return false;
    	}
    	
    }    
    section1 = getSection(sections[0]);//parseInt(sections[0]);
    section2 = getSection(sections[1]);
    section3 = getSection(sections[2]);
    section4 = getSection(sections[3]);
    
    if(section1 > 255 || 0 >= section1 ||section2 > 255 || 0 > section2 
        || section3 > 255 || 0 > section3 || section4 > 255 || 0 > section4)
    {
    	alert(RESOURCE["invalidIPAddrStr"]);
    		return false;
    }
    
    var infoMsg = null;
    if(1 == domainType)
    {
    	if( section1 < 128)
    	{
    		
    	}
    	else if(section1 < 192)
    	{
    	}
    	else if(section1 < 224)
    	{
    	}
    	else
    	{
    		infoMsg = RESOURCE["invalidIPAddrStr"];
    		alert(infoMsg);
    		return false;
    	}
    }
    else
    {
    	if(0 == section1 || section1 > 223 || 255 == section2 || 255 == section3 || 255 == section4 || 0 == section4)
    	{
    		alert(RESOURCE["invalidIPAddrStr"]);
    		return false;
    	}
    }
    
    if(win.hasSameIP(domainAddress))
    {
    	alert(RESOURCE["sameIPExit"]);
    	return false;
    }
    
    return true;
}

/*
 *              onclick  
 * @param flag 0 -        1 -       
 */
function doAddIP(flag)
{
    if(!validSearchDomain())
    {
    	return;
    }
    
    var xmlData = createAddIPXml();
    
    var URL = "../deviceSearchServlet?sfid=24604&flag=1&timestamp="+new Date().getTime();
    
    setPageEleStatus(true);
    
    loadXMLdoc(URL, "POST", true, callbackDoAddIP, flag, "inputdata="+xmlData);
}

/*
 *           
 */
function callbackDoAddIP(doc, flag)
{
	var datainterface = EncapsulateData(doc);
	
	var errArr = [];
    errArr[0] = "domainAddress";
    openErrPage("", datainterface.getError(), errArr);
    errArr = null;
    
    setPageEleStatus(false);
    
    if( 1 == flag)
    {
    	window.close();
    }
    else if( 0 == flag)
    {
        ct.getAtom("domainAddress").element.value = "";        
    }
    
    win.refreshTableData();
}

/*
 *         xml 
 */
function createAddIPXml()
{
	var domainAddress = ct.getAtom("domainAddress").element.value;
	
	var domainType = ct.getAtom("domainType").element.options[ct.getAtom("domainType").element.options.selectedIndex].value;
	
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	var row = new tagElement("row-params");
	
	var param = new tagElement("param");
	param.setAttribute("name", "domainAddress");
	param.setAttribute("value", domainAddress);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "domainType");
	param.setAttribute("value", domainType);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
	
}

/*
 *           
 */
function setPageEleStatus(state)
{
    ct.getAtom("domainType").element.disabled = state;
    ct.getAtom("domainAddress").element.disabled = state;
    
    document.getElementById("okbtn").disabled = state;
    document.getElementById("cancel").disabled = state;
    document.getElementById("applybtn").disabled = state;
}
