loadXMLdoc("../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
ifdemo = SYSTEMCONF.getDemo();

getResourse("../res/neinformationres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../res/necommres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../res/nelist_" + SYSTEMCONF.getLanguage() + ".xml");

document.write("<title>"+RESOURCE["appendNE"]+"</title>");

var GATETYPE_IP = "1";
var GATETYPE_OSI = "2";
var GATETYPE_COM = "3";
var GATETYPE_SSL = "4";
var GATETYPE_USBSERIAL = "5";

var ct;
var win = getParentWindow();
var storeGateWayType = GATETYPE_IP;
var hasTable = false;

window.onload = function()
{
	/*
	 * OPKD47786                onload        
	 *   CTable           CTable          
	 * appendChild        CTable             appendChild
	 */
	ct  = new CTable();
	ct.addHead(RESOURCE["attibutename"],RESOURCE["attrvalue"]);
	
	var atom = new Atom("text"); 
	atom.element.style.imeMode = "disabled";
	validateNum(atom.element,0,49151,5,"");

	EventUtil.addEventHandler(atom.element,"blur",neIDBlurEvent);
	
	ct.addAttrRow("id", RESOURCE["neID"]+"(*)", atom);
	
	atom = new Atom("text");
	validateNum(atom.element,0,254,3,9);
	atom.setValue("9");
	ct.addAttrRow("extendID", RESOURCE["extendID"], atom);
	
	atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipgateway"],GATETYPE_IP);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["seriesport"],GATETYPE_COM);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["SSLGW"],GATETYPE_SSL);
	if(window.parent && window.parent.document.getElementById("selNeType").value == 1)
	{
	    atom.element.options[atom.element.options.length] = new Option(RESOURCE["USB"],GATETYPE_USBSERIAL);
	}
	
	atom.element["onchange"] = function()
	{
		 changegateway(this);
	}
	ct.addAttrRow("gateway", RESOURCE["gatewaytype"], atom);
	
	atom = new Atom("text");
	ct.addAttrRow("address", RESOURCE["ipaddress"], atom);
	validateIp(atom.element);
	
	atom = new Atom("text");
	atom.setValue("1400");
	validateNum(atom.element,0,65534,5,1400);
	ct.addAttrRow("port", RESOURCE["port"], atom);
	
	atom = new Atom("text");
	atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function()
    {
    	 return chkfieldaddr(this,26,event);
    }                               
	ct.addAttrRow("nsapaddress", RESOURCE["nsapaddress"], atom);
	var inputtext = document.createElement("input");
    inputtext.disabled = true;
    inputtext.style.width = "100%";
    inputtext.style.backgroundColor  = "#CCCCCC";
    inputtext.className="textInput";
    ct.getAtom("nsapaddress").element.parentNode.appendChild(inputtext);
    ct.getAttrRow("nsapaddress").style.display = "none";
    
	atom = new Atom("select");
	for(i=1; i<=32; i++)
	{
		atom.element.options[atom.element.options.length] = new Option("COM"+i, i);
	}
	ct.addAttrRow("comport", RESOURCE["port"], atom);
	ct.getAttrRow("comport").style.display = "none";
	
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option("1200bps","1200");
	atom.element.options[atom.element.options.length] = new Option("2400bps","2400");
	atom.element.options[atom.element.options.length] = new Option("4800bps","4800");
	atom.element.options[atom.element.options.length] = new Option("9600bps","9600");
	atom.element.options[atom.element.options.length] = new Option("19200bps","19200");
	atom.element.options[atom.element.options.length] = new Option("38400bps","38400");
	atom.element.options[atom.element.options.length] = new Option("57600bps","57600");
	atom.element.options[atom.element.options.length] = new Option("115200bps","115200");
	if(window.parent && window.parent.document.getElementById("selNeType").value == 1)
	{
	   atom.element.options[atom.element.options.length] = new Option("921600bps","921600");
	}
    ct.addAttrRow("baudrate", RESOURCE["baudrate"], atom);
    ct.getAttrRow("baudrate").style.display = "none";
    atom.element.value = "115200";
    	
	atom = new Atom("text");
	atom.setValue("lct");
	atom.element.style.imeMode = "disabled";
	atom.element.maxLength = 16;
	atom.element.ondrop = function()
	{
		return false;
	}
	ct.addAttrRow("username", RESOURCE["username"], atom);
	
	atom = new Atom("password");
	atom.element.maxLength = 16;
	atom.element.ondrop = function()
	{
		return false;
	}
	ct.addAttrRow("password", RESOURCE["password"]+"(*)", atom);
	
	var usbAtom = new Atom("span");
	ct.addAttrRow("usbserdirver", RESOURCE["usbserdirver"], usbAtom);
	var elem = document.createElement("a");
    elem.href="###";
    elem.innerHTML = "<span style='color:blue'>" + "<u>" + "xr21x141x_1930_single_installer" + "</u>" + "</span>";
    elem.id = "usbserdirver";
	elem.style.width = "100%";
    elem.onclick = startUsbserDirver;
    usbAtom.element.parentNode.appendChild(elem);
	ct.getAttrRow("usbserdirver").style.display = "none";
	
	if (!hasTable)
	{
		hasTable = true;
		$("tablecontainer").appendChild(ct.getTable());
	}

	$("submitbtn").value=RESOURCE["okbutton"];
	$("cancel").value=RESOURCE["cancelbutton"];
	$("apply").value=RESOURCE["applybutton"];	
}

function neIDBlurEvent(evt)
{
	evt = evt?evt:window.event;
	var obj = evt.srcElement?evt.srcElement:evt.target;
	textlinkage(obj);
}


function createXML()
{
   var root = new inputxml("datainterface");//Create the root of a xml file
   var firstlevel = new tagElement("bussiness-params");
   var secondlevel = new tagElement("row-params");

   var thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","neID");
   var content = calNeId(ct.getAttrValue("id"),ct.getAttrValue("extendID"));
   thirdlevel.setAttribute("value",content);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","neGWType");
   str = ct.getAttrValue("gateway");
   thirdlevel.setAttribute("value",str);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","neGWAddress");

   if(str == GATETYPE_IP || str == GATETYPE_SSL)
   {
      content = ct.getAttrValue("address");
   }
   else if(str == GATETYPE_OSI)
   {
      content = ct.getAttrValue("nsapaddress");
      content = content + ct.getAtom("nsapaddress").element.parentNode.childNodes[1].value;
   }
   else
   {
      content = "---";
   }
   thirdlevel.setAttribute("value",content);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","port");
   if(str == GATETYPE_IP || str == GATETYPE_SSL)
   {
      content = ct.getAttrValue("port");
   }
   else if(str == GATETYPE_OSI)
   {
      content = -1;
   }
   else
   {
       content = ct.getAttrValue("comport");
   }
   thirdlevel.setAttribute("value",content);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","baudRate");
   if(str == GATETYPE_COM)
   {
   	
      content = ct.getAttrValue("baudrate");
	  /**
	   *                    CBB          
	   *      DTS2012041707737
	   *                9600                       9600    
	   */

	  if(content<=9600)
	  {
	  	if (!confirm(RESOURCE["baudrateLowAlarm"]))
		{
			return -1;
		}
	  }
   }
   else
   {
      content = -1;
   }
   thirdlevel.setAttribute("value",content);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","userName");
   content = ct.getAttrValue("username");
   thirdlevel.setAttribute("value",content);
   secondlevel.appendChild(thirdlevel);

   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","userPassword");
   content = ct.getAttrValue("password");
   thirdlevel.setAttribute("value",EncryptUtils.encrypt(content));
   secondlevel.appendChild(thirdlevel);
   
   thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name","forceLogin");
   thirdlevel.setAttribute("value","1");
   secondlevel.appendChild(thirdlevel);

   firstlevel.appendChild(secondlevel);
   root.getRoot().appendChild(firstlevel);

   var xml = root.toString();
   return xml;
}

/**
 * Demo                  
 */
function addNetoNelist()
{
    var neid = ct.getAttrValue("extendID")+"-"+ct.getAttrValue("id");
    var neGWType = ct.getAttrValue("gateway");
    var address = "";
    if(ct.getAttrValue("gateway") == GATETYPE_COM)
    {
       address = ct.getAttrValue("comport");
    }
    else if(ct.getAttrValue("gateway") == GATETYPE_OSI)
    {
       content = ct.getAtom("nsapaddress").element.parentNode.childNodes[1].value;
       address = ct.getAttrValue("nsapaddress")+content;
    }
    else
    {
       address = ct.getAttrValue("address");
    }
    win.appendNEToNEList(neid,neGWType,address,"1","1","0");

    alert(RESOURCE["operatesucc"]);
    newid = parseInt(ct.getAttrValue("id"))+1;
    ct.setAttrValue("id",newid);
    
    window.dainterface = [];
    return true;
}

function checkInputData(textinput, event)
{
   if(!restrict(textinput, event, "0123456789"))
   {
       return false;
   }
   if(!checkDataRange(textinput,0,49151))
   {
       return false;
   }
   return true;
}

function checkextendID(textinput,maxlen,event)
{
   if(!restrict(textinput,event, "0123456789"))
   {
      return false;
   }
   if(!maxlength(textinput,maxlen))
   {
      return false;
   }
   return true;
}

function checkport(textinput,event)
{
   if(!restrict(textinput,event, "0123456789"))
   {
       return false;
   }
   if(!maxlength(textinput,5))
   {
       return false;
   }
   return true;
}

function textlinkage(idobj)
{
   selectvalue = ct.getAttrValue("gateway");
   if(selectvalue == GATETYPE_IP)
   {
      setDefaultIPAddress()
   }
   else if (selectvalue == GATETYPE_OSI)
   {
      setDefaultNSAP();
   }
}

function chkfieldaddr(obj,len,event)
{
   if(!restrict(obj, event, "0123456789abcdef"))
   {
       return false;
   }
   if(!maxlength(obj,26))
   {
       return false;
   }
   return true;
}

function checksubmit()
{
	var atom = ct.getAtom("id");
	if(!IsNotNull(atom.element.value,RESOURCE["neID"]))
	{
		atom.element.focus();
		return false;
	}
	else if(!chkinputdata(atom.element.value,"wrongid"))
	{
		atom.element.value = "";
		atom.element.focus();
		return false;
	}
	if(typeof(win.isExistNEID) != "undefined")
	{
		if(win.isExistNEID(ct.getAttrValue("extendID")+"-"+ct.getAttrValue("id")))
		{
			alert(RESOURCE["sameid"]);
			atom.element.value = "";
			atom.element.focus();
			
			ct.getAtom("address").setValue("");
			
			if(ct.getAttrValue("gateway") == GATETYPE_OSI)
			{
				ct.getAtom("nsapaddress").element.parentNode.childNodes[1].value = "";
			}
			return false;
		}
	}
	
	atom = ct.getAtom("extendID");
	if(!IsNotNull(atom.element.value,RESOURCE["extendID"]))
	{
		atom.element.focus();
		return false;
	}
	else if(!chkinputdata(atom.element.value,"wrongextendid"))
	{
		atom.element.value = "";
		atom.element.focus();
		return false;
	}
	
	var gateway = ct.getAttrValue("gateway");
	if(gateway == GATETYPE_IP)
	{
		atom = ct.getAtom("address");
		if(!check_IPaddr(atom.element.value))
		{
			atom.element.focus();
			return false;
		}
		atom = ct.getAtom("port");
       if(!IsNotNull(atom.element.value,RESOURCE["port"]))
       {
           atom.element.focus();
           return false;
       }
	}
	else if(gateway == GATETYPE_OSI)
	{
		atom = ct.getAtom("nsapaddress");
		if(!IsNotNull(atom.element.value,RESOURCE["nsapaddress"]))
		{                       
			atom.element.focus();
			return false;
		}
		else if(!chkhexnum(atom.element.value,"wronghex"))
		{
			atom.element.value = "";
			atom.element.focus();
			return false;
		}
	}
	else
	{
		atom = ct.getAtom("comport");
		if(atom.element.value == "" || atom.element.value == null)
		{                       
			alert(RESOURCE["noport"]);
			atom.element.focus();
			return false;
		}
		atom = ct.getAtom("port");
       if(!IsNotNull(atom.element.value,RESOURCE["baudrate"]))
       {
           atom.element.focus();
           return false;
       }
	}
	
	atom = ct.getAtom("username");
	if(!IsNotNull(atom.element.value,RESOURCE["username"]))
	{
		atom.element.focus();
		return false;
	}
	
	atom = ct.getAtom("password");
	if(!IsNotNull(atom.element.value,RESOURCE["password"]))
	{
		atom.element.focus();
		return false;
	}
	if(atom.element.value.length < 6)
	{
		alert(RESOURCE["passwordscope"]);
		atom.element.focus();
		return false;
	}
	else if(atom.element.value.length > 16)
	{
		alert(RESOURCE["passwordscope"]);
		atom.element.value = "";
		atom.element.focus();
		return false;
	}
    return true;
}

/**
 *     ID     IP  
 */
function setDefaultIPAddress()
{
	var neid = ct.getAttrValue("id");
	if(neid != "")
	{
		ct.getAtom("address").setValue(getDefaultIP(neid));
	}
}

/**
 *     ID     OSI  
 */
function setDefaultNSAP()
{
	var neid = ct.getAttrValue("id");
	if(neid != "")
	{
		ct.getAtom("nsapaddress").element.parentNode.childNodes[1].value = NSAPdefval(neid);
	}
}

function changegateway(selectgateway)
{
    var selectvalue = selectgateway.value;//  select    
    ct.getAttrRow("address").style.display = "none";
    ct.getAttrRow("port").style.display = "none";
    ct.getAttrRow("nsapaddress").style.display = "none";
    ct.getAttrRow("comport").style.display = "none";
    ct.getAttrRow("baudrate").style.display = "none";
    ct.getAttrRow("usbserdirver").style.display = "none";
    if (selectvalue == GATETYPE_IP || selectvalue == GATETYPE_SSL) 
    {
        ct.getAttrRow("address").style.display = "";
        ct.getAttrRow("port").style.display = "";
        if (selectvalue == GATETYPE_SSL) 
        {
            ct.getAtom("port").element.value = 5432;
            ct.getAtom("port").element.disabled = true;
        }
        else 
        {
            ct.getAtom("port").element.value = 1400;
            ct.getAtom("port").element.disabled = false;
        }
        if (ct.getAtom("id").element.value == "0") 
        {
            ct.getAtom("id").element.value = "";
            ct.getAtom("extendID").element.value = "9";
        }
        setDefaultIPAddress();
    }
    else if (selectvalue == GATETYPE_OSI) 
    {
        ct.getAttrRow("nsapaddress").style.display = "";
        setDefaultNSAP();
    }
    else if (selectvalue == GATETYPE_COM) 
    {
        ct.getAttrRow("comport").style.display = "";
        ct.getAttrRow("baudrate").style.display = "";
        if (ct.getAtom("id").element.value == "") 
        {
            ct.getAtom("id").element.value = "0";
            ct.getAtom("extendID").element.value = "0";
        }
    }
    else if (selectvalue == GATETYPE_USBSERIAL) 
    {
        ct.getAttrRow("usbserdirver").style.display = "";
        if (ct.getAtom("id").element.value == "") 
        {
            ct.getAtom("id").element.value = "0";
            ct.getAtom("extendID").element.value = "0";
        }
    }
    
    storeGateWayType = selectgateway.value;
}
function NSAPdefval(neid)
{
   id0x = algorismtohex(neid);//   ID        

   switch(id0x.length)
   {
      case 1: id0x = "000" + id0x;
              break;
      case 2: id0x = "00" + id0x;
              break;
      case 3: id0x = "0" + id0x;
              break;
      default:
   }

   fixvalue = "08003e09"+id0x+"1d";//     
   return fixvalue;
}

function handlebackport(doc)
{
    if(doc.getElementsByTagName("row-param").length == 0)
    {
        alert(RESOURCE["noport"]);
    }
    else
    {
        for(j=0; j < doc.getElementsByTagName("row-param").length; j++)
        {
           serialport = results.getElementsByTagName("row-param")[i].firstChild.firstChild.nodeValue;
           addrtext.options[addrtext.options.length] = new Option(serialport, serialport);
        }
    }
}

function submitAppendpage(ifdemo)
{
   if(checksubmit())
   {
      if(ifdemo == 0)
      {
      	sendInfo();//Send request
      }
      else
      {
         addNetoNelist();//Add a piece of ne information into the table of nelist.html
      }
      return true;
   }
   else
   {
    	return false;
   }
}

function sendInfo()
{
   var xml = createXML();
   if(xml == -1)
   {
   		return;
   }
   var URL = "../neListServlet?sfid=12288&flag=0";
   
   setAllElementDisable(true);

   loadXMLdoc(URL,"POST",true,handleback,null,"inputdata="+xml);
}

/**
 *           
 */
function setAllElementDisable(bStatus)
{
	if(window.parent && window.parent.document.getElementById("selNeType"))
	{
		window.parent.document.getElementById("selNeType").disabled = bStatus;
	}
	setAttrDisable("id",bStatus);
	setAttrDisable("extendID",bStatus);
	setAttrDisable("gateway",bStatus);
	setAttrDisable("address",bStatus);
	setAttrDisable("port",bStatus);
	setAttrDisable("nsapaddress",bStatus);
	setAttrDisable("comport",bStatus);
	setAttrDisable("baudrate",bStatus);
	setAttrDisable("username",bStatus);
	setAttrDisable("password",bStatus);
	
	$("submitbtn").disabled = bStatus;
	$("apply").disabled = bStatus;
	$("cancel").disabled = bStatus;
}

/**
 *         
 */
function setAttrDisable(name,bStatus)
{
	if(ct.getAtom(name))
	{
		ct.getAtom(name).element.disabled = bStatus;
	}
}

function handleback(doc)
{
	var objerr = new Object();
	objerr = EncapsulateData(doc);
	
	if(ifdemo == 0)
	{
		var errArr = [];
		errArr[0] = "neID";
		openErrPage("", objerr.getError(), errArr);
		errArr = null;
	}

	setAllElementDisable(false);
	
	win.refreshNelist(win.st);
	showWarningInfo(objerr);
	showPNPUpdataInfo(objerr);
	if(0 == objerr.getSErrorCode())
	{
		newid = parseInt(ct.getAttrValue("id"))+1;
		ct.setAttrValue("id",newid);
		
		if(ct.getAtom("gateway") == GATETYPE_IP)
		{
			ct.getAtom("address").value = "";
		}
		textlinkage(ct.getAtom("id").element);
	
		if(submitflag)
		{
			xcloseDialog();
		}
	}
}  


function showWarningInfo(result)
{
	var warningScreenInfo = "";
	if (2 != result.getSErrorCode())//      
	{
		for(var j = 0,size = result.getDataRowLength();j < size;j++)
		{
			var neName = result.getDataRowParam(j,"nename");
			var wsInfo = result.getDataRowParam(j,"wsinfo"); 
			if(wsInfo != null && wsInfo != "")
			{
				warningScreenInfo = warningScreenInfo + neName + ":" + wsInfo + "\r";
			}
		}
	}
	if(warningScreenInfo != "")
	{
		alert(warningScreenInfo);
	}
}

function showPNPUpdataInfo(result)
{
    for (var j = 0, size = result.getDataRowLength(); j < size; j++) 
    {
        var isPNPUpdate = result.getDataRowParam(j, "isPNPUpdate");
        if (isPNPUpdate) 
        {
            alert(RESOURCE["pnpUpdate"]);
        }
    }
}


function getDefaultIP(inputID)
{
    lastnum = parseInt(inputID) % 256;
    thirdnum = (parseInt(inputID) - lastnum) / 256;
    return "129.9." + thirdnum + "." + lastnum;
}

function startUsbserDirver()
{
   xml = createXML();
   if(xml == -1)
   {
	   return;
   }
   var URL = "../neListServlet?sfid="+ TECMDCODE_START_USBSERINSTALLER+ "&flag=0";
	   
   loadXMLdoc(URL,"POST",true,handleUsbback,null,"inputdata="+xml);
}
function handleUsbback()
{
   
}

