/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.xml;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.IFileProvider;
import com.huawei.nglct.util.xml.TEAreaDescObject;
import com.huawei.nglct.util.xml.TEFileDescObject;
import com.huawei.nglct.util.xml.TEProfileFactory;
import com.huawei.uflight.appmanager.api.IAppManager;
import gnu.trove.TIntArrayList;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEResourceManager {
    private static String sIconResourceFileName = "";
    private static String sIconAreaObjectName = "";
    private static TEAreaDescObject iconAreaObject = null;
    private static String sStringResourceFileName = "";
    private static String sStringAreaObjectName = "";
    private static TEAreaDescObject stringAreaObject = null;
    private static String sAppClientPath = null;
    private static final char PC_DIR_PATH_SEPARATOR = '\\';
    private static final char JAR_FILE_SEPARATOR = '/';
    private static TIntArrayList pnpFileList = new TIntArrayList();
    private static Bundle pnpBundle = null;
    private static Object fileLck = new Object();

    private TEResourceManager() {
    }

    public static synchronized String getString(String fileName, String areaName, String key, boolean bClear) {
        try {
            if (!TESysManagerBean.getInstance().isIntegratedStatus() && sStringResourceFileName != null && sStringResourceFileName.equals(fileName) && sStringAreaObjectName != null && sStringAreaObjectName.equals(areaName) && null != stringAreaObject) {
                String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
                return sValue == null ? key : sValue;
            }
            sStringResourceFileName = fileName;
            sStringAreaObjectName = areaName;
            TEFileDescObject fileDescObject = TEProfileFactory.getFileDescObject(fileName);
            if (null == fileDescObject) {
                stringAreaObject = null;
                return key;
            }
            stringAreaObject = fileDescObject.getAreaDescObject(areaName);
            if (null == stringAreaObject) {
                String message = "\u00b4\u00d3\u00c5\u00e4\u00d6\u00c3\u00ce\u00c4\u00bc\u00fe\u00a3\u00ba";
                message = message + fileName;
                message = message + " \u00d7\u00f7\u00d3\u00c3\u00d3\u00f2\u00b6\u00d4\u00cf\u00f3:string_resource \u00ca\u00a7\u00b0\u00dc\u00a3\u00a1";
                TELogFactory.getNormalLogger().info(message);
                return key;
            }
            String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
            if (bClear || TESysManagerBean.getInstance().isIntegratedStatus()) {
                sIconAreaObjectName = "";
                sStringAreaObjectName = "";
                stringAreaObject = null;
            }
            return sValue == null ? key : sValue;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString(), (Throwable)e);
            return key;
        }
    }

    public static String getString(String fileName, String key) {
        return TEResourceManager.getString(fileName, "string_resource", key, false);
    }

    public static String getString(String fileName, String areaName, String key) {
        return TEResourceManager.getString(fileName, areaName, key, false);
    }

    public static String join(String baseString, String para) {
        if (baseString == null || para == null) {
            return baseString;
        }
        int i = baseString.indexOf("%0%");
        if (i < 0) {
            return baseString;
        }
        return baseString.substring(0, i) + para + baseString.substring(i + 3);
    }

    public static String join(String baseString, int para) {
        return TEResourceManager.join(baseString, String.valueOf(para));
    }

    public static String join(String baseString, String para0, String para1) {
        String[] paras = new String[]{para0, para1};
        return TEResourceManager.join(baseString, paras);
    }

    public static String join(String baseString, int para0, int para1) {
        String[] paras = new String[]{String.valueOf(para0), String.valueOf(para1)};
        return TEResourceManager.join(baseString, paras);
    }

    public static String join(String baseString, String[] paras) {
        if (baseString == null || paras == null) {
            return baseString;
        }
        int len = paras.length;
        String result = baseString;
        for (int i = 0; i < len; ++i) {
            int idx = result.indexOf("%" + i + "%");
            if (idx < 0) {
                return baseString;
            }
            result = result.substring(0, idx) + paras[i] + result.substring(idx + 3);
        }
        return result;
    }

    public static synchronized Icon getIcon(String fileName, String areaName, String key, boolean bClear) {
        if (!sIconResourceFileName.equals(fileName) || !sIconAreaObjectName.equals(areaName) || iconAreaObject == null) {
            sIconResourceFileName = fileName;
            sIconAreaObjectName = areaName;
            TEFileDescObject fileDescObject = TEProfileFactory.getFileDescObject(fileName);
            if (null == fileDescObject) {
                iconAreaObject = null;
                return null;
            }
            iconAreaObject = fileDescObject.getAreaDescObject(areaName);
            if (null == iconAreaObject) {
                String message = "\u00b4\u00d3\u00c5\u00e4\u00d6\u00c3\u00ce\u00c4\u00bc\u00fe\u00a3\u00ba";
                message = message + fileName;
                message = message + " \u00d7\u00f7\u00d3\u00c3\u00d3\u00f2\u00b6\u00d4\u00cf\u00f3:icon_resource \u00ca\u00a7\u00b0\u00dc\u00a3\u00a1";
                TELogFactory.getNormalLogger().info(message);
                return null;
            }
        }
        String sValue = iconAreaObject.getStringPropertyvalue(key, "value");
        if (bClear) {
            sIconResourceFileName = "";
            sIconAreaObjectName = "";
            iconAreaObject = null;
        }
        String iconFileName = TEResourceManager.getGrandParentdirectory(fileName) + "images" + File.separator + sValue;
        return TEResourceManager.getIcon(iconFileName);
    }

    public static Icon getIcon(String fileName, String key) {
        return TEResourceManager.getIcon(fileName, "icon_resource", key, false);
    }

    public static Icon getIcon(String fileName, String areaName, String key) {
        return TEResourceManager.getIcon(fileName, areaName, key, false);
    }

    public static Icon getIcon(String fileName) {
        Image image;
        String iconFileName = TEResourceManager.getPath() + fileName;
        try {
            image = Toolkit.getDefaultToolkit().getImage(iconFileName);
        }
        catch (Exception ex) {
            return null;
        }
        if (image == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(image);
        if (8 != icon.getImageLoadStatus()) {
            TELogFactory.getNormalLogger().debug("Icon load failed!");
        }
        return icon;
    }

    public static synchronized String getGrandParentdirectory(String fullPathName) {
        int posU;
        int pos;
        int posS = fullPathName.lastIndexOf(47);
        int n = pos = posS > (posU = fullPathName.lastIndexOf(File.separator)) ? posS : posU;
        if (0 >= pos) {
            return null;
        }
        posS = (fullPathName = fullPathName.substring(0, pos)).lastIndexOf(47);
        if (posS > (posU = fullPathName.lastIndexOf(File.separator))) {
            fullPathName = fullPathName.substring(0, posS + 1);
        } else if (posS < posU || posS == posU && posS > 0) {
            fullPathName = fullPathName.substring(0, posU + File.separator.length());
        } else {
            return null;
        }
        return fullPathName;
    }

    public static synchronized String getParentDirectory(String fullPathName) {
        int posU;
        int pos;
        int posS = fullPathName.lastIndexOf(47);
        int n = pos = posS > (posU = fullPathName.lastIndexOf(File.separator)) ? posS : posU;
        if (0 >= pos) {
            return null;
        }
        fullPathName = fullPathName.substring(0, pos);
        return fullPathName;
    }

    public static String getPath() {
        sAppClientPath = "";
        return sAppClientPath;
    }

    public static void setPath(String webAppPath) {
        sAppClientPath = webAppPath;
    }

    public static boolean isContainPNP(String filePath) {
        String filePathTmp = filePath.replace('\\', '/');
        if (!filePathTmp.startsWith("/")) {
            filePathTmp = "/" + filePathTmp;
        }
        int hash = TEStringUtils.hashString(filePathTmp);
        return pnpFileList.contains(hash);
    }

    public static URL getURL(String filePath) {
        if (filePath == null) {
            TELogFactory.getNormalLogger().error("The filePath is null!");
            return null;
        }
        Bundle commonBd = FrameworkUtil.getBundle(TEResourceManager.class);
        if (commonBd == null) {
            TELogFactory.getNormalLogger().error("The bundle is null! filePath" + filePath);
            return null;
        }
        BundleContext context = commonBd.getBundleContext();
        ServiceReference[] refs = null;
        try {
            if (context != null) {
                refs = context.getServiceReferences(IFileRegisterer.class.getName(), null);
            }
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("Get refs failed! filePath->" + filePath, (Throwable)e);
            return null;
        }
        if (refs == null) {
            TELogFactory.getNormalLogger().error("The refs is null! filePath->" + filePath);
            return null;
        }
        filePath = filePath.replace('\\', '/');
        Bundle bundle = null;
        if (!filePath.startsWith("/") && !filePath.startsWith("\\")) {
            filePath = "/" + filePath;
        }
        if (TEResourceManager.isContainPNP(filePath)) {
            bundle = TEResourceManager.getPNPBundle(context);
        } else {
            boolean isthis = false;
            for (ServiceReference ref : refs) {
                IFileRegisterer fileReg = (IFileRegisterer)context.getService(ref);
                isthis = fileReg.containsResFile(filePath);
                if (!isthis) continue;
                bundle = ref.getBundle();
                break;
            }
        }
        if (null == bundle) {
            bundle = commonBd;
        }
        filePath = filePath.replace('\\', '/');
        URL url = bundle.getResource(filePath);
        return url;
    }

    public static synchronized Bundle getPNPBundle(BundleContext context) {
        Bundle[] bundles;
        if (pnpBundle == null && null != (bundles = context.getBundles())) {
            for (Bundle tmpBundle : bundles) {
                if (!"com.huawei.weblct.pnp".equals(tmpBundle.getSymbolicName())) continue;
                pnpBundle = tmpBundle;
                break;
            }
        }
        return pnpBundle;
    }

    public static InputStream getInputStream(String filePath) throws IOException {
        URL url = TEResourceManager.getURL(filePath);
        if (null == url) {
            TELogFactory.getNormalLogger().error("The url is null! filePath->" + filePath);
            return null;
        }
        InputStream in = url.openStream();
        return in;
    }

    public static URL getURL(String bundleName, String filePath) throws InvalidSyntaxException {
        if (bundleName == null || filePath == null) {
            TELogFactory.getNormalLogger().error("param error! filePath" + filePath + "bundleName->" + bundleName);
            return null;
        }
        Bundle bundle = null;
        String path = null;
        URL url = null;
        if ("com.huawei.weblct.common".equals(bundleName)) {
            path = filePath.replace('\\', '/');
            bundle = FrameworkUtil.getBundle(TEResourceManager.class);
            url = bundle.getResource(path);
            return url;
        }
        BundleContext context = FrameworkUtil.getBundle(TEResourceManager.class).getBundleContext();
        if (TEResourceManager.isContainPNP(filePath) && (bundle = TEResourceManager.getPNPBundle(context)) != null) {
            path = filePath.replace('\\', '/');
            url = bundle.getResource(path);
            return url;
        }
        ServiceReference[] refs = context.getServiceReferences(IFileProvider.class.getName(), null);
        if (null == refs || refs.length == 0) {
            TELogFactory.getNormalLogger().error("The refs is null or refs.length is 0!");
            return null;
        }
        for (ServiceReference ref : refs) {
            bundle = ref.getBundle();
            if (null == bundle || !bundleName.equals(bundle.getSymbolicName())) continue;
            path = filePath.replace('\\', '/');
            url = bundle.getResource(path);
            return url;
        }
        TELogFactory.getNormalLogger().error("Can not find the file! filePath->" + filePath + ", bundleName->" + bundleName);
        return null;
    }

    public static InputStream getInputStream(String bundleName, String filePath) throws IOException {
        try {
            URL url = TEResourceManager.getURL(bundleName, filePath);
            if (null == url) {
                TELogFactory.getNormalLogger().error("The url is null!" + filePath + "bundleName->" + bundleName);
                return null;
            }
            InputStream in = url.openStream();
            return in;
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return null;
        }
    }

    public static boolean neListResouceMgr(String neListFilePath) {
        try {
            File f = new File(neListFilePath);
            if (!f.canWrite()) {
                RandomAccessFile r = new RandomAccessFile(neListFilePath, "r");
                StringBuffer buf = new StringBuffer();
                String line = null;
                while ((line = r.readLine()) != null) {
                    buf.append(line);
                    buf.append(System.getProperty("line.separator"));
                }
                r.close();
                f.delete();
                f.createNewFile();
                r = new RandomAccessFile(neListFilePath, "rw");
                r.writeBytes(buf.toString());
                r.close();
            }
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setNeListInfoKeyValue(String neListInfoFilePath, int neid, String keyName, String keyValue) {
        try {
            Object object = fileLck;
            synchronized (object) {
                File nelistFileObj = new File(neListInfoFilePath);
                InputStream inputsStream = nelistFileObj.toURL().openStream();
                Document doc = TEParseXMLFile.parseFile(inputsStream);
                if (null == doc) {
                    return false;
                }
                Node neNode = TEResourceManager.getNENode(doc, neid);
                if (null == neNode) {
                    return false;
                }
                NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
                if (keyNodeList.getLength() > 0) {
                    ((Element)keyNodeList.item(0)).setAttribute("value", keyValue);
                } else {
                    Element elemkeyName = doc.createElement(keyName);
                    elemkeyName.setAttribute("value", keyValue);
                    neNode.appendChild(elemkeyName);
                }
                doc.normalize();
                return TEResourceManager.writeXmlFile(doc, neListInfoFilePath);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!", (Throwable)e);
            return false;
        }
    }

    public static String getNeListInfoKeyValue(String neListInfoFilePath, int neid, String keyName) {
        try {
            File nelistFileObj = new File(neListInfoFilePath);
            InputStream inputsStream = nelistFileObj.toURL().openStream();
            Document doc = TEParseXMLFile.parseFile(inputsStream);
            if (null == doc) {
                return "";
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode) {
                return "";
            }
            NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
            if (keyNodeList.getLength() > 0) {
                return ((Element)keyNodeList.item(0)).getAttribute("value");
            }
            return "";
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get nelistinfo.xml file fail!" + neid + "-" + keyName, (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setNeListInfoNEKeys(String neListInfoFilePath, int neid, Hashtable neAttributes) {
        try {
            Object object = fileLck;
            synchronized (object) {
                File nelistFileObj = new File(neListInfoFilePath);
                InputStream inputsStream = nelistFileObj.toURL().openStream();
                Document doc = TEParseXMLFile.parseFile(inputsStream);
                if (null == doc || null == neAttributes) {
                    return false;
                }
                Node neNode = TEResourceManager.getNENode(doc, neid);
                if (null == neNode) {
                    TENE ne = TENEListMgr.getInstance().getNE(neid);
                    if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts() && null != ne) {
                        TEResourceManager.addNeListInfoNENode(neListInfoFilePath, ne, false);
                    } else {
                        return false;
                    }
                }
                Set keys = neAttributes.keySet();
                for (String keyName : keys) {
                    NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
                    if (keyNodeList.getLength() > 0) {
                        ((Element)keyNodeList.item(0)).setAttribute("value", String.valueOf(neAttributes.get(keyName)));
                        continue;
                    }
                    Element elemkeyName = doc.createElement(keyName);
                    elemkeyName.setAttribute("value", String.valueOf(neAttributes.get(keyName)));
                    neNode.appendChild(elemkeyName);
                }
                doc.normalize();
                return TEResourceManager.writeXmlFile(doc, neListInfoFilePath);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!" + neid, (Throwable)e);
            return false;
        }
    }

    public static Hashtable getNeListInfoNEKeys(String neListInfoFilePath, int neid) {
        Hashtable<String, String> neAttributes = null;
        try {
            File nelistFileObj = new File(neListInfoFilePath);
            InputStream inputsStream = nelistFileObj.toURL().openStream();
            Document doc = TEParseXMLFile.parseFile(inputsStream);
            if (null == doc) {
                return neAttributes;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode) {
                return neAttributes;
            }
            neAttributes = new Hashtable<String, String>();
            NodeList childNodeList = neNode.getChildNodes();
            Node childNode = null;
            int ksize = childNodeList.getLength();
            for (int k = 0; k < ksize; ++k) {
                childNode = childNodeList.item(k);
                if (childNode.getNodeType() != 1) continue;
                neAttributes.put(((Element)childNode).getNodeName(), ((Element)childNode).getAttribute("value"));
            }
            return neAttributes;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!" + neid, (Throwable)e);
            return neAttributes;
        }
    }

    public static Hashtable getNeListInfoNEKeys(String neListInfoFilePath, int neid, Vector neAttrs) {
        Hashtable<String, String> neAttributes = null;
        try {
            File nelistFileObj = new File(neListInfoFilePath);
            InputStream inputsStream = nelistFileObj.toURL().openStream();
            Document doc = TEParseXMLFile.parseFile(inputsStream);
            if (null == doc) {
                return neAttributes;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode || null == neAttrs) {
                return neAttributes;
            }
            neAttributes = new Hashtable<String, String>();
            for (String keyName : neAttrs) {
                NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
                if (keyNodeList.getLength() > 0) {
                    neAttributes.put(keyName, ((Element)keyNodeList.item(0)).getAttribute("value"));
                    continue;
                }
                neAttributes.put(keyName, "");
            }
            return neAttributes;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!" + neid, (Throwable)e);
            return neAttributes;
        }
    }

    public static Vector getNeListInfoNEIds(String neListInfoFilePath) {
        Vector<Integer> neIdList = null;
        try {
            File nelistFileObj = new File(neListInfoFilePath);
            InputStream inputsStream = nelistFileObj.toURL().openStream();
            Document doc = TEParseXMLFile.parseFile(inputsStream);
            if (null == doc) {
                return neIdList;
            }
            NodeList neNodeList = doc.getDocumentElement().getChildNodes();
            neIdList = new Vector<Integer>();
            int isize = neNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                Node nechildNode = neNodeList.item(i);
                Element nechildElement = null;
                if (nechildNode.getNodeType() != 1) continue;
                nechildElement = (Element)nechildNode;
                String neid = nechildElement.getAttribute("value");
                neIdList.add(Integer.valueOf(neid));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
        }
        return neIdList;
    }

    private static void removeAllChild(Element elem) {
        while (elem.hasChildNodes()) {
            elem.removeChild(elem.getFirstChild());
        }
    }

    private static Element getNENodeFromDoc(Document doc, TENE neObj, boolean isReplace) {
        if (null == doc) {
            return null;
        }
        Node neNode = TEResourceManager.getNENode(doc, neObj.getNEID());
        Element neelem = null;
        if (null != neNode || neObj.getRealNEID() == 0) {
            if (!isReplace) {
                return null;
            }
            neelem = (Element)neNode;
            TEResourceManager.removeAllChild(neelem);
        } else {
            neelem = doc.createElement("neid");
            doc.getDocumentElement().appendChild(neelem);
        }
        return neelem;
    }

    public static boolean addNeListDocNeNode(Document doc, TENE neObj, boolean isReplace) {
        Element neelem = TEResourceManager.getNENodeFromDoc(doc, neObj, isReplace);
        if (null == neelem) {
            return false;
        }
        neelem.setAttribute("value", String.valueOf(neObj.getNEID()));
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element elemneNENameType = doc.createElement("neName");
        elemneNENameType.setAttribute("value", String.valueOf(neObj.getNEName()));
        Element elemneGWType = doc.createElement("neGWType");
        elemneGWType.setAttribute("value", String.valueOf(neObj.getNEGWType()));
        Element elemLogicNEID = doc.createElement("realNEID");
        elemLogicNEID.setAttribute("value", String.valueOf(neObj.getRealNEID()));
        Element elemNEType = doc.createElement("neType");
        elemNEType.setAttribute("value", String.valueOf(neObj.getNEType()));
        Element elemNEVer = doc.createElement("neVersion");
        elemNEVer.setAttribute("value", String.valueOf(neObj.getHostVersion()));
        Element elemneGWAddress = doc.createElement("neGWAddress");
        elemneGWAddress.setAttribute("value", neObj.getNEGWAddress());
        Element elemport = doc.createElement("port");
        elemport.setAttribute("value", neObj.getPort());
        Element elemsynMode = doc.createElement("synMode");
        elemsynMode.setAttribute("value", "0");
        Element elemsynStartTime = doc.createElement("synStartTime");
        elemsynStartTime.setAttribute("value", "");
        Element elemsynCycle = doc.createElement("synCycle");
        elemsynCycle.setAttribute("value", "0");
        Element elembaudRate = doc.createElement("baudRate");
        elembaudRate.setAttribute("value", neObj.getBaudRate());
        Element elemloginName = doc.createElement("loginName");
        elemloginName.setAttribute("value", neObj.getCurUser());
        Element elementNeConnectType = doc.createElement("neConnectType");
        elementNeConnectType.setAttribute("value", String.valueOf(neObj.getIsTL1OrQX()));
        docfrag.appendChild(elemLogicNEID);
        docfrag.appendChild(elemneNENameType);
        docfrag.appendChild(elemneGWType);
        docfrag.appendChild(elemNEType);
        docfrag.appendChild(elemNEVer);
        docfrag.appendChild(elemneGWAddress);
        docfrag.appendChild(elemport);
        docfrag.appendChild(elemsynMode);
        docfrag.appendChild(elemsynStartTime);
        docfrag.appendChild(elemsynCycle);
        docfrag.appendChild(elembaudRate);
        docfrag.appendChild(elemloginName);
        docfrag.appendChild(elementNeConnectType);
        neelem.appendChild(docfrag);
        doc.normalize();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addNeListInfoNENode(String neListInfoFilePath, TENE neObj, boolean isReplace) {
        try {
            Object object = fileLck;
            synchronized (object) {
                File nelistFileObj = new File(neListInfoFilePath);
                InputStream inputsStream = nelistFileObj.toURL().openStream();
                Document doc = TEParseXMLFile.parseFile(inputsStream);
                boolean blAdd = TEResourceManager.addNeListDocNeNode(doc, neObj, isReplace);
                if (!blAdd) {
                    return false;
                }
                return TEResourceManager.writeXmlFile(doc, neListInfoFilePath);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteNeListInfoNENode(String neListInfoFilePath, int neid) {
        try {
            Object object = fileLck;
            synchronized (object) {
                File nelistFileObj = new File(neListInfoFilePath);
                InputStream inputsStream = nelistFileObj.toURL().openStream();
                Document doc = TEParseXMLFile.parseFile(inputsStream);
                if (null == doc) {
                    return false;
                }
                Node neNode = TEResourceManager.getNENode(doc, neid);
                if (null == neNode) {
                    return false;
                }
                doc.getDocumentElement().removeChild(neNode);
                doc.normalize();
                TEResourceManager.writeXmlFile(doc, neListInfoFilePath);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
        }
        TELogFactory.getNormalLogger().info("Not find neid=" + neid + "in nelistinfo.xml file !");
        return true;
    }

    public static File getFileByName(String relativePath) {
        URL url = TEResourceManager.getURL(relativePath);
        if (null == url) {
            TELogFactory.getNormalLogger().error("The url is null! filePath" + relativePath);
            return null;
        }
        File file = null;
        try {
            String realPath = FileLocator.toFileURL((URL)url).getPath();
            file = new File(realPath);
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("get file fail! filenam=" + relativePath, (Throwable)ex);
        }
        return file;
    }

    public static File getFileByName(String bundlename, String relativePath) {
        URL url = null;
        try {
            url = TEResourceManager.getURL(bundlename, relativePath);
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        if (null == url) {
            return null;
        }
        File file = null;
        try {
            String realPath = FileLocator.toFileURL((URL)url).getPath();
            file = new File(realPath);
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("get file fail! filenam=" + relativePath, (Throwable)ex);
        }
        return file;
    }

    public static File getFileInBundle(Bundle bundle, String relativePath) {
        File file = null;
        try {
            String realPath = TEResourceManager.getFileRealPath(bundle, relativePath);
            file = new File(realPath);
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("get file fail! filenam=" + relativePath, (Throwable)ex);
        }
        return file;
    }

    public static boolean writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File xmlFile = new File(filename);
            URL url = xmlFile.toURL();
            String filePath = FileLocator.toFileURL((URL)url).getPath();
            File file = new File(filePath);
            StreamResult result = new StreamResult(file);
            if (!file.canWrite()) {
                file.delete();
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return true;
        }
        catch (TransformerConfigurationException e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!", (Throwable)e);
            return false;
        }
        catch (TransformerException e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!", (Throwable)e);
            return false;
        }
        catch (IOException ioe) {
            TELogFactory.getNormalLogger().error("get file fail!", (Throwable)ioe);
            return false;
        }
    }

    public static ArrayList getNeListInfo(String neListInfoFilePath) {
        ArrayList nelistInfo = new ArrayList();
        try {
            File nelistFileObj = new File(neListInfoFilePath);
            InputStream inputsStream = nelistFileObj.toURL().openStream();
            Document doc = TEParseXMLFile.parseFile(inputsStream);
            if (null == doc) {
                return nelistInfo;
            }
            NodeList neNodeList = doc.getElementsByTagName("neid");
            Element elem = null;
            NodeList childNodeList = null;
            int isize = neNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                HashMap<String, String> neAttributes = new HashMap<String, String>();
                elem = (Element)neNodeList.item(i);
                neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                childNodeList = elem.getChildNodes();
                int m = childNodeList.getLength();
                for (int j = 0; j < m; ++j) {
                    elem = (Element)childNodeList.item(j);
                    neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                }
                nelistInfo.add(neAttributes);
            }
            return nelistInfo;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
            return nelistInfo;
        }
    }

    public static Node getNENode(Document doc, int neid) {
        try {
            if (null == doc) {
                return null;
            }
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            int phyNEID = ne.getRealNEID();
            int neConnectType = ne.getIsTL1OrQX();
            String tempNEName = ne.getNEName();
            NodeList neNodeList = doc.getElementsByTagName("neid");
            Node nechildNode = null;
            Node realNEIDNode = null;
            Node neNameNode = null;
            int tmpNEID = -1;
            String neName = "";
            int isize = neNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                nechildNode = neNodeList.item(i);
                realNEIDNode = ((Element)nechildNode).getElementsByTagName("realNEID").item(0);
                neNameNode = ((Element)nechildNode).getElementsByTagName("neName").item(0);
                tmpNEID = Integer.parseInt(((Element)realNEIDNode).getAttribute("value"));
                neName = ((Element)neNameNode).getAttribute("value");
                if (!(neConnectType == 0 ? phyNEID == tmpNEID : neName.equals(tempNEName))) continue;
                return nechildNode;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Not find ne(" + neid + ")in nelistinfo.xml!");
        }
        return null;
    }

    public static String getFileRealPath(Bundle bundle, String filePath) throws IOException {
        File file;
        String path;
        Bundle thisBundle = null == bundle ? FrameworkUtil.getBundle(TEResourceManager.class) : bundle;
        URL url = thisBundle.getResource(path = (filePath = (file = new File(filePath)).toString()).replace('\\', '/'));
        if (null == url) {
            return "";
        }
        String fileRealPath = FileLocator.toFileURL((URL)url).getPath();
        return fileRealPath;
    }

    public static String getRealPathByAppName(String appName) {
        if (null == appName || "".equals(appName)) {
            return "";
        }
        BundleContext context = FrameworkUtil.getBundle(TEResourceManager.class).getBundleContext();
        ServiceReference refs = context.getServiceReference(IAppManager.class.getName());
        if (null == refs) {
            return null;
        }
        IAppManager appManager = (IAppManager)context.getService(refs);
        return appManager.getAppByName(appName).getAppPath();
    }

    public static TIntArrayList getPNPFileList() {
        return pnpFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPNPfileList() {
        TIntArrayList tIntArrayList = pnpFileList;
        synchronized (tIntArrayList) {
            pnpFileList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPNPfileList(int fileHash) {
        TIntArrayList tIntArrayList = pnpFileList;
        synchronized (tIntArrayList) {
            pnpFileList.add(fileHash);
        }
    }
}

