/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.xml;

import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEAreaDescObject;
import com.huawei.nglct.util.xml.TEDescObject;
import com.huawei.nglct.util.xml.TEFileDescObject;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.Hashtable;

public class TEProfileFactory {
    private static Hashtable fileTable = new Hashtable();

    private TEProfileFactory() {
    }

    public static synchronized TEFileDescObject getFileDescObject(String fileName) {
        String fullFileName = TEResourceManager.getPath() + File.separator + fileName;
        TEFileDescObject fileObject = (TEFileDescObject)fileTable.get(fullFileName);
        if (null != fileObject) {
            return fileObject;
        }
        fileObject = new TEFileDescObject();
        if (!fileObject.initialize(fullFileName)) {
            return null;
        }
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            fileTable.put(fullFileName, fileObject);
        }
        return fileObject;
    }

    public static synchronized TEFileDescObject getFileDescObjectEx(String fileName) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            String fullFileName = TEResourceManager.getPath() + File.separator + fileName;
            return (TEFileDescObject)fileTable.get(fullFileName);
        }
        return TEProfileFactory.getFileDescObject(fileName);
    }

    public static synchronized void removeFileDescObject(String fileName) {
        fileTable.remove(TEResourceManager.getPath() + File.separator + fileName);
    }

    public static String getStringProperty(String fileName, String areaDescName, String descName, String propertyName) {
        TEFileDescObject file = TEProfileFactory.getFileDescObject(fileName);
        if (file == null) {
            return null;
        }
        return TEProfileFactory.getProperty(file, areaDescName, descName, propertyName);
    }

    public static int writeBackStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        TEFileDescObject file = TEProfileFactory.getFileDescObject(fileName);
        if (file == null) {
            return 8;
        }
        return TEProfileFactory.writeProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    private static String getProperty(TEFileDescObject file, String areaDescName, String descName, String propertyName) {
        TEAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            return null;
        }
        return areaObject.getStringPropertyvalue(descName, propertyName);
    }

    private static int writeProperty(TEFileDescObject file, String areaDescName, String descName, String propertyName, String propertyValue) {
        TEAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            return 8;
        }
        TEDescObject descObject = areaObject.getDescObject(descName);
        if (descObject == null) {
            return 8;
        }
        descObject.setPropertyValue(propertyName, propertyValue);
        return file.writeDescObject(descObject, true);
    }
}

