/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.system;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.consts.system.Environment;
import com.huawei.nglct.consts.system.TEFileLocation;
import com.huawei.nglct.core.taskmgr.TERecoverThread;
import com.huawei.nglct.core.taskmgr.TETask;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class TESystemUtil {
    public static final String SBI_PROXY_SERVER_NAME = "SBIProxyServerName";
    public static final String SBI_PROXY_SERVER_PORT = "SBIProxyPort";
    public static final String SBI_PROXY_SERVER_SSL_PORT = "SBIProxySSLPort";
    public static final String SBI_PROXY_SERVER_TL1_PORT = "SBIProxyTL1Port";
    public static final String SBI_PROXY_SERVER_TL1_SSL_PORT = "SBIProxyTL1SSLPort";
    public static String SBI_IP;
    public static String SBI_PORT;
    private static final String HTTP_DEFAULT_PORT = "8080";
    private static final String HTTPS_DEFAULT_PORT = "8443";
    public static Logger logger;

    private TESystemUtil() {
    }

    public static TETask getCurrentTask() {
        Thread thread = Thread.currentThread();
        if (thread.getClass() == TERecoverThread.class) {
            TERecoverThread rThread = (TERecoverThread)thread;
            return rThread.getTaskMgr().getCurrentTask();
        }
        return null;
    }

    public static boolean isDMThread() {
        TETaskMgr taskMgr;
        TETask task = TESystemUtil.getCurrentTask();
        return task != null && (taskMgr = task.taskMgrInst) != null && taskMgr.taskMgrID == 14;
    }

    public static String getSysEnvironment(String sEnvt) {
        String pbuf = System.getenv(sEnvt);
        if (null != pbuf) {
            if ((pbuf = pbuf + File.separator + "conf").endsWith("/") || pbuf.endsWith("\\")) {
                pbuf = pbuf.substring(0, pbuf.length() - 1).trim();
            }
            return pbuf;
        }
        return "";
    }

    public static String getIMAPEnvironment() {
        return TESystemUtil.getSysEnvironment("IMAP_ROOT");
    }

    public static String getIMAPPath() {
        String strPath = TESystemUtil.getIMAPEnvironment();
        if (null == strPath || "".equals(strPath)) {
            return "";
        }
        if (!strPath.endsWith("/") || !strPath.endsWith("\\")) {
            strPath = strPath + '/';
        }
        return strPath;
    }

    public static String getSBIIP() {
        if (SBI_IP == null) {
            SBI_IP = TEResourceBundle.getString(TEFileLocation.EMS_CFG_FILE, SBI_PROXY_SERVER_NAME);
        }
        return SBI_IP;
    }

    public static String getSBIPort(Environment.SBITYPE sbiType) {
        if (SBI_PORT == null) {
            String key2;
            block0 : switch (sbiType) {
                case QX: {
                    switch (Environment.g_QXSBIMode) {
                        case NORMAL: {
                            key2 = SBI_PROXY_SERVER_PORT;
                            break block0;
                        }
                        case SSL: {
                            key2 = SBI_PROXY_SERVER_SSL_PORT;
                            break block0;
                        }
                    }
                    return null;
                }
                case TL1: {
                    switch (Environment.g_TL1SBIMode) {
                        case NORMAL: {
                            String key2 = SBI_PROXY_SERVER_TL1_PORT;
                            break;
                        }
                        case SSL: {
                            String key2 = SBI_PROXY_SERVER_TL1_SSL_PORT;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                default: {
                    return null;
                }
            }
            SBI_PORT = TEResourceBundle.getString(TEFileLocation.EMS_CFG_FILE, key2);
        }
        return SBI_PORT;
    }

    public static void exportCurrentJVMStack() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("*********** JVM Stack Begin ***********");
        for (Map.Entry<Thread, StackTraceElement[]> stackTrace : Thread.getAllStackTraces().entrySet()) {
            Thread thread = stackTrace.getKey();
            StackTraceElement[] stack = stackTrace.getValue();
            if (thread.equals(Thread.currentThread())) continue;
            sb.append("\n Thread\u00a3\u00ba" + thread.getName() + "\n");
            for (StackTraceElement element : stack) {
                sb.append("\t" + element + "\n");
            }
        }
        sb.append("*********** JVM Stack End ***********");
        logger.info(sb.toString());
    }

    public static String getHTTPPort() {
        String httpPort = System.getProperty("org.osgi.service.http.port");
        if (httpPort == null) {
            httpPort = HTTP_DEFAULT_PORT;
        }
        return httpPort;
    }

    public static String getHTTPSPort() {
        String httpsPort = System.getProperty("org.osgi.service.http.port.secure");
        if (httpsPort == null) {
            httpsPort = HTTPS_DEFAULT_PORT;
        }
        return httpsPort;
    }

    public static boolean isHTTPS() {
        boolean isHttps = false;
        String secure = System.getProperty("org.osgi.service.http.secure.enabled");
        if ("true".equals(secure)) {
            isHttps = true;
        }
        return isHttps;
    }

    public static boolean isHTTP() {
        boolean isHttp = true;
        String http = System.getProperty("org.osgi.service.http.enabled");
        if ("false".equals(http)) {
            isHttp = false;
        }
        return isHttp;
    }

    public static String getHTTPURL(String servername) {
        return "http://" + servername + ":" + TESystemUtil.getHTTPPort();
    }

    public static String getHTTPSURL(String servername) {
        return "https://" + servername + ":" + TESystemUtil.getHTTPSPort();
    }

    public static String getNeListURL(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) {
        String redirectURL = httpReqeust.getContextPath();
        String visit = (String)httpReqeust.getSession().getAttribute("visit");
        if ("normal".equals(visit) && TESystemUtil.isHTTP()) {
            httpReqeust.getSession().removeAttribute("visit");
            redirectURL = TESystemUtil.getHTTPURL(httpReqeust.getServerName());
        }
        redirectURL = redirectURL + "/weblct" + "/page/nelistmain.html";
        return redirectURL;
    }

    public static boolean isLoginSuccess(HttpServletRequest httpReqeust) {
        HttpSession session = httpReqeust.getSession(false);
        if (session == null) {
            return false;
        }
        return "true".equals(session.getAttribute("passed"));
    }

    public static void removeLoginFlag(HttpServletRequest httpReqeust) {
        HttpSession session = httpReqeust.getSession(true);
        if (session == null) {
            return;
        }
        session.removeAttribute("passed");
    }

    public static void setLoginSuccess(HttpServletRequest httpReqeust) {
        HttpSession session = httpReqeust.getSession(true);
        if (session == null) {
            return;
        }
        session.setAttribute("passed", (Object)"true");
    }

    public static void setPassNeedChange(HttpServletRequest httpReqeust) {
        HttpSession session = httpReqeust.getSession(true);
        if (session == null) {
            return;
        }
        session.setAttribute("passed", (Object)"change");
    }

    public static boolean isPassNeedChange(HttpServletRequest httpReqeust) {
        HttpSession session = httpReqeust.getSession(false);
        if (session == null) {
            return false;
        }
        return "change".equals(session.getAttribute("passed"));
    }

    public static void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String localhostServerName = request.getHeader("X-Forwarded-Host");
        String localhostServerPort = "80";
        String redirectUrl = url;
        if (null != localhostServerName && !localhostServerName.isEmpty()) {
            String strScheme = "http://";
            if (TESysManagerBean.getInstance().getServerSSLMode() == 2 || TESysManagerBean.getInstance().getServerSSLMode() == 1) {
                strScheme = "https://";
                localhostServerPort = "443";
            }
            redirectUrl = strScheme + localhostServerName + ":" + localhostServerPort;
            if (url.substring(0, 1).equals("/")) {
                if (url.indexOf("/weblct") != 0) {
                    redirectUrl = redirectUrl + "/weblct";
                }
            } else {
                if (url.indexOf("weblct") != 0) {
                    redirectUrl = redirectUrl + "/weblct";
                }
                redirectUrl = redirectUrl + "/";
            }
            redirectUrl = redirectUrl + url;
        }
        response.sendRedirect(TESystemUtil.addProcInfoToUrl(redirectUrl));
    }

    public static String getTerminalIP(HttpServletRequest request) {
        String ipAddress = "";
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            ipAddress = request.getHeader("X-Forwarded-For");
            if (null == ipAddress || ipAddress.isEmpty()) {
                ipAddress = request.getRemoteAddr();
            }
        } else {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }

    public static String addProcInfoToUrl(String urlStr) {
        int procID = TESysManagerBean.getInstance().getAppProcID();
        int procHandle = TESysManagerBean.getInstance().getAppPorcHandle();
        if (procID <= 0 || procHandle <= 0) {
            TELogFactory.getNormalLogger().info("proc info invalid! procID:" + procID + ", procHandle:" + procHandle);
            return urlStr;
        }
        String abs_url_req = "(^https?://[^/]*/weblct/" + procID + "/" + procHandle + ")|(^/weblct/" + procID + "/" + procHandle + ")";
        Pattern pattern = Pattern.compile(abs_url_req);
        Matcher matcher = pattern.matcher(urlStr);
        if (matcher.find()) {
            TELogFactory.getNormalLogger().info("proc info has been added! ");
            return urlStr;
        }
        abs_url_req = "(^https?://[^/]*/weblct)|(^/weblct)";
        pattern = Pattern.compile(abs_url_req);
        matcher = pattern.matcher(urlStr);
        String resUrl = null;
        if (matcher.find()) {
            resUrl = urlStr.replaceAll(abs_url_req, matcher.group(0) + "/" + procID + "/" + procHandle);
            TELogFactory.getNormalLogger().info("the url changed is " + resUrl);
        } else {
            TELogFactory.getNormalLogger().info("the url is not absolute! url is :" + urlStr);
            resUrl = urlStr;
        }
        return resUrl;
    }

    public static void main(String[] arg) {
    }

    static {
        logger = TELogFactory.getNormalLogger();
    }
}

