/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util.string;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TEStringUtils {
    private TEStringUtils() {
    }

    public static boolean str2Ip(String pcIp, List unsignedIP) {
        int second = 0;
        int sec = 0;
        int ulIP = 0;
        int first = pcIp.indexOf(46);
        int value = -1;
        while (second < pcIp.length()) {
            if (first == second) {
                return false;
            }
            String sub = pcIp.substring(second, first).trim();
            try {
                value = Integer.parseInt(sub);
            }
            catch (Exception e) {
                return false;
            }
            if (value < 0 || value > 255 || sec >= 4) {
                return false;
            }
            ulIP = (ulIP << 8) + value;
            ++sec;
            second = first + 1;
            first = (first = pcIp.indexOf(46, second)) == -1 ? pcIp.length() : first;
        }
        unsignedIP.add(ulIP);
        return sec == 4;
    }

    public static String getString(String str) {
        try {
            str = new String(str.getBytes("ISO-8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TEStringUtils.getString() fail!", (Throwable)e);
        }
        return str;
    }

    public static StringBuffer vec2Str(List<Integer> ints) {
        StringBuffer dst = new StringBuffer();
        if (ints.isEmpty()) {
            return dst;
        }
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        tmp.addAll(ints);
        int frist = (Integer)tmp.get(0);
        int second = (Integer)tmp.get(0);
        for (int i = 1; i < tmp.size(); ++i) {
            if ((Integer)tmp.get(i) - frist == 1) {
                frist = (Integer)tmp.get(i);
                continue;
            }
            dst.append(Integer.toString(second));
            if (frist != second) {
                dst.append(frist == second + 1 ? "&" : "&&");
                dst.append(Integer.toString(frist));
            }
            dst.append("&");
            frist = second = ((Integer)tmp.get(i)).intValue();
        }
        dst.append(Integer.toString(second));
        if (frist != second) {
            dst.append(frist == second + 1 ? "&" : "&&");
            dst.append(Integer.toString(frist));
        }
        return dst;
    }

    public static String intsToString(int[] ints) {
        ArrayList<Integer> intList = new ArrayList<Integer>(ints.length);
        int m = ints.length;
        for (int i = 0; i < m; ++i) {
            intList.add(ints[i]);
        }
        return TEStringUtils.parseIntegerList(intList);
    }

    public static String parseIntegerList(ArrayList<Integer> parseList) {
        Collections.sort(parseList);
        String pathName = "";
        if (parseList.size() >= 2) {
            Iterator<Integer> it = parseList.iterator();
            int curNum = it.next();
            int offset = 0;
            StringBuffer temp = new StringBuffer(String.valueOf(curNum));
            while (it.hasNext()) {
                int nextNum = it.next();
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        temp.append("-").append(curNum + offset);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                temp.append("-").append(curNum + offset);
            }
            pathName = pathName + temp.toString();
        } else if (parseList.size() == 1) {
            pathName = pathName + parseList.get(0);
        }
        return pathName;
    }

    public static int str2Vec(String cpValue, List<Integer> values) {
        StringTokenizer token1 = new StringTokenizer(cpValue, "&");
        int count = 0;
        while (token1.hasMoreTokens()) {
            String segment = token1.nextToken();
            if (segment == null || "".equals(segment)) continue;
            TEStringUtils.strToNumList(segment, values);
            ++count;
        }
        return count;
    }

    public static boolean strToNumList(String strValues, List<Integer> intValues, int radix) {
        boolean success = true;
        String[] items = strValues.split(",");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i].trim();
            if ("".equals(item)) continue;
            ArrayList<Integer> hook = new ArrayList<Integer>();
            if (!TEStringUtils.getSpan(items[i], hook, radix)) {
                success = false;
                break;
            }
            int start = (Integer)hook.get(0);
            int end = (Integer)hook.get(1);
            for (int j = start; j <= end; ++j) {
                intValues.add(j);
            }
        }
        return success;
    }

    public static boolean strToNumList(String strValues, List<Integer> intValues) {
        return TEStringUtils.strToNumList(strValues, intValues, 10);
    }

    public static boolean getSpan(String str, List<Integer> hook) {
        return TEStringUtils.getSpan(str, hook, 10);
    }

    public static boolean getSpan(String str, List<Integer> hook, int radix) {
        int end;
        int start;
        boolean success = false;
        int pos = str.indexOf("-");
        try {
            if (pos == -1) {
                end = start = Integer.parseInt(str.trim(), radix);
            } else {
                String leftStr = str.substring(0, pos).trim();
                String rightStr = str.substring(pos + 1, str.length()).trim();
                start = Integer.parseInt(leftStr, radix);
                end = Integer.parseInt(rightStr, radix);
            }
            success = true;
        }
        catch (NumberFormatException e) {
            return false;
        }
        hook.add(start);
        hook.add(end);
        return success && start >= 0 && start <= end;
    }

    public static String strncpy(String source, int maxLen) {
        String target = source;
        if (target != null && target.length() > maxLen) {
            target = target.substring(0, maxLen);
        }
        return target;
    }

    public static String snprintf(int maxLen, String format, Object ... detailInfo) {
        String operateDesc = "";
        if (format != null && detailInfo != null && (operateDesc = String.format(format, detailInfo)).length() > maxLen) {
            operateDesc = operateDesc.substring(0, maxLen);
        }
        return operateDesc;
    }

    public static boolean getSubStr(String strSrc, String strStartSign, String strEndSign, StringBuffer strSin) {
        int beginPos = strSrc.indexOf(strStartSign);
        int endPos = 0;
        int length = 0;
        int beginSignLength = strStartSign.length();
        if (beginPos < 0) {
            return false;
        }
        endPos = strSrc.substring(beginPos + beginSignLength).indexOf(strEndSign);
        length = endPos - beginPos - beginSignLength;
        if (endPos < 0 || length < 0) {
            return false;
        }
        strSin.append(strSrc.substring(beginPos + beginSignLength, beginPos + beginSignLength + length));
        return true;
    }

    public static String trim(String oriStr, String token) {
        if ((oriStr = oriStr.trim()).startsWith(token)) {
            oriStr = oriStr.substring(token.length());
        }
        if (oriStr.endsWith(token)) {
            oriStr = oriStr.substring(0, oriStr.lastIndexOf(token));
        }
        return oriStr;
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str);
    }

    public static boolean getSpan(String str, int[] nStart, int[] nEnd) {
        boolean bSuccess = false;
        int nPos = (str = str.trim()).indexOf("-");
        if (nPos >= 0) {
            String strLeft = str.substring(0, nPos);
            String strRight = str.substring(nPos + 1, str.length());
            bSuccess = TEStringUtils.strToInt(strLeft, nStart) && TEStringUtils.strToInt(strRight, nEnd);
        } else {
            bSuccess = TEStringUtils.strToInt(str, nStart);
            if (bSuccess) {
                nEnd[0] = nStart[0];
            }
        }
        return bSuccess && nStart[0] >= 0 && nEnd[0] >= nStart[0];
    }

    public static boolean getSubStr(String strSrc, String strStartSign, String strEndSign) {
        int iBeginPos = 0;
        int iEndPos = 0;
        int iLength = 0;
        int iBeginSignLength = 0;
        iBeginSignLength = strStartSign.length();
        iBeginPos = strSrc.indexOf(strStartSign);
        if (-1 == iBeginPos) {
            return false;
        }
        iEndPos = strSrc.indexOf(strEndSign, iBeginPos + iBeginSignLength);
        iLength = iEndPos - iBeginPos - iBeginSignLength;
        return -1 != iEndPos && iLength >= 0;
    }

    public static boolean isNumeric(String str) {
        if ("".equals(str.trim())) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]*");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean isHexString(String str) {
        if ("".equals(str.trim())) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9,a-f,A-F]*");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean isNumber(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean strToInt(String str, int[] nInt) {
        try {
            nInt[0] = Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String intToFormatString(List<Integer> intList, int strLength) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < intList.size(); ++i) {
            sb.append(TEStringUtils.convertStringToProtolType(Integer.toString(intList.get(i), 16), strLength));
        }
        return sb.toString();
    }

    public static String convertStringToProtolType(String input, int longth) {
        StringBuffer sb = new StringBuffer(input);
        if (sb.length() < longth) {
            int addLength = longth - sb.length();
            for (int i = 0; i < addLength; ++i) {
                sb.insert(0, '0');
            }
        }
        return sb.toString();
    }

    public static String fillMpId(String mpid) {
        int len = mpid.length();
        StringBuffer mpids = new StringBuffer("");
        for (int i = 0; i < 8 - len; ++i) {
            mpids.append("0");
        }
        return mpids.toString() + mpid;
    }

    public static String pathToString(Integer[] paths) {
        StringBuffer pathStr = new StringBuffer();
        int len = paths.length;
        for (int i = 0; i < len; ++i) {
            pathStr.append(",").append(paths[i]);
        }
        return pathStr.toString().substring(1);
    }

    public static boolean isVailidXMLChar(char xmlChar) {
        return xmlChar == '\t' || xmlChar == '\n' || xmlChar == '\r' || xmlChar >= ' ' && xmlChar <= '\ud7ff' || xmlChar >= '\ue000' && xmlChar <= '\ufffd' || xmlChar >= '\u10000' && xmlChar <= '\u10ffff';
    }

    public static String removeInvalidXMLChar(String inputString) {
        StringBuffer sb = new StringBuffer();
        boolean isRemoveChar = false;
        for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            if (TEStringUtils.isVailidXMLChar(c)) {
                sb.append(c);
                continue;
            }
            sb.append("?");
            isRemoveChar = true;
        }
        if (isRemoveChar) {
            TELogFactory.getNormalLogger().info("Find invalid XML string [" + inputString + "]");
            TELogFactory.getNormalLogger().info("Remove char and the new string is [" + sb.toString() + "]");
        }
        return sb.toString();
    }

    public static String replaceInvalidXMLChar(String inputString) {
        String result = inputString.replace("&", "&amp;");
        result = result.replace("'", "&apos;");
        result = result.replace("\"", "&quot;");
        result = result.replace(">", "&gt;");
        result = result.replace("<", " &lt;");
        return result;
    }

    public static String encodeUnicode(String str) {
        try {
            str = URLEncoder.encode(str, "UTF-8");
            return str.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().debug("URLEncoder failt!", (Throwable)e);
            return str;
        }
    }

    public static int hashString(String str) {
        int h = str.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static String ascStrToStr(String str) {
        byte[] arr = new byte[str.length() / 2];
        int len = str.length();
        for (int i = 0; i < len; i += 2) {
            int val = Integer.valueOf(str.substring(i, i + 2), 16);
            arr[(i + 1) / 2] = val > 127 ? (byte)(val - 255) : Byte.valueOf(str.substring(i, i + 2), 16);
        }
        return new String(arr);
    }

    public static String delInvalidSeq(String str) {
        String param = "00";
        if (str.length() % 2 > 0) {
            return str;
        }
        while (str.indexOf("00") == 0) {
            str = str.substring("00".length());
        }
        if (str.length() <= 0) {
            return str;
        }
        while (str.lastIndexOf("00") == str.length() - "00".length()) {
            str = str.substring(0, str.length() - "00".length());
        }
        return str;
    }

    public static List<Integer> prototypeToValues(String valueStr, int valueNum) {
        if (0 == valueNum || TEStringUtils.isNumber(valueStr)) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> values = new ArrayList<Integer>(valueNum);
        StringBuffer sb = new StringBuffer(valueStr);
        int valueStrLen = valueStr.length();
        int charNum = valueStrLen / valueNum;
        String temp = "";
        int i = 0;
        int j = 0;
        while (i < charNum * valueNum) {
            temp = sb.substring(i, i + charNum);
            values.add(Integer.parseInt(temp, 16));
            i += charNum;
            ++j;
        }
        Collections.sort(values);
        return values;
    }

    public static byte[] prototypeToArrayValues(String valueStr, int valueNum) {
        if (0 == valueNum || !TEStringUtils.isNumber(valueStr)) {
            return new byte[valueNum];
        }
        byte[] values = new byte[valueNum];
        StringBuffer sb = new StringBuffer(valueStr);
        int valueStrLen = valueStr.length();
        int charNum = valueStrLen / valueNum;
        String temp = "";
        int i = 0;
        int j = 0;
        while (i < charNum * valueNum) {
            temp = sb.substring(i, i + charNum);
            values[j] = (byte)Integer.parseInt(temp, 16);
            if (values[j] < 0) {
                int n = j;
                values[n] = (byte)(values[n] + 256);
            }
            i += charNum;
            ++j;
        }
        return values;
    }

    public static int getChineseLength(String value) {
        char[] charr = value.toCharArray();
        int length = 0;
        for (char ch : charr) {
            if (ch > '\u0080') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String getSpace(int length) {
        StringBuffer spaceSb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            spaceSb.append(' ');
        }
        return spaceSb.toString();
    }

    public static boolean isParamEmpty(Param param) {
        return param == null || param.getValue() == null || param.getValue().isEmpty();
    }

    public static String createComplteHexStr(String hexStr, int length) {
        String outStr = "";
        int len = hexStr.length();
        if (len < length) {
            StringBuffer strBuf = new StringBuffer();
            int count = length - len;
            for (int i = 0; i < count; ++i) {
                strBuf.append("0");
            }
            strBuf.append(hexStr);
            outStr = strBuf.toString();
        } else {
            outStr = len == length ? hexStr : hexStr.substring(len - length);
        }
        return outStr;
    }

    public static String joinListAsComma(Collection<String> attrs) {
        String strResult = "";
        StringBuffer sbStr = new StringBuffer();
        if (attrs != null && !attrs.isEmpty()) {
            Iterator<String> iterator = attrs.iterator();
            while (iterator.hasNext()) {
                sbStr.append(iterator.next()).append(',');
            }
            if (sbStr.length() > 0) {
                strResult = sbStr.substring(0, sbStr.length() - 1);
            }
        }
        return strResult;
    }

    public static String joinListAsComma(List<Integer> attrs) {
        String strResult = "";
        StringBuffer sbStr = new StringBuffer();
        if (attrs != null && !attrs.isEmpty()) {
            int len = attrs.size();
            for (int i = 0; i < len; ++i) {
                sbStr.append(attrs.get(i)).append(',');
            }
            if (sbStr.length() > 0) {
                strResult = sbStr.substring(0, sbStr.length() - 1);
            }
        }
        return strResult;
    }
}

